/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacv;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.ShortPointer;
import org.bytedeco.javacpp.indexer.ByteIndexer;
import org.bytedeco.javacpp.indexer.DoubleIndexer;
import org.bytedeco.javacpp.indexer.FloatIndexer;
import org.bytedeco.javacpp.indexer.Indexable;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.javacpp.indexer.IntIndexer;
import org.bytedeco.javacpp.indexer.LongIndexer;
import org.bytedeco.javacpp.indexer.ShortIndexer;
import org.bytedeco.javacpp.indexer.UByteIndexer;
import org.bytedeco.javacpp.indexer.UShortIndexer;

public class Frame
implements Indexable {
    public boolean keyFrame;
    public static final int DEPTH_BYTE = -8;
    public static final int DEPTH_UBYTE = 8;
    public static final int DEPTH_SHORT = -16;
    public static final int DEPTH_USHORT = 16;
    public static final int DEPTH_INT = -32;
    public static final int DEPTH_LONG = -64;
    public static final int DEPTH_FLOAT = 32;
    public static final int DEPTH_DOUBLE = 64;
    public int imageWidth;
    public int imageHeight;
    public int imageDepth;
    public int imageChannels;
    public int imageStride;
    public Buffer[] image;
    public int sampleRate;
    public int audioChannels;
    public Buffer[] samples;
    public Object opaque;
    public long timestamp;

    public Frame() {
    }

    public Frame(int width, int height, int depth, int channels) {
        int pixelSize = Math.abs(depth) / 8;
        this.imageWidth = width;
        this.imageHeight = height;
        this.imageDepth = depth;
        this.imageChannels = channels;
        this.imageStride = (this.imageWidth * this.imageChannels * pixelSize + 7 & 0xFFFFFFF8) / pixelSize;
        this.image = new Buffer[1];
        ByteBuffer buffer = ByteBuffer.allocateDirect(this.imageHeight * this.imageStride * pixelSize).order(ByteOrder.nativeOrder());
        switch (this.imageDepth) {
            case -8: 
            case 8: {
                this.image[0] = buffer;
                break;
            }
            case -16: 
            case 16: {
                this.image[0] = buffer.asShortBuffer();
                break;
            }
            case -32: {
                this.image[0] = buffer.asIntBuffer();
                break;
            }
            case -64: {
                this.image[0] = buffer.asLongBuffer();
                break;
            }
            case 32: {
                this.image[0] = buffer.asFloatBuffer();
                break;
            }
            case 64: {
                this.image[0] = buffer.asDoubleBuffer();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported depth value: " + this.imageDepth);
            }
        }
    }

    public <I extends Indexer> I createIndexer() {
        return this.createIndexer(true, 0);
    }

    @Override
    public <I extends Indexer> I createIndexer(boolean direct) {
        return this.createIndexer(direct, 0);
    }

    public <I extends Indexer> I createIndexer(boolean direct, int i) {
        long[] sizes = new long[]{this.imageHeight, this.imageWidth, this.imageChannels};
        long[] strides = new long[]{this.imageStride, this.imageChannels, 1L};
        Buffer buffer = this.image[i];
        Object array = buffer.hasArray() ? buffer.array() : null;
        switch (this.imageDepth) {
            case 8: {
                return (I)(array != null ? UByteIndexer.create((byte[])array, sizes, strides).indexable(this) : (direct ? UByteIndexer.create((ByteBuffer)buffer, sizes, strides).indexable(this) : UByteIndexer.create(new BytePointer((ByteBuffer)buffer), sizes, strides, false).indexable(this)));
            }
            case -8: {
                return (I)(array != null ? ByteIndexer.create((byte[])array, sizes, strides).indexable(this) : (direct ? ByteIndexer.create((ByteBuffer)buffer, sizes, strides).indexable(this) : ByteIndexer.create(new BytePointer((ByteBuffer)buffer), sizes, strides, false).indexable(this)));
            }
            case 16: {
                return (I)(array != null ? UShortIndexer.create((short[])array, sizes, strides).indexable(this) : (direct ? UShortIndexer.create((ShortBuffer)buffer, sizes, strides).indexable(this) : UShortIndexer.create(new ShortPointer((ShortBuffer)buffer), sizes, strides, false).indexable(this)));
            }
            case -16: {
                return (I)(array != null ? ShortIndexer.create((short[])array, sizes, strides).indexable(this) : (direct ? ShortIndexer.create((ShortBuffer)buffer, sizes, strides).indexable(this) : ShortIndexer.create(new ShortPointer((ShortBuffer)buffer), sizes, strides, false).indexable(this)));
            }
            case -32: {
                return (I)(array != null ? IntIndexer.create((int[])array, sizes, strides).indexable(this) : (direct ? IntIndexer.create((IntBuffer)buffer, sizes, strides).indexable(this) : IntIndexer.create(new IntPointer((IntBuffer)buffer), sizes, strides, false).indexable(this)));
            }
            case -64: {
                return (I)(array != null ? LongIndexer.create((long[])array, sizes, strides).indexable(this) : (direct ? LongIndexer.create((LongBuffer)buffer, sizes, strides).indexable(this) : LongIndexer.create(new LongPointer((LongBuffer)buffer), sizes, strides, false).indexable(this)));
            }
            case 32: {
                return (I)(array != null ? FloatIndexer.create((float[])array, sizes, strides).indexable(this) : (direct ? FloatIndexer.create((FloatBuffer)buffer, sizes, strides).indexable(this) : FloatIndexer.create(new FloatPointer((FloatBuffer)buffer), sizes, strides, false).indexable(this)));
            }
            case 64: {
                return (I)(array != null ? DoubleIndexer.create((double[])array, sizes, strides).indexable(this) : (direct ? DoubleIndexer.create((DoubleBuffer)buffer, sizes, strides).indexable(this) : DoubleIndexer.create(new DoublePointer((DoubleBuffer)buffer), sizes, strides, false).indexable(this)));
            }
        }
        assert (false);
        return null;
    }

    public Frame clone() {
        Frame newFrame = new Frame();
        newFrame.imageWidth = this.imageWidth;
        newFrame.imageHeight = this.imageHeight;
        newFrame.imageDepth = this.imageDepth;
        newFrame.imageChannels = this.imageChannels;
        newFrame.imageStride = this.imageStride;
        newFrame.keyFrame = this.keyFrame;
        newFrame.opaque = this.opaque;
        newFrame.image = Frame.cloneBufferArray(this.image);
        newFrame.audioChannels = this.audioChannels;
        newFrame.sampleRate = this.sampleRate;
        newFrame.samples = Frame.cloneBufferArray(this.samples);
        newFrame.timestamp = this.timestamp;
        return newFrame;
    }

    private static Buffer[] cloneBufferArray(Buffer[] srcBuffers) {
        Buffer[] clonedBuffers = null;
        if (srcBuffers != null) {
            int dataSize;
            int i;
            clonedBuffers = new Buffer[srcBuffers.length];
            for (i = 0; i < srcBuffers.length; ++i) {
                srcBuffers[i].rewind();
            }
            if (srcBuffers[0] instanceof ByteBuffer) {
                for (i = 0; i < srcBuffers.length; ++i) {
                    clonedBuffers[i] = ByteBuffer.allocateDirect(srcBuffers[i].capacity()).put((ByteBuffer)srcBuffers[i]).rewind();
                }
            } else if (srcBuffers[0] instanceof ShortBuffer) {
                dataSize = 2;
                for (i = 0; i < srcBuffers.length; ++i) {
                    clonedBuffers[i] = ByteBuffer.allocateDirect(srcBuffers[i].capacity() * dataSize).order(ByteOrder.nativeOrder()).asShortBuffer().put((ShortBuffer)srcBuffers[i]).rewind();
                }
            } else if (srcBuffers[0] instanceof IntBuffer) {
                dataSize = 4;
                for (i = 0; i < srcBuffers.length; ++i) {
                    clonedBuffers[i] = ByteBuffer.allocateDirect(srcBuffers[i].capacity() * dataSize).order(ByteOrder.nativeOrder()).asIntBuffer().put((IntBuffer)srcBuffers[i]).rewind();
                }
            } else if (srcBuffers[0] instanceof LongBuffer) {
                dataSize = 8;
                for (i = 0; i < srcBuffers.length; ++i) {
                    clonedBuffers[i] = ByteBuffer.allocateDirect(srcBuffers[i].capacity() * dataSize).order(ByteOrder.nativeOrder()).asLongBuffer().put((LongBuffer)srcBuffers[i]).rewind();
                }
            } else if (srcBuffers[0] instanceof FloatBuffer) {
                dataSize = 4;
                for (i = 0; i < srcBuffers.length; ++i) {
                    clonedBuffers[i] = ByteBuffer.allocateDirect(srcBuffers[i].capacity() * dataSize).order(ByteOrder.nativeOrder()).asFloatBuffer().put((FloatBuffer)srcBuffers[i]).rewind();
                }
            } else if (srcBuffers[0] instanceof DoubleBuffer) {
                dataSize = 8;
                for (i = 0; i < srcBuffers.length; ++i) {
                    clonedBuffers[i] = ByteBuffer.allocateDirect(srcBuffers[i].capacity() * dataSize).order(ByteOrder.nativeOrder()).asDoubleBuffer().put((DoubleBuffer)srcBuffers[i]).rewind();
                }
            }
            for (i = 0; i < srcBuffers.length; ++i) {
                srcBuffers[i].rewind();
            }
        }
        return clonedBuffers;
    }
}

