/*
 * Decompiled with CFR 0.152.
 */
package net.sf.image4j.codec.ico;

import java.awt.image.BufferedImage;
import net.sf.image4j.codec.bmp.BMPImage;
import net.sf.image4j.codec.bmp.InfoHeader;
import net.sf.image4j.codec.ico.IconEntry;

public class ICOImage
extends BMPImage {
    protected IconEntry iconEntry;
    protected boolean pngCompressed = false;
    protected int iconIndex = -1;

    public ICOImage(BufferedImage bufferedImage, InfoHeader infoHeader, IconEntry iconEntry) {
        super(bufferedImage, infoHeader);
        this.iconEntry = iconEntry;
    }

    public IconEntry getIconEntry() {
        return this.iconEntry;
    }

    public void setIconEntry(IconEntry iconEntry) {
        this.iconEntry = iconEntry;
    }

    public boolean isPngCompressed() {
        return this.pngCompressed;
    }

    public void setPngCompressed(boolean bl) {
        this.pngCompressed = bl;
    }

    @Override
    public InfoHeader getInfoHeader() {
        return super.getInfoHeader();
    }

    public int getIconIndex() {
        return this.iconIndex;
    }

    public void setIconIndex(int n) {
        this.iconIndex = n;
    }

    @Override
    public int getWidth() {
        return this.iconEntry == null ? -1 : (this.iconEntry.bWidth == 0 ? 256 : this.iconEntry.bWidth);
    }

    @Override
    public int getHeight() {
        return this.iconEntry == null ? -1 : (this.iconEntry.bHeight == 0 ? 256 : this.iconEntry.bHeight);
    }

    @Override
    public int getColourDepth() {
        return this.iconEntry == null ? -1 : (int)this.iconEntry.sBitCount;
    }

    @Override
    public int getColourCount() {
        int n = this.iconEntry.sBitCount == 32 ? 24 : (int)this.iconEntry.sBitCount;
        return n == -1 ? -1 : 1 << n;
    }

    @Override
    public boolean isIndexed() {
        return this.iconEntry == null ? false : this.iconEntry.sBitCount <= 8;
    }
}

