/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.tiff;

import com.activetree.common.internal.DemoShape;
import com.activetree.common.page.AbstractPage;
import com.activetree.common.report.page.AtImagePage;
import com.activetree.common.utils.AtDebug;
import com.activetree.common.utils.MediaUtil;
import com.activetree.tiff.TiffReader;
import com.sun.media.jai.codec.ImageDecoder;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.io.IOException;
import javax.media.jai.PlanarImage;

public class AtTiffPage
extends AtImagePage {
    private int a = 0;

    public AtTiffPage() {
        this.pageScaling = 11;
    }

    public AtTiffPage(Object object, int n, DemoShape demoShape) {
        super(n + 1, AtTiffPage.createTiffPageFormat(object, n), object, demoShape);
        this.pageIndex = n;
        this.pageScaling = 11;
    }

    protected static synchronized PageFormat createTiffPageFormat(Object object, int n) {
        Object object2;
        Object object3;
        TiffReader tiffReader = (TiffReader)object;
        BufferedImage bufferedImage = null;
        try {
            object3 = tiffReader.tiffDecoder;
            object2 = object3.decodeAsRenderedImage(n);
            PlanarImage planarImage = PlanarImage.wrapRenderedImage((RenderedImage)object2);
            bufferedImage = planarImage.getAsBufferedImage();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        object3 = new Rectangle2D.Double(0.0, 0.0, bufferedImage.getWidth(), bufferedImage.getHeight());
        object2 = MediaUtil.getSelectedPageFormat((Rectangle2D)object3);
        return object2;
    }

    public AbstractPage newInstance() {
        AtTiffPage atTiffPage = new AtTiffPage(this.imageSource, this.pageIndex, this.demoShape);
        atTiffPage.printPageIndex = this.printPageIndex;
        atTiffPage.setZoom(this.getZoom());
        atTiffPage.isFitToPrintableArea = this.isFitToPrintableArea;
        atTiffPage.horizontallyCentered = this.horizontallyCentered;
        atTiffPage.verticallyCentered = this.verticallyCentered;
        super.copyAttributes((AbstractPage)atTiffPage);
        return atTiffPage;
    }

    protected void drawPrintable(Graphics graphics, PageFormat pageFormat, int n) {
        super.drawPrintable(graphics, pageFormat, n);
    }

    public BufferedImage getImage() {
        try {
            return this.a(this.pageIndex);
        }
        catch (IOException iOException) {
            AtDebug.debug((Throwable)iOException);
            throw new RuntimeException(iOException);
        }
    }

    private synchronized BufferedImage a(int n) throws IOException {
        TiffReader tiffReader = (TiffReader)this.imageSource;
        ++this.a;
        AtDebug.debug((String)(n + ": image load count...imageLoadCount=" + this.a));
        ImageDecoder imageDecoder = tiffReader.tiffDecoder;
        RenderedImage renderedImage = imageDecoder.decodeAsRenderedImage(n);
        PlanarImage planarImage = PlanarImage.wrapRenderedImage((RenderedImage)renderedImage);
        return planarImage.getAsBufferedImage();
    }
}

