/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.action;

import com.activetree.common.resource.AtCommonResource;
import com.activetree.common.resource.AtImageList;
import com.activetree.common.resource.AtResource;
import java.awt.Component;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public abstract class AtAbstractAction
extends AbstractAction {
    public static final String LARGE_ICON = "LARGE_ICON";
    public static final String MNEMONIC = "MNEMONIC_CHAR";
    public static final String ACCELERATOR_KEY = "AcceleratorKey";
    protected AtResource resource = AtCommonResource.MESSAGE_RESOURCE;
    protected AtImageList images = AtImageList.IMAGE_LIST;
    protected Component parent;

    public AtAbstractAction(String resourcetag) {
        super(AtCommonResource.MESSAGE_RESOURCE.getText(resourcetag));
        this.processResourceTag(resourcetag);
    }

    public AtAbstractAction(Component parent, String resourcetag) {
        super(AtCommonResource.MESSAGE_RESOURCE.getText(resourcetag));
        this.processResourceTag(resourcetag);
        this.parent = parent;
    }

    public AtAbstractAction(String resourcetag, Icon smicon, Icon lgicon) {
        super(AtCommonResource.MESSAGE_RESOURCE.getText(resourcetag), smicon);
        this.processResourceTag(resourcetag);
    }

    public AtAbstractAction(Component parent, String resourcetag, Icon smicon, Icon lgicon) {
        super(AtCommonResource.MESSAGE_RESOURCE.getText(resourcetag), smicon);
        this.processResourceTag(resourcetag);
        this.parent = parent;
    }

    public void setLargeIcon(Icon lgicon) {
        this.putValue(LARGE_ICON, lgicon);
    }

    public Icon getLargeIcon() {
        return (Icon)this.getValue(LARGE_ICON);
    }

    public void setSmallIcon(Icon smicon) {
        this.putValue("SmallIcon", smicon);
    }

    private void processResourceTag(String resourcetag) {
        KeyStroke k;
        char mn = this.resource.getMnemonic(resourcetag);
        if (mn != ' ') {
            this.putValue(MNEMONIC, new Character(mn));
        }
        if ((k = this.resource.getShortcut(resourcetag)) != null) {
            this.putValue(ACCELERATOR_KEY, k);
        }
    }
}

