/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.attr.reader;

import com.activetree.common.attr.WebDocAttributes;
import com.activetree.common.attr.reader.CommonAttributeReader;
import com.activetree.common.data.CellIndexData;
import com.activetree.common.data.ColorData;
import com.activetree.common.data.FontData;
import com.activetree.common.data.InsetsData;
import com.activetree.common.data.KeyValue;
import com.activetree.common.data.PathData;
import com.activetree.common.data.PointData;
import com.activetree.common.utils.AtDebug;
import com.activetree.common.web.BasicWebDoc;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class DefaultCommonAttributeReader
extends BasicWebDoc
implements WebDocAttributes,
CommonAttributeReader {
    protected final ArrayList gen_list = new ArrayList();
    protected static final String EMPTY_LABEL = "";
    public static boolean DEFAULT_BOOLEAN = false;
    public static int DEFAULT_INT = -1;

    public Map getAttributes() {
        return this.attributes;
    }

    public void clean() {
        super.clean();
        this.gen_list.clear();
    }

    public void setAttribute(String attr, Object value, Map map) {
        if (attr != null) {
            map.put(attr, value);
        }
    }

    public void setAttribute(String attr, Object attrValue) {
        String ts;
        if (attrValue != null && attrValue instanceof String && (ts = (String)attrValue).equalsIgnoreCase("null")) {
            AtDebug.debug("!!!!!! WOOPS !!!!!!! - [" + attr + "] was 4 char null - changed to null");
            attrValue = null;
        }
        String s = "setAttribute(" + attr + "=";
        if (attr.equals("PASSWORD") || attr.equalsIgnoreCase("URL_AUTH_ID") || attr.equals("URL_AUTH_PASSWORD") || attr.equals("LICENSE_KEY")) {
            String ts2 = DefaultCommonAttributeReader.getSecurityFilter(attrValue);
            s = s + "[" + ts2 + "])";
        } else {
            s = s + "[" + attrValue + "])";
        }
        this.attributes.put(attr, attrValue);
        if (attr.equalsIgnoreCase("JOB_ERROR_STACK") || attr.equalsIgnoreCase("JOB_ERROR_STACK")) {
            AtDebug.debug("setAttribute(" + attr + ") [unavailable]");
        } else {
            AtDebug.debug(s);
        }
    }

    public void setBooleanAttribute(String attr, boolean value) {
        this.setAttribute(attr, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public Object getAttribute(String attr) {
        String s = "getAttribute(" + attr + ") ";
        Object o = this.attributes.get(attr);
        if (o != null) {
            s = s + " [SELF]";
        }
        if (o == null) {
            Map defaultAttributes = this.getDefaultAttributes();
            o = defaultAttributes != null ? defaultAttributes.get(attr) : null;
            Object v0 = o;
            if (o != null) {
                s = s + " [DEFAULT]";
            }
        }
        if (o == null) {
            s = s + " [DOES NOT EXIST]";
        }
        if (!attr.equals("DEBUG")) {
            if (attr.equals("PASSWORD") || attr.equalsIgnoreCase("URL_AUTH_ID") || attr.equals("URL_AUTH_PASSWORD") || attr.equals("LICENSE_KEY")) {
                String ts = DefaultCommonAttributeReader.getSecurityFilter(o);
                AtDebug.debug(s + " value=[" + ts + "] len=" + (o != null && o instanceof String ? ((String)o).length() : 0));
            } else if (attr.equalsIgnoreCase("JOB_ERROR_STACK") || attr.equalsIgnoreCase("JOB_ERROR_STACK")) {
                AtDebug.debug("getAttribute(" + attr + ") [unavailable]");
            } else {
                AtDebug.debug(s + " value=[" + o + "] len=" + (o != null && o instanceof String ? ((String)o).length() : 0));
            }
        }
        return o;
    }

    public String getStringAttribute(String attr) {
        Object o = this.getAttribute(attr);
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        return o.toString();
    }

    public int getPrimitiveIntegerAttribute(String attr) {
        Object o = this.getAttribute(attr);
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o instanceof String) {
            try {
                return Integer.parseInt((String)o);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return -1;
    }

    public boolean getPrimitiveBooleanAttribute(String attr) {
        Object o = this.getAttribute(attr);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            try {
                return Boolean.valueOf((String)o);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public Iterator getParameterNames() {
        return this.attributes.keySet().iterator();
    }

    public Iterator getAttributeNames() {
        Iterator iter = this.getParameterNames();
        return iter;
    }

    public String valueOf(Boolean bool) {
        if (bool == null) {
            return Boolean.toString(false);
        }
        return bool.toString();
    }

    public String valueOf(Integer num) {
        if (num == null) {
            return "0";
        }
        return String.valueOf(num);
    }

    public String valueOf(URL url) {
        if (url == null) {
            return EMPTY_LABEL;
        }
        return url.toExternalForm();
    }

    public String[] getStringArrayAttribute(String attr) {
        Object o = this.getAttribute(attr);
        if (o instanceof String[]) {
            return (String[])o;
        }
        this.gen_list.clear();
        String s = this.getStringAttribute(attr);
        try {
            StringTokenizer tk = new StringTokenizer(s, ",");
            while (tk.hasMoreTokens()) {
                String t = tk.nextToken();
                if ((t = t.trim()).equalsIgnoreCase(EMPTY_LABEL)) continue;
                this.gen_list.add(t);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        String[] ary = this.toStringArray(this.gen_list);
        return ary;
    }

    public Object[] toObjectArray(List list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        Object[] ary = new Object[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ary[i] = list.get(i);
        }
        return ary;
    }

    public String[] toStringArray(List list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        String[] ary = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Object o = list.get(i);
            ary[i] = o instanceof String ? (String)o : (o != null ? o.toString() : null);
        }
        return ary;
    }

    public Boolean getBooleanAttribute(String attr) {
        Object o = this.getAttribute(attr);
        this.logErrorIf(attr, o, Boolean.class);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return null;
    }

    public Boolean[] getBooleanArrayAttribute(String attr) {
        Object o = this.getAttribute(attr);
        if (o instanceof Boolean[]) {
            return (Boolean[])o;
        }
        String[] boolAry = this.getStringArrayAttribute(attr);
        if (boolAry != null && boolAry.length > 0) {
            Boolean[] ret = new Boolean[boolAry.length];
            for (int i = 0; i < boolAry.length; ++i) {
                String s = boolAry[i];
                Boolean b = null;
                if (s != null && s.equalsIgnoreCase("true")) {
                    b = Boolean.TRUE;
                } else if (s != null && s.equalsIgnoreCase("false")) {
                    b = Boolean.FALSE;
                }
                ret[i] = b;
            }
            return ret;
        }
        return null;
    }

    public Double getDoubleAttribute(String attr) {
        Object o = this.getAttribute(attr);
        this.logErrorIf(attr, o, Double.class);
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Number) {
            return new Double(((Number)o).doubleValue());
        }
        return null;
    }

    public Float getFloatAttribute(String attr) {
        Object o = this.getAttribute(attr);
        this.logErrorIf(attr, o, Float.class);
        if (o instanceof Float) {
            return (Float)o;
        }
        if (o instanceof Number) {
            return new Float(((Number)o).floatValue());
        }
        return null;
    }

    public Number getNumberAttribute(String attr) {
        Object o = this.getAttribute(attr);
        this.logErrorIf(attr, o, Number.class);
        if (o instanceof Number) {
            return (Number)o;
        }
        return null;
    }

    public Double[] getDoubleArrayAttribute(String attrString) {
        Object o = this.getAttribute(attrString);
        if (o instanceof Double[]) {
            return (Double[])o;
        }
        String[] ary = this.getStringArrayAttribute(attrString);
        if (ary != null && ary.length > 0) {
            Double[] ret = new Double[ary.length];
            for (int i = 0; i < ary.length; ++i) {
                String s = ary[i];
                try {
                    double d = Double.parseDouble(s);
                    ret[i] = new Double(d);
                    continue;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            return ret;
        }
        return null;
    }

    public Integer getIntegerAttribute(String attr) {
        Object o = this.getAttribute(attr);
        this.logErrorIf(attr, o, Integer.class);
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Number) {
            return new Integer(((Number)o).intValue());
        }
        return null;
    }

    public Integer[] getIntegerArrayAttribute(String attrString) {
        Object o = this.getAttribute(attrString);
        if (o instanceof Integer[]) {
            return (Integer[])o;
        }
        String[] ary = this.getStringArrayAttribute(attrString);
        if (ary != null && ary.length > 0) {
            Integer[] ret = new Integer[ary.length];
            for (int i = 0; i < ary.length; ++i) {
                String s = ary[i];
                try {
                    int d = Integer.parseInt(s);
                    ret[i] = new Integer(d);
                    continue;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            return ret;
        }
        return null;
    }

    public Float[] getFloatArrayAttribute(String attrString) {
        Object o = this.getAttribute(attrString);
        if (o instanceof Float[]) {
            return (Float[])o;
        }
        String[] ary = this.getStringArrayAttribute(attrString);
        if (ary != null && ary.length > 0) {
            Float[] ret = new Float[ary.length];
            for (int i = 0; i < ary.length; ++i) {
                String s = ary[i];
                try {
                    float f = Float.parseFloat(s);
                    ret[i] = new Float(f);
                    continue;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            return ret;
        }
        return null;
    }

    public Float[] getFloatArray(String attr) {
        Object o = this.getAttribute(attr);
        if (o instanceof Float[]) {
            return (Float[])o;
        }
        return null;
    }

    public boolean getPrimitiveBooleanAttribute(String attr, boolean mustHave, boolean defaultValue) {
        Boolean b = this.getBooleanAttribute(attr);
        if (b != null) {
            return b;
        }
        return defaultValue;
    }

    public boolean[] getPrimitiveBooleanArrayAttribute(String attr) {
        Object o = this.getAttribute(attr);
        if (o instanceof boolean[]) {
            return (boolean[])o;
        }
        Boolean[] ary = this.getBooleanArrayAttribute(attr);
        boolean[] ret = ary != null && ary.length > 0 ? new boolean[ary.length] : null;
        for (int i = 0; ary != null && i < ary.length; ++i) {
            Boolean b = ary[i];
            ret[i] = b != null ? b : DEFAULT_BOOLEAN;
        }
        return ret;
    }

    public double getPrimitiveDoubleAttribute(String attr) {
        Double d = this.getDoubleAttribute(attr);
        return d != null ? d : (double)DEFAULT_INT;
    }

    public double[] getPrimitiveDoubleArrayAttribute(String attr) {
        Object o = this.getAttribute(attr);
        if (o instanceof double[]) {
            return (double[])o;
        }
        Double[] ary = this.getDoubleArrayAttribute(attr);
        double[] ret = ary != null && ary.length > 0 ? new double[ary.length] : null;
        for (int i = 0; ary != null && i < ary.length; ++i) {
            Double d = ary[i];
            ret[i] = d != null ? d : (double)DEFAULT_INT;
        }
        return ret;
    }

    public float getPrimitiveFloatAttribute(String attr) {
        Float f = this.getFloatAttribute(attr);
        if (f != null) {
            return f.floatValue();
        }
        return -1.0f;
    }

    public float[] getPrimitiveFloatArrayAttribute(String attr) {
        Object o = this.getAttribute(attr);
        if (o instanceof float[]) {
            return (float[])o;
        }
        Float[] ary = this.getFloatArrayAttribute(attr);
        float[] ret = ary != null && ary.length > 0 ? new float[ary.length] : null;
        for (int i = 0; ary != null && i < ary.length; ++i) {
            Float f = ary[i];
            ret[i] = f != null ? f.floatValue() : (float)DEFAULT_INT;
        }
        return ret;
    }

    public int[] getPrimitiveIntegerArrayAttribute(String attr) {
        Object obj = this.getAttribute(attr);
        if (obj instanceof int[]) {
            return (int[])obj;
        }
        Integer[] ary = this.getIntegerArrayAttribute(attr);
        int[] ret = ary != null && ary.length > 0 ? new int[ary.length] : null;
        for (int i = 0; ary != null && i < ary.length; ++i) {
            Integer o = ary[i];
            ret[i] = o != null ? o : DEFAULT_INT;
        }
        return ret;
    }

    public PathData getPathDataAttribute(String attr) {
        Object o = this.getAttribute(attr);
        this.logErrorIf(attr, o, PathData.class);
        if (o instanceof PathData) {
            return (PathData)o;
        }
        return null;
    }

    public PointData getPointDataAttribute(String attr) {
        Object o = this.getAttribute(attr);
        this.logErrorIf(attr, o, PointData.class);
        if (o instanceof PointData) {
            return (PointData)o;
        }
        return null;
    }

    public KeyValue getKeyValueAttribute(String attr) {
        Object o = this.getAttribute(attr);
        this.logErrorIf(attr, o, KeyValue.class);
        if (o instanceof KeyValue) {
            return (KeyValue)o;
        }
        return null;
    }

    public CellIndexData getCellIndexDataAttribute(String attr) {
        Object o = this.getAttribute(attr);
        this.logErrorIf(attr, o, CellIndexData.class);
        if (o instanceof CellIndexData) {
            return (CellIndexData)o;
        }
        return null;
    }

    public ColorData getColorDataAttribute(String attr) {
        Object o = this.getAttribute(attr);
        this.logErrorIf(attr, o, ColorData.class);
        if (o instanceof ColorData) {
            return (ColorData)o;
        }
        return null;
    }

    public FontData getFontDataAttribute(String attr) {
        Object o = this.getAttribute(attr);
        this.logErrorIf(attr, o, FontData.class);
        if (o instanceof FontData) {
            return (FontData)o;
        }
        return null;
    }

    public InsetsData getInsetsDataAttribute(String attr) {
        Object o = this.getAttribute(attr);
        this.logErrorIf(attr, o, InsetsData.class);
        if (o instanceof InsetsData) {
            return (InsetsData)o;
        }
        return null;
    }

    public static final String getSecurityFilter(Object o) {
        if (o == null) {
            return null;
        }
        if (!(o instanceof String)) {
            return "?";
        }
        StringBuffer buf = new StringBuffer((String)o);
        for (int i = 0; i < buf.length(); ++i) {
            buf.setCharAt(i, '*');
        }
        return buf.toString();
    }

    protected void logErrorIf(String key, Object attrValue, Class expCls) {
    }

    public String getDebugString() {
        return this.attributes.toString();
    }
}

