/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.conversion;

import com.activetree.common.attr.ConversionAttributes;
import com.activetree.common.attr.reader.DefaultCommonAttributeReader;
import com.activetree.common.conversion.ConversionFactory;
import com.activetree.common.conversion.PdfProperties;
import com.activetree.common.conversion.impl.ConverterWebDoc;
import com.activetree.common.data.KeyValue;
import com.activetree.common.doc.DocEvent;
import com.activetree.common.doc.DocListener;
import com.activetree.common.doc.DocPageable;
import com.activetree.common.doc.PrintDialog;
import com.activetree.common.object.DefaultPasswordProvider;
import com.activetree.common.page.AbstractPage;
import com.activetree.common.print.AbstractPrinter;
import com.activetree.common.utils.AtDebug;
import com.activetree.common.utils.MediaUtil;
import com.activetree.common.utils.WebDocUtil;
import com.activetree.common.utils.WebUtil;
import com.activetree.common.web.WebContext;
import com.activetree.common.web.WebContextImpl;
import com.activetree.common.web.WebDocAttributeParser;
import com.activetree.common.web.WebInterface;
import java.awt.Component;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class AbstractWebDocConverter
extends WebDocAttributeParser
implements ConversionAttributes {
    public AbstractWebDocConverter(WebInterface docParamContext) {
        super(docParamContext);
    }

    public void setAttribute(String attr, Object value) {
    }

    public Object getAttribute(String attr) {
        return null;
    }

    protected DefaultCommonAttributeReader createWebDoc() {
        return new ConverterWebDoc();
    }

    protected WebContext createWebContext(DefaultCommonAttributeReader webDoc) {
        Object appletContext = null;
        try {
            appletContext = this.getContext();
        }
        catch (Throwable t) {
            // empty catch block
        }
        Component owner = this.getContextOwner();
        WebContextImpl printCtx = new WebContextImpl(appletContext, webDoc, owner);
        return printCtx;
    }

    protected PrintDialog createPrintDialog() {
        return null;
    }

    protected void downloadPrintDialogCustomParams() {
    }

    protected boolean initDocParams(WebContext context) {
        this.inited = super.initDocParams(context);
        context.debug("AbstractWebDocConverter.super.initDocParams() - inited=" + this.inited);
        Boolean singleThreaded = this.getBooleanParameter("SINGLE_THREADED", null);
        String docType = this.getStringParameter("DOC_TYPE", null);
        Boolean autoMatchSize = this.getBooleanParameter("AUTO_MATCH_OUTPUT_TO_PAGE_SIZE", null);
        Number resizeFactor = this.getNumberParameter("RESIZE_FACTOR", null);
        String outputDir = this.getStringParameter("OUTPUT_DIRECTORY", null);
        Number qualityFactor = this.getNumberParameter("QUALITY_FACTOR", null);
        Number compressionAlg = this.getNumberParameter("COMPRESSION_ALGORITHM", null);
        Boolean useCompression = this.getBooleanParameter("USE_COMPRESSION", null);
        Boolean substituteFont = this.getBooleanParameter("SUBSTITUTE_FONT", null);
        Boolean applyPrepress = this.getBooleanParameter("APPLY_PREPRESS", null);
        Object outputStream = this.getObjectParameter("OUTPUT_STREAM");
        Number dpi = this.getNumberParameter("DPI", null);
        Boolean useDpi = this.getBooleanParameter("USE_DEFAULT_DPI", null);
        String prefixStr = this.getStringParameter("PREFIX_lIST", null);
        List prefixList = WebUtil.getDocListParameter(prefixStr);
        this.webDoc.setAttribute("SINGLE_THREADED", singleThreaded);
        this.webDoc.setAttribute("DOC_TYPE", docType);
        this.webDoc.setAttribute("AUTO_MATCH_OUTPUT_TO_PAGE_SIZE", autoMatchSize);
        this.webDoc.setAttribute("RESIZE_FACTOR", resizeFactor);
        this.webDoc.setAttribute("OUTPUT_DIRECTORY", outputDir);
        this.webDoc.setAttribute("QUALITY_FACTOR", qualityFactor);
        this.webDoc.setAttribute("COMPRESSION_ALGORITHM", compressionAlg);
        this.webDoc.setAttribute("USE_COMPRESSION", useCompression);
        this.webDoc.setAttribute("SUBSTITUTE_FONT", substituteFont);
        this.webDoc.setAttribute("APPLY_PREPRESS", applyPrepress);
        this.webDoc.setAttribute("OUTPUT_STREAM", outputStream);
        this.webDoc.setAttribute("DPI", dpi);
        this.webDoc.setAttribute("USE_DEFAULT_DPI", useDpi);
        this.webDoc.setAttribute("PREFIX_lIST", prefixList);
        context.debug("AbstractWebDocConverter.self.initDocParams() end - inited=" + this.inited);
        return true;
    }

    public void start() {
        boolean singleThreaded = this.webDoc.getPrimitiveBooleanAttribute("SINGLE_THREADED");
        if (singleThreaded) {
            this.webContext.debug("SINGLE_THREADED=true");
            this.run();
        } else {
            Thread t = new Thread(this);
            t.start();
            this.webContext.debug("#### Job launched ####");
        }
    }

    public void run() {
        if (!this.inited) {
            this.webContext.debug("AbstractWebDocConverter.run() - inited=" + this.inited + ", returning...no action.");
            return;
        }
        String docType = this.webDoc.getStringAttribute("DOC_TYPE");
        if (docType == null) {
            throw new RuntimeException("No DOC_TYPE set.");
        }
        String outputDir = this.getOutputDirectory();
        List prefixList = (List)this.webDoc.getAttribute("PREFIX_lIST");
        Object outputStream = this.getOutputStream();
        ArrayList<KeyValue> allPages = null;
        AbstractPrinter printer = null;
        List docList = (List)this.webDoc.getAttribute("DOC_LIST_OBJ");
        for (int i = 0; docList != null && i < docList.size(); ++i) {
            DocListener docListener;
            Object aDoc = docList.get(i);
            Pageable pages = null;
            try {
                printer = this.getPrinter();
                docListener = (DocListener)this.webDoc.getAttribute("DOC_LISTENER");
                if (docListener != null) {
                    printer.addDocListener(docListener);
                }
                this.setSecurityProvider(printer);
                pages = printer.getPageable(aDoc);
                this.processPrinterError(pages, printer);
            }
            catch (Throwable t) {
                DocListener docListener2 = (DocListener)this.webDoc.getAttribute("DOC_LISTENER");
                String format = this.webDoc.getStringAttribute("DOC_TYPE");
                DocEvent evt = new DocEvent(aDoc, 24, -1, format + ": " + t.getMessage());
                evt.setWebDoc(this.webDoc);
                if (docListener2 != null) {
                    docListener2.activityPerformed(evt);
                }
                if (printer == null) continue;
                printer.notifyEvent(evt);
                continue;
            }
            docListener = (DocListener)this.webDoc.getAttribute("DOC_LISTENER");
            DocEvent evt = new DocEvent(aDoc, 40, pages != null ? pages.getNumberOfPages() : 0, pages);
            evt.setWebDoc(this.webDoc);
            if (docListener != null) {
                docListener.activityPerformed(evt);
                pages = (Pageable)evt.getDetails();
            }
            if (printer != null) {
                printer.notifyEvent(evt);
                pages = (Pageable)evt.getDetails();
            }
            String prefixStr = null;
            try {
                prefixStr = (String)prefixList.get(i);
            }
            catch (Throwable t) {
                // empty catch block
            }
            for (int page = 0; pages != null && page < pages.getNumberOfPages(); ++page) {
                AbstractPage printable = (AbstractPage)pages.getPrintable(page);
                printable.setRenderingReason("PageRenderingReasonDataConversion");
                printable.setSource(aDoc);
                printable.setDocInfo(docType);
                Object outputFile = null;
                if (outputStream instanceof OutputStream) {
                    outputFile = outputStream;
                } else if (outputStream instanceof String) {
                    String s = outputDir + File.separatorChar + (String)outputStream;
                    outputFile = s;
                } else {
                    String fileName = null;
                    if (prefixStr == null) {
                        fileName = "page_";
                        fileName = fileName + (i + 1);
                    } else {
                        fileName = prefixStr;
                    }
                    fileName = fileName + "_";
                    fileName = fileName + (page + 1);
                    fileName = fileName + ".";
                    fileName = fileName + docType.toLowerCase();
                    outputFile = outputDir + File.separatorChar + fileName;
                }
                KeyValue kv = new KeyValue(outputFile, printable);
                KeyValue docKv = new KeyValue(aDoc, kv);
                if (allPages == null) {
                    allPages = new ArrayList<KeyValue>();
                }
                allPages.add(docKv);
            }
        }
        if (allPages == null) {
            return;
        }
        if (printer != null) {
            int pageCount = allPages != null ? allPages.size() : 0;
            printer.notifyPageCount(pageCount, docList);
        }
        if (docType.equalsIgnoreCase("PNG")) {
            this.convert("PNG", allPages, printer);
        } else if (docType.equalsIgnoreCase("GIF")) {
            this.convert("GIF", allPages, printer);
        } else if (docType.equalsIgnoreCase("BMP")) {
            this.convert("BMP", allPages, printer);
        } else if (docType.equalsIgnoreCase("JPG")) {
            this.convert("JPG", allPages, printer);
        } else if (docType.equalsIgnoreCase("PS")) {
            this.convertToPS(allPages, printer);
        } else if (docType.equalsIgnoreCase("PDF")) {
            this.convertToPDF(allPages, printer);
        } else if (docType.equalsIgnoreCase("TIF")) {
            this.convertToTIF(allPages, printer);
        } else {
            throw new RuntimeException("Unknown DOC_TYPE " + docType);
        }
        DocListener docListener = (DocListener)this.webDoc.getAttribute("DOC_LISTENER");
        Object docListStr = this.webDoc.getAttribute("DOC_LIST");
        DocEvent evt = new DocEvent(docListStr, 30, allPages != null ? allPages.size() : 0, docType);
        evt.setWebDoc(this.webDoc);
        if (docListener != null) {
            docListener.activityPerformed(evt);
        }
        if (printer != null) {
            printer.notifyEvent(evt);
        }
    }

    protected void convertToPS(List pages, AbstractPrinter printer) {
        block4: {
            Object writer = null;
            AbstractPage[] docPages = new AbstractPage[pages != null ? pages.size() : 0];
            for (int page = 0; pages != null && page < pages.size(); ++page) {
                AbstractPage aPage;
                KeyValue docKv = (KeyValue)pages.get(page);
                KeyValue kv = (KeyValue)docKv.value;
                writer = kv.key;
                docPages[page] = aPage = (AbstractPage)kv.value;
            }
            try {
                OutputStream outputStream = this.getDocOutputStream(writer);
                ConversionFactory.saveAsPostScript(docPages, outputStream);
            }
            catch (Throwable t) {
                DocListener docListener = (DocListener)this.webDoc.getAttribute("DOC_LISTENER");
                Object docList = this.webDoc.getAttribute("DOC_LIST");
                DocEvent evt = new DocEvent(docList, 24, -1, "PS: " + t.getMessage());
                evt.setWebDoc(this.webDoc);
                if (docListener != null) {
                    docListener.activityPerformed(evt);
                }
                if (printer == null) break block4;
                printer.notifyEvent(evt);
            }
        }
    }

    protected void convertToPDF(List pages, AbstractPrinter printer) {
        block10: {
            Object writer = null;
            DocPageable pageable = new DocPageable();
            for (int page = 0; pages != null && page < pages.size(); ++page) {
                KeyValue docKv = (KeyValue)pages.get(page);
                KeyValue kv = (KeyValue)docKv.value;
                writer = kv.key;
                AbstractPage aPage = (AbstractPage)kv.value;
                PageFormat pf = aPage.getPageFormat();
                String paperName = (String)this.webDoc.getAttribute("PAPER");
                if (paperName != null && paperName.length() > 0) {
                    PageFormat pfNew;
                    ArrayList paperParams = AbstractWebDocConverter.getPaperParams(paperName, this.webContext);
                    double topMargin = (Double)paperParams.get(0);
                    double leftMargin = (Double)paperParams.get(1);
                    double bottomMargin = (Double)paperParams.get(2);
                    double rightMargin = (Double)paperParams.get(3);
                    String widthStr = (String)paperParams.get(4);
                    double width = -1.0;
                    try {
                        width = Double.parseDouble(widthStr);
                    }
                    catch (Throwable t) {
                        AtDebug.debug(t);
                    }
                    String heightStr = (String)paperParams.get(5);
                    double height = -1.0;
                    try {
                        height = Double.parseDouble(heightStr);
                    }
                    catch (Throwable t) {
                        AtDebug.debug(t);
                    }
                    if ((width != -1.0 || height != -1.0) && (pfNew = WebDocAttributeParser.getPageFormatForSelectedMediaName(paperName, this.webContext)) != null) {
                        pf = pfNew;
                    }
                }
                MediaUtil.debugPageFormat(pf);
                aPage.setPageFormat(pf);
                aPage.setPrinterPageFormat(pf);
                pageable.append(aPage, pf);
            }
            int compressionAlgorithm = this.webDoc.getPrimitiveIntegerAttribute("COMPRESSION_ALGORITHM");
            boolean useCompression = this.webDoc.getPrimitiveBooleanAttribute("USE_COMPRESSION");
            boolean substituteFont = this.webDoc.getPrimitiveBooleanAttribute("SUBSTITUTE_FONT");
            boolean applyPrepress = this.webDoc.getPrimitiveBooleanAttribute("APPLY_PREPRESS");
            PdfProperties prop = new PdfProperties();
            prop.setCompressionAlgorithm(compressionAlgorithm);
            prop.setUseCompression(useCompression);
            prop.setAutoCorrectFontName(substituteFont);
            prop.setApplyPrepress(applyPrepress);
            try {
                OutputStream outputStream = this.getDocOutputStream(writer);
                ConversionFactory.saveAsPdf(outputStream, pageable, prop);
            }
            catch (Throwable t) {
                Object docList = this.webDoc.getAttribute("DOC_LIST");
                DocEvent evt = new DocEvent(docList, 24, -1, "PDF: " + t.getMessage());
                DocListener docListener = (DocListener)this.webDoc.getAttribute("DOC_LISTENER");
                evt.setWebDoc(this.webDoc);
                if (docListener != null) {
                    docListener.activityPerformed(evt);
                }
                if (printer == null) break block10;
                printer.notifyEvent(evt);
            }
        }
    }

    protected void convertToTIF(List pages, AbstractPrinter printer) {
        block4: {
            Object writer = null;
            AbstractPage[] docPages = new AbstractPage[pages != null ? pages.size() : 0];
            for (int page = 0; pages != null && page < pages.size(); ++page) {
                AbstractPage aPage;
                KeyValue docKv = (KeyValue)pages.get(page);
                KeyValue kv = (KeyValue)docKv.value;
                writer = kv.key;
                docPages[page] = aPage = (AbstractPage)kv.value;
            }
            int compressionAlgorithm = this.webDoc.getPrimitiveIntegerAttribute("COMPRESSION_ALGORITHM");
            boolean useCompression = this.webDoc.getPrimitiveBooleanAttribute("USE_COMPRESSION");
            int dpi = this.webDoc.getPrimitiveIntegerAttribute("DPI");
            boolean useDefaultDpi = this.webDoc.getPrimitiveBooleanAttribute("USE_DEFAULT_DPI");
            double resizeFactor = this.webDoc.getPrimitiveDoubleAttribute("RESIZE_FACTOR");
            boolean autoMatchToPaperSize = this.webDoc.getPrimitiveBooleanAttribute("AUTO_MATCH_OUTPUT_TO_PAGE_SIZE");
            try {
                OutputStream outputStream = this.getDocOutputStream(writer);
                ConversionFactory.saveAsTIFF(docPages, outputStream, useCompression, compressionAlgorithm, dpi, useDefaultDpi, resizeFactor, autoMatchToPaperSize);
            }
            catch (Throwable t) {
                DocListener docListener = (DocListener)this.webDoc.getAttribute("DOC_LISTENER");
                Object docList = this.webDoc.getAttribute("DOC_LIST");
                DocEvent evt = new DocEvent(docList, 24, -1, "TIF: " + t.getMessage());
                evt.setWebDoc(this.webDoc);
                if (docListener != null) {
                    docListener.activityPerformed(evt);
                }
                if (printer == null) break block4;
                printer.notifyEvent(evt);
            }
        }
    }

    protected OutputStream getDocOutputStream(Object writer) throws FileNotFoundException {
        OutputStream outputStream = null;
        if (writer instanceof OutputStream) {
            outputStream = (OutputStream)writer;
        } else if (writer instanceof String) {
            FileOutputStream fos = new FileOutputStream((String)writer);
            outputStream = fos;
        }
        return outputStream;
    }

    protected void convert(String format, List pages, AbstractPrinter printer) {
        double resizeFactor = this.webDoc.getPrimitiveDoubleAttribute("RESIZE_FACTOR");
        boolean autoMatchToPaperSize = this.webDoc.getPrimitiveBooleanAttribute("AUTO_MATCH_OUTPUT_TO_PAGE_SIZE");
        for (int page = 0; pages != null && page < pages.size(); ++page) {
            KeyValue docKv = (KeyValue)pages.get(page);
            Object aDoc = docKv.key;
            KeyValue kv = (KeyValue)docKv.value;
            String fileName = (String)kv.key;
            AbstractPage aPage = (AbstractPage)kv.value;
            this.saveAs(printer, format, aDoc, aPage, fileName, resizeFactor, autoMatchToPaperSize);
        }
    }

    protected void saveAs(AbstractPrinter printer, String format, Object aDoc, AbstractPage aPage, String fileName, double resizeFactor, boolean autoMatchToPaperSize) {
        block12: {
            DocListener docListener = (DocListener)this.webDoc.getAttribute("DOC_LISTENER");
            HashMap<String, Object> convProp = new HashMap<String, Object>();
            try {
                convProp.put("ConversionType", format);
                convProp.put("FileName", fileName);
                convProp.put("ResizeFactor", resizeFactor + "");
                convProp.put("AutomatchToPaperSize", new Boolean(autoMatchToPaperSize));
                if (format.equals("PNG")) {
                    ConversionFactory.saveAsPNG(aPage, fileName, resizeFactor, autoMatchToPaperSize);
                } else if (format.equals("BMP")) {
                    ConversionFactory.saveAsBMP(aPage, fileName, resizeFactor, autoMatchToPaperSize);
                } else if (format.equals("GIF")) {
                    ConversionFactory.saveAsGIF(aPage, fileName, resizeFactor, autoMatchToPaperSize);
                } else if (format.equals("JPG")) {
                    float qualityFactor = this.webDoc.getPrimitiveFloatAttribute("QUALITY_FACTOR");
                    ConversionFactory.saveAsJPEG(aPage, fileName, qualityFactor, resizeFactor, autoMatchToPaperSize);
                    convProp.put("QUALITY_FACTOR", qualityFactor + "");
                }
                DocEvent evt = new DocEvent(aDoc, 5, aPage.getPageIndex(), convProp);
                evt.setWebDoc(this.webDoc);
                if (docListener != null) {
                    docListener.activityPerformed(evt);
                }
                if (printer != null) {
                    printer.notifyEvent(evt);
                }
            }
            catch (Throwable t) {
                DocEvent evt = new DocEvent(aDoc, 24, aPage.getPageIndex(), format + ": " + t.getMessage(), convProp);
                evt.setWebDoc(this.webDoc);
                if (docListener != null) {
                    docListener.activityPerformed(evt);
                }
                if (printer == null) break block12;
                printer.notifyEvent(evt);
            }
        }
    }

    protected String getOutputDirectory() {
        File f;
        String outputDir = ".";
        String outputDirStr = this.webDoc.getStringAttribute("OUTPUT_DIRECTORY");
        if (outputDirStr != null) {
            f = new File(outputDirStr);
            boolean isDir = f.isDirectory();
            if (isDir) {
                outputDir = outputDirStr;
            } else {
                this.webContext.debug(7, "WARNING: \"OUTPUT_DIRECTORY\" - does not exist (default to: \".\"");
            }
        }
        f = new File(outputDir);
        String dirPath = f.getAbsolutePath();
        this.webContext.debug("Output Directory Path: " + dirPath);
        return dirPath;
    }

    protected Object getOutputStream() {
        String type = this.webDoc.getStringAttribute("DOC_TYPE");
        type = type.toLowerCase();
        Object o = this.webDoc.getAttribute("OUTPUT_STREAM");
        if (o instanceof OutputStream) {
            return o;
        }
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    protected void setSecurityProvider(AbstractPrinter printer) {
        if (printer == null) {
            return;
        }
        DefaultPasswordProvider auth = WebDocUtil.createAuthenticator(this.webDoc);
        printer.setPasswordProvider(auth);
    }

    protected abstract AbstractPrinter getPrinter();
}

