/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.conversion;

import com.activetree.common.conversion.PdfProperties;
import com.activetree.common.conversion.impl.BMP;
import com.activetree.common.conversion.impl.GIF;
import com.activetree.common.conversion.impl.JPEG;
import com.activetree.common.conversion.impl.JPG;
import com.activetree.common.conversion.impl.MemoryImageMaker;
import com.activetree.common.conversion.impl.PDF;
import com.activetree.common.conversion.impl.PNG;
import com.activetree.common.conversion.impl.PostScript;
import com.activetree.common.conversion.impl.TIFF;
import com.activetree.common.exception.AtException;
import com.activetree.common.page.AbstractPage;
import java.awt.image.BufferedImage;
import java.awt.print.Pageable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageOutputStream;

public final class ConversionFactory
implements Serializable {
    public static final void saveAsPdf(OutputStream outputStream, Pageable pageable) throws ClassNotFoundException, AtException {
        ConversionFactory.saveAsPdf(outputStream, pageable, new PdfProperties());
    }

    public static final void saveAsPdf(OutputStream outputStream, Pageable pageable, PdfProperties pdfProperties) throws ClassNotFoundException, AtException {
        PDF pdf = new PDF();
        pdf.saveAsPdf(outputStream, pageable, pdfProperties);
    }

    public static final InputStream getAsPdf(Pageable pageable, PdfProperties pdfProperties) throws ClassNotFoundException, AtException {
        PDF pdf = new PDF();
        InputStream pdfStream = pdf.getAsPdf(pageable, pdfProperties);
        return pdfStream;
    }

    public static final void saveAsRTF(OutputStream outputStream, Pageable pageable) throws ClassNotFoundException, AtException {
        throw new ClassNotFoundException("ClassNotFoundException: write to support@activetree.com for help.");
    }

    public static final InputStream getAsRTF(Pageable pageable) throws ClassNotFoundException, AtException {
        throw new ClassNotFoundException("ClassNotFoundException: write to support@activetree.com for help.");
    }

    public static final void saveAsPNG(AbstractPage page, String outputFileName) throws AtException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(outputFileName);
        }
        catch (Throwable t) {
            throw new AtException(t);
        }
        ConversionFactory.saveAsPNG(page, outputStream);
    }

    public static final void saveAsPNG(AbstractPage page, String outputFileName, double resizeFactor, boolean autoMatchToPaperSize) throws AtException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(outputFileName);
        }
        catch (Throwable t) {
            throw new AtException(t);
        }
        ConversionFactory.saveAsPNG(page, outputStream, resizeFactor, autoMatchToPaperSize);
    }

    public static final void saveAsPNG(AbstractPage page, OutputStream outputStream) throws AtException {
        boolean autoMatchToPaperSize = false;
        double resizeFactor = 1.0;
        ConversionFactory.saveAsPNG(page, outputStream, resizeFactor, autoMatchToPaperSize);
    }

    public static final void saveAsPNG(AbstractPage page, OutputStream outputStream, double resizeFactor, boolean autoMatchToPaperSize) throws AtException {
        PNG.saveAsPNG(page, outputStream, resizeFactor, autoMatchToPaperSize);
    }

    public static final void saveAsJPEG(AbstractPage page, String outputFileName, float qualityFactor) throws AtException {
        boolean autoMatchToPaperSize = false;
        ConversionFactory.saveAsJPEG(page, outputFileName, qualityFactor, autoMatchToPaperSize);
    }

    public static final void saveAsJPEG(AbstractPage page, String outputFileName, float qualityFactor, boolean autoMatchToPaperSize) throws AtException {
        FileImageOutputStream output = null;
        try {
            File file = new File(outputFileName);
            output = new FileImageOutputStream(file);
        }
        catch (Throwable t) {
            throw new AtException(t);
        }
        double resizeFactor = 1.0;
        ConversionFactory.saveAsJPEG(page, output, qualityFactor, resizeFactor, autoMatchToPaperSize);
    }

    public static final void saveAsJPEG(AbstractPage page, String outputFileName, float qualityFactor, double resizeFactor, boolean autoMatchToPaperSize) throws AtException {
        FileImageOutputStream output = null;
        try {
            File file = new File(outputFileName);
            output = new FileImageOutputStream(file);
        }
        catch (Throwable t) {
            throw new AtException(t);
        }
        ConversionFactory.saveAsJPEG(page, output, qualityFactor, resizeFactor, autoMatchToPaperSize);
    }

    public static final void saveAsJPEG(AbstractPage page, ImageOutputStream outputStream, float qualityFactor) throws AtException {
        boolean autoMatchToPaperSize = false;
        double resizeFactor = 1.0;
        ConversionFactory.saveAsJPEG(page, outputStream, qualityFactor, resizeFactor, autoMatchToPaperSize);
    }

    public static final void saveAsJPEG(AbstractPage page, ImageOutputStream outputStream, float qualityFactor, double resizeFactor, boolean autoMatchToPaperSize) throws AtException {
        JPEG.saveAsJPEG(page, outputStream, qualityFactor, resizeFactor, autoMatchToPaperSize);
    }

    public static final void saveAsJPG(AbstractPage page, ImageOutputStream outputStream, float qualityFactor, double resizeFactor, boolean autoMatchToPaperSize) throws AtException {
        JPG.saveAsJPG(page, outputStream, qualityFactor, resizeFactor, autoMatchToPaperSize);
    }

    public static final BufferedImage[] getImagesForPages(AbstractPage[] pages) throws AtException {
        double resizeFactor = 1.0;
        boolean autoMatchToPaperSize = false;
        BufferedImage[] imgs = ConversionFactory.getImagesForPages(pages, resizeFactor, autoMatchToPaperSize);
        return imgs;
    }

    public static final BufferedImage[] getImagesForPages(AbstractPage[] pages, double resizeFactor, boolean autoMatchToPaperSize) throws AtException {
        BufferedImage[] output = MemoryImageMaker.getImagesForPages(pages, resizeFactor, autoMatchToPaperSize);
        return output;
    }

    public static final void saveAsTIFF(AbstractPage[] allPages, String outputFileName, boolean compress) throws AtException {
        FileOutputStream outputStream = null;
        try {
            String filename = outputFileName;
            outputStream = new FileOutputStream(filename);
        }
        catch (Throwable t) {
            throw new AtException(t);
        }
        ConversionFactory.saveAsTIFF(allPages, outputStream, compress);
    }

    public static final void saveAsTIFF(AbstractPage[] allPages, String outputFileName, boolean compress, int compressionAlgorithm) throws AtException {
        FileOutputStream outputStream = null;
        try {
            String filename = outputFileName;
            outputStream = new FileOutputStream(filename);
        }
        catch (Throwable t) {
            throw new AtException(t);
        }
        ConversionFactory.saveAsTIFF(allPages, outputStream, compress, compressionAlgorithm);
    }

    public static final void saveAsTIFF(AbstractPage[] allPages, OutputStream outputStream, boolean compress) throws AtException {
        int COMPRESSION_PACKBITS = 32773;
        ConversionFactory.saveAsTIFF(allPages, outputStream, compress, COMPRESSION_PACKBITS);
    }

    public static final void saveAsTIFF(AbstractPage[] allPages, OutputStream outputStream, boolean compress, int compressionAlgorithm) throws AtException {
        boolean isUseDpi = true;
        ConversionFactory.saveAsTIFF(allPages, outputStream, compress, compressionAlgorithm, -1, isUseDpi);
    }

    public static final void saveAsTIFF(AbstractPage[] allPages, OutputStream outputStream, boolean compress, int compressionAlgorithm, int dpi) throws AtException {
        ConversionFactory.saveAsTIFF(allPages, outputStream, compress, compressionAlgorithm, dpi, false);
    }

    public static final void saveAsTIFF(AbstractPage[] allPages, OutputStream outputStream, boolean compress, int compressionAlgorithm, int dpi, boolean isUseDefaultDpi) throws AtException {
        boolean autoMatchToPaperSize = false;
        double resizeFactor = 1.0;
        ConversionFactory.saveAsTIFF(allPages, outputStream, compress, compressionAlgorithm, dpi, isUseDefaultDpi, resizeFactor, autoMatchToPaperSize);
    }

    public static final void saveAsTIFF(AbstractPage[] allPages, OutputStream outputStream, boolean compress, int compressionAlgorithm, int dpi, boolean isUseDefaultDpi, double resizeFactor, boolean autoMatchToPaperSize) throws AtException {
        TIFF.saveAsTIFF(allPages, outputStream, compress, compressionAlgorithm, dpi, isUseDefaultDpi, resizeFactor, autoMatchToPaperSize);
    }

    public static final void saveAsGIF(AbstractPage page, String outputFileName, double resizeFactor, boolean autoMatchToPaperSize) throws AtException {
        GIF.saveAsGIF(page, outputFileName, resizeFactor, autoMatchToPaperSize);
    }

    public static final void saveAsGIF(AbstractPage page, OutputStream outputStream, double resizeFactor, boolean autoMatchToPaperSize) throws AtException {
        GIF.saveAsGIF(page, outputStream, resizeFactor, autoMatchToPaperSize);
    }

    public static final void saveAsBMP(AbstractPage page, String outputFileName, double resizeFactor, boolean autoMatchToPaperSize) throws AtException {
        try {
            FileOutputStream outputStream = new FileOutputStream(outputFileName);
            ConversionFactory.saveAsBMP(page, outputStream, resizeFactor, autoMatchToPaperSize);
        }
        catch (Throwable t) {
            throw new AtException(t);
        }
    }

    public static final void saveAsBMP(AbstractPage page, OutputStream outputStream, double resizeFactor, boolean autoMatchToPaperSize) throws AtException {
        BMP.saveAsBMP(page, outputStream, resizeFactor, autoMatchToPaperSize);
    }

    public static final InputStream getPostScriptOutput(AbstractPage[] pages) throws Exception {
        InputStream is = new PostScript().getAsPostScript(pages);
        return is;
    }

    public static final void saveAsPostScript(AbstractPage[] pages, OutputStream psStream) throws Exception {
        new PostScript().saveAsPostScript(pages, psStream);
    }
}

