/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.conversion;

import com.activetree.common.data.ColorData;
import com.activetree.common.data.FontData;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class PdfProperties
implements Serializable {
    public static final String TEXT_AS_GLYPH = "TEXT_AS_GLYPH";
    public static final String AUTO_CORRECT_FONT_NAME = "SUBSTITUTE_FONT";
    public static final String USE_COMPRESSION = "APPLY_COMPRESSION";
    public static final String COMPRESSION_ALGORITHM = "COMPRESSION_ALGORITHM";
    public static final String APPLY_PREPRESS = "APPLY_PREPRESS";
    public static final String EMBED_FONTS = "EMBED_FONTS";
    public static final String EMBED_FONTS_AS = "EMBED_FONTS_AS";
    public static final String DEFAULT_FONT = "DEFAULT_FONT";
    public static final String DEFAULT_FOREGROUND = "DEFAULT_FOREGROUND";
    public static final String DEFAULT_BACKGROUND = "DEFAULT_BACKGROUND";
    public static final String DEFAULT_STROKE = "DEFAULT_STROKE";
    public static final String DEFAULT_COMPOSITE = "DEFAULT_COMPOSITE";
    public static final String IS_TYPE1_ENCRYPT = "IS_TYPE1_ENCRYPT";
    public static final String TYPE1_ENCRYPTION_METHOD = "TYPE1_ENCRYPTION_METHOD";
    public static final String TYPE1_ADD_ZEROS = "TYPE1_ADD_ZEROS";
    public static final Integer ENCRYPTION_HEX = new Integer(100);
    public static final String EMBED_TYPE1 = "Type1";
    public static final String EMBED_TYPE3 = "Type3";
    public static final String EMBED_TRUE_TYPE = "TrueType";
    public static final String EMBED_UNICODE = "Unicode";
    public static final Integer COMPRESSION_FLATE_DECODE = new Integer(32946);
    public static final Integer COMPRESSION_NONE = new Integer(1);
    public static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    public static final String ENCODING = "ENCODING";
    public static final String IDENTITY_H = "Identity-H";
    public static final String IDENTITY_V = "Identity-V";
    public static final String CP1252 = "Cp1252";
    public static final String WINANSI = "Cp1252";
    public static final String INCLUDE_FONT_SUBSET = "includeFontSubset";
    private static HashMap defaultAttrs = new HashMap();
    private HashMap attrs = new HashMap();
    protected String producer = "Smart jPDFWriter";
    protected String author = "ActiveTree";
    protected String getDate;
    protected String title = "Java PDF Writer";
    protected String subject = "Java PDF Writer";
    protected String keywords = "Java PDF Writer";
    private HashMap failoverFontMap;

    public void addToFailoverFontMap(String javaFontNameMayFail, FontData javaFontToFailover) {
        if (this.failoverFontMap == null) {
            this.failoverFontMap = new HashMap();
        }
        String fontName = javaFontNameMayFail.trim().toLowerCase();
        this.failoverFontMap.put(fontName, javaFontToFailover);
    }

    public Map getFailoverFontMap() {
        return this.failoverFontMap;
    }

    public void setAttribute(String attr, Object value) {
        if (attr == null || value == null) {
            throw new NullPointerException("Key \"" + attr + "\", value \"" + value + "\" is not allowed.");
        }
        this.attrs.put(attr, value);
    }

    public Object getAttribute(String attr) {
        Object o = this.attrs.get(attr);
        if (o == null) {
            o = defaultAttrs.get(attr);
        }
        return o;
    }

    public boolean getPrimitiveBooleanAttribute(String attr) {
        Boolean b = (Boolean)this.getAttribute(attr);
        if (b != null) {
            return b;
        }
        return false;
    }

    public int getPrimitiveIntegerValue(String attr) {
        Integer o = (Integer)this.getAttribute(attr);
        if (o != null) {
            return o;
        }
        return -1;
    }

    public String getStringAttribute(String attr) {
        Object s = this.getAttribute(attr);
        if (s != null) {
            return s.toString();
        }
        return null;
    }

    public int getCompressionAlgorithm() {
        Integer o = (Integer)this.getAttribute(COMPRESSION_ALGORITHM);
        if (o == null) {
            o = COMPRESSION_FLATE_DECODE;
        }
        return o;
    }

    public void setCompressionAlgorithm(int compressionAlgorithm) {
        this.setAttribute(COMPRESSION_ALGORITHM, new Integer(compressionAlgorithm));
    }

    public boolean isAutoCorrectFontName() {
        Boolean o = (Boolean)this.getAttribute(AUTO_CORRECT_FONT_NAME);
        if (o == null) {
            o = Boolean.FALSE;
        }
        return o;
    }

    public void setAutoCorrectFontName(boolean substituteFont) {
        this.setAttribute(AUTO_CORRECT_FONT_NAME, new Boolean(substituteFont));
    }

    public boolean isUseCompression() {
        Boolean o = (Boolean)this.getAttribute(USE_COMPRESSION);
        if (o == null) {
            o = Boolean.TRUE;
        }
        return o;
    }

    public void setUseCompression(boolean useCompression) {
        this.setAttribute(USE_COMPRESSION, new Boolean(useCompression));
    }

    public boolean isApplyPrepress() {
        Boolean o = (Boolean)this.getAttribute(APPLY_PREPRESS);
        if (o == null) {
            o = Boolean.TRUE;
        }
        return o;
    }

    public void setApplyPrepress(boolean applyPrepress) {
        this.setAttribute(APPLY_PREPRESS, new Boolean(applyPrepress));
    }

    public boolean isEmbedFont() {
        Boolean o = (Boolean)this.getAttribute(EMBED_FONTS);
        if (o == null) {
            o = Boolean.TRUE;
        }
        return o;
    }

    public void setEmbedFont(boolean embedFont) {
        this.setAttribute(EMBED_FONTS, new Boolean(embedFont));
    }

    public void setProducer(String producer) {
    }

    public String getProducer() {
        return this.producer == null ? "" : this.producer;
    }

    public String getTitle() {
        return this.title == null ? "" : this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getAuthor() {
        if (this.author == null) {
            String user = "";
            try {
                user = System.getProperty("user.name");
                return user;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.author;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getSubject() {
        return this.subject == null ? "" : this.subject;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public String getKeywords() {
        return this.keywords == null ? "" : this.keywords;
    }

    public String getCreationDate() {
        String tz;
        Calendar date = Calendar.getInstance();
        int offset = date.get(15) + date.get(16);
        if (offset == 0) {
            tz = "Z";
        } else {
            DecimalFormat fmt = new DecimalFormat("00");
            int tzh = Math.abs(offset / 3600000);
            int tzm = Math.abs(offset % 3600000);
            tz = offset > 0 ? "+" + fmt.format(tzh) + "'" + fmt.format(tzm) + "'" : "-" + fmt.format(tzh) + "'" + fmt.format(tzm) + "'";
        }
        return "" + dateFormat.format(date.getTime()) + tz + "";
    }

    static {
        defaultAttrs.put(USE_COMPRESSION, Boolean.TRUE);
        defaultAttrs.put(COMPRESSION_ALGORITHM, COMPRESSION_FLATE_DECODE);
        defaultAttrs.put(AUTO_CORRECT_FONT_NAME, Boolean.FALSE);
        defaultAttrs.put(APPLY_PREPRESS, Boolean.TRUE);
        defaultAttrs.put(TEXT_AS_GLYPH, Boolean.FALSE);
        defaultAttrs.put(EMBED_FONTS, Boolean.TRUE);
        defaultAttrs.put(EMBED_FONTS_AS, EMBED_UNICODE);
        defaultAttrs.put(ENCODING, IDENTITY_H);
        defaultAttrs.put(INCLUDE_FONT_SUBSET, Boolean.FALSE);
        defaultAttrs.put(DEFAULT_FONT, new FontData("Helvetica", "plain", 10));
        defaultAttrs.put(DEFAULT_FOREGROUND, new ColorData(0, 0, 0, 255));
        defaultAttrs.put(DEFAULT_BACKGROUND, new ColorData(255, 255, 255, 255));
        defaultAttrs.put(IS_TYPE1_ENCRYPT, Boolean.FALSE);
        defaultAttrs.put(TYPE1_ENCRYPTION_METHOD, ENCRYPTION_HEX);
        defaultAttrs.put(TYPE1_ADD_ZEROS, Boolean.TRUE);
    }
}

