/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.conversion.impl;

import com.activetree.common.conversion.impl.BMPConverterPrivate;
import com.activetree.common.conversion.impl.ImageBase;
import com.activetree.common.exception.AtException;
import com.activetree.common.page.AbstractPage;
import com.activetree.common.utils.AtDebug;
import com.activetree.common.utils.StringUtil;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class BMP
extends ImageBase {
    public static final void saveAsBMP(AbstractPage page, String outputFileName, double resizeFactor, boolean autoMatchToPaperSize) throws AtException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(outputFileName);
        }
        catch (Throwable t) {
            String stack = StringUtil.getStackTrace(t);
            throw new AtException(stack);
        }
        BMP.saveAsBMP(page, outputStream, resizeFactor, autoMatchToPaperSize);
    }

    public static void saveAsBMP(AbstractPage page, OutputStream outputStream, double resizeFactor, boolean autoMatchToPaperSize) throws AtException {
        BMPConverterPrivate bmpConverter = new BMPConverterPrivate(FORMAT);
        bmpConverter.saveAsBMP(page, outputStream, resizeFactor, autoMatchToPaperSize);
    }

    public static final Image loadBMP(InputStream inputStream) {
        try {
            Image image;
            InputStream fs = inputStream;
            int bflen = 14;
            byte[] bf = new byte[bflen];
            fs.read(bf, 0, bflen);
            int bilen = 40;
            byte[] bi = new byte[bilen];
            fs.read(bi, 0, bilen);
            int nsize = (bf[5] & 0xFF) << 24 | (bf[4] & 0xFF) << 16 | (bf[3] & 0xFF) << 8 | bf[2] & 0xFF;
            int nbisize = (bi[3] & 0xFF) << 24 | (bi[2] & 0xFF) << 16 | (bi[1] & 0xFF) << 8 | bi[0] & 0xFF;
            int nwidth = (bi[7] & 0xFF) << 24 | (bi[6] & 0xFF) << 16 | (bi[5] & 0xFF) << 8 | bi[4] & 0xFF;
            int nheight = (bi[11] & 0xFF) << 24 | (bi[10] & 0xFF) << 16 | (bi[9] & 0xFF) << 8 | bi[8] & 0xFF;
            int nplanes = (bi[13] & 0xFF) << 8 | bi[12] & 0xFF;
            int nbitcount = (bi[15] & 0xFF) << 8 | bi[14] & 0xFF;
            int ncompression = bi[19] << 24 | bi[18] << 16 | bi[17] << 8 | bi[16];
            int nsizeimage = (bi[23] & 0xFF) << 24 | (bi[22] & 0xFF) << 16 | (bi[21] & 0xFF) << 8 | bi[20] & 0xFF;
            int nxpm = (bi[27] & 0xFF) << 24 | (bi[26] & 0xFF) << 16 | (bi[25] & 0xFF) << 8 | bi[24] & 0xFF;
            int nypm = (bi[31] & 0xFF) << 24 | (bi[30] & 0xFF) << 16 | (bi[29] & 0xFF) << 8 | bi[28] & 0xFF;
            int nclrused = (bi[35] & 0xFF) << 24 | (bi[34] & 0xFF) << 16 | (bi[33] & 0xFF) << 8 | bi[32] & 0xFF;
            int nclrimp = (bi[39] & 0xFF) << 24 | (bi[38] & 0xFF) << 16 | (bi[37] & 0xFF) << 8 | bi[36] & 0xFF;
            if (nbitcount == 24) {
                int npad = nsizeimage / nheight - nwidth * 3;
                int[] ndata = new int[nheight * nwidth];
                byte[] brgb = new byte[(nwidth + npad) * 3 * nheight];
                fs.read(brgb, 0, (nwidth + npad) * 3 * nheight);
                int nindex = 0;
                for (int j = 0; j < nheight; ++j) {
                    for (int i = 0; i < nwidth; ++i) {
                        ndata[nwidth * (nheight - j - 1) + i] = 0xFF000000 | (brgb[nindex + 2] & 0xFF) << 16 | (brgb[nindex + 1] & 0xFF) << 8 | brgb[nindex] & 0xFF;
                        nindex += 3;
                    }
                    nindex += npad;
                }
                MemoryImageSource mis = new MemoryImageSource(nwidth, nheight, ndata, 0, nwidth);
                image = Toolkit.getDefaultToolkit().createImage(mis);
            } else if (nbitcount == 8) {
                int nNumColors = 0;
                nNumColors = nclrused > 0 ? nclrused : 1 << nbitcount;
                if (nsizeimage == 0) {
                    nsizeimage = (nwidth * nbitcount + 31 & 0xFFFFFFE0) >> 3;
                    nsizeimage *= nheight;
                }
                int[] npalette = new int[nNumColors];
                byte[] bpalette = new byte[nNumColors * 4];
                fs.read(bpalette, 0, nNumColors * 4);
                int nindex8 = 0;
                for (int n = 0; n < nNumColors; ++n) {
                    npalette[n] = 0xFF000000 | (bpalette[nindex8 + 2] & 0xFF) << 16 | (bpalette[nindex8 + 1] & 0xFF) << 8 | bpalette[nindex8] & 0xFF;
                    nindex8 += 4;
                }
                int npad8 = nsizeimage / nheight - nwidth;
                int[] ndata8 = new int[nwidth * nheight];
                byte[] bdata = new byte[(nwidth + npad8) * nheight];
                fs.read(bdata, 0, (nwidth + npad8) * nheight);
                nindex8 = 0;
                for (int j8 = 0; j8 < nheight; ++j8) {
                    for (int i8 = 0; i8 < nwidth; ++i8) {
                        ndata8[nwidth * (nheight - j8 - 1) + i8] = npalette[bdata[nindex8] & 0xFF];
                        ++nindex8;
                    }
                    nindex8 += npad8;
                }
                MemoryImageSource mis = new MemoryImageSource(nwidth, nheight, ndata8, 0, nwidth);
                image = Toolkit.getDefaultToolkit().createImage(mis);
            } else {
                image = null;
            }
            fs.close();
            return image;
        }
        catch (Exception e) {
            AtDebug.debug(9, "Caught exception in loadbitmap!");
            AtDebug.debug(9, e);
            return null;
        }
    }

    static {
        FORMAT = "BMP";
    }
}

