/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.conversion.impl;

import com.activetree.common.conversion.impl.ImageJAI;
import com.activetree.common.conversion.impl.MemoryImageMaker;
import com.activetree.common.exception.AtException;
import com.activetree.common.page.AbstractPage;
import com.activetree.common.utils.JreUtil;
import com.activetree.common.utils.StringUtil;
import com.sun.media.jai.codec.BMPEncodeParam;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoder;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class BMPConverterPrivate
extends ImageJAI {
    String FORMAT = "BMP";

    BMPConverterPrivate(String format) throws AtException {
        this.FORMAT = format;
    }

    void saveAsBMP(AbstractPage page, OutputStream outputStream, double resizeFactor, boolean autoMatchToPaperSize) throws AtException {
        try {
            AbstractPage[] pages = new AbstractPage[]{page};
            BufferedImage[] images = MemoryImageMaker.getImagesForPages(pages, resizeFactor, autoMatchToPaperSize);
            if (JreUtil.isJreEqualsOrHigher("1.6")) {
                ImageIO.write((RenderedImage)images[0], "BMP", outputStream);
            } else {
                BMPEncodeParam bmpEncodeParam = new BMPEncodeParam();
                bmpEncodeParam.setCompressed(false);
                ImageEncoder encoder = ImageCodec.createImageEncoder((String)this.FORMAT, (OutputStream)outputStream, (ImageEncodeParam)bmpEncodeParam);
                for (int i = 0; images != null && i < images.length; ++i) {
                    encoder.encode((RenderedImage)images[i]);
                }
            }
            outputStream.close();
        }
        catch (Throwable t) {
            String stack = StringUtil.getStackTrace(t);
            throw new AtException(stack);
        }
    }
}

