/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.conversion.impl;

import com.activetree.common.conversion.impl.ImageBase;
import com.activetree.common.conversion.impl.MemoryImageMaker;
import com.activetree.common.exception.AtException;
import com.activetree.common.page.AbstractPage;
import com.activetree.common.utils.StringUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;

public class GIF
extends ImageBase {
    public static final void saveAsGIF(AbstractPage page, String outputFileName, double resizeFactor, boolean autoMatchToPaperSize) throws AtException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(outputFileName);
        }
        catch (Throwable t) {
            String stack = StringUtil.getStackTrace(t);
            throw new AtException(stack);
        }
        GIF.saveAsGIF(page, outputStream, resizeFactor, autoMatchToPaperSize);
    }

    public static void saveAsGIF(AbstractPage page, OutputStream outputStream, double resizeFactor, boolean autoMatchToPaperSize) throws AtException {
        try {
            ImageWriter writer;
            AbstractPage[] pages = new AbstractPage[]{page};
            BufferedImage[] images = MemoryImageMaker.getImagesForPages(pages, resizeFactor, autoMatchToPaperSize);
            boolean useImageIo = false;
            Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(FORMAT);
            if (iter.hasNext() && (writer = iter.next()) != null) {
                useImageIo = true;
            }
            if (!useImageIo) {
                throw new RuntimeException("You need JRE 1.6.0 or higher version of Java Runtime for " + FORMAT + " conversion.");
            }
            ImageIO.write((RenderedImage)images[0], FORMAT, outputStream);
            outputStream.close();
        }
        catch (Throwable t) {
            throw new AtException(t);
        }
    }

    static {
        FORMAT = "GIF";
    }
}

