/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.conversion.impl;

import com.activetree.common.exception.AtException;
import com.activetree.common.page.AbstractPage;
import com.activetree.common.utils.AtDebug;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;

public class MIMConverterPrivate {
    final BufferedImage[] getImagesForPages(AbstractPage[] pages) throws AtException {
        boolean autoMatchToPaperSize = false;
        double resizeFactor = 1.0;
        BufferedImage[] imgs = this.getImagesForPages(pages, resizeFactor, autoMatchToPaperSize);
        return imgs;
    }

    final BufferedImage[] getImagesForPages(AbstractPage[] pages, double resizeFactor, boolean autoMatchToPaperSize) throws AtException {
        if (pages == null) {
            throw new AtException("null pages can not convert.");
        }
        BufferedImage[] pagesAsImage = new BufferedImage[pages.length];
        for (int i = 0; i < pages.length; ++i) {
            AbstractPage orgPage = pages[i];
            AbstractPage aPage = orgPage.newInstance();
            PageFormat orgPageFormat = aPage.getPageFormat();
            if (orgPageFormat != null) {
                orgPageFormat = (PageFormat)orgPageFormat.clone();
            }
            aPage.resizePageFormat(aPage, resizeFactor, autoMatchToPaperSize);
            double scale = aPage.getScale();
            BufferedImage pageImage = null;
            double pageWidth = orgPageFormat.getWidth() * scale;
            double pageHeight = orgPageFormat.getHeight() * scale;
            AtDebug.debug("getImagesForPages()...pageW=" + pageWidth + ", pageH=" + pageHeight);
            pageImage = new BufferedImage((int)pageWidth, (int)pageHeight, 1);
            Graphics g = pageImage.getGraphics();
            g.setColor(SystemColor.white);
            g.fillRect(0, 0, pageImage.getWidth(), pageImage.getHeight());
            try {
                aPage.setIsImageConversion(true);
                aPage.draw(g);
            }
            catch (Throwable t) {
                throw new AtException(t);
            }
            pagesAsImage[i] = pageImage;
        }
        return pagesAsImage;
    }
}

