/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.conversion.impl;

import com.activetree.common.conversion.PdfProperties;
import com.activetree.common.exception.AtException;
import com.activetree.common.utils.AtDebug;
import com.activetree.common.utils.ReflectionUtil;
import com.activetree.common.utils.StringUtil;
import java.awt.print.Pageable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;

public class PDF {
    private static final String ERROR_MESSAGE = "Please include PDF generation library in class path (visit http://www.activetree.com).";
    private static final String pdfClass = "com.activetree.pdfgen.PdfWriter";
    private static final String saveAsPdf = "saveAsPdf";

    public void saveAsPdf(OutputStream outputStream, Pageable pageable, PdfProperties pdfProperties) throws ClassNotFoundException, AtException {
        try {
            Class pdfGen = ReflectionUtil.loadClass(pdfClass);
            Object obj = pdfGen.newInstance();
            Method method = pdfGen.getDeclaredMethod(saveAsPdf, OutputStream.class, Pageable.class, PdfProperties.class);
            method.invoke(obj, outputStream, pageable, pdfProperties == null ? new PdfProperties() : pdfProperties);
            int x = 10;
            ++x;
        }
        catch (ClassNotFoundException t1) {
            throw new ClassNotFoundException(t1.getMessage() + " (" + ERROR_MESSAGE + ")");
        }
        catch (Throwable t) {
            String stack = StringUtil.getStackTrace(t);
            AtDebug.debug(stack);
            String msg = StringUtil.getMessage(t);
            throw new AtException(msg);
        }
    }

    public InputStream getAsPdf(Pageable pageable, PdfProperties pdfProperties) throws ClassNotFoundException, AtException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.saveAsPdf(outputStream, pageable, pdfProperties);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        return inputStream;
    }
}

