/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.conversion.impl;

import com.activetree.common.conversion.impl.ImageBase;
import com.activetree.common.conversion.impl.MemoryImageMaker;
import com.activetree.common.exception.AtException;
import com.activetree.common.page.AbstractPage;
import com.activetree.common.utils.StringUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class PNG
extends ImageBase {
    public static void saveAsPNG(AbstractPage page, String outputFileName) throws AtException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(outputFileName);
        }
        catch (Throwable t) {
            String stack = StringUtil.getStackTrace(t);
            throw new AtException(stack);
        }
        PNG.saveAsPNG(page, outputStream);
    }

    public static void saveAsPNG(AbstractPage page, OutputStream outputStream) throws AtException {
        double resizeFactor = 1.0;
        boolean autoMatchToPaperSize = false;
        PNG.saveAsPNG(page, outputStream, resizeFactor, autoMatchToPaperSize);
    }

    public static final void saveAsPNG(AbstractPage page, OutputStream outputStream, double resizeFactor, boolean autoMatchToPaperSize) throws AtException {
        try {
            AbstractPage[] pages = new AbstractPage[]{page};
            BufferedImage[] images = MemoryImageMaker.getImagesForPages(pages, resizeFactor, autoMatchToPaperSize);
            ImageIO.write((RenderedImage)images[0], FORMAT, outputStream);
            outputStream.close();
        }
        catch (Throwable t) {
            String stack = StringUtil.getStackTrace(t);
            throw new AtException(stack);
        }
    }

    static {
        FORMAT = "PNG";
    }
}

