/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.conversion.impl;

import com.activetree.common.doc.PSPageable;
import com.activetree.common.exception.AtException;
import com.activetree.common.page.AbstractPage;
import com.activetree.common.resource.AtCommonResource;
import com.activetree.common.utils.AtDebug;
import com.activetree.common.utils.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.SimpleDoc;
import javax.print.StreamPrintService;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;

public class PSConverterPrivate {
    final InputStream getAsPostScript(AbstractPage[] pages) throws AtException {
        DocFlavor.SERVICE_FORMATTED printableFlavor = DocFlavor.SERVICE_FORMATTED.PAGEABLE;
        String psMimeType = DocFlavor.BYTE_ARRAY.POSTSCRIPT.getMimeType();
        StreamPrintServiceFactory[] factories = StreamPrintServiceFactory.lookupStreamPrintServiceFactories(printableFlavor, psMimeType);
        if (factories == null || factories.length == 0) {
            throw new AtException(AtCommonResource.MESSAGE_RESOURCE.getText("NO_POST_SCRIPT_SUPPORT"));
        }
        this.debugStreamPrintingServiceFactories(factories);
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        try {
            StreamPrintService psConversionService = factories[0].getPrintService(fos);
            DocPrintJob pj = psConversionService.createPrintJob();
            HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
            PSPageable printable = new PSPageable(pages);
            HashDocAttributeSet docAttrs = new HashDocAttributeSet();
            SimpleDoc doc = new SimpleDoc(printable, printableFlavor, docAttrs);
            pj.print(doc, aset);
            fos.close();
        }
        catch (Throwable t) {
            String stack = StringUtil.getStackTrace(t);
            throw new AtException(stack);
        }
        ByteArrayInputStream is = new ByteArrayInputStream(fos.toByteArray());
        return is;
    }

    final void saveAsPostScript(AbstractPage[] pages, OutputStream psStream) throws AtException {
        DocFlavor.SERVICE_FORMATTED printableFlavor = DocFlavor.SERVICE_FORMATTED.PAGEABLE;
        String psMimeType = DocFlavor.BYTE_ARRAY.POSTSCRIPT.getMimeType();
        StreamPrintServiceFactory[] factories = StreamPrintServiceFactory.lookupStreamPrintServiceFactories(printableFlavor, psMimeType);
        if (factories == null || factories.length == 0) {
            throw new AtException("Unsupported data conversion mime type: " + psMimeType + ". No StreamPrintServiceFactory found.");
        }
        this.debugStreamPrintingServiceFactories(factories);
        OutputStream fos = psStream;
        try {
            StreamPrintService psConversionService = factories[0].getPrintService(fos);
            AtDebug.debug("StreamPrintService instanceof: " + psConversionService.getClass().getName());
            DocPrintJob pj = psConversionService.createPrintJob();
            AtDebug.debug("pj instanceof: " + pj.getClass().getName());
            HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
            PSPageable pageable = new PSPageable(pages);
            HashDocAttributeSet docAttrs = new HashDocAttributeSet();
            SimpleDoc doc = new SimpleDoc(pageable, printableFlavor, docAttrs);
            pj.print(doc, aset);
            fos.close();
        }
        catch (Throwable t) {
            String stack = StringUtil.getStackTrace(t);
            throw new AtException(stack);
        }
    }

    private void debugStreamPrintingServiceFactories(StreamPrintServiceFactory[] factories) {
        for (int i = 0; factories != null && i < factories.length; ++i) {
            StreamPrintServiceFactory aStreamProducerFactory = factories[i];
            AtDebug.debug(aStreamProducerFactory.getClass().getName());
            AtDebug.debug("StreamPrintServiceFactory instanceof: " + aStreamProducerFactory.getClass().getName());
            AtDebug.debug("Output Format: " + aStreamProducerFactory.getOutputFormat());
        }
    }
}

