/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.doc;

import com.activetree.common.doc.DocEvent;
import com.activetree.common.doc.DocListener;
import com.activetree.common.resource.AtCommonResource;
import com.activetree.common.utils.AtDebug;
import java.util.ArrayList;
import java.util.List;
import javax.print.PrintService;

public abstract class DefaultDocListener
implements DocListener {
    private int totalPageCount = 0;
    private int pagePrintCount = 0;
    private int renderingCount = 0;
    int printableCallCount = 0;
    private int lastPrintPageIndex = -1;
    protected final ArrayList failedDocs = new ArrayList();
    protected Object webDoc;
    protected boolean jobFinished = false;

    public void activityPerformed(DocEvent evt) {
        int type = evt.getType();
        Object source = evt.getSource();
        this.webDoc = evt.getWebDoc();
        if (type == 26) {
            Object docList = source;
            this.totalPageCount = 0;
            this.jobStarted(evt, docList);
        } else if (type == 40) {
            this.filterPageable(evt, source);
        } else if (type == 4) {
            int pageCount = evt.getValue();
            this.totalPageCount += pageCount;
            this.pageCount(evt, pageCount);
        } else if (type == 1) {
            this.pageLoaded(evt, evt.getValue());
        } else if (type == 3) {
            this.printableCalled(evt, evt.getValue());
        } else if (type == 2) {
            Object reason = evt.getDetails();
            int pageIndex = evt.getValue();
            if (reason instanceof String) {
                String reasonStr = (String)reason;
                if (reasonStr.equalsIgnoreCase("PageRenderingReasonViewing")) {
                    this.pageRenderedForViewer(evt, evt.getValue());
                } else if (reasonStr.equalsIgnoreCase("PageRenderingReasonPrinting")) {
                    if (this.lastPrintPageIndex != pageIndex) {
                        ++this.pagePrintCount;
                        AtDebug.debug("pagePrintCount=" + this.pagePrintCount);
                        if (this.printableCallCount > 0) {
                            AtDebug.debug("pageIndex " + (pageIndex - 1) + " had printableCallCount=" + this.printableCallCount);
                        }
                        this.pagePrinted(evt, this.pagePrintCount);
                        this.printableCallCount = 1;
                    } else {
                        ++this.printableCallCount;
                    }
                    this.lastPrintPageIndex = pageIndex;
                } else if (reasonStr.equalsIgnoreCase("PageRenderingReasonThumbnailLoading")) {
                    this.pageRenderedForThumbnailView(evt, evt.getValue());
                } else if (reasonStr.equalsIgnoreCase("PageRenderingReasonDataConversion")) {
                    Object info = evt.getInfo();
                    if (info instanceof String && ((String)info).equalsIgnoreCase("PS")) {
                        ++this.renderingCount;
                        if (this.renderingCount == 2) {
                            ++this.pagePrintCount;
                            this.renderingCount = 0;
                            this.pageConverted(evt, this.pagePrintCount);
                        }
                    } else {
                        ++this.pagePrintCount;
                        this.pageConverted(evt, this.pagePrintCount);
                    }
                }
            }
        } else if (type == 21) {
            String printerName = AtCommonResource.MESSAGE_RESOURCE.getText("UNKNOWN");
            Object o = evt.getDetails();
            PrintService ps = null;
            if (o instanceof PrintService) {
                ps = (PrintService)o;
            }
            if (ps != null) {
                printerName = ps.getName();
            }
            this.pagePrintCount = 0;
            this.renderingCount = 0;
            this.printStarting(evt, source, printerName);
        } else if (type == 22) {
            String printerName = AtCommonResource.MESSAGE_RESOURCE.getText("UNKNOWN");
            Object o = evt.getDetails();
            PrintService ps = null;
            if (o instanceof PrintService) {
                ps = (PrintService)o;
            }
            if (ps != null) {
                printerName = ps.getName();
            }
            this.pagePrintCount = 0;
            this.renderingCount = 0;
            this.printFinished(evt, source, printerName);
        } else if (type == 24) {
            int value = evt.getValue();
            Object details = evt.getDetails();
            this.failedDocs.add(source);
            this.docError(evt, source, value, details);
        } else if (type == 35) {
            this.jobCancelled(evt, source);
        } else if (type == 30) {
            if (this.jobFinished) {
                this.jobFinished = false;
                return;
            }
            this.jobFinished(evt);
            this.clearCache();
            this.totalPageCount = 0;
            this.jobFinished = true;
        }
    }

    public List getFailedDocs() {
        return this.failedDocs;
    }

    protected void clearCache() {
        this.failedDocs.clear();
    }

    public int getTotalPageCount() {
        return this.totalPageCount;
    }

    protected void pageRenderedForViewer(DocEvent evt, int pageIndex) {
    }

    protected void pageRenderedForThumbnailView(DocEvent evt, int thumbnailIndex) {
    }

    protected void pageLoaded(DocEvent evt, int pageIndex) {
    }

    protected void pageCount(DocEvent evt, int pageCount) {
    }

    protected void pageConverted(DocEvent evt, int pageCount) {
    }

    protected void printStarting(DocEvent evt, Object source, String printerName) {
    }

    protected void printableCalled(DocEvent evt, int pageIndex) {
    }

    protected void pagePrinted(DocEvent evt, int pageCount) {
    }

    protected void printFinished(DocEvent evt, Object source, String printerName) {
    }

    protected void docError(DocEvent evt, Object failedDoc, int value, Object details) {
    }

    protected void jobStarted(DocEvent evt, Object docList) {
    }

    protected void filterPageable(DocEvent evt, Object docList) {
    }

    protected void jobCancelled(DocEvent evt, Object docList) {
    }

    protected void jobFinished(DocEvent evt) {
    }
}

