/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.media;

import com.activetree.common.media.JPrintMediaSize;
import com.activetree.common.utils.AtDebug;
import com.activetree.common.utils.DataUtil;
import java.io.Serializable;
import java.util.StringTokenizer;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;

public class AtMediaSizeObject
implements Serializable {
    private MediaSizeName mediaSizeName;
    private MediaSize mediaSize;
    private String mediaSizeNameString;
    private String mediaSizeInchString;
    private String mediaSizeNameWithInchString;
    private String mediaSizePixelString;
    private String mediaSizeNameWithPixelString;
    private String mediaSizeMMString;
    private String mediaSizeNameWithMMString;
    private String mediaSizeCMString;
    private String mediaSizeNameWithCMString;
    private String mediaSizeNameWithInchAndPixel;

    public AtMediaSizeObject(MediaSizeName mediaSizeName) {
        this.mediaSizeName = mediaSizeName;
        this.resetMediaSize();
        this.resetMediaSizeInchString();
        this.resetMediaSizePixelString();
        this.resetMediaSizeMMString();
        this.resetMediaSizeCMString();
        this.mediaSizeNameWithInchAndPixel = this.mediaSizeNameString + " [" + this.mediaSizeInchString + " inch, " + this.mediaSizePixelString + " pixels]";
    }

    private void resetMediaSize() {
        MediaSize mediaSize = JPrintMediaSize.getMediaSizeForName(this.mediaSizeName);
        if (mediaSize == null) {
            throw new RuntimeException("JRE did not support a MediaSize for MediaSizeName (name=" + this.mediaSizeName.getName() + ", value=" + this.mediaSizeName.getValue() + ")");
        }
        this.mediaSize = mediaSize;
        this.mediaSizeNameString = AtMediaSizeObject.getUserReadableMediaSizeName(this.mediaSizeName);
    }

    private void resetMediaSizeInchString() {
        String w = this.getMediaWidthInch(2);
        String h = this.getMediaHeightInch(2);
        this.mediaSizeInchString = "(" + w + "," + h + ")";
        this.mediaSizeNameWithInchString = this.mediaSizeNameString + " " + this.mediaSizeInchString;
    }

    private void resetMediaSizeMMString() {
        String w = this.getMediaWidthMMString(2);
        String h = this.getMediaHeightMMString(2);
        this.mediaSizeMMString = "(" + w + "," + h + ")";
        this.mediaSizeNameWithMMString = this.mediaSizeNameString + " " + this.mediaSizeMMString;
    }

    private void resetMediaSizeCMString() {
        String w = this.getMediaWidthCMString(2);
        String h = this.getMediaHeightCMString(2);
        this.mediaSizeCMString = "(" + w + "," + h + ")";
        this.mediaSizeNameWithCMString = this.mediaSizeNameString + " " + this.mediaSizeCMString;
    }

    private void resetMediaSizePixelString() {
        double pixelw = this.getMediaWidthPixel();
        double pixelh = this.getMediaHeightPixel();
        String w = DataUtil.getString(pixelw, 0);
        String h = DataUtil.getString(pixelh, 0);
        this.mediaSizePixelString = "(" + w + "," + h + ")";
        this.mediaSizeNameWithPixelString = this.mediaSizeNameString + " " + this.mediaSizePixelString;
    }

    public String getMediaSizeMMString() {
        return this.mediaSizeMMString;
    }

    public String getMediaSizeNameWithMMString() {
        return this.mediaSizeNameWithMMString;
    }

    public String getMediaSizeCMString() {
        return this.mediaSizeCMString;
    }

    public String getMediaSizeNameWithCMString() {
        return this.mediaSizeNameWithCMString;
    }

    public String getMediaSizeNameWithInchAndPixel() {
        return this.mediaSizeNameWithInchAndPixel;
    }

    public String getMediaSizePixelString() {
        return this.mediaSizePixelString;
    }

    public String getMediaSizeInchString() {
        return this.mediaSizeInchString;
    }

    public String getMediaSizeNameWithInchString() {
        return this.mediaSizeNameWithInchString;
    }

    public String getMediaSizeNameWithPixelString() {
        return this.mediaSizeNameWithPixelString;
    }

    public double getMediaWidthPixel() {
        MediaSize mediaSize = this.getMediaSize();
        int inchUnit = 25400;
        double paperWidthInch = mediaSize.getX(inchUnit);
        double paperWidthPixel = 72.0 * paperWidthInch;
        double rounded = Math.round(paperWidthPixel);
        return rounded;
    }

    public double getMediaHeightPixel() {
        MediaSize mediaSize = this.getMediaSize();
        int inchUnit = 25400;
        double paperHeightInch = mediaSize.getY(inchUnit);
        double paperHeightPixel = 72.0 * paperHeightInch;
        double rounded = Math.round(paperHeightPixel);
        return rounded;
    }

    public double getMediaWidthInch() {
        MediaSize mediaSize = this.getMediaSize();
        int inchUnit = 25400;
        double paperWidthInch = mediaSize.getX(inchUnit);
        return paperWidthInch;
    }

    public double getMediaHeightInch() {
        MediaSize mediaSize = this.getMediaSize();
        int inchUnit = 25400;
        double paperHeightInch = mediaSize.getY(inchUnit);
        return paperHeightInch;
    }

    public double getMediaWidthMM() {
        MediaSize mediaSize = this.getMediaSize();
        int unit = 1000;
        double paperWidthMM = mediaSize.getX(unit);
        return paperWidthMM;
    }

    public double getMediaHeightMM() {
        MediaSize mediaSize = this.getMediaSize();
        int unit = 1000;
        double paperHeightMM = mediaSize.getY(unit);
        return paperHeightMM;
    }

    public String getMediaWidthMMString(int precisionCount) {
        double widthMM = this.getMediaWidthMM();
        String w = DataUtil.getString(widthMM, precisionCount);
        return w;
    }

    public String getMediaHeightMMString(int precisionCount) {
        double heightMM = this.getMediaHeightMM();
        String h = DataUtil.getString(heightMM, precisionCount);
        return h;
    }

    public double getMediaWidthCM() {
        MediaSize mediaSize = this.getMediaSize();
        int unit = 1000;
        double paperWidthMM = mediaSize.getX(unit);
        double paperWidthCms = paperWidthMM / 10.0;
        return paperWidthCms;
    }

    public double getMediaHeightCM() {
        MediaSize mediaSize = this.getMediaSize();
        int unit = 1000;
        double paperHeightMM = mediaSize.getY(unit);
        double heightCms = paperHeightMM / 10.0;
        return heightCms;
    }

    public String getMediaWidthCMString(int precisionCount) {
        double widthCms = this.getMediaWidthCM();
        String w = DataUtil.getString(widthCms, precisionCount);
        return w;
    }

    public String getMediaHeightCMString(int precisionCount) {
        double heightCms = this.getMediaHeightCM();
        String h = DataUtil.getString(heightCms, precisionCount);
        return h;
    }

    public String getMediaWidthInch(int precisionCount) {
        double inchw = this.getMediaWidthInch();
        String w = DataUtil.getString(inchw, precisionCount);
        return w;
    }

    public String getMediaHeightInch(int precisionCount) {
        double inchh = this.getMediaHeightInch();
        String h = DataUtil.getString(inchh, precisionCount);
        return h;
    }

    public MediaSize getMediaSize() {
        return this.mediaSize;
    }

    public MediaSizeName getMediaSizeName() {
        return this.mediaSizeName;
    }

    public String getMediaName() {
        return this.mediaSizeNameString;
    }

    public String toString() {
        return this.getMediaName();
    }

    public static String getUserReadableMediaSizeName(MediaSizeName msn) {
        String retVal = null;
        MediaSize mediaSizeForName = JPrintMediaSize.getMediaSizeForName(msn);
        if (mediaSizeForName != null) {
            MediaSizeName tempMsn = mediaSizeForName.getMediaSizeName();
            if (tempMsn != null) {
                String name = tempMsn.toString();
                StringTokenizer tk = new StringTokenizer(name, "-");
                StringBuffer buf = new StringBuffer();
                while (tk.hasMoreTokens()) {
                    String aToken = tk.nextToken();
                    if (aToken != null && (aToken.equalsIgnoreCase("ISO") || aToken.equalsIgnoreCase("NA") || aToken.equalsIgnoreCase("JIS"))) {
                        aToken = aToken.toUpperCase();
                    }
                    if (aToken == null || aToken.length() <= 0) continue;
                    buf.append(Character.toUpperCase(aToken.charAt(0)));
                    if (aToken.length() > 1) {
                        buf.append(aToken.substring(1));
                    }
                    buf.append(' ');
                }
                retVal = buf.toString();
                retVal = retVal.trim();
            }
        } else {
            AtDebug.debug("MediaSizeName: not found in MediaSize.getMediaSizeForName(msn=" + msn.getName() + ")");
        }
        return retVal;
    }
}

