/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.print;

import com.activetree.common.doc.DocEvent;
import com.activetree.common.doc.DocListener;
import com.activetree.common.doc.DocListenerManager;
import com.activetree.common.exception.AtException;
import com.activetree.common.internal.DemoShape;
import com.activetree.common.media.StandardPapers;
import com.activetree.common.object.PasswordProvider;
import com.activetree.common.page.AbstractPage;
import com.activetree.common.resource.AtCommonResource;
import com.activetree.common.utils.AtDebug;
import com.activetree.common.utils.MediaUtil;
import com.activetree.common.utils.StringUtil;
import java.awt.Component;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.net.URL;
import java.net.UnknownHostException;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.Sides;

public abstract class AbstractPrinter
implements Serializable {
    public static final int PAGE_SCALING_NONE = 10;
    public static final int PAGE_SCALING_FIT_TO_PRINTABLE_AREA = 11;
    public static final int PAGE_SCALING_SHRINK_TO_PRINTABLE_AREA = 12;
    protected int copies = 1;
    protected boolean collate = false;
    protected String jobName = AtCommonResource.MESSAGE_RESOURCE.getText("ACTIVETREE_PRINT_JOB");
    protected double zoom = 1.0;
    protected boolean antiAliased = false;
    protected PrintRequestAttributeSet pAttrs;
    private DocListenerManager docListenerManager = new DocListenerManager();
    protected boolean choosePaperSourceByPageSize = false;
    protected boolean usePrinterMargins = true;
    protected PrintQuality printQuality = PrintQuality.HIGH;
    protected Sides sideToPrint = Sides.ONE_SIDED;
    protected PasswordProvider passwordProvider;
    protected int pageScaling = 10;
    protected boolean autoRotateAndCenter = true;
    protected PageFormat defaultOutputPageFormat;
    protected PrintService printService;
    protected DocPrintJob docPrintJob;
    protected int pageNoLocation = 0;
    protected Component owner;
    protected DemoShape demoShape;
    private int errorType = 1;
    private boolean hasError = false;
    private String errorMessage = "";
    private Throwable exception;
    protected byte[] content = null;
    protected static PrinterJob lastPrinterJob;

    public byte[] getData() {
        return this.content;
    }

    public abstract void close();

    public abstract Pageable getPageable(Object var1) throws AtException;

    public abstract Pageable getPageable(Object var1, PageFormat var2) throws AtException;

    public void print(Object source) throws AtException {
    }

    public void print(Object source, PageFormat pf) throws AtException {
    }

    public int getPageNumberLocation() {
        return this.pageNoLocation;
    }

    public void setPageNumberLocation(int newPageNoLocation) {
        this.pageNoLocation = newPageNoLocation;
    }

    public void setOwner(Component owner) {
        this.owner = owner;
    }

    public Component getOwner() {
        return this.owner;
    }

    public PageFormat getDefaultPageFormat() {
        if (this.defaultOutputPageFormat == null) {
            PageFormat dpf = new PageFormat();
            Paper paper = new Paper();
            paper.setSize(612.0, 792.0);
            paper.setImageableArea(0.0, 0.0, paper.getWidth(), paper.getHeight());
            dpf.setPaper(paper);
            this.defaultOutputPageFormat = dpf;
        }
        return this.defaultOutputPageFormat;
    }

    public void setDefaultPageFormat(PageFormat defaultPageFormat) {
        this.defaultOutputPageFormat = defaultPageFormat;
    }

    public PasswordProvider getPasswordProvider() {
        return this.passwordProvider;
    }

    public void setPasswordProvider(PasswordProvider passwordProvider) {
        this.passwordProvider = passwordProvider;
    }

    public DocPrintJob getDocPrintJob() {
        return this.docPrintJob;
    }

    public void setDocPrintJob(DocPrintJob docPrintJob) {
        this.docPrintJob = docPrintJob;
    }

    public PrintService getPrintService() {
        return this.printService;
    }

    public void setPrintService(PrintService printService) {
        this.printService = printService;
    }

    protected void copyAttributes(AbstractPrinter anotherPrinter) {
        anotherPrinter.pageScaling = this.pageScaling;
        anotherPrinter.autoRotateAndCenter = this.autoRotateAndCenter;
        anotherPrinter.copies = this.copies;
        anotherPrinter.collate = this.collate;
        anotherPrinter.jobName = this.jobName;
        anotherPrinter.zoom = this.zoom;
        anotherPrinter.antiAliased = this.antiAliased;
        anotherPrinter.pAttrs = this.pAttrs;
        anotherPrinter.docListenerManager = this.docListenerManager;
        anotherPrinter.choosePaperSourceByPageSize = this.choosePaperSourceByPageSize;
        anotherPrinter.usePrinterMargins = this.usePrinterMargins;
        anotherPrinter.printQuality = this.printQuality;
        anotherPrinter.sideToPrint = this.sideToPrint;
        anotherPrinter.hasError = this.hasError;
        anotherPrinter.errorType = this.errorType;
        anotherPrinter.errorMessage = this.errorMessage;
        anotherPrinter.exception = this.exception;
    }

    public void setPageScaling(int pageScaling) {
        if (pageScaling != 10 && pageScaling != 11 && pageScaling != 12) {
            throw new RuntimeException("Not a valid page scaling option \"" + pageScaling + "\".");
        }
        this.pageScaling = pageScaling;
    }

    public int getPageScaling() {
        return this.pageScaling;
    }

    public void setAutoRotateAndCenter(boolean rotateAndCenter) {
        this.autoRotateAndCenter = rotateAndCenter;
    }

    public boolean isAutoRotateAndCenter() {
        return this.autoRotateAndCenter;
    }

    protected void resetPageScaling(boolean fitToPage) {
        if (fitToPage) {
            this.setPageScaling(11);
        } else {
            this.setPageScaling(10);
        }
    }

    public static void validateSource(Object source) throws AtException {
        if (source == null) {
            throw new NullPointerException("Null data source.");
        }
        if (source instanceof String) {
            try {
                URL url = StringUtil.getURL((String)source);
            }
            catch (Throwable t1) {
                String msg = "ERROR: Invalid data source (found: \"" + source + "\").";
                AtDebug.debug(9, msg);
                throw new AtException(t1);
            }
        } else if (!(source instanceof URL || source instanceof File || source instanceof byte[])) {
            throw new AtException("Unknown data source. Must be one of: java.net.URL, java.io.File, String (local file), or byte[] data");
        }
    }

    protected String populateErrorMessage(Throwable t) {
        String errorMessage = "";
        if (t instanceof UnknownHostException) {
            errorMessage = "Unknown host name \"" + t.getMessage() + "\". \nCheck internet connection.";
        } else if (t instanceof FileNotFoundException) {
            errorMessage = "The page cannot be found: ";
            errorMessage = errorMessage + t.getMessage();
        } else {
            errorMessage = t.getMessage();
        }
        return errorMessage;
    }

    protected PrintRequestAttributeSet getModifiedPrintAttributeSet(PrintRequestAttributeSet currPset) {
        HashPrintRequestAttributeSet pSet = new HashPrintRequestAttributeSet();
        PrintQuality currPrintQuality = this.getPrintQuality();
        Sides currSide = this.getSideToPrint();
        if (currPset == null) {
            pSet.add(currPrintQuality != null ? currPrintQuality : PrintQuality.HIGH);
            pSet.add(currSide != null ? currSide : Sides.ONE_SIDED);
            return pSet;
        }
        if (currPset.containsKey(PrintQuality.HIGH.getCategory())) {
            pSet.add(currPrintQuality != null ? currPrintQuality : PrintQuality.HIGH);
        }
        if (currPset.containsKey(Sides.DUPLEX.getCategory())) {
            pSet.add(currSide != null ? currSide : Sides.ONE_SIDED);
        }
        Attribute[] currAttrs = currPset.toArray();
        for (int i = 0; currAttrs != null && i < currAttrs.length; ++i) {
            Attribute aAttr = currAttrs[i];
            pSet.add(aAttr);
        }
        return pSet;
    }

    public void setPrintQuality(PrintQuality printQuality) {
        if (printQuality == null) {
            throw new IllegalArgumentException("Null - PrintQuality is not allowed.");
        }
        this.printQuality = printQuality;
    }

    public PrintQuality getPrintQuality() {
        return this.printQuality;
    }

    public void setSideToPrint(Sides side) {
        if (side == null) {
            throw new IllegalArgumentException("Null Sides is not allowed.");
        }
        this.sideToPrint = side;
    }

    public Sides getSideToPrint() {
        return this.sideToPrint;
    }

    public boolean isSubstituteFont() {
        return false;
    }

    public void setSubstituteFont(boolean substituteFont) {
    }

    protected DocListenerManager getDocListenerManager() {
        return this.docListenerManager;
    }

    public void addDocListener(DocListener dl) {
        this.docListenerManager.addDocListener(dl);
    }

    public void removeDocListener(DocListener dl) {
        this.docListenerManager.removeDocListener(dl);
    }

    public void removeAllDocListeners() {
        this.docListenerManager.removeAllDocListeners();
    }

    public int getDocListenerCount() {
        return this.docListenerManager.getDocListenerCount();
    }

    public DocListener[] getDocListeners() {
        return this.docListenerManager.getDocListeners();
    }

    public void notifyPageCount(int pageCount, Object source) {
        DocEvent docEvt = new DocEvent(source, 4, pageCount, source);
        this.docListenerManager.notifyDocListeners(docEvt);
    }

    public void notifyPageLoaded(AbstractPage page) {
        int pageIdx = page.getPageIndex();
        DocEvent docEvt = new DocEvent(page, 1, pageIdx, page);
        this.docListenerManager.notifyDocListeners(docEvt);
    }

    public void notifyDocumentLoaded(Object source, Pageable pages) {
        if (pages != null) {
            DocEvent docEvt = new DocEvent(source, 25, pages.getNumberOfPages(), pages);
            this.docListenerManager.notifyDocListeners(docEvt);
        }
    }

    public void notifyEvent(DocEvent evt) {
        this.docListenerManager.notifyDocListeners(evt);
    }

    public boolean isChoosePaperSourceByPageSize() {
        return this.choosePaperSourceByPageSize;
    }

    public void setChoosePaperSourceByPageSize(boolean choosePaperSourceByPageSize) {
        this.choosePaperSourceByPageSize = choosePaperSourceByPageSize;
    }

    public void setPrintRequestAttributeSet(PrintRequestAttributeSet pAttrs) {
        this.pAttrs = pAttrs;
    }

    public PrintRequestAttributeSet getPrintRequestAttributeSet() {
        return this.pAttrs;
    }

    public void applyAntialiasing(boolean antiAliasing) {
        this.antiAliased = antiAliasing;
    }

    public boolean isAntialiased() {
        return this.antiAliased;
    }

    public void setZoomPercent(double zoomPercent) {
        this.zoom = zoomPercent / 100.0;
    }

    public double getZoom() {
        return this.zoom;
    }

    public double getZoomPercent() {
        return this.zoom * 100.0;
    }

    public int getCopies() {
        return this.copies;
    }

    public void setCopies(int copies) {
        this.copies = copies;
    }

    public void setCollate(boolean collate) {
        this.collate = collate;
    }

    public boolean isCollate() {
        return this.collate;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobName() {
        return this.jobName;
    }

    public boolean isUsePrinterMargins() {
        return this.usePrinterMargins;
    }

    public void setUsePrinterMargins(boolean usePrinterMargins) {
        this.usePrinterMargins = usePrinterMargins;
    }

    public void setFitToPageWidth(boolean fitToPage) {
        this.resetPageScaling(fitToPage);
    }

    public boolean isFitToPageWidth() {
        int currPageScaling = this.getPageScaling();
        return currPageScaling == 11;
    }

    public void setHasError(boolean hasError) {
        this.hasError = hasError;
    }

    public boolean hasError() {
        return this.hasError;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errMsg) {
        this.errorMessage = errMsg;
    }

    public void setException(Throwable t) {
        this.exception = t;
    }

    public Throwable getException() {
        return this.exception;
    }

    public int getErrorType() {
        return this.errorType;
    }

    public void setErrorType(int errType) {
        this.errorType = errType;
    }

    public static final PageFormat getPaperSourceByPageSize(Rectangle2D printableArea) {
        if (printableArea == null) {
            return null;
        }
        AtDebug.debug("getPaperSourceByPageSize() printableArea=" + printableArea);
        int orientation = 1;
        PageFormat retPf = StandardPapers.getMatchedPageFormat(printableArea, 1.0, 1.0, orientation);
        if (retPf != null) {
            AtDebug.debug("Got matched PageFormat: " + MediaUtil.getDebugString(retPf));
        } else {
            double w = printableArea.getWidth();
            double h = printableArea.getHeight();
            String sizeStr = "(" + w + "," + h + ")";
            AtDebug.debug(9, "WARNING: Auto match failed to find a PageFormat for page size " + sizeStr);
        }
        return retPf;
    }

    public static final PageFormat getPrinterValidatedPageFormat(PrinterJob pj, PageFormat currPf, boolean usePrinterMargins) {
        lastPrinterJob = pj;
        if (pj == null || currPf == null) {
            return currPf;
        }
        PageFormat validatedPageFormat = currPf;
        if (usePrinterMargins) {
            String orgPfStr = MediaUtil.getDebugString(currPf);
            validatedPageFormat = pj.validatePage(currPf);
            String newPfStr = MediaUtil.getDebugString(validatedPageFormat);
            AtDebug.debug("Got printer validated PageFormat");
            AtDebug.debug("Original " + orgPfStr);
            AtDebug.debug("New " + newPfStr);
        }
        return validatedPageFormat;
    }
}

