/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.print.dialog;

import com.activetree.common.doc.PrintDialog;
import com.activetree.common.media.AtMediaSizeObject;
import com.activetree.common.media.AtPrintServiceObject;
import com.activetree.common.print.dialog.JobControlPane;
import com.activetree.common.print.dialog.PageFormatPreviewPane;
import com.activetree.common.print.dialog.PageHandlingPane;
import com.activetree.common.print.dialog.PaperSelectionPane;
import com.activetree.common.print.dialog.PrintRequestAttributePane;
import com.activetree.common.print.dialog.PrinterSelectionPane;
import com.activetree.common.print.dialog.RangeSelectionPane;
import com.activetree.common.resource.AtCommonResource;
import com.activetree.common.resource.AtConstants;
import com.activetree.common.swing.AtInsetsPanel;
import com.activetree.common.swing.OkCancelButtonPane;
import com.activetree.common.utils.AtComponentUtil;
import com.activetree.common.utils.AtDebug;
import com.activetree.common.utils.AtLAFUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.Sides;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class AtPrintDialog
extends JDialog
implements PrintDialog {
    protected Window ownerComp;
    protected boolean mustHavePrintService = false;
    protected PrinterSelectionPane printerPane;
    protected PaperSelectionPane paperPane;
    protected RangeSelectionPane rangePane;
    protected PageFormatPreviewPane pagePreviewPane;
    protected PrintRequestAttributePane printRequestAttributePane;
    protected PageHandlingPane pageHandlingPane;
    protected JobControlPane jobControlPane;
    protected OkCancelButtonPane okCancelPane;

    public AtPrintDialog(Dialog dialog, String title, boolean modal) {
        super(dialog, title, modal);
        this.ownerComp = dialog;
        boolean printerSelectionEnabled = true;
        boolean showStandardPapersOnly = false;
        MediaSizeName defaultMediaName = null;
        this.initContentPane(dialog, DocFlavor.SERVICE_FORMATTED.PAGEABLE, new HashPrintRequestAttributeSet(), printerSelectionEnabled, defaultMediaName, showStandardPapersOnly);
    }

    public AtPrintDialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        this.ownerComp = frame;
        boolean printerSelectionEnabled = true;
        boolean showStandardPapersOnly = false;
        MediaSizeName defaultMediaName = null;
        this.initContentPane(frame, DocFlavor.SERVICE_FORMATTED.PAGEABLE, new HashPrintRequestAttributeSet(), printerSelectionEnabled, defaultMediaName, showStandardPapersOnly);
    }

    public AtPrintDialog(Dialog dialog, String title, boolean modal, DocFlavor flavor, PrintRequestAttributeSet pAttrs) {
        super(dialog, title, modal);
        this.ownerComp = dialog;
        boolean printerSelectionEnabled = true;
        boolean showStandardPapersOnly = false;
        MediaSizeName defaultMediaName = null;
        this.initContentPane(dialog, flavor, pAttrs, printerSelectionEnabled, defaultMediaName, showStandardPapersOnly);
    }

    public AtPrintDialog(Frame frame, String title, boolean modal, DocFlavor flavor, PrintRequestAttributeSet pAttrs) {
        super(frame, title, modal);
        this.ownerComp = frame;
        boolean printerSelectionEnabled = true;
        boolean showStandardPapersOnly = false;
        MediaSizeName defaultMediaName = null;
        this.initContentPane(frame, flavor, pAttrs, printerSelectionEnabled, defaultMediaName, showStandardPapersOnly);
    }

    public AtPrintDialog(Dialog dialog, String title, boolean modal, boolean showStandardPapers, boolean printerSelectionEnabled, MediaSizeName defaultMediaName) {
        super(dialog, title, modal);
        this.ownerComp = dialog;
        this.initContentPane(dialog, DocFlavor.SERVICE_FORMATTED.PAGEABLE, new HashPrintRequestAttributeSet(), printerSelectionEnabled, defaultMediaName, showStandardPapers);
    }

    public AtPrintDialog(Frame frame, String title, boolean modal, boolean showStandardPapers, boolean printerSelectionEnabled, MediaSizeName defaultMediaName) {
        super(frame, title, modal);
        this.ownerComp = frame;
        this.initContentPane(frame, DocFlavor.SERVICE_FORMATTED.PAGEABLE, new HashPrintRequestAttributeSet(), printerSelectionEnabled, defaultMediaName, showStandardPapers);
    }

    public AtPrintDialog(Dialog dialog, String title, boolean modal, DocFlavor flavor, PrintRequestAttributeSet pAttrs, boolean showStandardPapers, boolean printerSelectionEnabled, MediaSizeName defaultMediaName) {
        super(dialog, title, modal);
        this.ownerComp = dialog;
        this.initContentPane(dialog, flavor, pAttrs, printerSelectionEnabled, defaultMediaName, showStandardPapers);
    }

    public AtPrintDialog(Frame frame, String title, boolean modal, DocFlavor flavor, PrintRequestAttributeSet pAttrs, boolean showStandardPapers, boolean printerSelectionEnabled, MediaSizeName defaultMediaName) {
        super(frame, title, modal);
        this.ownerComp = frame;
        this.initContentPane(frame, flavor, pAttrs, printerSelectionEnabled, defaultMediaName, showStandardPapers);
    }

    protected void initContentPane(Component owner, DocFlavor flavor, PrintRequestAttributeSet pAttrs, boolean printerSelectionEnabled, MediaSizeName defaultMediaName, boolean showStandardPapersOnly) {
        this.setupContentPane(owner, flavor, pAttrs, printerSelectionEnabled, defaultMediaName, showStandardPapersOnly);
        this.setDefaultCloseOperation(0);
        this.addControlRefreshListener();
        AtPrintServiceObject selectedPs = this.printerPane.getSelectedPrintServiceObject();
        this.updatePaperCombo(selectedPs);
        this.addOkCancelActionListener();
        this.addWindowCloseListener();
    }

    protected void updatePaperCombo(AtPrintServiceObject selectedPs) {
        this.setCursor(WAIT_CURSOR);
        this.paperPane.updatePaper(selectedPs);
        this.setCursor(DEFAULT_CURSOR);
    }

    public void refresh() {
        this.printerPane.refresh();
        this.paperPane.refresh();
        this.rangePane.refresh();
        this.pagePreviewPane.refresh();
        this.printRequestAttributePane.refresh();
        this.pageHandlingPane.refresh();
        this.jobControlPane.refresh();
        this.okCancelPane.refresh();
    }

    public PrintRequestAttributePane getPrintRequestAttributePane() {
        return this.printRequestAttributePane;
    }

    public PageHandlingPane getPageHandlingPane() {
        return this.pageHandlingPane;
    }

    public JobControlPane getJobControlPane() {
        return this.jobControlPane;
    }

    public PaperSelectionPane getPaperSelectionPane() {
        return this.paperPane;
    }

    public PrinterSelectionPane getPrinterSelectionPane() {
        return this.printerPane;
    }

    public RangeSelectionPane getRangeSelectionPane() {
        return this.rangePane;
    }

    public PageFormatPreviewPane getPageFormatPreviewPane() {
        return this.pagePreviewPane;
    }

    public void setDocFlavor(DocFlavor flavor) {
        this.printerPane.setDocFlavor(flavor);
    }

    public DocFlavor getDocFlavor() {
        return this.printerPane.getDocFlavor();
    }

    public void setPrintRequestAttributeSet(PrintRequestAttributeSet printerDiscoveryAttributeSet) {
        this.printerPane.setPrintRequestAttributeSet(printerDiscoveryAttributeSet);
    }

    public PrintRequestAttributeSet getPrintRequestAttributeSet() {
        return this.printerPane.getPrintRequestAttributeSet();
    }

    protected void addControlRefreshListener() {
        this.printerPane.addSelectionChangeListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                int state = evt.getStateChange();
                if (state == 1) {
                    AtPrintServiceObject selectedPrinter = AtPrintDialog.this.printerPane.getSelectedPrintServiceObject();
                    AtPrintDialog.this.updatePaperCombo(selectedPrinter);
                }
            }
        });
        this.paperPane.addSelectionChangeListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                int state = evt.getStateChange();
                if (state == 1) {
                    AtMediaSizeObject selectedMedia = AtPrintDialog.this.paperPane.getSelectedPaper();
                    AtPrintDialog.this.pagePreviewPane.setMediaSizeObject(selectedMedia);
                }
            }
        });
        this.paperPane.addPaperOrientationChangeListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                int paperOrientation = AtPrintDialog.this.paperPane.getPaperOrientation();
                AtPrintDialog.this.pagePreviewPane.setPageOrientation(paperOrientation);
            }
        });
        this.paperPane.addPaperMarginChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Double[] oldMargins = (Double[])evt.getOldValue();
                Double[] newMargins = (Double[])evt.getNewValue();
                double currLeftMargin = newMargins[0];
                double currRightMargin = newMargins[1];
                double currTopMargin = newMargins[2];
                double currBottomMargin = newMargins[3];
                AtPrintDialog.this.pagePreviewPane.setMargins(currLeftMargin, currRightMargin, currTopMargin, currBottomMargin);
            }
        });
        this.pagePreviewPane.refresh();
    }

    protected void addWindowCloseListener() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                AtPrintDialog.this.okCancelPane.cancel();
            }
        });
    }

    protected void addOkCancelActionListener() {
        ActionListener l2 = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AtPrintDialog.this.hide();
            }
        };
        this.okCancelPane.addActionListener(l2);
    }

    public void addActionListener(ActionListener l2) {
        this.okCancelPane.addActionListener(l2);
    }

    public void removeActionListener(ActionListener l2) {
        this.okCancelPane.removeActionListener(l2);
    }

    public void removeAllActionListeners() {
        this.okCancelPane.removeAllActionListeners();
    }

    public OkCancelButtonPane getOkCancelButtonPane() {
        return this.okCancelPane;
    }

    protected void setupContentPane(Component owner, DocFlavor flavor, PrintRequestAttributeSet pAttrs, boolean printerSelectionEnabled, MediaSizeName defaultMediaName, boolean showStandardPapersOnly) {
        JPanel top = this.getPropertiesPane(owner, flavor, pAttrs, printerSelectionEnabled, defaultMediaName, showStandardPapersOnly);
        Container c = this.getContentPane();
        c.removeAll();
        c.setLayout(new GridBagLayout());
        c.add((Component)top, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pack();
    }

    public boolean isPrinterSelectionEnabled() {
        return this.printerPane.isPrinterSelectionEnabled();
    }

    public void setPrinterSelectionEnabled(boolean enabled) {
        this.printerPane.setPrinterSelectionEnabled(enabled);
    }

    public MediaSizeName getSelectedMediaSizeName() {
        return this.paperPane.getSelectedMediaSizeName();
    }

    public void setMediaNameSelected(MediaSizeName mediaSizeName) {
        this.paperPane.setMediaSizeNameSelected(mediaSizeName);
    }

    public void setMediaSizeSelected(MediaSize mediaSize) {
        this.paperPane.setMediaSizeSelected(mediaSize);
    }

    public void setMediaSizeSelected(PageFormat mediaSize) {
        this.paperPane.setMediaSizeSelected(mediaSize);
    }

    public MediaSize getSelectedMediaSize() {
        return this.paperPane.getSelectedMediaSize();
    }

    public boolean hasPrintServices() {
        return this.printerPane.hasPrintServices();
    }

    public double getSelectedPaperWidth() {
        double paperWidth = this.paperPane.getSelectedPaperWidth();
        return paperWidth;
    }

    public double getSelectedPaperHeight() {
        double selPaperHeight = this.paperPane.getSelectedPaperHeight();
        return selPaperHeight;
    }

    public Border createTitledBorder(String title) {
        TitledBorder border = BorderFactory.createTitledBorder(title);
        Color titleColor = AtConstants.TITLE_COLOR;
        Font titleFont = AtConstants.TITLE_FONT;
        int titleJustification = 1;
        int titlePosition = 2;
        border = BorderFactory.createTitledBorder(border, title, titleJustification, titlePosition, titleFont, titleColor);
        return border;
    }

    protected JPanel getPropertiesPane(Component owner, DocFlavor flavor, PrintRequestAttributeSet pAttrs, boolean printerSelectionEnabled, MediaSizeName defaultMediaSizeName, boolean showStandardPapersOnly) {
        this.printerPane = this.createPrinterPane(owner, flavor, pAttrs, printerSelectionEnabled);
        this.paperPane = this.createPaperPane(owner, showStandardPapersOnly, defaultMediaSizeName);
        this.rangePane = this.createRangePane(owner);
        this.pagePreviewPane = this.createPageFormatPreviewPane();
        this.printRequestAttributePane = this.createPrintRequestAttributePane();
        this.pageHandlingPane = this.createPageHandlingPane();
        this.jobControlPane = this.createJobControlPane();
        this.okCancelPane = this.createOkCancelPane();
        AtInsetsPanel top = new AtInsetsPanel(new Insets(0, 0, 0, 0));
        top.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        top.add((Component)this.printerPane, gridBagConstraints);
        JPanel compositePane = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        compositePane.add((Component)this.paperPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        compositePane.add((Component)this.rangePane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.0;
        compositePane.add((Component)this.pagePreviewPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        compositePane.add((Component)this.printRequestAttributePane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        top.add((Component)compositePane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        top.add((Component)this.pageHandlingPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        top.add((Component)this.jobControlPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        top.add((Component)this.okCancelPane, gridBagConstraints);
        this.postInit();
        return top;
    }

    protected void postInit() {
    }

    protected PrinterSelectionPane createPrinterPane(Component owner, DocFlavor flavor, PrintRequestAttributeSet pAttrs, boolean printerSelectionEnabled) {
        PrinterSelectionPane printerPane = new PrinterSelectionPane(owner, flavor, pAttrs, printerSelectionEnabled);
        return printerPane;
    }

    protected PaperSelectionPane createPaperPane(Component owner, boolean showStandardPapersOnly, MediaSizeName defaultMediaSizeName) {
        PaperSelectionPane paperSelPane = new PaperSelectionPane(owner, showStandardPapersOnly, defaultMediaSizeName);
        return paperSelPane;
    }

    protected RangeSelectionPane createRangePane(Component owner) {
        RangeSelectionPane rangePane = new RangeSelectionPane(owner);
        return rangePane;
    }

    protected PageFormatPreviewPane createPageFormatPreviewPane() {
        PageFormatPreviewPane pfPreviewPane = new PageFormatPreviewPane();
        return pfPreviewPane;
    }

    protected PrintRequestAttributePane createPrintRequestAttributePane() {
        PrintRequestAttributePane pReqAttrPane = new PrintRequestAttributePane();
        return pReqAttrPane;
    }

    protected PageHandlingPane createPageHandlingPane() {
        PageHandlingPane pageHandlingPane = new PageHandlingPane();
        return pageHandlingPane;
    }

    protected JobControlPane createJobControlPane() {
        JobControlPane jobPane = new JobControlPane();
        return jobPane;
    }

    protected OkCancelButtonPane createOkCancelPane() {
        OkCancelButtonPane buttonPane = new OkCancelButtonPane();
        return buttonPane;
    }

    public boolean isChoosePaperSourceByPageSize() {
        return this.pageHandlingPane.isChoosePaperSourceByPageSize();
    }

    public void setChoosePaperSourceByPageSize(boolean selected) {
        this.pageHandlingPane.setChoosePaperSourceByPageSize(selected);
    }

    public void setChoosePaperSourceByPageSizeEnabled(boolean enabled) {
        this.pageHandlingPane.setChoosePaperSourceByPageSizeEnabled(enabled);
    }

    public void setChoosePaperSourceByPageSizeVisible(boolean visible) {
        this.pageHandlingPane.setChoosePaperSourceByPageSizeVisible(visible);
    }

    public double getLeftMargin() {
        double lm = this.paperPane.getLeftMargin();
        return lm;
    }

    public double getRightMargin() {
        double rm = this.paperPane.getRightMargin();
        return rm;
    }

    public void setRightMargin(double rightMargin) {
        this.paperPane.setRightMargin(rightMargin);
    }

    public double getTopMargin() {
        double tm = this.paperPane.getTopMargin();
        return tm;
    }

    public void setTopMargin(double topMargin) {
        this.paperPane.setTopMargin(topMargin);
    }

    public double getBottomMargin() {
        double bm = this.paperPane.getBottomMargin();
        return bm;
    }

    public void setBottomMargin(double bottomMargin) {
        this.paperPane.setBottomMargin(bottomMargin);
    }

    public void setVisible(boolean visible) {
    }

    public boolean showPrintDialog() {
        return this.showPrintDialog(true, false);
    }

    public boolean showPrintDialog(boolean visible) {
        return this.showPrintDialog(visible, false);
    }

    public boolean showPrintDialog(boolean visible, boolean verifyPrintServices) {
        this.okCancelPane.setOkPressed(false);
        if (verifyPrintServices && !this.hasPrintServices() && this.isMustHavePrintService()) {
            Window window = AtComponentUtil.getWindowForComponent(this);
            String message = AtCommonResource.MESSAGE_RESOURCE.getText("NO_PRINT_SERVICES");
            String title = AtCommonResource.MESSAGE_RESOURCE.getText("PRINT_DIALOG_TITLE");
            JOptionPane.showMessageDialog(window, message, title, 1);
            return false;
        }
        this.pack();
        super.setVisible(visible);
        boolean okPressed = this.okCancelPane.isOkPressed();
        return okPressed;
    }

    public boolean isMustHavePrintService() {
        return this.mustHavePrintService;
    }

    public void setMustHavePrintService(boolean mustHavePrintService) {
        this.mustHavePrintService = mustHavePrintService;
    }

    public void setOrientationRadioButtonsEnabled(boolean enabled) {
        this.paperPane.setOrientationRadioButtonsEnabled(enabled);
    }

    public void setPortraitOrientationRadioButtonEnabled(boolean enabled) {
        this.paperPane.setPortraitOrientationRadioButtonEnabled(enabled);
    }

    public void setLandscapeEnabled(boolean enabled) {
        this.paperPane.setLandscapeOrientationEnabled(enabled);
    }

    public PrintService getSelectedPrintService() {
        try {
            AtPrintServiceObject psObj = this.printerPane.getSelectedPrintServiceObject();
            if (psObj != null) {
                return psObj.getPrintService();
            }
        }
        catch (Throwable t) {
            AtDebug.debug(9, t);
        }
        return null;
    }

    public void setPrintServiceSelected(PrintService ps) {
        this.printerPane.setPrintServiceSelected(ps);
    }

    public void setPrintServiceSelected(String ps) {
        this.printerPane.setPrintServiceSelected(ps);
    }

    public int getOrientation() {
        int orientation = this.paperPane.getPaperOrientation();
        return orientation;
    }

    public AtMediaSizeObject getSelectedMedia() {
        return this.getSelectedPaper();
    }

    public AtMediaSizeObject getSelectedPaper() {
        AtMediaSizeObject mo = this.paperPane.getSelectedPaper();
        return mo;
    }

    public void setPaperSelectionIndex(int idx) {
        this.paperPane.setPaperSelectionIndex(idx);
    }

    public void setSelectedMedia(PageFormat pageFormat) {
        if (pageFormat == null) {
            AtDebug.debug("setSelectedPageFormat()...NULL pageFormat.");
            return;
        }
        double mediaWidth = pageFormat.getWidth();
        double mediaHeight = pageFormat.getHeight();
        double imageableWidth = pageFormat.getImageableWidth();
        double imageableHeight = pageFormat.getImageableHeight();
        double topMargin = pageFormat.getImageableY();
        double leftMargin = pageFormat.getImageableX();
        double rightMargin = mediaWidth - (leftMargin + imageableWidth);
        double bottomMargin = mediaHeight - (topMargin + imageableHeight);
        double width = pageFormat.getPaper().getWidth();
        double height = pageFormat.getPaper().getHeight();
        MediaSize mediaSize = new MediaSize((float)width, (float)height, 1);
        this.setSelectedMedia(mediaSize, pageFormat.getOrientation(), leftMargin, rightMargin, topMargin, bottomMargin);
    }

    public void setSelectedMedia(MediaSize mediaSize, int orientation, double topMarginPixels, double leftMarginPixels, double bottomMarginPixels, double rightMarginPixels) {
        PageFormat tempPf = new PageFormat();
        double mediaWidth = mediaSize.getX(1);
        double mediaHeight = mediaSize.getY(1);
        Paper tempPaper = new Paper();
        tempPaper.setSize(mediaWidth, mediaHeight);
        tempPaper.setImageableArea(leftMarginPixels, topMarginPixels, mediaWidth, mediaHeight);
        tempPf.setPaper(tempPaper);
        tempPf.setOrientation(orientation);
        this.pagePreviewPane.setMedia(mediaSize, orientation, topMarginPixels, leftMarginPixels, bottomMarginPixels, rightMarginPixels);
        this.paperPane.setPaperOrientation(orientation);
        this.paperPane.setMediaSizeSelected(tempPf);
    }

    public PageFormat getSelectedPageFormat() {
        PageFormat pf = this.paperPane.getSelectedPageFormat();
        return pf;
    }

    public void setFitToPage(boolean fitToPage) {
        this.pageHandlingPane.setFitToPage(fitToPage);
    }

    public boolean isFitToPage() {
        return this.pageHandlingPane.isFitToPage();
    }

    public boolean isUsePrinterMargins() {
        return this.pageHandlingPane.isUsePrinterMargins();
    }

    public void setUsePrinterMargins(boolean usePrinterMargins) {
        this.pageHandlingPane.setUsePrinterMargins(usePrinterMargins);
    }

    public String getPrinterStatus() {
        return this.printerPane.getPrinterStatus();
    }

    public int getQueueJobCount() {
        return this.printerPane.getQueueJobCount();
    }

    public void setRange(int totalPageCount) {
        this.setTotalPageCount(totalPageCount);
    }

    public void setTotalPageCount(int totalPageCount) {
        this.rangePane.setTotalPageCount(totalPageCount);
    }

    public void setRangeOfPages(String rangeOfPages) {
        this.rangePane.setRangeOfPages(rangeOfPages);
    }

    public void setRangeSelectionType(int rangeType) {
        this.rangePane.setRangeSelectionType(rangeType);
    }

    public int getRangeSelectionType() {
        int rangeType = this.rangePane.getRangeSelectionType();
        return rangeType;
    }

    public int[] getRange(int pageCount, int currPageNumber) {
        int[] retval = null;
        retval = this.rangePane.getRangeOfPages(pageCount, currPageNumber);
        return retval;
    }

    public int getCopies() {
        return this.pageHandlingPane.getCopies();
    }

    public void setCopies(int copies) {
        this.pageHandlingPane.setCopies(copies);
    }

    public boolean isCollate() {
        return this.pageHandlingPane.isCollate();
    }

    public void setCollate(boolean collate) {
        this.pageHandlingPane.setCollate(collate);
    }

    public String getPrintJobName() {
        return this.jobControlPane.getPrintJobName();
    }

    public void setPrintJobName(String printJobName) {
        this.jobControlPane.setPrintJobName(printJobName);
    }

    public void setPrintJobNamePropertyEnabled(boolean enabled) {
        this.jobControlPane.setPrintJobNamePropertyEnabled(enabled);
    }

    public void setPrintJobNamePropertyVisible(boolean visible) {
        this.jobControlPane.setPrintJobNamePropertyEnabled(visible);
    }

    public void setPaperComboEnabled(boolean enabled) {
        this.paperPane.setPaperComboEnabled(enabled);
    }

    public boolean isPaperComboEnabled() {
        return this.paperPane.isPaperComboEnabled();
    }

    public void setCancelButtonText(String cancelButtonText) {
        this.okCancelPane.setCancelButtonText(cancelButtonText);
    }

    public void setCancelButtonTooltip(String cancelButtonTooltip) {
        this.okCancelPane.setCancelButtonTooltip(cancelButtonTooltip);
    }

    public void setCollateEnabled(boolean enabled) {
        this.pageHandlingPane.setCollateEnabled(enabled);
    }

    public boolean isCollateEnabled() {
        return this.pageHandlingPane.isCollateEnabled();
    }

    public void setPrintAllPagesEnabled(boolean enabled) {
        this.rangePane.setAllPagesRadioButtonEnabled(enabled);
    }

    public boolean isPrintAllPagesEnabled() {
        return this.rangePane.isAllPagesRadioButtonEnabled();
    }

    public boolean isPrintAllPages() {
        return this.rangePane.isAllPagesRadioButtonSelected();
    }

    public void setPrintCurrentPageEnabled(boolean enabled) {
        this.rangePane.setCurrentPageRadioButtonEnabled(enabled);
    }

    public boolean isPrintCurrentPageEnabled() {
        return this.rangePane.isCurrentPageRadioButtonEnabled();
    }

    public boolean isPrintCurrentPage() {
        return this.rangePane.isCurrentPageRadioButtonSelected();
    }

    public void setPrintRangeOfPagesEnabled(boolean enabled) {
        this.rangePane.setRangeOfPagesRadioButtonEnabled(enabled);
    }

    public boolean isPrintRangeOfPages() {
        return this.rangePane.isRangeOfPagesRadioButtonSelected();
    }

    public boolean isPrintRangeOfPagesEnabled() {
        return this.rangePane.isAllPagesRadioButtonEnabled();
    }

    public void setFitToPageEnabled(boolean enabled) {
        this.pageHandlingPane.setFitToPageEnabled(enabled);
    }

    public void setUsePrinterMarginsEnabled(boolean enabled) {
        this.pageHandlingPane.setUsePrinterMarginsEnabled(enabled);
    }

    public void setOkButtonText(String okButtonText) {
        this.okCancelPane.setOkButtonText(okButtonText);
    }

    public void setOkButtonTooltip(String okButtonTooltip) {
        this.okCancelPane.setOkButtonTooltip(okButtonTooltip);
    }

    public void setCopiesEnabled(boolean enabled) {
        this.pageHandlingPane.setCopiesSpinControlEnabled(enabled);
    }

    public void setStatusPropertyEnabled(boolean enabled) {
        this.printerPane.setStatusPropertyEnabled(enabled);
    }

    public void setJobsPropertyEnabled(boolean enabled) {
        this.printerPane.setJobsPropertyEnabled(enabled);
    }

    public void setPrintQuality(String printQuality) {
        this.printRequestAttributePane.setPrintQuality(printQuality);
    }

    public void setPrintQuality(PrintQuality printQuality) {
        this.printRequestAttributePane.setPrintQuality(printQuality);
    }

    public PrintQuality getPrintQuality() {
        PrintQuality pq = this.printRequestAttributePane.getPrintQuality();
        return pq;
    }

    public void setMediaSide(String side) {
        this.printRequestAttributePane.setMediaSide(side);
    }

    public void setMediaSide(Sides side) {
        this.printRequestAttributePane.setMediaSide(side);
    }

    public Sides getSideToPrint() {
        Sides ps = this.printRequestAttributePane.getMediaSide();
        return ps;
    }

    public void setPageScaling(int pageScaling) {
        PageHandlingPane pane = this.getPageHandlingPane();
        pane.setPageScaling(pageScaling);
    }

    public int getPageScaling() {
        PageHandlingPane pane = this.getPageHandlingPane();
        return pane.getPageScaling();
    }

    public void setPageHandlingPaneEnabled(boolean enabled) {
        PageHandlingPane pane = this.getPageHandlingPane();
        pane.setEnabled(enabled);
    }

    public void setPageHandlingPaneVisible(boolean visible) {
        PageHandlingPane pane = this.getPageHandlingPane();
        pane.setVisible(visible);
    }

    public void setPageScalingLabel(String label) {
        PageHandlingPane pane = this.getPageHandlingPane();
        pane.setPageScalingLabel(label);
    }

    public String getPageScalingLabel() {
        PageHandlingPane pane = this.getPageHandlingPane();
        JLabel label = pane.getPageScalingLabel();
        return label.getText();
    }

    public void setAutoRotateAndCenterSelected(boolean selected) {
        PageHandlingPane pane = this.getPageHandlingPane();
        pane.setAutoRotateAndCenterSelected(selected);
    }

    public boolean isAutoRotateAndCenter() {
        PageHandlingPane pane = this.getPageHandlingPane();
        return pane.isAutoRotateAndCenter();
    }

    public static void main(String[] args) {
        AtLAFUtil.setDefaultLookAndFeel();
        AtPrintDialog printDialog = new AtPrintDialog((Frame)null, "Print Setup Dialog", false);
        boolean okPressed = printDialog.showPrintDialog(true, false);
        if (okPressed) {
            System.out.println("Ok");
        } else {
            System.out.println("Cancel");
        }
    }
}

