/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.print.dialog;

import com.activetree.common.resource.AtCommonResource;
import com.activetree.common.swing.AtInsetsPanel;
import com.activetree.common.utils.AtComponentUtil;
import com.activetree.common.utils.AtDebug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.print.PrintService;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AtPrinterSelectionFrame
extends JDialog {
    private JLabel listLabel;
    private JList list;
    private JButton ok;
    private JButton cancel;
    private Vector listData;
    private PrintService[] services;
    private Dimension size = new Dimension(400, 220);
    private boolean okPressed = false;
    private JSpinner copySpinner;
    private SpinnerNumberModel copySpinModel;
    private JTextField jobNameField;
    private String jobName;
    private int copies;
    protected Window owner;

    public AtPrinterSelectionFrame(Frame frame, String title, String jobName, int copies) {
        super(frame, title, true);
        this.owner = frame;
        this.init(jobName, copies);
    }

    public AtPrinterSelectionFrame(Dialog dialog, String title, String jobName, int copies) {
        super(dialog, title, true);
        this.owner = dialog;
        this.init(jobName, copies);
    }

    private void init(String jobName, int copies) {
        this.jobName = jobName;
        this.copies = copies;
        JComponent centerPanel = this.createContentPane();
        AtInsetsPanel c = new AtInsetsPanel();
        c.setLayout(new BorderLayout(5, 5));
        c.add((Component)centerPanel, "Center");
        this.setSize(this.size.width, this.size.height);
        this.setContentPane(c);
        super.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                AtPrinterSelectionFrame.this.cancelActionPerformed(new ActionEvent(this, 1, "x"));
            }
        });
        if (this.owner != null) {
            AtComponentUtil.centerOnContainer(this.owner, this);
        }
    }

    public void setComponentBorder(JComponent component) {
        component.setBorder(new EtchedBorder());
    }

    public JComponent createContentPane() {
        this.listLabel = new JLabel(AtCommonResource.MESSAGE_RESOURCE.getText("Select_a_print_service"));
        this.listData = new Vector();
        this.list = new JList(this.listData);
        this.list.setVisibleRowCount(3);
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                AtDebug.debug("selected value: " + AtPrinterSelectionFrame.this.list.getSelectedValue());
                AtDebug.debug("sel indexes: " + AtPrinterSelectionFrame.this.list.getSelectedIndices());
                AtDebug.debug("lead Sel Index:  " + AtPrinterSelectionFrame.this.list.getLeadSelectionIndex());
                AtDebug.debug("anchor sel index: " + AtPrinterSelectionFrame.this.list.getAnchorSelectionIndex());
            }
        });
        JLabel copiesLabel = new JLabel(AtCommonResource.MESSAGE_RESOURCE.getText("COPIES"));
        this.copySpinModel = new SpinnerNumberModel(this.getCopies(), 1, Integer.MAX_VALUE, 1);
        this.copySpinner = new JSpinner(this.copySpinModel);
        this.copySpinner.setPreferredSize(new Dimension(50, 20));
        JLabel jobNameLabel = new JLabel(AtCommonResource.MESSAGE_RESOURCE.getText("PRINT_JOB_NAME_LABEL"));
        this.jobNameField = new JTextField(this.getJobName());
        JPanel copyPane = new JPanel(new GridBagLayout());
        copyPane.add((Component)copiesLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 5), 0, 0));
        copyPane.add((Component)this.copySpinner, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 5), 0, 0));
        copyPane.add((Component)jobNameLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 5), 0, 0));
        copyPane.add((Component)this.jobNameField, new GridBagConstraints(3, 0, 1, 1, 100.0, 0.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
        JScrollPane listScroll = new JScrollPane(this.list);
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)this.listLabel, "North");
        centerPanel.add((Component)listScroll, "Center");
        centerPanel.add((Component)copyPane, "South");
        this.ok = new JButton(AtCommonResource.MESSAGE_RESOURCE.getText("Ok"));
        this.ok.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("Ok"));
        this.cancel = new JButton(AtCommonResource.MESSAGE_RESOURCE.getText("Cancel"));
        this.cancel.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("Cancel"));
        JPanel buttonPanel = new JPanel(new FlowLayout(4, 0, 0));
        buttonPanel.add(this.ok);
        buttonPanel.add(this.cancel);
        AtInsetsPanel container = new AtInsetsPanel();
        container.setLayout(new BorderLayout(0, 0));
        container.add((Component)centerPanel, "Center");
        container.add((Component)buttonPanel, "South");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AtPrinterSelectionFrame.this.okActionPerformed(evt);
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AtPrinterSelectionFrame.this.cancelActionPerformed(evt);
            }
        });
        return container;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
        this.jobNameField.setText(jobName);
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setCopies(int copies) {
        this.copies = copies;
        if (copies < 1) {
            copies = 1;
        }
        this.copySpinner.setValue(new Integer(copies));
    }

    public int getCopies() {
        if (this.copies < 1) {
            return 1;
        }
        return this.copies;
    }

    public boolean showPrintServicesDialog(PrintService[] services, PrintService defaultPs) {
        AtDebug.debug("showPrintSerivcesDialog() services.length=" + services.length);
        this.setServices(services);
        this.setDefaultSelection(defaultPs);
        if (this.list.getSelectedIndex() >= 0) {
            Point p = this.list.indexToLocation(this.list.getSelectedIndex());
            Rectangle r = new Rectangle(p.x - 10, p.y - 10, 10, 10);
            this.list.scrollRectToVisible(r);
        }
        this.setVisible(true);
        return this.okPressed;
    }

    private void setDefaultSelection(PrintService defaultPs) {
        int defaultIdx = 0;
        for (int i = 0; defaultPs != null && i < this.services.length; ++i) {
            if (!this.services[i].getName().equals(defaultPs.getName())) continue;
            defaultIdx = i;
            break;
        }
        this.setSelectedIndex(defaultIdx);
    }

    public void okActionPerformed(ActionEvent evt) {
        this.okPressed = true;
        try {
            this.copies = this.copySpinModel.getNumber().intValue();
            AtDebug.debug("Settting copies..." + this.copies);
        }
        catch (Throwable t) {
            this.copies = 1;
        }
        this.jobName = this.jobNameField.getText();
        if (this.jobName == null) {
            this.jobName = AtCommonResource.MESSAGE_RESOURCE.getText("ACTIVETREE_PRINT_JOB");
        }
        this.setVisible(false);
    }

    public void cancelActionPerformed(ActionEvent evt) {
        this.okPressed = false;
        this.setVisible(false);
    }

    public void setServices(PrintService[] ps) {
        this.services = ps;
        this.listData.clear();
        if (ps == null) {
            return;
        }
        for (int i = 0; i < ps.length; ++i) {
            this.listData.add(ps[i].getName());
        }
        this.list.updateUI();
    }

    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    public void setSelectedIndex(int index) {
        if (index < 0) {
            return;
        }
        this.list.setSelectedIndex(index);
    }

    public PrintService getSelectedService() {
        int idx = this.getSelectedIndex();
        return this.services[idx];
    }

    public void setSelectedService(PrintService ps) {
        this.list.setSelectedValue(ps.getName(), true);
    }
}

