/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.print.dialog;

import com.activetree.common.media.AtMediaSizeObject;
import com.activetree.common.print.dialog.PageFormatPreviewPane;
import com.activetree.common.print.dialog.PaperSelectionPane;
import com.activetree.common.print.dialog.RangeSelectionPane;
import com.activetree.common.swing.OkCancelButtonPane;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.print.attribute.standard.MediaSizeName;
import javax.swing.JPanel;

public class PageComponent
extends JPanel {
    protected PaperSelectionPane paperSelectionPane;
    protected RangeSelectionPane rangeSelectionPane;
    protected PageFormatPreviewPane pageFormatPreviewPane;
    protected OkCancelButtonPane okCancelButtonPane;

    public PageComponent() {
        this((Component)null);
    }

    public PageComponent(Component owner) {
        this(owner, null);
    }

    public PageComponent(Component owner, MediaSizeName defaultMedia) {
        this.setupContentPane(owner, defaultMedia);
        this.addChangeListeners();
    }

    protected void setupContentPane(Component owner, MediaSizeName defaultMedia) {
        this.setLayout(new GridBagLayout());
        this.paperSelectionPane = this.createPaperSelectionPane(owner, defaultMedia);
        this.rangeSelectionPane = this.createRangeSelectionPane(owner);
        this.pageFormatPreviewPane = this.createPageFormatPreviewPane();
        this.okCancelButtonPane = this.createOkCancelButtonPane();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 18;
        this.add((Component)this.paperSelectionPane, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 18;
        this.add((Component)this.rangeSelectionPane, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 2;
        gbc.weightx = 0.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 18;
        this.add((Component)this.pageFormatPreviewPane, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 0, 0, 0);
        gbc.anchor = 18;
        this.add((Component)this.okCancelButtonPane, gbc);
    }

    protected PaperSelectionPane createPaperSelectionPane(Component owner, MediaSizeName defaultMedia) {
        boolean showStandardPapersOnly = true;
        PaperSelectionPane p = new PaperSelectionPane(owner, showStandardPapersOnly, defaultMedia);
        return p;
    }

    protected RangeSelectionPane createRangeSelectionPane(Component owner) {
        RangeSelectionPane rp = new RangeSelectionPane(owner);
        return rp;
    }

    protected PageFormatPreviewPane createPageFormatPreviewPane() {
        AtMediaSizeObject media = this.paperSelectionPane.getSelectedPaper();
        PageFormatPreviewPane p = new PageFormatPreviewPane(media);
        return p;
    }

    protected OkCancelButtonPane createOkCancelButtonPane() {
        OkCancelButtonPane buttonPane = new OkCancelButtonPane();
        return buttonPane;
    }

    protected void addChangeListeners() {
        this.paperSelectionPane.addSelectionChangeListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                int state = evt.getStateChange();
                if (state == 1) {
                    AtMediaSizeObject selectedMedia = PageComponent.this.paperSelectionPane.getSelectedPaper();
                    PageComponent.this.pageFormatPreviewPane.setMediaSizeObject(selectedMedia);
                }
            }
        });
        this.paperSelectionPane.addPaperOrientationChangeListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                int paperOrientation = PageComponent.this.paperSelectionPane.getPaperOrientation();
                PageComponent.this.pageFormatPreviewPane.setPageOrientation(paperOrientation);
            }
        });
        this.paperSelectionPane.addPaperMarginChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Double[] oldMargins = (Double[])evt.getOldValue();
                Double[] newMargins = (Double[])evt.getNewValue();
                double currLeftMargin = newMargins[0];
                double currRightMargin = newMargins[1];
                double currTopMargin = newMargins[2];
                double currBottomMargin = newMargins[3];
                PageComponent.this.pageFormatPreviewPane.setMargins(currLeftMargin, currRightMargin, currTopMargin, currBottomMargin);
            }
        });
        this.pageFormatPreviewPane.refresh();
    }

    public void refresh() {
        this.paperSelectionPane.refresh();
        this.rangeSelectionPane.refresh();
        this.pageFormatPreviewPane.refresh();
        this.okCancelButtonPane.refresh();
    }

    public PaperSelectionPane getPaperSelectionPane() {
        return this.paperSelectionPane;
    }

    public PageFormatPreviewPane getPageFormatPreviewPane() {
        return this.pageFormatPreviewPane;
    }

    public OkCancelButtonPane getOkCancelButtonPane() {
        return this.okCancelButtonPane;
    }

    public RangeSelectionPane getRangeSelectionPane() {
        return this.rangeSelectionPane;
    }
}

