/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.print.dialog;

import com.activetree.common.resource.AtCommonResource;
import com.activetree.common.swing.AtTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class RangeSelectionPane
extends JPanel {
    protected Component owner;
    protected ButtonGroup rangeGroup;
    protected JRadioButton allRadioButton;
    protected JRadioButton currentPageRadio;
    protected JRadioButton rangeOfPagesRadio;
    protected AtTextField rangeOfPageEntry;
    private char[] validChars = new char[]{'-', ',', ' '};
    protected int currentPageNumber = 1;
    protected int totalPageCount = 0;

    public RangeSelectionPane(Component owner) {
        this.owner = owner;
        this.setupContentPane();
        this.addRangeButtonSelectionListener();
        this.postInit();
    }

    protected void setupContentPane() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder(null, AtCommonResource.MESSAGE_RESOURCE.getText("RANGE"), 1, 2, null));
        this.rangeGroup = new ButtonGroup();
        this.allRadioButton = new JRadioButton();
        this.allRadioButton.setSelected(true);
        this.allRadioButton.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("ALL_PAGES"));
        this.allRadioButton.setText(AtCommonResource.MESSAGE_RESOURCE.getText("ALL_PAGES"));
        this.rangeGroup.add(this.allRadioButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        this.add((Component)this.allRadioButton, gridBagConstraints);
        this.currentPageRadio = new JRadioButton();
        this.currentPageRadio.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("CURRENT_PAGE"));
        this.currentPageRadio.setText(AtCommonResource.MESSAGE_RESOURCE.getText("CURRENT_PAGE"));
        this.currentPageRadio.setToolTipText(AtCommonResource.MESSAGE_RESOURCE.getText("PRINT_ONLY_CURRENT_PAGE"));
        this.rangeGroup.add(this.currentPageRadio);
        this.currentPageRadio.setActionCommand("CURRENT_PAGE");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        this.add((Component)this.currentPageRadio, gridBagConstraints);
        this.rangeOfPagesRadio = new JRadioButton();
        this.rangeOfPagesRadio.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("RANGE_OF_PAGES"));
        this.rangeOfPagesRadio.setToolTipText(AtCommonResource.MESSAGE_RESOURCE.getText("RANGE_HELP_TOOLTIP"));
        this.rangeGroup.add(this.rangeOfPagesRadio);
        this.rangeOfPagesRadio.setText(AtCommonResource.MESSAGE_RESOURCE.getText("RANGE_OF_PAGES"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.rangeOfPagesRadio, gridBagConstraints);
        this.rangeOfPageEntry = new AtTextField();
        this.rangeOfPageEntry.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.rangeOfPageEntry, gridBagConstraints);
    }

    protected void postInit() {
        this.rangeOfPageEntry.setEnabled(false);
    }

    protected void addRangeButtonSelectionListener() {
        ActionListener rangeSelListener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ButtonModel bm = RangeSelectionPane.this.rangeOfPagesRadio.getModel();
                ButtonModel sm = RangeSelectionPane.this.rangeGroup.getSelection();
                if (sm.isSelected() && sm == bm) {
                    RangeSelectionPane.this.rangeOfPageEntry.setEnabled(true);
                } else {
                    RangeSelectionPane.this.rangeOfPageEntry.setEnabled(false);
                }
            }
        };
        this.allRadioButton.addActionListener(rangeSelListener);
        this.currentPageRadio.addActionListener(rangeSelListener);
        this.rangeOfPagesRadio.addActionListener(rangeSelListener);
    }

    public void refresh() {
    }

    public void setCurrentPageNumber(int currPageNumber) {
        this.currentPageNumber = currPageNumber;
    }

    public int getCurrentPageNumber() {
        return this.currentPageNumber;
    }

    public void setRangeSelectionType(int rangeType) {
        if (rangeType == 1) {
            this.allRadioButton.setSelected(true);
        } else if (rangeType == 2) {
            this.currentPageRadio.setSelected(true);
        } else if (rangeType == 3) {
            this.rangeOfPagesRadio.setSelected(true);
        }
    }

    public int getRangeSelectionType() {
        int rangeType = 1;
        ButtonModel sbm = this.rangeGroup.getSelection();
        if (sbm == this.allRadioButton.getModel()) {
            rangeType = 1;
        } else if (sbm == this.currentPageRadio.getModel()) {
            rangeType = 2;
        } else if (sbm == this.rangeOfPagesRadio.getModel()) {
            rangeType = 3;
        }
        return rangeType;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.allRadioButton.setEnabled(enabled);
        this.currentPageRadio.setEnabled(enabled);
        this.rangeOfPagesRadio.setEnabled(enabled);
    }

    public void setAllPagesRadioButtonEnabled(boolean enabled) {
        this.allRadioButton.setEnabled(enabled);
    }

    public boolean isAllPagesRadioButtonEnabled() {
        return this.allRadioButton.isEnabled();
    }

    public boolean isAllPagesRadioButtonSelected() {
        return this.allRadioButton.isSelected();
    }

    public void setCurrentPageRadioButtonEnabled(boolean enabled) {
        this.currentPageRadio.setEnabled(enabled);
    }

    public boolean isCurrentPageRadioButtonEnabled() {
        return this.currentPageRadio.isEnabled();
    }

    public boolean isCurrentPageRadioButtonSelected() {
        return this.currentPageRadio.isSelected();
    }

    public void setTotalPageCount(int totalPageCount) {
        String range = null;
        range = totalPageCount <= 0 ? AtCommonResource.MESSAGE_RESOURCE.getText("ZERO_DASH") + totalPageCount : AtCommonResource.MESSAGE_RESOURCE.getText("ONE_DASH") + totalPageCount;
        this.totalPageCount = totalPageCount;
        this.rangeOfPageEntry.setText(range);
    }

    public int getTotalPageCount() {
        return this.totalPageCount;
    }

    public void setRangeOfPages(String rangeOfPages) {
        this.rangeOfPageEntry.setText(rangeOfPages);
    }

    public String getRangeOfPageString() {
        return this.rangeOfPageEntry.getText();
    }

    public void setRangeOfPagesRadioButtonEnabled(boolean enabled) {
        this.rangeOfPagesRadio.setEnabled(enabled);
    }

    public boolean isRangeOfPagesRadioButtonEnabled() {
        return this.rangeOfPagesRadio.isEnabled();
    }

    public boolean isRangeOfPagesRadioButtonSelected() {
        return this.rangeOfPagesRadio.isSelected();
    }

    public int[] getRangeOfPages() {
        int[] rangeOfPages = this.getRangeOfPages(this.totalPageCount, this.currentPageNumber);
        return rangeOfPages;
    }

    public int[] getRangeOfPages(int pageCount, int currPageNumber) {
        if (!this.validateRange(pageCount, currPageNumber)) {
            return null;
        }
        int[] pagesToPrint = this.getSelectedPages(pageCount, currPageNumber);
        if (pagesToPrint == null) {
            return null;
        }
        if (pagesToPrint == null || pagesToPrint.length < 1) {
            JOptionPane.showMessageDialog(this.owner, "\"" + this.getRangeOfPageString() + "\"\n" + AtCommonResource.MESSAGE_RESOURCE.getText("RANGE_FORMAT_ERROR_MSG"), AtCommonResource.MESSAGE_RESOURCE.getText("Error"), 0);
            this.setTotalPageCount(this.getTotalPageCount());
            return null;
        }
        return pagesToPrint;
    }

    private String getRangeString(int pageCount, int currPageNumber) {
        String rangeStr = null;
        int rangeType = this.getRangeSelectionType();
        if (rangeType == 1) {
            rangeStr = pageCount < 0 ? "0-0" : "1-" + pageCount;
        } else if (rangeType == 2) {
            rangeStr = currPageNumber <= 0 ? "0-0" : String.valueOf(currPageNumber);
        } else if (rangeType == 3) {
            rangeStr = this.rangeOfPageEntry.getText();
        }
        return rangeStr;
    }

    private int[] getSelectedPages(int pageCount, int currPageNumber) {
        String value = this.getRangeString(pageCount, currPageNumber);
        if (this.hasIllegalChars(value)) {
            JOptionPane.showMessageDialog(this.owner, "\"" + this.getRangeOfPageString() + "\"\n" + AtCommonResource.MESSAGE_RESOURCE.getText("STRING_HAS_ILLEGAL_CHARS"), AtCommonResource.MESSAGE_RESOURCE.getText("Error"), 0);
            this.setTotalPageCount(this.getTotalPageCount());
            return null;
        }
        String pageString = this.getFilteredPageString(pageCount, currPageNumber);
        Vector<Integer> allPages = new Vector<Integer>();
        StringTokenizer tk = new StringTokenizer(pageString, ",");
        while (tk.hasMoreTokens()) {
            String token = tk.nextToken();
            if (this.isRangeToken(token)) {
                Vector rangePages = this.getPagesFromRange(token);
                allPages.addAll(rangePages);
                continue;
            }
            int pageNo = Integer.parseInt(token);
            allPages.add(new Integer(pageNo));
        }
        Vector<Integer> pagesToPrint = allPages;
        int minPageNo = 1;
        int maxPageNo = pageCount;
        Vector<Integer> filteredPages = new Vector<Integer>();
        for (int i = 0; i < pagesToPrint.size(); ++i) {
            Integer aPageNo = (Integer)pagesToPrint.get(i);
            if (aPageNo < minPageNo || aPageNo > maxPageNo) continue;
            filteredPages.add(aPageNo);
        }
        int[] range = new int[filteredPages.size()];
        for (int i = 0; i < filteredPages.size(); ++i) {
            Integer x = (Integer)filteredPages.get(i);
            range[i] = x;
        }
        return range;
    }

    private boolean hasIllegalChars(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            boolean digit = Character.isDigit(ch);
            boolean validChar = this.isValidChar(ch);
            if (digit || validChar) continue;
            return true;
        }
        return false;
    }

    private boolean isValidChar(char ch) {
        boolean matched = false;
        for (int i = 0; this.validChars != null && i < this.validChars.length; ++i) {
            if (ch != this.validChars[i]) continue;
            matched = true;
            break;
        }
        return matched;
    }

    private boolean isRangeToken(String token) {
        StringTokenizer tk = new StringTokenizer(token, "-");
        int tokenCount = tk.countTokens();
        return tokenCount >= 2;
    }

    private Vector getPagesFromRange(String range) {
        StringTokenizer tk = new StringTokenizer(range, "-");
        String startToken = tk.nextToken();
        String endToken = tk.nextToken();
        int startPage = Integer.parseInt(startToken);
        int endPage = Integer.parseInt(endToken);
        Vector<Integer> rangePages = new Vector<Integer>();
        for (int i = startPage; i <= endPage; ++i) {
            rangePages.add(new Integer(i));
        }
        return rangePages;
    }

    private boolean validateRange(int pageCount, int currPageIndex) {
        String filteredStr = this.getFilteredPageString(pageCount, currPageIndex);
        int idx1 = filteredStr.indexOf(",,");
        int idx2 = filteredStr.indexOf("--");
        if (idx1 >= 0 || idx2 >= 0) {
            JOptionPane.showMessageDialog(this, "\"" + this.getRangeOfPageString() + "\"\n" + AtCommonResource.MESSAGE_RESOURCE.getText("RANGE_FORMAT_ERROR_MSG"), AtCommonResource.MESSAGE_RESOURCE.getText("Error"), 0);
            this.setTotalPageCount(this.getTotalPageCount());
            return false;
        }
        return true;
    }

    private String getFilteredPageString(int pageCount, int currPageNumber) {
        String value = this.getRangeString(pageCount, currPageNumber);
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (ch == ' ') continue;
            buf.append(ch);
        }
        String filteredStr = buf.toString();
        return filteredStr;
    }
}

