/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.print.util;

import java.net.URI;
import java.net.URL;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.standard.ColorSupported;
import javax.print.attribute.standard.PrinterInfo;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.PrinterLocation;
import javax.print.attribute.standard.PrinterMakeAndModel;
import javax.print.attribute.standard.PrinterMoreInfo;
import javax.print.attribute.standard.PrinterMoreInfoManufacturer;
import javax.print.attribute.standard.PrinterName;
import javax.print.attribute.standard.PrinterState;
import javax.print.attribute.standard.PrinterURI;
import javax.print.attribute.standard.QueuedJobCount;

public class AtPrinterInfoProviderFactory {
    public static final int PRINTER_STATE_UNKNOWN = PrinterState.UNKNOWN.getValue();
    public static final int PRINTER_STATE_IDLE = PrinterState.IDLE.getValue();
    public static final int PRINTER_STATE_PROCESSING = PrinterState.PROCESSING.getValue();
    public static final int PRINTER_STATE_STOPPED = PrinterState.STOPPED.getValue();
    private static AtPrinterInfoProviderFactory ourInstance;

    public static synchronized AtPrinterInfoProviderFactory getInstance() {
        if (ourInstance == null) {
            ourInstance = new AtPrinterInfoProviderFactory();
        }
        return ourInstance;
    }

    private AtPrinterInfoProviderFactory() {
    }

    public static boolean isAcceptingJobs(PrintService ps) {
        AtPrinterInfoProviderFactory.checkNPE(ps);
        Object acceptingJobs = ps.getAttribute(PrinterIsAcceptingJobs.class);
        if (acceptingJobs != null) {
            PrinterIsAcceptingJobs jobs = (PrinterIsAcceptingJobs)acceptingJobs;
            int value = jobs.getValue();
            if (value == PrinterIsAcceptingJobs.ACCEPTING_JOBS.getValue()) {
                return true;
            }
            if (value == PrinterIsAcceptingJobs.NOT_ACCEPTING_JOBS.getValue()) {
                return false;
            }
        }
        return false;
    }

    public static final int getSubmittedJobCount(PrintService ps) {
        AtPrinterInfoProviderFactory.checkNPE(ps);
        Object qJobCount = ps.getAttribute(QueuedJobCount.class);
        if (qJobCount != null) {
            QueuedJobCount retJbCount = (QueuedJobCount)qJobCount;
            int count = retJbCount.getValue();
            return count;
        }
        return -1;
    }

    public static final String getPrinterMakeAndModel(PrintService ps) {
        AtPrinterInfoProviderFactory.checkNPE(ps);
        Object printerMakeAndModel = ps.getAttribute(PrinterMakeAndModel.class);
        if (printerMakeAndModel != null) {
            PrinterMakeAndModel m = (PrinterMakeAndModel)printerMakeAndModel;
            String makeAndModel = m.getName();
            return makeAndModel;
        }
        return null;
    }

    public static final String getPrinterManufacturerInfo(PrintService ps) {
        AtPrinterInfoProviderFactory.checkNPE(ps);
        Object manufacturer = ps.getAttribute(PrinterMoreInfoManufacturer.class);
        if (manufacturer != null) {
            PrinterMoreInfoManufacturer m = (PrinterMoreInfoManufacturer)manufacturer;
            String mInfo = m.toString();
            return mInfo;
        }
        return null;
    }

    public static final String getPrinterInfo(PrintService ps) {
        AtPrinterInfoProviderFactory.checkNPE(ps);
        Object manufacturer = ps.getAttribute(PrinterInfo.class);
        if (manufacturer != null) {
            PrinterInfo m = (PrinterInfo)manufacturer;
            String info = m.getValue();
            return info;
        }
        return null;
    }

    public static final String getPrinterMoreInfo(PrintService ps) {
        AtPrinterInfoProviderFactory.checkNPE(ps);
        Object manufacturer = ps.getAttribute(PrinterMoreInfo.class);
        if (manufacturer != null) {
            PrinterMoreInfo m = (PrinterMoreInfo)manufacturer;
            String moreInfo = m.toString();
            return moreInfo;
        }
        return null;
    }

    public static final String getPrinterLocation(PrintService ps) {
        AtPrinterInfoProviderFactory.checkNPE(ps);
        Object location = ps.getAttribute(PrinterLocation.class);
        if (location != null) {
            String locationStr = location.toString();
            return locationStr;
        }
        return null;
    }

    public static final int getPrinterState(PrintService ps) {
        Object state = ps.getAttribute(PrinterState.class);
        if (state != null) {
            PrinterState pStateObj = (PrinterState)state;
            int value = pStateObj.getValue();
            if (value == PrinterState.IDLE.getValue()) {
                return PRINTER_STATE_IDLE;
            }
            if (value == PrinterState.PROCESSING.getValue()) {
                return PRINTER_STATE_PROCESSING;
            }
            if (value == PrinterState.STOPPED.getValue()) {
                return PRINTER_STATE_STOPPED;
            }
            if (value == PrinterState.UNKNOWN.getValue()) {
                return PRINTER_STATE_UNKNOWN;
            }
        }
        return PRINTER_STATE_UNKNOWN;
    }

    public static final String getPrinterURI(PrintService ps) {
        PrinterURI uriObj;
        URI uri;
        AtPrinterInfoProviderFactory.checkNPE(ps);
        Object printerUri = ps.getAttribute(PrinterURI.class);
        if (printerUri != null && (uri = (uriObj = (PrinterURI)printerUri).getURI()) != null) {
            String uriStr = uri.toString();
            return uriStr;
        }
        return null;
    }

    public static final String getPrinterURL(PrintService ps) {
        PrinterURI uriObj;
        URI uri;
        AtPrinterInfoProviderFactory.checkNPE(ps);
        Object printerUri = ps.getAttribute(PrinterURI.class);
        if (printerUri != null && (uri = (uriObj = (PrinterURI)printerUri).getURI()) != null) {
            try {
                URL url = uri.toURL();
                if (url != null) {
                    String u = url.toString();
                    return u;
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return null;
    }

    public static final String getPrinterName(PrintService ps) {
        AtPrinterInfoProviderFactory.checkNPE(ps);
        Object printerName = ps.getAttribute(PrinterName.class);
        if (printerName != null) {
            PrinterName pn = (PrinterName)printerName;
            String v = pn.getValue();
            return v;
        }
        return null;
    }

    public static final boolean isColorPrintingSupported(PrintService ps) {
        AtPrinterInfoProviderFactory.checkNPE(ps);
        Object o = ps.getAttribute(ColorSupported.class);
        if (o != null) {
            ColorSupported cs = (ColorSupported)o;
            int v = cs.getValue();
            if (v == ColorSupported.SUPPORTED.getValue()) {
                return true;
            }
            if (v == ColorSupported.NOT_SUPPORTED.getValue()) {
                return false;
            }
        }
        return false;
    }

    private static void checkNPE(PrintService ps) {
        if (ps == null) {
            throw new NullPointerException("PrintService is null.");
        }
    }

    public static void main(String[] args) {
        PrintService ps = PrintServiceLookup.lookupDefaultPrintService();
        if (ps != null) {
            String name = AtPrinterInfoProviderFactory.getPrinterName(ps);
            String pLoc = AtPrinterInfoProviderFactory.getPrinterLocation(ps);
            String pInfo = AtPrinterInfoProviderFactory.getPrinterInfo(ps);
            String pMoreInfo = AtPrinterInfoProviderFactory.getPrinterMoreInfo(ps);
            String pManufacturer = AtPrinterInfoProviderFactory.getPrinterManufacturerInfo(ps);
            String pMakeModel = AtPrinterInfoProviderFactory.getPrinterMakeAndModel(ps);
            int pState = AtPrinterInfoProviderFactory.getPrinterState(ps);
            String pUri = AtPrinterInfoProviderFactory.getPrinterURI(ps);
            String pUrl = AtPrinterInfoProviderFactory.getPrinterURL(ps);
            int jobCount = AtPrinterInfoProviderFactory.getSubmittedJobCount(ps);
            boolean acceptingJobs = AtPrinterInfoProviderFactory.isAcceptingJobs(ps);
            boolean colorPrintSupported = AtPrinterInfoProviderFactory.isColorPrintingSupported(ps);
            System.out.println("Printer Details\nname: " + name + "\n" + "pLoc=" + pLoc + "\n" + "pInfo=" + pInfo + "\n" + "pMoreInfo=" + pMoreInfo + "\n" + "pManufacturer=" + pManufacturer + "\n" + "pMakeModel=" + pMakeModel + "\n" + "pState=" + pState + "\n" + "pUri=" + pUri + "\n" + "pUrl=" + pUrl + "\n" + "jobCount=" + jobCount + "\n" + "acceptingJobs? " + acceptingJobs + "\n" + "colorPrintSupported? " + colorPrintSupported);
        }
    }
}

