/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.report;

import com.activetree.common.report.AtElement;
import com.activetree.common.report.AtPrintUtil;
import com.activetree.common.report.PrintableCell;
import com.activetree.common.utils.GraphicsUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;

public class DefaultPrintableCell
implements PrintableCell {
    private final HashMap orgFontMap = new HashMap();

    public void draw(Graphics graphics, JTable table, Object cellValue, int row, int col, boolean isHeaderCell, Rectangle cellBbox, double zoom) {
        Graphics2D g = (Graphics2D)graphics;
        g.setRenderingHints(GraphicsUtil.getRenderingHints());
        Component cellComp = AtPrintUtil.getCellRendererComponent(table, row, col, isHeaderCell);
        Component viewportComp = AtPrintUtil.getViewportComponent(cellComp);
        if (viewportComp != null) {
            cellComp = viewportComp;
        }
        if (row < 0) {
            JTableHeader header = table.getTableHeader();
            cellComp.setBackground(header.getBackground());
            cellComp.setForeground(header.getForeground());
            cellComp.setFont(header.getFont());
            if (cellComp instanceof JComponent) {
                ((JComponent)cellComp).setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            }
        }
        cellComp.setVisible(true);
        Image cellImage = null;
        this.orgFontMap.clear();
        if (zoom != 1.0) {
            if (cellValue instanceof Image || cellValue instanceof ImageIcon) {
                cellImage = this.getImage(cellValue, zoom);
                if (cellImage == null) {
                    this.buildFontMap(cellComp);
                    this.replaceFont(zoom);
                }
            } else {
                this.buildFontMap(cellComp);
                this.replaceFont(zoom);
            }
        }
        if (cellImage != null) {
            int imgx = cellBbox.x + (cellBbox.width - cellImage.getWidth(null)) / 2;
            int imgy = cellBbox.y + (cellBbox.height - cellImage.getHeight(null)) / 2;
            g.drawImage(cellImage, imgx, imgy, null);
        } else {
            AffineTransform orgAt = g.getTransform();
            Shape orgClip = g.getClip();
            g.translate(cellBbox.x, cellBbox.y);
            g.setClip(0, 0, cellBbox.width + 1, cellBbox.height + 1);
            cellComp.setSize(cellBbox.width, cellBbox.height);
            cellComp.validate();
            cellComp.printAll(g);
            g.setTransform(orgAt);
            g.setClip(orgClip);
            this.regainOriginalFont();
        }
        this.orgFontMap.clear();
    }

    public int getCellHeight(JTable table, int row, int column, boolean isHeaderCell) {
        int height = 0;
        if (isHeaderCell) {
            height = table.getTableHeader().getHeaderRect((int)column).height;
            if (height <= 0) {
                FontMetrics fm = table.getFontMetrics(table.getTableHeader().getFont());
                height = fm.getHeight();
            }
        } else {
            height = table.getCellRect((int)row, (int)column, (boolean)true).height;
            if (height <= 0) {
                height = table.getRowHeight(row);
            }
        }
        return height;
    }

    public int getCellWidth(JTable table, int row, int column, boolean isHeaderCell) {
        int width = 0;
        if (isHeaderCell) {
            Rectangle headerRect = table.getTableHeader().getHeaderRect(column);
            width = headerRect.width;
        } else {
            Rectangle cellRect = table.getCellRect(row, column, true);
            width = cellRect.width;
        }
        if (width <= 0) {
            width = table.getColumnModel().getColumn(column).getPreferredWidth();
        }
        return width;
    }

    public AtElement getContent(JTable table, int row, int column, boolean isHeaderCell, Rectangle cellBbox, double zoom) {
        return null;
    }

    private void buildFontMap(Component comp) {
        if (comp == null) {
            return;
        }
        Font orgFont = comp.getFont();
        this.orgFontMap.put(comp, orgFont);
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            Component[] childs = cont.getComponents();
            for (int i = 0; childs != null && i < childs.length; ++i) {
                Component aChild = childs[i];
                this.buildFontMap(aChild);
            }
        }
    }

    private void replaceFont(double zoom) {
        Iterator compIter = this.orgFontMap.keySet().iterator();
        while (compIter != null && compIter.hasNext()) {
            Component comp = (Component)compIter.next();
            Font orgFont = (Font)this.orgFontMap.get(comp);
            if (orgFont == null) continue;
            Font zoomedFont = AtPrintUtil.getFont(orgFont, zoom);
            comp.setFont(zoomedFont);
        }
    }

    private void regainOriginalFont() {
        Iterator compIter = this.orgFontMap.keySet().iterator();
        while (compIter != null && compIter.hasNext()) {
            Component comp = (Component)compIter.next();
            Font orgFont = (Font)this.orgFontMap.get(comp);
            comp.setFont(orgFont);
        }
    }

    Image getImage(Object cellValue, double zoom) {
        if (cellValue == null) {
            return null;
        }
        Image image = null;
        if (cellValue instanceof ImageIcon) {
            image = ((ImageIcon)cellValue).getImage();
        } else if (cellValue instanceof Image) {
            image = (Image)cellValue;
        }
        if (image == null) {
            return null;
        }
        double width = image.getWidth(null);
        double height = image.getHeight(null);
        BufferedImage bi = new BufferedImage((int)(width *= zoom), (int)(height *= zoom), 2);
        Graphics2D g = bi.createGraphics();
        g.setColor(SystemColor.white);
        g.fillRect(0, 0, (int)width, (int)height);
        g.drawImage(image, 0, 0, (int)width, (int)height, null);
        return bi;
    }
}

