/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.report;

import com.activetree.common.action.AtViewerActionListener;
import com.activetree.common.conversion.ConversionFactory;
import com.activetree.common.conversion.PdfProperties;
import com.activetree.common.data.KeyValue;
import com.activetree.common.exception.AtUserActionVetoException;
import com.activetree.common.object.KeyValueObject;
import com.activetree.common.page.AbstractPage;
import com.activetree.common.print.dialog.AtPrinterSelectionFrame;
import com.activetree.common.print.dialog.PageSelectionDialog;
import com.activetree.common.report.page.AbstractReportPage;
import com.activetree.common.report.printer.AbstractReportPrinter;
import com.activetree.common.report.watermark.Watermark;
import com.activetree.common.report.watermark.WatermarkProducer;
import com.activetree.common.resource.AtCommonResource;
import com.activetree.common.resource.AtImageList;
import com.activetree.common.swing.AtImageCellWidget;
import com.activetree.common.swing.AtInsetsPanel;
import com.activetree.common.swing.AtIntegerTypeDocument;
import com.activetree.common.swing.AtMouseWheelScrollListener;
import com.activetree.common.swing.ImageOutputSetupDialog;
import com.activetree.common.utils.AtComponentUtil;
import com.activetree.common.utils.AtDebug;
import com.activetree.common.utils.FileChooserUtil;
import com.activetree.common.viewer.ThumbnailData;
import com.activetree.common.viewer.ThumbnailView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.RepaintManager;

public class ReportPreviewPane
extends JPanel {
    public static final String THUMBNAILS_CMD = AtCommonResource.MESSAGE_RESOURCE.getText("THUMBNAILS_CMD");
    public static final String WATERMARK_CMD = "WATER_MARK";
    public static final String PAGE_SETUP_CMD = AtCommonResource.MESSAGE_RESOURCE.getText("PageSetup");
    public static final String NEXT_CMD = AtCommonResource.MESSAGE_RESOURCE.getText("Next");
    public static final String PREVIOUS_CMD = AtCommonResource.MESSAGE_RESOURCE.getText("Previous");
    public static final String GO_CMD = AtCommonResource.MESSAGE_RESOURCE.getText("Go");
    public static final String ZOOMIN_CMD = AtCommonResource.MESSAGE_RESOURCE.getText("Zoomin");
    public static final String ZOOMOUT_CMD = AtCommonResource.MESSAGE_RESOURCE.getText("Zoomout");
    public static final String HUNDREAD_PERCENT_CMD = AtCommonResource.MESSAGE_RESOURCE.getText("HUNDREAD_PERCENT");
    public static final String PRINT_SETUP_CMD = AtCommonResource.MESSAGE_RESOURCE.getText("PRINT_AND_PAGE_SETUP_CMD");
    public static final String PRINT_CMD = AtCommonResource.MESSAGE_RESOURCE.getText("Print");
    public static final String PDF_CMD = AtCommonResource.MESSAGE_RESOURCE.getText("PDF");
    public static final String PNG_CMD = AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_PNG");
    public static final String JPEG_CMD = AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_JPEG");
    public static final String HELP_CMD = AtCommonResource.MESSAGE_RESOURCE.getText("HELP");
    public static final String CLOSE_CMD = AtCommonResource.MESSAGE_RESOURCE.getText("CLOSE");
    public static final String THUMBNAIL_SELECTION_CMD = "thumbnailSelection";
    public static final String THUMBNAILS_BUTTON = THUMBNAILS_CMD;
    public static final String NEXT_BUTTON = NEXT_CMD;
    public static final String PREVIOUS_BUTTON = PREVIOUS_CMD;
    public static final String GO_BUTTON = GO_CMD;
    public static final String PRINT_BUTTON = PRINT_CMD;
    public static final String PDF_BUTTON = PDF_CMD;
    public static final String PNG_BUTTON = PNG_CMD;
    public static final String JPEG_BUTTON = JPEG_CMD;
    public static final String ZOOMIN_BUTTON = ZOOMIN_CMD;
    public static final String ZOOMOUT_BUTTON = ZOOMOUT_CMD;
    public static final String ZOOM_NORMAL_BUTTON = HUNDREAD_PERCENT_CMD;
    public static final String HELP_BUTTON = HELP_CMD;
    protected final PdfProperties pdfProperties = new PdfProperties();
    protected String dirToOpen;
    protected String lastOpenedDirectory;
    protected JComponent thumbnails;
    protected JComponent watermarkButton;
    protected JComponent pageSetupButton;
    protected JComponent next;
    protected JComponent previous;
    protected JComponent zoomin;
    protected JComponent zoomout;
    protected JComponent go;
    protected JComponent fullScreen;
    protected JComponent print;
    protected JComponent pdf;
    protected JComponent png;
    protected JComponent jpeg;
    protected JComponent help;
    protected JComponent close;
    protected JTextField pageField;
    protected JTextField printField;
    protected AtInsetsPanel toolbarPane;
    protected AtInsetsPanel pageNumberPane;
    protected JToolBar browseBar;
    protected JToolBar thumbnailsBar;
    protected JToolBar zoomBar;
    protected JToolBar pageBar;
    protected JToolBar printBar;
    protected JLabel pageNo;
    protected JLabel totalPages;
    protected JComboBox percentCombo;
    protected KeyValueObject[] percentValues = this.createPercentZoomComboValues();
    protected int thumbnailX = 10;
    protected int thumbnailY = 10;
    protected int thumbnailMargin = 5;
    protected int thumbnailWidth = 60;
    protected int thumbnailHeight = 70;
    protected Font thumbnailPageNoFont = new Font("Helvetica", 0, 10);
    protected FontMetrics thumbnailPageNoFm = this.getFontMetrics(this.thumbnailPageNoFont);
    protected Color thumbnailSelectionBackground = new Color(153, 153, 255);
    protected AbstractReportPage[] pages;
    protected int currPageIndex = 0;
    protected int lastViewedPage;
    protected JScrollPane pageScroller;
    protected AbstractReportPrinter printerClass;
    protected ThumbnailsView thumbnailsView;
    private int lastDividerLocation = 120;
    protected JSplitPane splitPane;
    protected JScrollPane thumbnailsScroller;
    protected int splitLocation = 110;
    protected Dimension size = new Dimension(790, 500);
    protected Hashtable buttons = new Hashtable();
    protected ActionListener percentComboListener;
    protected AtPageView pageView;
    protected Container container;
    protected AtPreviewActionComponent previewActionComponent;
    private Provider provider = new Provider();
    private boolean thumbnailsVisible = true;
    private WatermarkProducer watermarkPane = new WatermarkProducer();
    private Watermark watermark;
    private boolean watermarkEnabled = false;
    private Cursor DEFAULT_CURSOR = new Cursor(0);
    private Cursor HAND_CLOSED_CURSOR;
    private Cursor HAND_OPEN_CURSOR;
    protected static final String LAST_OPENED_DIRECTORY = "LastOpenedDirectory";
    public static String DEFAULT_USER_PREF = ".report_preview.pref";
    protected String entryPrefix;
    protected Properties oldPrefs;
    protected Vector reportActionListeners;
    protected Dimension watermarkFrameSize;
    private ReportPreviewPane view;

    public void setThumbnailsButtonVisible(boolean visible) {
        this.thumbnails.setVisible(visible);
        this.thumbnails.invalidate();
    }

    public void setWatermarkButtonVisible(boolean visible) {
        this.watermarkButton.setVisible(visible);
        this.watermarkButton.invalidate();
    }

    public void setPageSetupButtonVisible(boolean visible) {
        this.pageSetupButton.setVisible(visible);
        this.pageSetupButton.invalidate();
    }

    public void setNextButtonVisible(boolean visible) {
        this.next.setVisible(visible);
        this.next.invalidate();
    }

    public void setPreviousButtonVisible(boolean visible) {
        this.previous.setVisible(visible);
        this.previous.invalidate();
    }

    public void setZoominButtonVisible(boolean visible) {
        this.zoomin.setVisible(visible);
        this.zoomin.invalidate();
    }

    public void setZoomoutButtonVisible(boolean visible) {
        this.zoomout.setVisible(visible);
        this.zoomout.invalidate();
    }

    public void setGotoPageButtonVisible(boolean visible) {
        this.go.setVisible(visible);
        this.go.invalidate();
    }

    public void setZoomToNormalButtonVisible(boolean visible) {
        this.fullScreen.setVisible(visible);
        this.fullScreen.invalidate();
    }

    public void setPrintButtonVisible(boolean visible) {
        this.print.setVisible(visible);
        this.print.invalidate();
    }

    public void setPdfButtonVisible(boolean visible) {
        this.pdf.setVisible(visible);
        this.pdf.invalidate();
    }

    public void setPngButtonVisible(boolean visible) {
        this.png.setVisible(visible);
        this.png.invalidate();
    }

    public void setJpegButtonVisible(boolean visible) {
        this.jpeg.setVisible(visible);
        this.jpeg.invalidate();
    }

    public void setHelpButtonVisible(boolean visible) {
        this.help.setVisible(visible);
        this.help.invalidate();
    }

    public void setGotoPageNumberEntryFieldVisible(boolean visible) {
        this.pageField.setVisible(visible);
        this.pageField.invalidate();
    }

    public void setPrintPageNumbersEntryFieldVisible(boolean visible) {
        this.printField.setVisible(visible);
        this.printField.invalidate();
    }

    public void setToolbarPaneVisible(boolean visible) {
        this.toolbarPane.setVisible(visible);
        this.toolbarPane.invalidate();
    }

    public JComponent getToolBarPane() {
        return this.toolbarPane;
    }

    public void setPageNumberDisplayPaneVisible(boolean visible) {
        this.pageNumberPane.setVisible(visible);
        this.pageNumberPane.invalidate();
    }

    public JToolBar getBrowsePagesToolbar() {
        return this.browseBar;
    }

    public void setThumbnailsToolbarVisible(boolean visible) {
        this.thumbnailsBar.setVisible(visible);
        this.thumbnailsBar.invalidate();
    }

    public void setBrowsePagesToolbarVisible(boolean visible) {
        this.browseBar.setVisible(visible);
        this.browseBar.invalidate();
    }

    public JToolBar getZoomToolbar() {
        return this.zoomBar;
    }

    public void setZoomToolbarVisible(boolean visible) {
        this.zoomBar.setVisible(visible);
        this.zoomBar.invalidate();
    }

    public JToolBar getGotoPageNumberToolbar() {
        return this.pageBar;
    }

    public void setGotoPageNumberToolbarVisible(boolean visible) {
        this.pageBar.setVisible(visible);
        this.pageBar.invalidate();
    }

    public JToolBar getPrintToolbar() {
        return this.printBar;
    }

    public void setPrintToolbarVisible(boolean visible) {
        this.printBar.setVisible(visible);
        this.printBar.invalidate();
    }

    public JLabel getPageNumberDisplayLabel() {
        return this.pageNo;
    }

    public void setPageNumberDisplayLabelVisible(boolean visible) {
        this.pageNo.setVisible(visible);
        this.pageNo.invalidate();
    }

    public JLabel getTotalPagesDisplayLabel() {
        return this.totalPages;
    }

    public void setTotalPageDisplayLabelVisible(boolean visible) {
        this.totalPages.setVisible(visible);
        this.totalPages.invalidate();
    }

    public void setZoomPErcentComboVisible(boolean visible) {
        this.percentCombo.setVisible(visible);
        this.percentCombo.invalidate();
    }

    protected KeyValueObject[] createPercentZoomComboValues() {
        KeyValueObject[] percentValues = new KeyValueObject[]{new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("500%"), 500.0), new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("475%"), 475.0), new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("450%"), 450.0), new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("425%"), 425.0), new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("400%"), 400.0), new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("375%"), 375.0), new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("350%"), 350.0), new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("325%"), 325.0), new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("300%"), 300.0), new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("275%"), 275.0), new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("250%"), 250.0), new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("225%"), 225.0), new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("200%"), 200.0), new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("175%"), 175.0), new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("150%"), 150.0), new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("125%"), 125.0), new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("100%"), 100.0), new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("75%"), 75.0), new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("50%"), 50.0), new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("25%"), 25.0)};
        return percentValues;
    }

    public void setThumbnailsX(int thumbnailX) {
        this.thumbnailX = thumbnailX;
    }

    public int getThumbnailsX() {
        return this.thumbnailX;
    }

    public void setThumbnailsY(int thumbnailsY) {
        this.thumbnailY = thumbnailsY;
    }

    public int getThumbnailsY() {
        return this.thumbnailY;
    }

    public void setThumbnailsMargin(int margin) {
        this.thumbnailMargin = margin;
    }

    public int getThumbnailsMargin() {
        return this.thumbnailMargin;
    }

    public void setThumbnailWidth(int width) {
        this.thumbnailWidth = width;
    }

    public int getThumbnailWidth() {
        return this.thumbnailWidth;
    }

    public void setThumbnailHeight(int height) {
        this.thumbnailHeight = height;
    }

    public int getThumbnailHeight() {
        return this.thumbnailHeight;
    }

    public void setThumbnailPageNumberFont(Font font) {
        this.thumbnailPageNoFont = font;
    }

    public Font getThumbnailPageNumberFont() {
        return this.thumbnailPageNoFont;
    }

    public void setThumbnailSelectionBackground(Color background) {
        this.thumbnailSelectionBackground = background;
    }

    public Color getThumbnailSelectionBackground() {
        return this.thumbnailSelectionBackground;
    }

    public void setPages(AbstractReportPage[] pages) {
        this.pages = pages;
    }

    public JScrollPane getPageScrollPane() {
        return this.pageScroller;
    }

    public void setPrinterClass(AbstractReportPrinter printerClass) {
        this.printerClass = printerClass;
    }

    public void setThumbnailsPaneVisible(boolean visible) {
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public JScrollPane getThumbnailsScroller() {
        return this.thumbnailsScroller;
    }

    public void setSplitLocation(int newSplitLocation) {
        this.splitLocation = newSplitLocation;
    }

    public int getSplitLocation() {
        return this.splitLocation;
    }

    public Dimension getDefaultViewSize() {
        return this.size;
    }

    public void setToolbarVisible(boolean visible) {
        this.previewActionComponent.setVisible(visible);
        this.previewActionComponent.invalidate();
    }

    public JComponent getToolBar() {
        return this.previewActionComponent;
    }

    public ReportPreviewPane(AbstractReportPage[] inputPages, AbstractReportPrinter inputPtinerClass) {
        this.HAND_CLOSED_CURSOR = this.createCustomCursor(AtImageList.IMAGE_LIST.HAND_CLOSED_ICON);
        this.HAND_OPEN_CURSOR = this.createCustomCursor(AtImageList.IMAGE_LIST.HAND_OPEN_ICON);
        this.entryPrefix = "Rpt";
        this.reportActionListeners = new Vector();
        this.watermarkFrameSize = new Dimension(700, 600);
        this.view = this;
        this.pages = inputPages;
        this.printerClass = inputPtinerClass;
        this.loadUserPreferences();
        this.setupContentPane();
    }

    protected String getUserPreferencePropertiesName() {
        return DEFAULT_USER_PREF;
    }

    protected void loadUserPreferences() {
        AtDebug.debug("loadUserPreferences()");
        String userPrefPropertiesName = this.getUserPreferencePropertiesName();
        FileInputStream is = null;
        try {
            String userHome = System.getProperty("user.home");
            if (userHome != null) {
                String urlPropFile = userHome + System.getProperty("file.separator") + userPrefPropertiesName;
                is = new FileInputStream(urlPropFile);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (is != null) {
            try {
                Properties p = new Properties();
                p.load(is);
                Enumeration<Object> keys = p.keys();
                while (keys != null && keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    key = key.trim();
                    String value = p.getProperty(key);
                    value = value.trim();
                    if (key == null || !key.equalsIgnoreCase(LAST_OPENED_DIRECTORY)) continue;
                    this.dirToOpen = value;
                }
                this.oldPrefs = p;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void saveUserPreferences() {
        String userPrefPropertiesName = this.getUserPreferencePropertiesName();
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        if (this.lastOpenedDirectory != null) {
            properties.put(LAST_OPENED_DIRECTORY, this.lastOpenedDirectory);
        }
        FileOutputStream out = null;
        try {
            String userHome;
            if (properties.size() > 0 && (userHome = System.getProperty("user.home")) != null) {
                String urlPropFile = userHome + System.getProperty("file.separator") + userPrefPropertiesName;
                out = new FileOutputStream(urlPropFile);
            }
        }
        catch (Throwable t) {
            AtDebug.debug(9, t);
        }
        if (out != null) {
            try {
                Properties p = new Properties();
                if (this.oldPrefs != null && this.oldPrefs.size() > 0) {
                    p.putAll((Map<?, ?>)this.oldPrefs);
                }
                p.putAll((Map<?, ?>)properties);
                p.store(out, this.entryPrefix + " - User preferences");
            }
            catch (Throwable t) {
                AtDebug.debug(9, t);
            }
        }
    }

    private void setupContentPane() {
        int pageCount = 0;
        if (this.pages != null) {
            pageCount = this.pages.length;
        }
        this.setSize(this.size);
        this.setFocusable(true);
        AbstractReportPage firstPage = null;
        if (this.pages != null && this.pages.length > 0) {
            firstPage = this.pages[0];
        }
        this.pageView = new AtPageView(firstPage);
        this.pageView.setFocusable(true);
        this.pageView.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                ReportPreviewPane.this.pageView.grabFocus();
            }
        });
        this.pageView.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                ReportPreviewPane.this.pageView.grabFocus();
            }

            public void mousePressed(MouseEvent evt) {
                ReportPreviewPane.this.pageView.setCursor(ReportPreviewPane.this.HAND_CLOSED_CURSOR);
            }

            public void mouseReleased(MouseEvent evt) {
                ReportPreviewPane.this.pageView.setCursor(ReportPreviewPane.this.HAND_OPEN_CURSOR);
            }

            public void mouseExited(MouseEvent evt) {
                ReportPreviewPane.this.pageView.setCursor(ReportPreviewPane.this.DEFAULT_CURSOR);
            }

            public void mouseEntered(MouseEvent evt) {
                ReportPreviewPane.this.pageView.setCursor(ReportPreviewPane.this.HAND_OPEN_CURSOR);
            }
        });
        this.pageView.addMouseMotionListener(new MouseMotionListener(){
            Point dragPoint = new Point();

            public void mouseDragged(MouseEvent mouseevent) {
                if (this.dragPoint == null) {
                    return;
                }
                JScrollBar jscrollbar = ReportPreviewPane.this.pageScroller.getVerticalScrollBar();
                JScrollBar jscrollbar1 = ReportPreviewPane.this.pageScroller.getHorizontalScrollBar();
                Point point = new Point((int)mouseevent.getPoint().getX() - jscrollbar1.getValue(), (int)mouseevent.getPoint().getY() - jscrollbar.getValue());
                int i1 = (int)((double)jscrollbar1.getValue() - (point.getX() - this.dragPoint.getX()));
                int j1 = (int)((double)jscrollbar.getValue() - (point.getY() - this.dragPoint.getY()));
                jscrollbar1.setValue(i1);
                jscrollbar.setValue(j1);
                this.dragPoint.setLocation(point);
            }

            public void mouseMoved(MouseEvent mouseevent) {
                JScrollBar jscrollbar = ReportPreviewPane.this.pageScroller.getVerticalScrollBar();
                JScrollBar jscrollbar1 = ReportPreviewPane.this.pageScroller.getHorizontalScrollBar();
                this.dragPoint.setLocation(mouseevent.getPoint().getX() - (double)jscrollbar1.getValue(), mouseevent.getPoint().getY() - (double)jscrollbar.getValue());
            }
        });
        this.previewActionComponent = new AtPreviewActionComponent(pageCount);
        double zoomPercent = 100.0;
        if (this.printerClass != null) {
            zoomPercent = this.printerClass.getZoomPercent();
        }
        this.previewActionComponent.resetPreviewControls(zoomPercent, false);
        this.thumbnailsView = new ThumbnailsView(this);
        this.thumbnailsScroller = new JScrollPane(this.thumbnailsView);
        new AtMouseWheelScrollListener(this.thumbnailsScroller, 25);
        this.pageScroller = new JScrollPane(this.pageView);
        this.pageView.setAutoscrolls(true);
        this.pageScroller.setWheelScrollingEnabled(true);
        new AtMouseWheelScrollListener(this.pageScroller, 25);
        this.container = this;
        this.container.setLayout(new BorderLayout(5, 5));
        this.container.add((Component)this.previewActionComponent, "North");
        this.splitPane = new JSplitPane(1, true, this.thumbnailsScroller, this.pageScroller);
        this.splitPane.setDividerSize(0);
        this.thumbnailsScroller.setVisible(false);
        this.splitPane.setDividerLocation(0);
        this.setViewerControlVisible(THUMBNAILS_CMD, false);
        this.thumbnailsVisible = true;
        this.container.add((Component)this.splitPane, "Center");
        this.addActionListeners();
        this.show(0);
    }

    public Cursor createCustomCursor(ImageIcon imageicon) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Point point = new Point(12, 12);
        String s3 = "";
        Cursor cursor = toolkit.createCustomCursor(imageicon.getImage(), point, s3);
        return cursor;
    }

    public boolean addReportActionListener(AtViewerActionListener l2) {
        if (!this.reportActionListeners.contains(l2)) {
            this.reportActionListeners.add(l2);
        }
        return false;
    }

    public boolean removeReportActionListener(AtViewerActionListener l2) {
        return this.reportActionListeners.remove(l2);
    }

    public void removeAllReportActionListeners() {
        this.reportActionListeners.removeAllElements();
    }

    void notifyReportActionListeners(ActionEvent evt) throws AtUserActionVetoException {
        for (int i = 0; this.reportActionListeners != null && i < this.reportActionListeners.size(); ++i) {
            AtViewerActionListener l2 = (AtViewerActionListener)this.reportActionListeners.get(i);
            l2.viewerActionPerformed(evt);
        }
    }

    AbstractReportPage[] getPages() {
        return this.pages;
    }

    public void show(int pageIndex) {
        AbstractReportPage page = null;
        if (this.pages == null || this.pages.length == 0) {
            return;
        }
        page = this.pages[pageIndex];
        this.pageView.setPage(page);
        this.pageView.repaint();
        if (pageIndex == 0) {
            this.previewActionComponent.getPreviousButton().setEnabled(false);
        } else {
            this.previewActionComponent.getPreviousButton().setEnabled(true);
        }
        if (pageIndex == this.pages.length - 1) {
            this.previewActionComponent.getNextButton().setEnabled(false);
        } else {
            this.previewActionComponent.getNextButton().setEnabled(true);
        }
        this.currPageIndex = pageIndex;
        this.previewActionComponent.setCurrentPageLabel(pageIndex);
        this.previewActionComponent.getPageField().setText(String.valueOf(pageIndex + 1));
    }

    public void showNext() {
        this.show(this.currPageIndex + 1);
    }

    public void showPrevious() {
        this.show(this.currPageIndex - 1);
    }

    public void showLast() {
        this.show(this.pages.length - 1);
    }

    public void showFirst() {
        this.show(0);
    }

    public void showPageIndex(int pageIndex) {
        this.show(pageIndex);
    }

    public int getDisplayedPageIndex() {
        return this.currPageIndex;
    }

    public AbstractReportPage getDisplayedPage() {
        return this.pages[this.currPageIndex];
    }

    public AbstractReportPage getPageAt(int idx) {
        return this.pages[idx];
    }

    public int getPageCount() {
        if (this.pages == null) {
            return 0;
        }
        return this.pages.length;
    }

    public void destroy() {
        this.saveUserPreferences();
        if (this.printerClass != null) {
            this.printerClass.setCopies(1);
            this.printerClass.setZoomPercent(100.0);
        }
    }

    protected void addActionListeners() {
        this.previewActionComponent.addPreviewActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ReportPreviewPane.this.notifyReportActionListeners(evt);
                }
                catch (AtUserActionVetoException ex) {
                    AtDebug.debug(9, "User action is vetowed by: " + ex.getClass().getName());
                    return;
                }
                Container window = AtComponentUtil.getWindowForComponent(ReportPreviewPane.this.view);
                if (window == null) {
                    window = ReportPreviewPane.this.view;
                }
                window.setCursor(Cursor.getPredefinedCursor(3));
                String cmd = evt.getActionCommand();
                if (cmd.equals(PAGE_SETUP_CMD)) {
                    ReportPreviewPane.this.pageSetupActionPerformed(evt);
                } else if (cmd.equals(NEXT_CMD)) {
                    ReportPreviewPane.this.nextActionPerformed(evt);
                } else if (cmd.equals(THUMBNAILS_CMD)) {
                    ReportPreviewPane.this.thumbnailsActionPerformed(evt);
                } else if (cmd.equals(ReportPreviewPane.WATERMARK_CMD)) {
                    ReportPreviewPane.this.watermarkAction(evt);
                } else if (cmd.equals(PREVIOUS_CMD)) {
                    ReportPreviewPane.this.previousActionPerformed(evt);
                } else if (cmd.equals(GO_CMD)) {
                    ReportPreviewPane.this.goActionPerformed(evt);
                } else if (cmd.equals(HUNDREAD_PERCENT_CMD)) {
                    ReportPreviewPane.this.fullScreenActionPerformed(evt);
                } else if (cmd.equals(ZOOMIN_CMD)) {
                    ReportPreviewPane.this.zoominActionPerformed(evt);
                } else if (cmd.equals(ZOOMOUT_CMD)) {
                    ReportPreviewPane.this.zoomoutActionPerformed(evt);
                } else if (cmd.equals(PRINT_SETUP_CMD)) {
                    ReportPreviewPane.this.showPrinterAndPageSetupDialog();
                } else if (cmd.equals(PRINT_CMD)) {
                    ReportPreviewPane.this.printActionPerformed(evt);
                } else if (cmd.equals(PDF_CMD)) {
                    ((ReportPreviewPane)ReportPreviewPane.this).provider.theProvider.saveAsPdfActionPerformed(evt, window);
                } else if (cmd.equals(PNG_CMD)) {
                    ((ReportPreviewPane)ReportPreviewPane.this).provider.theProvider.savePagesAsPNG();
                } else if (cmd.equals(JPEG_CMD)) {
                    ((ReportPreviewPane)ReportPreviewPane.this).provider.theProvider.savePagesAsJPEG();
                } else if (cmd.equals(HELP_CMD)) {
                    ReportPreviewPane.this.helpActionPerformed(evt);
                } else if (cmd.equals(CLOSE_CMD)) {
                    ReportPreviewPane.this.destroy();
                }
                window.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
    }

    protected void thumbnailsActionPerformed(ActionEvent evt) {
        if (this.thumbnailsVisible) {
            this.lastDividerLocation = this.splitPane.getDividerLocation();
            this.splitPane.setLeftComponent(null);
            this.thumbnailsVisible = false;
        } else {
            this.splitPane.setLeftComponent(this.thumbnailsScroller);
            this.splitPane.setDividerLocation(this.lastDividerLocation);
            this.thumbnailsVisible = true;
        }
        this.splitPane.revalidate();
    }

    public boolean isWatermarkEnabled() {
        return this.watermarkEnabled;
    }

    public void setWatermarkEnabled(boolean watermarkEnabled) {
        this.watermarkEnabled = watermarkEnabled;
    }

    public void setWatermarkFrameSize(Dimension newSize) {
        this.watermarkFrameSize = newSize;
    }

    public Dimension getWatermarkWindowSize() {
        return this.watermarkFrameSize;
    }

    public void setTextWatermark(String textWatermark) {
        this.watermarkPane.setText(textWatermark);
    }

    public String getTextWatermark() {
        return this.watermarkPane.getText();
    }

    protected void watermarkAction(ActionEvent evt) {
        Window window = AtComponentUtil.getWindowForComponent(this.view);
        String title = AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_ADD_WATERMARK_TITLE");
        JDialog dialog = null;
        dialog = window instanceof Dialog ? new JDialog((Dialog)window, title, true) : (window instanceof Frame ? new JDialog((Frame)window, title, true) : new JDialog((Dialog)null, title, true));
        Container c = dialog.getContentPane();
        c.add((Component)this.watermarkPane, "Center");
        if (this.watermarkFrameSize == null) {
            this.watermarkFrameSize = new Dimension(700, 600);
        }
        dialog.setSize(this.watermarkFrameSize);
        final JDialog dlg = dialog;
        dlg.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                dlg.setVisible(false);
                dlg.dispose();
            }
        });
        AtComponentUtil.centerOnContainer(window, dialog);
        dialog.setVisible(true);
        if (!this.watermarkPane.isOkPressed()) {
            return;
        }
        String titlex = AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_WATERMARK_SELECT_PAGES_TITLE");
        Vector<String> listData = new Vector<String>();
        for (int i = 0; this.pages != null && i < this.pages.length; ++i) {
            String pageStr = AtCommonResource.MESSAGE_RESOURCE.getText("PAGE_MSG");
            listData.add(pageStr + " " + (i + 1));
        }
        PageSelectionDialog pageSelDialog = null;
        if (window instanceof Dialog) {
            pageSelDialog = new PageSelectionDialog((Dialog)window, titlex, true, listData);
        } else if (window instanceof Frame) {
            pageSelDialog = new PageSelectionDialog((Frame)window, titlex, true, listData);
        }
        pageSelDialog.setSize(new Dimension(400, 300));
        AtComponentUtil.centerOnContainer(window, pageSelDialog);
        pageSelDialog.setVisible(true);
        if (!pageSelDialog.isOkPressed()) {
            return;
        }
        int[] selPageIdxs = pageSelDialog.getSelectedIndexes();
        this.watermark = this.watermarkPane.getWatermark();
        this.watermarkEnabled = this.watermarkPane.isWatermarkEnabled();
        for (int i = 0; selPageIdxs != null && i < selPageIdxs.length; ++i) {
            int pageIdx = selPageIdxs[i];
            this.pages[pageIdx].setWatermark(this.watermark);
            this.pages[pageIdx].setDrawWatermark(this.isWatermarkEnabled());
        }
        pageSelDialog.dispose();
        this.showPageIndex(this.getDisplayedPageIndex());
    }

    protected void pageSetupActionPerformed(ActionEvent evt) {
        boolean showPageSetupDialog;
        PageFormat currPf = this.printerClass.getPageFormat();
        PrintRequestAttributeSet pAttrs = this.printerClass.getPrintRequestAttributeSet();
        boolean okPressed = this.printerClass.showPrintSetup(pAttrs, currPf, false, showPageSetupDialog = true, false);
        if (!okPressed) {
            return;
        }
        this.lastViewedPage = this.currPageIndex;
        AtDebug.debug("Page setup action performed.");
        double zoomPercent = 100.0;
        if (this.printerClass != null) {
            zoomPercent = this.printerClass.getZoomPercent();
        }
        this.previewActionComponent.resetPreviewControls(zoomPercent, true);
    }

    protected void nextActionPerformed(ActionEvent evt) {
        this.showNext();
        this.thumbnailsView.setThumbnailSelectionIndex(this.getDisplayedPageIndex());
    }

    protected void previousActionPerformed(ActionEvent evt) {
        this.showPrevious();
        this.thumbnailsView.setThumbnailSelectionIndex(this.getDisplayedPageIndex());
    }

    protected void goActionPerformed(ActionEvent evt) {
        this.provider.theProvider.goActionPerformed(evt);
    }

    protected void fullScreenActionPerformed(ActionEvent evt) {
        this.lastViewedPage = this.currPageIndex;
        AtDebug.debug("100% action performed.");
        double zoomPercent = 100.0;
        if (this.printerClass != null) {
            this.printerClass.setZoomPercent(zoomPercent);
        }
        this.previewActionComponent.resetPreviewControls(zoomPercent, true);
    }

    protected void zoominActionPerformed(ActionEvent evt) {
        this.lastViewedPage = this.currPageIndex;
        AtDebug.debug("zoomin action performed...");
        double zoomPercent = 100.0;
        if (this.printerClass != null) {
            zoomPercent = this.printerClass.getZoomPercent();
            this.printerClass.zoomIn();
        }
        this.previewActionComponent.resetPreviewControls(zoomPercent, true);
    }

    protected void zoomoutActionPerformed(ActionEvent evt) {
        this.lastViewedPage = this.currPageIndex;
        AtDebug.debug("zoomout action.");
        double zoomPercent = 100.0;
        if (this.printerClass != null) {
            zoomPercent = this.printerClass.getZoomPercent();
            this.printerClass.zoomOut();
        }
        this.previewActionComponent.resetPreviewControls(zoomPercent, true);
    }

    protected void helpActionPerformed(ActionEvent evt) {
        AtDebug.debug("Help...need to show a help dialog.");
        Window window = AtComponentUtil.getWindowForComponent(this.view);
        HelpDialog help = null;
        help = window instanceof Dialog ? new HelpDialog((Dialog)window, AtCommonResource.MESSAGE_RESOURCE.getText("PREVIEW_HELP_WINDOW_TITLE")) : (window instanceof Frame ? new HelpDialog((Frame)window, AtCommonResource.MESSAGE_RESOURCE.getText("PREVIEW_HELP_WINDOW_TITLE")) : new HelpDialog((Frame)null, AtCommonResource.MESSAGE_RESOURCE.getText("PREVIEW_HELP_WINDOW_TITLE")));
        AtComponentUtil.centerOnContainer(window, help);
        help.setVisible(true);
    }

    public final Vector getSelectedPages() {
        return this.provider.theProvider.getSelectedPages();
    }

    private boolean hasIllegalChars(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (!Character.isLetter(ch)) continue;
            return true;
        }
        return false;
    }

    private String getFilteredPageString() {
        String value = this.previewActionComponent.getPrintFieldValue();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (ch == ' ') continue;
            buf.append(ch);
        }
        String filteredStr = buf.toString();
        return filteredStr;
    }

    private boolean validateRange() {
        String filteredStr = this.getFilteredPageString();
        int idx1 = filteredStr.indexOf(",,");
        int idx2 = filteredStr.indexOf("--");
        if (idx1 >= 0 || idx2 >= 0) {
            JOptionPane.showMessageDialog(this.view, AtCommonResource.MESSAGE_RESOURCE.getText("RANGE_FORMAT_ERROR_MSG"), AtCommonResource.MESSAGE_RESOURCE.getText("Error"), 0);
            return false;
        }
        return true;
    }

    private boolean isRangeToken(String token) {
        StringTokenizer tk = new StringTokenizer(token, "-");
        int tokenCount = tk.countTokens();
        return tokenCount >= 2;
    }

    private Vector getPagesFromRange(String range) {
        StringTokenizer tk = new StringTokenizer(range, "-");
        String startToken = tk.nextToken();
        String endToken = tk.nextToken();
        int startPage = Integer.parseInt(startToken);
        int endPage = Integer.parseInt(endToken);
        Vector<Integer> rangePages = new Vector<Integer>();
        for (int i = startPage; i <= endPage; ++i) {
            rangePages.add(new Integer(i));
        }
        return rangePages;
    }

    protected void printActionPerformed(ActionEvent evt) {
        this.provider.theProvider.printActionPerformed(evt);
    }

    private void showPrinterAndPageSetupDialog() {
        AtDebug.debug("showPrinterAndPageSetupDialog()..create one and show");
    }

    protected void print(PrintService[] services, Pageable pages) {
        Window window = AtComponentUtil.getWindowForComponent(this.view);
        AtPrinterSelectionFrame pFrame = null;
        String jobName = this.getJobName();
        int copies = 1;
        if (this.printerClass != null) {
            jobName = this.printerClass.getJobName();
            copies = this.printerClass.getCopies();
        }
        pFrame = window instanceof Dialog ? new AtPrinterSelectionFrame((Dialog)window, AtCommonResource.MESSAGE_RESOURCE.getText("DISCOVERED_PRINTERS"), jobName, copies) : (window instanceof Frame ? new AtPrinterSelectionFrame((Frame)window, AtCommonResource.MESSAGE_RESOURCE.getText("DISCOVERED_PRINTERS"), jobName, copies) : new AtPrinterSelectionFrame((Dialog)null, AtCommonResource.MESSAGE_RESOURCE.getText("DISCOVERED_PRINTERS"), jobName, copies));
        AtDebug.debug("showing print service");
        PrintService defaultPrintService = null;
        if (this.printerClass != null) {
            defaultPrintService = this.printerClass.getPrintService();
        }
        if (defaultPrintService == null) {
            defaultPrintService = PrintServiceLookup.lookupDefaultPrintService();
        }
        AtComponentUtil.centerOnContainer(window, pFrame);
        boolean ok = pFrame.showPrintServicesDialog(services, defaultPrintService);
        if (!ok) {
            pFrame.dispose();
            return;
        }
        PrinterJob printer = PrinterJob.getPrinterJob();
        try {
            printer.setPageable(pages);
            printer.setCopies(pFrame.getCopies());
            printer.setJobName(pFrame.getJobName());
            printer.setPrintService(pFrame.getSelectedService());
            if (this.printerClass != null) {
                this.printerClass.setCopies(pFrame.getCopies());
                this.printerClass.setJobName(pFrame.getJobName());
            }
        }
        catch (Throwable ex) {
            String msg = ex.getMessage();
            JOptionPane.showMessageDialog(this.view, "\"" + msg + "\"", AtCommonResource.MESSAGE_RESOURCE.getText("Error"), 0);
            return;
        }
        try {
            AtDebug.debug("Printing...pages in book: " + pages.getNumberOfPages());
            printer.print();
        }
        catch (Throwable e1) {
            String msg = e1.getMessage();
            JOptionPane.showMessageDialog(this.view, "\"" + msg + "\"", AtCommonResource.MESSAGE_RESOURCE.getText("Error"), 0);
            return;
        }
    }

    public void setViewerControlVisible(String buttonName, boolean visible) {
        JComponent button = (JComponent)this.buttons.get(buttonName);
        if (button != null) {
            button.setVisible(visible);
            this.previewActionComponent.revalidate();
        }
    }

    public void setViewerControlEnabled(String buttonName, boolean enable) {
        JComponent button = (JComponent)this.buttons.get(buttonName);
        if (button != null) {
            button.setEnabled(enable);
            this.previewActionComponent.revalidate();
        }
    }

    public void setViewerControlTooltipText(String buttonName, String tooltipText) {
        JComponent button = (JComponent)this.buttons.get(buttonName);
        if (button != null) {
            button.setToolTipText(tooltipText);
        }
    }

    public void setPreviewButtonImage(String buttonName, ImageIcon buttonImage) {
        JComponent button = (JComponent)this.buttons.get(buttonName);
        this.setButtonImage(button, buttonImage);
    }

    protected void setButtonImage(JComponent button, ImageIcon buttonImage) {
        if (button != null && button instanceof AtImageCellWidget) {
            AtImageCellWidget b = (AtImageCellWidget)button;
            b.setIcon(buttonImage);
        } else if (button instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)button;
            b.setIcon(buttonImage);
        }
        button.repaint();
    }

    public void setThumbnailsVisible(boolean visible) {
        if (visible) {
            this.splitPane.setLeftComponent(this.thumbnailsScroller);
            this.splitPane.setDividerLocation(this.splitLocation);
            this.thumbnailsVisible = true;
        } else {
            this.splitPane.setLeftComponent(null);
            this.splitPane.setDividerLocation(0);
            this.thumbnailsVisible = false;
        }
        this.splitPane.updateUI();
        this.splitPane.setDividerSize(3);
    }

    public ThumbnailData[] getThumbnails() {
        return this.thumbnailsView.getThumbnailData();
    }

    public void printCurrentPage(boolean showPrinterAndPageSelectionDialog) {
        this.printPageIndex(showPrinterAndPageSelectionDialog, this.getDisplayedPageIndex(), 1);
    }

    public void printPageIndex(boolean showPrinterAndPageSelectionDialog, int pageIndex, int copies) {
        if (showPrinterAndPageSelectionDialog) {
            AbstractReportPage[] pages = new AbstractReportPage[]{this.getDisplayedPage()};
            this.printPages(pages, false, copies);
        } else {
            this.printPageIndex(pageIndex, copies);
        }
    }

    public void printPages(AbstractReportPage[] allPages, boolean showPrinterAndPageSelectionDialog, int copies) {
        String msg;
        PrinterJob printer = PrinterJob.getPrinterJob();
        if (!printer.printDialog()) {
            return;
        }
        Book book = new Book();
        for (int i = 0; allPages != null && i < allPages.length; ++i) {
            AbstractReportPage page = allPages[i];
            PageFormat pageFormat = page.getPageFormat();
            book.append(page, pageFormat, copies);
        }
        try {
            printer.setPageable(book);
        }
        catch (Throwable ex) {
            msg = ex.getMessage();
            JOptionPane.showMessageDialog(this.view, "\"" + msg + "\"", AtCommonResource.MESSAGE_RESOURCE.getText("Error"), 0);
            return;
        }
        try {
            printer.setJobName(this.getJobName());
            printer.print();
        }
        catch (Throwable e1) {
            msg = e1.getMessage();
            JOptionPane.showMessageDialog(this.view, "\"" + msg + "\"", AtCommonResource.MESSAGE_RESOURCE.getText("Error"), 0);
            return;
        }
    }

    public void printCurrentPage() {
        this.printCurrentPage(1);
    }

    public void printCurrentPage(int copies) {
        this.printPageIndex(this.getDisplayedPageIndex(), copies);
    }

    public void printPageIndex(int pageIndex, int copies) {
        PrintService defaultPrinter = PrintServiceLookup.lookupDefaultPrintService();
        this.printPageIndex(defaultPrinter, pageIndex, copies);
    }

    public void printPageIndex(PrintService printerService, int pageIndex, int copies) {
        PrinterJob pj = PrinterJob.getPrinterJob();
        try {
            Book book = new Book();
            AbstractReportPage page = this.getPageAt(pageIndex);
            PageFormat pageFormat = page.getPageFormat();
            book.append(page, pageFormat, copies);
            pj.setPrintService(printerService);
            pj.setPageable(book);
            pj.setJobName(this.getJobName());
            pj.print();
            AtDebug.debug("printPageIndex() printed to: " + printerService.getName());
        }
        catch (Throwable t) {
            AtDebug.debug(9, t);
        }
    }

    public void printPages(AbstractReportPage[] pages) {
        this.printPages(pages, 1);
    }

    public void printPages(AbstractReportPage[] pages, int copies) {
        PrintService defaultPrinter = PrintServiceLookup.lookupDefaultPrintService();
        this.printPages(pages, defaultPrinter, copies);
    }

    public void printPages(AbstractReportPage[] pages, PrintService printerService, int copies) {
        PrinterJob pj = PrinterJob.getPrinterJob();
        try {
            Book book = new Book();
            for (int i = 0; pages != null && i < pages.length; ++i) {
                AbstractReportPage page = pages[i];
                PageFormat pageFormat = page.getPageFormat();
                book.append(page, pageFormat, copies);
            }
            pj.setPrintService(printerService);
            pj.setJobName(this.getJobName());
            pj.setPageable(book);
            pj.print();
            AtDebug.debug("pages printed to: " + printerService.getName());
        }
        catch (Throwable t) {
            AtDebug.debug(9, t);
        }
    }

    public void pdfDisplayedPage() {
        AbstractReportPage[] pages = new AbstractReportPage[]{this.getDisplayedPage()};
        this.pdfPages(pages);
    }

    public void pdfPage(int pageIndex) {
        AbstractReportPage page = this.getPageAt(pageIndex);
        AbstractReportPage[] pages = new AbstractReportPage[]{page};
        this.pdfPages(pages);
    }

    public void pdfPages(AbstractReportPage[] pages) {
        Container window = AtComponentUtil.getWindowForComponent(this.view);
        if (window == null) {
            window = this.view;
        }
        String pdf = AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_PDF");
        String pdf_files = AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_PDF_FILES");
        KeyValue kv = FileChooserUtil.getOutputStream(window, pdf, pdf_files, 2, this.dirToOpen);
        OutputStream outputStream = null;
        if (kv != null) {
            String path;
            outputStream = (OutputStream)kv.value;
            File f = (File)kv.key;
            this.lastOpenedDirectory = path = f.getPath();
        }
        if (outputStream == null) {
            return;
        }
        Book book = new Book();
        PageFormat pageFormat = null;
        for (int i = 0; i < pages.length; ++i) {
            AbstractReportPage page = pages[i];
            pageFormat = page.getPageFormat();
            book.append(page, pageFormat);
        }
        try {
            this.pdfProperties.setAutoCorrectFontName(this.printerClass.isSubstituteFont());
            this.pdfProperties.setApplyPrepress(pages != null ? pages[0].isAntiAliased() : true);
            ConversionFactory.saveAsPdf(outputStream, book, this.pdfProperties);
        }
        catch (Throwable t) {
            AtDebug.debug(9, t);
        }
        AtDebug.debug("PDF document is produced for viewing.");
    }

    public String getJobName() {
        return "SmartJReport Report Pages";
    }

    protected JComponent createFlatButton(String caption, String tooltip, ImageIcon image, ActionListener l2) {
        AtImageCellWidget button = new AtImageCellWidget(image);
        button.setActionCommand(caption);
        if (tooltip != null) {
            button.setToolTipText(tooltip);
        }
        button.setFocusEnabled(true);
        button.setFont(this.getFont());
        button.addActionListener(l2);
        return button;
    }

    class ThumbnailsView
    extends JPanel {
        protected ReportPreviewPane viewPane;
        protected final Vector thumbnails = new Vector();

        public ThumbnailsView(ReportPreviewPane vp) {
            this.viewPane = vp;
            this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ ThumbnailsView this$1;
                {
                    this.this$1 = this$1;
                }

                public void mouseClicked(MouseEvent e) {
                    this.this$1.viewPane.setCursor(Cursor.getPredefinedCursor(3));
                    this.this$1.handleMouseClick(e);
                    this.this$1.viewPane.setCursor(Cursor.getPredefinedCursor(0));
                }
            });
            this.setLayout(new BorderLayout(0, 0));
        }

        void refreshUI() {
            this.removeAll();
            this.createThumbnails();
            this.createView();
            this.revalidate();
            int dispPageIdx = this.viewPane.getDisplayedPageIndex();
            this.setThumbnailSelectionIndex(dispPageIdx);
        }

        ThumbnailData[] getThumbnailData() {
            ThumbnailData[] data = new ThumbnailData[this.thumbnails.size()];
            for (int i = 0; i < this.thumbnails.size(); ++i) {
                data[i] = (ThumbnailData)this.thumbnails.get(i);
            }
            return data;
        }

        private void createThumbnails() {
            for (int i = 0; i < this.thumbnails.size(); ++i) {
                ThumbnailView aThumbnaialView = (ThumbnailView)this.thumbnails.get(i);
                aThumbnaialView.clean();
            }
            this.thumbnails.clear();
            try {
                AbstractReportPage[] pages = this.viewPane.getPages();
                for (int i = 0; pages != null && i < pages.length; ++i) {
                    AbstractReportPage aPage = pages[i];
                    aPage.setRenderingReason("PageRenderingReasonThumbnailLoading");
                    ThumbnailData data = new ThumbnailData(aPage, i);
                    int displayedPageIndex = this.viewPane.getDisplayedPageIndex();
                    if (i == displayedPageIndex) {
                        data.selected = true;
                    }
                    ThumbnailView thumbnailView = new ThumbnailView(data, this.viewPane);
                    this.thumbnails.add(thumbnailView);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        void createView() {
            JPanel all = new JPanel(new GridBagLayout());
            ThumbnailGroupPane aRowGroup = new ThumbnailGroupPane(new GridBagLayout());
            int rowCount = 0;
            int rowGroup = 0;
            for (int i = 0; this.thumbnails != null && i < this.thumbnails.size(); ++i) {
                Component aThumbnailView = (Component)this.thumbnails.get(i);
                aRowGroup.add(aThumbnailView, new GridBagConstraints(0, ++rowCount - 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
                if (rowCount < 512) continue;
                all.add((Component)aRowGroup, new GridBagConstraints(0, rowGroup, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
                ++rowGroup;
                aRowGroup = new ThumbnailGroupPane(new GridBagLayout());
                rowCount = 0;
            }
            if (rowCount > 0 && rowCount < 512) {
                all.add((Component)aRowGroup, new GridBagConstraints(0, rowGroup, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            }
            this.add((Component)all, "North");
        }

        public void setThumbnailSelectionIndex(int selectedThumbnailIdx) {
            if (selectedThumbnailIdx >= 0 && selectedThumbnailIdx < this.thumbnails.size()) {
                this.unselectAll();
                ThumbnailView selectedThumbnail = (ThumbnailView)this.thumbnails.get(selectedThumbnailIdx);
                selectedThumbnail.getData().selected = true;
                Rectangle thumbnailBbox = this.getThumbnailBounds(selectedThumbnailIdx);
                JScrollPane thumbnailsScroller = this.viewPane.getThumbnailsScroller();
                Rectangle visRect = thumbnailsScroller.getViewport().getViewRect();
                if (!visRect.contains(thumbnailBbox)) {
                    Point viewPos = null;
                    viewPos = thumbnailBbox.y < visRect.y ? new Point(thumbnailBbox.x, thumbnailBbox.y) : (thumbnailBbox.y + thumbnailBbox.height > visRect.y + visRect.height ? new Point(thumbnailBbox.x, thumbnailBbox.y + thumbnailBbox.height - visRect.height) : new Point(thumbnailBbox.x, thumbnailBbox.y));
                    thumbnailsScroller.getViewport().setViewPosition(viewPos);
                }
            }
            this.revalidate();
            this.repaint();
        }

        void handleMouseClick(MouseEvent evt) {
            if (this.thumbnails == null) {
                return;
            }
            Point p = evt.getPoint();
            int selectedThumbnailIdx = -1;
            ThumbnailView selectedThumbnail = null;
            for (int i = 0; this.thumbnails != null && i < this.thumbnails.size(); ++i) {
                ThumbnailView aThumbnailView = (ThumbnailView)this.thumbnails.get(i);
                Rectangle bbox = this.getThumbnailBounds(i);
                if (!bbox.contains(p)) continue;
                selectedThumbnailIdx = i;
                selectedThumbnail = aThumbnailView;
                break;
            }
            if (selectedThumbnail != null) {
                try {
                    ActionEvent ae = new ActionEvent(selectedThumbnail.getData(), 1001, ReportPreviewPane.THUMBNAIL_SELECTION_CMD);
                    this.viewPane.notifyReportActionListeners(ae);
                }
                catch (AtUserActionVetoException ex) {
                    AtDebug.debug(9, "User action is vetowed by: " + ex.getClass().getName());
                    return;
                }
            }
            if (selectedThumbnailIdx >= 0) {
                this.unselectAll();
                AtDebug.debug("selecting " + selectedThumbnailIdx);
                ThumbnailView selectedView = (ThumbnailView)this.thumbnails.get(selectedThumbnailIdx);
                selectedView.getData().selected = true;
                this.viewPane.showPageIndex(selectedThumbnailIdx);
            }
            this.revalidate();
            this.repaint();
        }

        public void unselectAll() {
            for (int i = 0; this.thumbnails != null && i < this.thumbnails.size(); ++i) {
                ThumbnailView aThumbnailView = (ThumbnailView)this.thumbnails.get(i);
                aThumbnailView.getData().selected = false;
            }
        }

        public Rectangle getThumbnailBounds(int thumbnailIndex) {
            ThumbnailView aThumbnailView = (ThumbnailView)this.thumbnails.get(thumbnailIndex);
            Container parent = aThumbnailView.getParent();
            if (parent instanceof ThumbnailGroupPane) {
                Rectangle parentBbox = parent.getBounds();
                Rectangle selfBbox = aThumbnailView.getBounds();
                selfBbox.x = parentBbox.x + selfBbox.x;
                selfBbox.y = parentBbox.y + selfBbox.y;
                return selfBbox;
            }
            return aThumbnailView.getBounds();
        }

        private class ThumbnailGroupPane
        extends JPanel {
            public ThumbnailGroupPane(LayoutManager l2) {
                super(l2);
            }
        }
    }

    private class HelpDialog
    extends JFrame
    implements Serializable {
        private String helpText;

        public HelpDialog(Dialog dialog, String title) {
            super(title);
            this.setSize(550, 600);
            this.initHelpText();
            this.init();
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ HelpDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void windowClosing(WindowEvent evt) {
                    this.this$1.setVisible(false);
                    this.this$1.dispose();
                }
            });
        }

        public HelpDialog(Frame frame, String title) {
            super(title);
            this.setSize(550, 600);
            this.initHelpText();
            this.init();
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ HelpDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void windowClosing(WindowEvent evt) {
                    this.this$1.setVisible(false);
                    this.this$1.dispose();
                }
            });
            if (frame != null) {
                this.setIconImage(frame.getIconImage());
            }
        }

        private void init() {
            AtInsetsPanel cp = new AtInsetsPanel(new BorderLayout());
            cp.setBackground(SystemColor.white);
            cp.setInsets(new Insets(1, 1, 1, 1));
            cp.setLayout(new BorderLayout(0, 0));
            JEditorPane htmlPane = new JEditorPane("text/html", this.helpText);
            htmlPane.setEditable(false);
            htmlPane.setCaretPosition(0);
            JScrollPane htmlScroller = new JScrollPane(htmlPane);
            cp.add((Component)htmlScroller, "Center");
            Container top = this.getContentPane();
            top.setLayout(new BorderLayout(0, 0));
            top.add((Component)cp, "Center");
        }

        private void initHelpText() {
            this.helpText = AtCommonResource.MESSAGE_RESOURCE.getText("PREVIEW_HELP_HEADER");
            this.helpText = this.helpText + AtCommonResource.MESSAGE_RESOURCE.getText("THUMBNAILS_HELP");
            this.helpText = this.helpText + AtCommonResource.MESSAGE_RESOURCE.getText("BROWSE_HELP");
            this.helpText = this.helpText + AtCommonResource.MESSAGE_RESOURCE.getText("GOTO_PAGE_HELP");
            this.helpText = this.helpText + AtCommonResource.MESSAGE_RESOURCE.getText("PRINT_HELP");
            this.helpText = this.helpText + AtCommonResource.MESSAGE_RESOURCE.getText("PDF_HELP");
            this.helpText = this.helpText + AtCommonResource.MESSAGE_RESOURCE.getText("ZOOM_HELP");
            this.helpText = this.helpText + AtCommonResource.MESSAGE_RESOURCE.getText("PREVIEW_HELP_TAILER");
        }
    }

    private class AtPageView
    extends JPanel {
        public static final int MARGIN = 20;
        protected AbstractReportPage page;
        protected BufferedImage image;
        protected Dimension size = new Dimension();
        protected double scale = 1.0;

        public AtPageView(AbstractReportPage page) {
            this.page = page;
            this.resetViewSize(page);
        }

        public Dimension getPreferredSize() {
            return this.size;
        }

        public AbstractReportPage getPage() {
            return this.page;
        }

        public void setPage(AbstractReportPage page) {
            this.page = page;
            this.resetViewSize(page);
            this.image = this.createPageImage(page);
            this.repaint();
        }

        public void resetViewSize(AbstractReportPage page) {
            if (page != null) {
                this.size.width = page.getSize().width + 20;
                this.size.height = page.getSize().height + 20;
                this.setSize(this.size);
                this.setPreferredSize(this.size);
            }
        }

        private BufferedImage createPageImage(AbstractReportPage page) {
            RepaintManager repaintmanager;
            if (page == null) {
                return null;
            }
            Dimension size = page.getSize();
            BufferedImage pageImage = new BufferedImage(size.width, size.height, 2);
            Graphics g = pageImage.getGraphics();
            Color orgColor = g.getColor();
            g.setColor(SystemColor.white);
            g.fillRect(0, 0, pageImage.getWidth(), pageImage.getHeight());
            g.setColor(orgColor);
            try {
                repaintmanager = RepaintManager.currentManager(null);
                repaintmanager.setDoubleBufferingEnabled(false);
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                page.draw(g);
            }
            catch (Throwable t) {
                AtDebug.debug(9, t);
            }
            try {
                repaintmanager = RepaintManager.currentManager(null);
                repaintmanager.setDoubleBufferingEnabled(false);
            }
            catch (Throwable t) {
                // empty catch block
            }
            return pageImage;
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.image == null) {
                return;
            }
            Graphics2D g = (Graphics2D)graphics;
            Dimension d = this.getSize();
            Color oldColor = g.getColor();
            g.setColor(SystemColor.white);
            g.fillRect(0, 0, d.width, d.height);
            double x = d.width / 2 - this.page.getSize().width / 2;
            double y = d.height / 2 - this.page.getSize().height / 2;
            Rectangle pageArea = new Rectangle((int)x, (int)y, this.page.getSize().width, this.page.getSize().height);
            g.setColor(SystemColor.controlShadow.darker());
            g.fillRect(pageArea.x + 5, pageArea.y + 5, pageArea.width, pageArea.height);
            g.setColor(SystemColor.white);
            g.fillRect(pageArea.x, pageArea.y, pageArea.width, pageArea.height);
            g.setColor(SystemColor.darkGray);
            g.drawRect(pageArea.x, pageArea.y, pageArea.width, pageArea.height);
            g.drawImage((Image)this.image, (int)x, (int)y, this);
            g.drawRect(pageArea.x, pageArea.y, pageArea.width, pageArea.height);
            g.setColor(oldColor);
        }
    }

    protected class AtPreviewActionComponent
    extends AtInsetsPanel {
        private Vector listeners = new Vector();

        public AtPreviewActionComponent(int pageCount) {
            ActionListener l2 = new ActionListener(this){
                private final /* synthetic */ AtPreviewActionComponent this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.notifyClients(e);
                }
            };
            Dimension size = new Dimension(22, 22);
            this.setInsets(new Insets(0, 3, 0, 3));
            ReportPreviewPane.this.thumbnails = ReportPreviewPane.this.createFlatButton(THUMBNAILS_CMD, AtCommonResource.MESSAGE_RESOURCE.getText("THUMBNAILS_BUTTON_TOOLTIP"), AtImageList.IMAGE_LIST.THUMBNAILS, l2);
            ReportPreviewPane.this.watermarkButton = ReportPreviewPane.this.createFlatButton(ReportPreviewPane.WATERMARK_CMD, AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_ADD_TEXT_WATERMARK"), AtImageList.IMAGE_LIST.WATERMARK, l2);
            ReportPreviewPane.this.pageSetupButton = ReportPreviewPane.this.createFlatButton(PAGE_SETUP_CMD, AtCommonResource.MESSAGE_RESOURCE.getTooltip("PageSetup"), AtImageList.IMAGE_LIST.NEW_16, l2);
            ReportPreviewPane.this.next = ReportPreviewPane.this.createFlatButton(NEXT_CMD, AtCommonResource.MESSAGE_RESOURCE.getText("PREVIEW_NEXT_BUTTON_TOOLTIP"), AtImageList.IMAGE_LIST.NEXT, l2);
            ReportPreviewPane.this.previous = ReportPreviewPane.this.createFlatButton(PREVIOUS_CMD, AtCommonResource.MESSAGE_RESOURCE.getText("PREVIEW_PREVIOUS_BUTTON_TOOLTIP"), AtImageList.IMAGE_LIST.PREVIOUS, l2);
            ReportPreviewPane.this.zoomin = ReportPreviewPane.this.createFlatButton(ZOOMIN_CMD, AtCommonResource.MESSAGE_RESOURCE.getText("ZOOM_IN_TOOLTIP"), AtImageList.IMAGE_LIST.ZOOMIN, l2);
            ReportPreviewPane.this.zoomout = ReportPreviewPane.this.createFlatButton(ZOOMOUT_CMD, AtCommonResource.MESSAGE_RESOURCE.getText("ZOOM_OUT_TOOLTIP"), AtImageList.IMAGE_LIST.ZOOMOUT, l2);
            ReportPreviewPane.this.go = ReportPreviewPane.this.createFlatButton(GO_CMD, AtCommonResource.MESSAGE_RESOURCE.getText("PREVIEW_GO_BUTTON_TOOLTIP"), AtImageList.IMAGE_LIST.GO, l2);
            ReportPreviewPane.this.fullScreen = ReportPreviewPane.this.createFlatButton(HUNDREAD_PERCENT_CMD, AtCommonResource.MESSAGE_RESOURCE.getTooltip("HUNDREAD_PERCENT"), AtImageList.IMAGE_LIST.HUNDREAD_PERCENT, l2);
            ReportPreviewPane.this.print = ReportPreviewPane.this.createFlatButton(PRINT_CMD, AtCommonResource.MESSAGE_RESOURCE.getText("PREVIEW_PRINT_BUTTON_TOOLTIP"), AtImageList.IMAGE_LIST.PRINT, l2);
            ReportPreviewPane.this.pdf = ReportPreviewPane.this.createFlatButton(PDF_CMD, AtCommonResource.MESSAGE_RESOURCE.getText("SAVE_AS_PDF_CMD"), AtImageList.IMAGE_LIST.PDF, l2);
            ReportPreviewPane.this.png = ReportPreviewPane.this.createFlatButton(PNG_CMD, AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_SAVE_PAGE_AS_PNG"), AtImageList.IMAGE_LIST.PNG, l2);
            ReportPreviewPane.this.jpeg = ReportPreviewPane.this.createFlatButton(JPEG_CMD, AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_SAVE_PAGE_AS_JPEG"), AtImageList.IMAGE_LIST.JPEG, l2);
            ReportPreviewPane.this.help = ReportPreviewPane.this.createFlatButton(HELP_CMD, AtCommonResource.MESSAGE_RESOURCE.getText("HELP_TOOLTIP"), AtImageList.IMAGE_LIST.HELP, l2);
            ReportPreviewPane.this.close = ReportPreviewPane.this.createFlatButton(CLOSE_CMD, AtCommonResource.MESSAGE_RESOURCE.getTooltip("CLOSE"), AtImageList.IMAGE_LIST.CLOSE_X, l2);
            ReportPreviewPane.this.percentCombo = new JComboBox<KeyValueObject>(ReportPreviewPane.this.percentValues);
            ReportPreviewPane.this.percentCombo.setPreferredSize(new Dimension(70, 16));
            ReportPreviewPane.this.percentComboListener = new PercentComboActionListener();
            ReportPreviewPane.this.percentCombo.addActionListener(ReportPreviewPane.this.percentComboListener);
            ReportPreviewPane.this.buttons.put(PAGE_SETUP_CMD, ReportPreviewPane.this.pageSetupButton);
            ReportPreviewPane.this.buttons.put(NEXT_CMD, ReportPreviewPane.this.next);
            ReportPreviewPane.this.buttons.put(PREVIOUS_CMD, ReportPreviewPane.this.previous);
            ReportPreviewPane.this.buttons.put(ZOOMIN_CMD, ReportPreviewPane.this.zoomin);
            ReportPreviewPane.this.buttons.put(ZOOMOUT_CMD, ReportPreviewPane.this.zoomout);
            ReportPreviewPane.this.buttons.put(GO_CMD, ReportPreviewPane.this.go);
            ReportPreviewPane.this.buttons.put(HUNDREAD_PERCENT_CMD, ReportPreviewPane.this.fullScreen);
            ReportPreviewPane.this.buttons.put(PRINT_CMD, ReportPreviewPane.this.print);
            ReportPreviewPane.this.buttons.put(PDF_CMD, ReportPreviewPane.this.pdf);
            ReportPreviewPane.this.buttons.put(PNG_CMD, ReportPreviewPane.this.png);
            ReportPreviewPane.this.buttons.put(JPEG_CMD, ReportPreviewPane.this.jpeg);
            ReportPreviewPane.this.buttons.put(HELP_CMD, ReportPreviewPane.this.help);
            ReportPreviewPane.this.buttons.put(CLOSE_CMD, ReportPreviewPane.this.close);
            ReportPreviewPane.this.buttons.put(THUMBNAILS_CMD, ReportPreviewPane.this.thumbnails);
            ReportPreviewPane.this.buttons.put(ReportPreviewPane.WATERMARK_CMD, ReportPreviewPane.this.watermarkButton);
            ReportPreviewPane.this.pageNo = new JLabel(AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_ONE"), 10);
            ReportPreviewPane.this.totalPages = new JLabel(String.valueOf(pageCount), 10);
            ReportPreviewPane.this.pageField = new JTextField(3);
            ReportPreviewPane.this.pageField.setDocument(new AtIntegerTypeDocument());
            ReportPreviewPane.this.pageField.setPreferredSize(size);
            ReportPreviewPane.this.pageField.addActionListener(new ActionListener(this){
                private final /* synthetic */ AtPreviewActionComponent this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent evt) {
                    AtPreviewActionComponent.access$1200(this.this$1).goActionPerformed(evt);
                }
            });
            ReportPreviewPane.this.printField = new JTextField(6);
            ReportPreviewPane.this.printField.setText(AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_ONE_DASH") + pageCount);
            ReportPreviewPane.this.thumbnailsBar = new JToolBar(AtCommonResource.MESSAGE_RESOURCE.getText("THUMBNAILS_CMD"));
            ReportPreviewPane.this.thumbnailsBar.setFloatable(false);
            ReportPreviewPane.this.thumbnailsBar.add(ReportPreviewPane.this.thumbnails);
            ReportPreviewPane.this.thumbnailsBar.add(ReportPreviewPane.this.watermarkButton);
            ReportPreviewPane.this.browseBar = new JToolBar(AtCommonResource.MESSAGE_RESOURCE.getText("Browse"));
            ReportPreviewPane.this.browseBar.setFloatable(false);
            ReportPreviewPane.this.browseBar.add(ReportPreviewPane.this.pageSetupButton);
            ReportPreviewPane.this.browseBar.add(ReportPreviewPane.this.previous);
            ReportPreviewPane.this.browseBar.add(ReportPreviewPane.this.next);
            ReportPreviewPane.this.pageBar = new JToolBar(AtCommonResource.MESSAGE_RESOURCE.getText("Page"));
            ReportPreviewPane.this.pageBar.setFloatable(false);
            ReportPreviewPane.this.pageBar.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 1, SystemColor.control.darker()));
            ReportPreviewPane.this.pageBar.add(ReportPreviewPane.this.pageField);
            ReportPreviewPane.this.pageBar.add(ReportPreviewPane.this.go);
            ReportPreviewPane.this.printBar = new JToolBar(AtCommonResource.MESSAGE_RESOURCE.getText("Print"));
            ReportPreviewPane.this.printBar.setFloatable(false);
            ReportPreviewPane.this.printBar.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 1, SystemColor.control.darker()));
            ReportPreviewPane.this.printBar.add(ReportPreviewPane.this.printField);
            ReportPreviewPane.this.printBar.add(ReportPreviewPane.this.print);
            ReportPreviewPane.this.printBar.add(ReportPreviewPane.this.pdf);
            ReportPreviewPane.this.printBar.add(ReportPreviewPane.this.png);
            ReportPreviewPane.this.printBar.add(ReportPreviewPane.this.jpeg);
            ReportPreviewPane.this.zoomBar = new JToolBar(AtCommonResource.MESSAGE_RESOURCE.getText("Zoom"));
            ReportPreviewPane.this.zoomBar.setFloatable(false);
            ReportPreviewPane.this.zoomBar.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, SystemColor.control.darker()));
            ReportPreviewPane.this.zoomBar.add(ReportPreviewPane.this.zoomout);
            ReportPreviewPane.this.zoomBar.add(ReportPreviewPane.this.zoomin);
            ReportPreviewPane.this.zoomBar.add(ReportPreviewPane.this.percentCombo);
            ReportPreviewPane.this.zoomBar.add(ReportPreviewPane.this.fullScreen);
            this.setLayout(new FlowLayout(3, 2, 0));
            ReportPreviewPane.this.toolbarPane = new AtInsetsPanel(new FlowLayout(3, 0, 0));
            ReportPreviewPane.this.toolbarPane.setInsets(new Insets(5, 3, 0, 3));
            ReportPreviewPane.this.toolbarPane.add(ReportPreviewPane.this.browseBar);
            ReportPreviewPane.this.toolbarPane.add(ReportPreviewPane.this.pageBar);
            ReportPreviewPane.this.toolbarPane.add(ReportPreviewPane.this.printBar);
            ReportPreviewPane.this.toolbarPane.add(ReportPreviewPane.this.zoomBar);
            ReportPreviewPane.this.toolbarPane.add(ReportPreviewPane.this.help);
            this.add(ReportPreviewPane.this.toolbarPane);
            ReportPreviewPane.this.pageNumberPane = new AtInsetsPanel(new FlowLayout(3, 3, 0));
            ReportPreviewPane.this.pageNumberPane.setInsets(new Insets(3, 3, 0, 3));
            ReportPreviewPane.this.pageNumberPane.add(ReportPreviewPane.this.pageNo);
            ReportPreviewPane.this.pageNumberPane.add(new JLabel(" " + AtCommonResource.MESSAGE_RESOURCE.getText("PAGE_OF") + " ", 10));
            ReportPreviewPane.this.pageNumberPane.add(ReportPreviewPane.this.totalPages);
            this.add(ReportPreviewPane.this.pageNumberPane);
        }

        void resetPreviewControls(double zoomPercent, boolean resetPages) {
            AtDebug.debug("resetPreviewControls() zoom=" + zoomPercent);
            ReportPreviewPane.this.percentCombo.removeActionListener(ReportPreviewPane.this.percentComboListener);
            int selIdx = -1;
            try {
                selIdx = this.getSelectionIndex((int)zoomPercent);
                ReportPreviewPane.this.percentCombo.setSelectedIndex(selIdx);
            }
            catch (Throwable t) {
                AtDebug.debug(9, t);
            }
            ReportPreviewPane.this.percentCombo.addActionListener(ReportPreviewPane.this.percentComboListener);
            this.enableDisableZoomButtons(selIdx);
            if (resetPages && ReportPreviewPane.this.printerClass != null) {
                boolean isFitToPageWidth = false;
                if (ReportPreviewPane.this.printerClass != null) {
                    isFitToPageWidth = ReportPreviewPane.this.printerClass.isFitToPageWidth();
                    ReportPreviewPane.this.printerClass.setFitToPageWidth(false);
                }
                Pageable pageable = ReportPreviewPane.this.printerClass.getPageable(ReportPreviewPane.this.printerClass.getPrintObject(), ReportPreviewPane.this.printerClass.getPageNumberLocation());
                if (ReportPreviewPane.this.pages == null || pageable.getNumberOfPages() == 0 || ReportPreviewPane.this.printerClass.hasError()) {
                    String errMsg = ReportPreviewPane.this.printerClass.getErrorMessage();
                    throw new RuntimeException(errMsg);
                }
                if (ReportPreviewPane.this.printerClass != null) {
                    ReportPreviewPane.this.printerClass.setFitToPageWidth(isFitToPageWidth);
                }
                AbstractReportPage[] newPages = new AbstractReportPage[pageable.getNumberOfPages()];
                for (int i = 0; i < pageable.getNumberOfPages(); ++i) {
                    newPages[i] = (AbstractReportPage)pageable.getPrintable(i);
                    newPages[i].setWatermark(ReportPreviewPane.this.watermark);
                    newPages[i].setDrawWatermark(ReportPreviewPane.this.isWatermarkEnabled());
                }
                ReportPreviewPane.this.pages = newPages;
            }
            if (ReportPreviewPane.this.pages.length >= ReportPreviewPane.this.lastViewedPage + 1) {
                ReportPreviewPane.this.showPageIndex(ReportPreviewPane.this.lastViewedPage);
            } else {
                ReportPreviewPane.this.showFirst();
            }
            ReportPreviewPane.this.pageNo.setText(String.valueOf(ReportPreviewPane.this.currPageIndex + 1));
            ReportPreviewPane.this.totalPages.setText(String.valueOf(ReportPreviewPane.this.getPageCount()));
            ReportPreviewPane.this.printField.setText(AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_ONE_DASH") + ReportPreviewPane.this.getPageCount());
            if (ReportPreviewPane.this.thumbnailsView != null) {
                ReportPreviewPane.this.thumbnailsView.refreshUI();
                ReportPreviewPane.this.thumbnailsView.setThumbnailSelectionIndex(ReportPreviewPane.this.getDisplayedPageIndex());
            }
        }

        int getSelectionIndex(int zoomPercent) {
            int maxIndex = -1;
            if (ReportPreviewPane.this.percentValues != null) {
                maxIndex = ReportPreviewPane.this.percentValues.length - 1;
            }
            for (int i = 0; ReportPreviewPane.this.percentValues != null && i < ReportPreviewPane.this.percentValues.length; ++i) {
                KeyValueObject aValueObject = ReportPreviewPane.this.percentValues[i];
                double percent1 = aValueObject.getValue();
                double percent2 = -1.0;
                if (i + 1 <= ReportPreviewPane.this.percentValues.length - 1) {
                    KeyValueObject nextValueObject = ReportPreviewPane.this.percentValues[i + 1];
                    percent2 = nextValueObject.getValue();
                }
                if (percent2 > percent1 && (double)zoomPercent <= percent2 && (double)zoomPercent >= percent1) {
                    double middlePercent = percent1 + (percent2 - percent1) / 2.0;
                    if ((double)zoomPercent >= percent1 && (double)zoomPercent < middlePercent) {
                        if (i > maxIndex) {
                            return maxIndex;
                        }
                        return i;
                    }
                    if (i + 1 > maxIndex) {
                        return maxIndex;
                    }
                    return i + 1;
                }
                if (!(percent2 < percent1) || !((double)zoomPercent >= percent2) || !((double)zoomPercent <= percent1)) continue;
                double middlePercent = percent1 - (percent1 - percent2) / 2.0;
                if ((double)zoomPercent <= percent1 && (double)zoomPercent > middlePercent) {
                    if (i > maxIndex) {
                        return maxIndex;
                    }
                    return i;
                }
                if (i + 1 > maxIndex) {
                    return maxIndex;
                }
                return i + 1;
            }
            int retValue = ReportPreviewPane.this.percentValues.length - 1;
            if (retValue < 0) {
                retValue = 0;
            }
            return retValue;
        }

        private void enableDisableZoomButtons(int selIdx) {
            if (selIdx == ReportPreviewPane.this.percentValues.length - 1) {
                ReportPreviewPane.this.zoomin.setEnabled(true);
                ReportPreviewPane.this.zoomout.setEnabled(false);
            } else if (selIdx == 0) {
                ReportPreviewPane.this.zoomin.setEnabled(false);
                ReportPreviewPane.this.zoomout.setEnabled(true);
            } else {
                ReportPreviewPane.this.zoomin.setEnabled(true);
                ReportPreviewPane.this.zoomout.setEnabled(true);
            }
        }

        void addPreviewActionListener(ActionListener l2) {
            if (!this.listeners.contains(l2)) {
                this.listeners.add(l2);
            }
        }

        void removePreviewActionListener(ActionListener l2) {
            this.listeners.remove(l2);
        }

        protected void notifyClients(ActionEvent evt) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ActionListener)this.listeners.get(i)).actionPerformed(evt);
            }
        }

        void setCurrentPageLabel(int pageIndex) {
            ReportPreviewPane.this.pageNo.setText(String.valueOf(pageIndex + 1));
        }

        void setTotalPageLabel(int pageCount) {
            ReportPreviewPane.this.totalPages.setText(String.valueOf(pageCount));
        }

        void setPrintFieldValue(String value) {
            ReportPreviewPane.this.printField.setText(value);
        }

        String getPrintFieldValue() {
            return ReportPreviewPane.this.printField.getText();
        }

        int getPageFieldValue() {
            return Integer.parseInt(ReportPreviewPane.this.pageField.getText());
        }

        void setPageFieldValue(int pageNumber) {
            ReportPreviewPane.this.pageField.setText(String.valueOf(pageNumber));
        }

        JComponent getNextButton() {
            return ReportPreviewPane.this.next;
        }

        JComponent getPreviousButton() {
            return ReportPreviewPane.this.previous;
        }

        JComponent getGoButton() {
            return ReportPreviewPane.this.go;
        }

        JTextField getPageField() {
            return ReportPreviewPane.this.pageField;
        }

        class PercentComboActionListener
        implements ActionListener {
            int lastSelIdx = -1;

            PercentComboActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                try {
                    ReportPreviewPane.this.notifyReportActionListeners(evt);
                }
                catch (AtUserActionVetoException ex) {
                    AtDebug.debug(9, "User action is vetowed by: " + ex.getClass().getName());
                    return;
                }
                Container window = AtComponentUtil.getWindowForComponent(ReportPreviewPane.this.view);
                if (window == null) {
                    window = ReportPreviewPane.this.view;
                }
                window.setCursor(Cursor.getPredefinedCursor(3));
                int currSelIdx = ((AtPreviewActionComponent)AtPreviewActionComponent.this).ReportPreviewPane.this.percentCombo.getSelectedIndex();
                ((AtPreviewActionComponent)AtPreviewActionComponent.this).ReportPreviewPane.this.lastViewedPage = ((AtPreviewActionComponent)AtPreviewActionComponent.this).ReportPreviewPane.this.currPageIndex;
                this.lastSelIdx = currSelIdx;
                KeyValueObject keyValue = ((AtPreviewActionComponent)AtPreviewActionComponent.this).ReportPreviewPane.this.percentValues[this.lastSelIdx];
                if (((AtPreviewActionComponent)AtPreviewActionComponent.this).ReportPreviewPane.this.printerClass != null) {
                    ((AtPreviewActionComponent)AtPreviewActionComponent.this).ReportPreviewPane.this.printerClass.setZoomPercent(keyValue.getValue());
                    AtPreviewActionComponent.this.resetPreviewControls(((AtPreviewActionComponent)AtPreviewActionComponent.this).ReportPreviewPane.this.printerClass.getZoomPercent(), true);
                }
                window.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    class Provider
    implements Serializable {
        TheProvider theProvider = new TheProvider();

        Provider() {
        }

        class TheProvider
        implements Serializable {
            private static final int PNG = 1;
            private static final int JPEG = 2;

            TheProvider() {
            }

            void savePagesAsPNG() {
                String title = AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_CREATE_PNG_OUTPUT");
                String png = AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_PNG_EXTENSION");
                String description = AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_PNG_FILES");
                Window window = AtComponentUtil.getWindowForComponent(ReportPreviewPane.this.view);
                ImageOutputSetupDialog dialog = null;
                dialog = window instanceof Dialog ? new ImageOutputSetupDialog((Dialog)window, title, png, description, true) : (window instanceof Frame ? new ImageOutputSetupDialog((Frame)window, title, png, description, true) : new ImageOutputSetupDialog((Dialog)null, title, png, description, false));
                dialog.pack();
                AtComponentUtil.centerOnContainer(window, dialog);
                dialog.setVisible(true);
                if (!dialog.isOkPressed()) {
                    dialog.dispose();
                    return;
                }
                String pngFileName = dialog.getFileName();
                double resizeFactor = dialog.getResizeFactor();
                boolean autoMatchToPaperSize = false;
                int mode = dialog.getOuputMode();
                if (mode == 100) {
                    try {
                        AbstractReportPage currPage = ReportPreviewPane.this.getDisplayedPage();
                        ConversionFactory.saveAsPNG((AbstractPage)currPage, pngFileName, resizeFactor, autoMatchToPaperSize);
                    }
                    catch (Throwable t) {
                        AtDebug.debug(9, t);
                    }
                } else if (mode == 101) {
                    Vector selectedPages = this.getSelectedPages();
                    Vector<AbstractReportPage> outputPages = new Vector<AbstractReportPage>();
                    for (int i = 0; i < selectedPages.size(); ++i) {
                        Integer pageNo = (Integer)selectedPages.get(i);
                        int pageInt = pageNo;
                        if (pageInt > ((Provider)Provider.this).ReportPreviewPane.this.pages.length || pageInt <= 0) continue;
                        AbstractReportPage page = ((Provider)Provider.this).ReportPreviewPane.this.pages[pageInt - 1];
                        outputPages.add(page);
                    }
                    String fileNamePrefix = this.getFileNamePrefix(pngFileName);
                    String outputDir = this.getOutputDir(pngFileName);
                    String ext = this.getFileExtension(pngFileName);
                    if (ext == null) {
                        ext = png;
                    }
                    this.saveAs(outputPages, outputDir, fileNamePrefix, ext, 1, resizeFactor, autoMatchToPaperSize);
                } else if (mode == 102) {
                    Vector<AbstractReportPage> outputPages = new Vector<AbstractReportPage>();
                    for (int i = 0; ((Provider)Provider.this).ReportPreviewPane.this.pages != null && i < ((Provider)Provider.this).ReportPreviewPane.this.pages.length; ++i) {
                        outputPages.add(((Provider)Provider.this).ReportPreviewPane.this.pages[i]);
                    }
                    String fileNamePrefix = this.getFileNamePrefix(pngFileName);
                    String outputDir = this.getOutputDir(pngFileName);
                    String ext = this.getFileExtension(pngFileName);
                    if (ext == null) {
                        ext = png;
                    }
                    this.saveAs(outputPages, outputDir, fileNamePrefix, ext, 1, resizeFactor, autoMatchToPaperSize);
                }
            }

            void savePagesAsJPEG() {
                String title = AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_CREATE_JPEG_OUTPUT");
                String jpeg = AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_JPEG_EXTENSION");
                String description = AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_JPEG_FILES");
                Container window = AtComponentUtil.getWindowForComponent(ReportPreviewPane.this.view);
                if (window == null) {
                    window = ReportPreviewPane.this.view;
                }
                ImageOutputSetupDialog dialog = null;
                dialog = window instanceof Dialog ? new ImageOutputSetupDialog((Dialog)window, title, jpeg, description, true) : (window instanceof Frame ? new ImageOutputSetupDialog((Frame)window, title, jpeg, description, true) : new ImageOutputSetupDialog((Dialog)null, title, jpeg, description, false));
                dialog.pack();
                AtComponentUtil.centerOnContainer(window, dialog);
                dialog.setVisible(true);
                if (!dialog.isOkPressed()) {
                    dialog.dispose();
                    return;
                }
                String jpgFileName = dialog.getFileName();
                double resizeFactor = dialog.getResizeFactor();
                boolean autoMatchToPaperSize = false;
                int mode = dialog.getOuputMode();
                if (mode == 100) {
                    try {
                        ConversionFactory.saveAsJPEG((AbstractPage)ReportPreviewPane.this.getDisplayedPage(), jpgFileName, 1.0f, resizeFactor, autoMatchToPaperSize);
                    }
                    catch (Throwable t) {
                        AtDebug.debug(9, t);
                    }
                } else if (mode == 101) {
                    Vector selectedPages = this.getSelectedPages();
                    Vector<AbstractReportPage> outputPages = new Vector<AbstractReportPage>();
                    for (int i = 0; i < selectedPages.size(); ++i) {
                        Integer pageNo = (Integer)selectedPages.get(i);
                        int pageInt = pageNo;
                        if (pageInt > ((Provider)Provider.this).ReportPreviewPane.this.pages.length || pageInt <= 0) continue;
                        AbstractReportPage page = ((Provider)Provider.this).ReportPreviewPane.this.pages[pageInt - 1];
                        outputPages.add(page);
                    }
                    String fileNamePrefix = this.getFileNamePrefix(jpgFileName);
                    String outputDir = this.getOutputDir(jpgFileName);
                    String ext = this.getFileExtension(jpgFileName);
                    if (ext == null) {
                        ext = jpeg;
                    }
                    this.saveAs(outputPages, outputDir, fileNamePrefix, ext, 2, resizeFactor, autoMatchToPaperSize);
                } else if (mode == 102) {
                    Vector<AbstractReportPage> outputPages = new Vector<AbstractReportPage>();
                    for (int i = 0; ((Provider)Provider.this).ReportPreviewPane.this.pages != null && i < ((Provider)Provider.this).ReportPreviewPane.this.pages.length; ++i) {
                        outputPages.add(((Provider)Provider.this).ReportPreviewPane.this.pages[i]);
                    }
                    String fileNamePrefix = this.getFileNamePrefix(jpgFileName);
                    String outputDir = this.getOutputDir(jpgFileName);
                    String ext = this.getFileExtension(jpgFileName);
                    if (ext == null) {
                        ext = jpeg;
                    }
                    this.saveAs(outputPages, outputDir, fileNamePrefix, ext, 2, resizeFactor, autoMatchToPaperSize);
                }
            }

            String getFileNamePrefix(String fileName) {
                try {
                    String fileSep = System.getProperty("file.separator");
                    int idx = fileName.lastIndexOf(46);
                    int fileSepIdx = fileName.lastIndexOf(fileSep);
                    String file = fileName.substring(fileSepIdx + 1, idx);
                    return file;
                }
                catch (Throwable throwable) {
                    return "smartjreport";
                }
            }

            String getFileExtension(String fileName) {
                try {
                    int idx = fileName.lastIndexOf(46);
                    String ext = fileName.substring(idx + 1);
                    return ext;
                }
                catch (Throwable throwable) {
                    return null;
                }
            }

            String getOutputDir(String fileName) {
                try {
                    String fileSep = System.getProperty("file.separator");
                    int fileSepIdx = fileName.lastIndexOf(fileSep);
                    String dir = fileName.substring(0, fileSepIdx);
                    return dir;
                }
                catch (Throwable throwable) {
                    return "";
                }
            }

            void saveAs(Vector outputPages, String outputDir, String fileNamePrefix, String ext, int outputType, double resizeFactor, boolean autoMatchToPaperSize) {
                AbstractReportPage[] allPages = new AbstractReportPage[outputPages.size()];
                for (int i = 0; outputPages != null && i < outputPages.size(); ++i) {
                    allPages[i] = (AbstractReportPage)outputPages.get(i);
                }
                String fileSep = System.getProperty("file.separator");
                try {
                    for (int i = 0; allPages != null && i < allPages.length; ++i) {
                        String fileName = outputDir + fileSep + fileNamePrefix + (i + 1) + "." + ext;
                        if (outputType == 2) {
                            ConversionFactory.saveAsJPEG((AbstractPage)allPages[i], fileName, 1.0f, resizeFactor, autoMatchToPaperSize);
                            continue;
                        }
                        if (outputType != 1) continue;
                        ConversionFactory.saveAsPNG((AbstractPage)allPages[i], fileName, resizeFactor, autoMatchToPaperSize);
                    }
                }
                catch (Throwable t) {
                    String msg = t.getMessage();
                    JOptionPane.showMessageDialog(ReportPreviewPane.this.view, "\"" + msg + "\"", AtCommonResource.MESSAGE_RESOURCE.getText("Error"), 0);
                    return;
                }
            }

            void saveAsPdfActionPerformed(ActionEvent evt, Component frame) {
                AtDebug.debug("Save As PDF file...");
                String pdf = AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_PDF");
                String pdf_files = AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_PDF_FILES");
                KeyValue kv = FileChooserUtil.getOutputStream(frame, pdf, pdf_files, 2, ((Provider)Provider.this).ReportPreviewPane.this.dirToOpen);
                OutputStream outputStream = null;
                if (kv != null) {
                    outputStream = (OutputStream)kv.value;
                    File f = (File)kv.key;
                    String path = f.getPath();
                    if (f.isDirectory()) {
                        ((Provider)Provider.this).ReportPreviewPane.this.lastOpenedDirectory = path;
                    } else {
                        int idx = path.lastIndexOf(File.separatorChar);
                        if (idx >= 0) {
                            ((Provider)Provider.this).ReportPreviewPane.this.lastOpenedDirectory = path.substring(0, idx);
                        }
                    }
                }
                if (outputStream == null) {
                    return;
                }
                Vector pagesToPrint = this.getSelectedPages();
                if (pagesToPrint == null) {
                    return;
                }
                if (pagesToPrint == null || pagesToPrint.size() < 1) {
                    JOptionPane.showMessageDialog(ReportPreviewPane.this.view, AtCommonResource.MESSAGE_RESOURCE.getText("RANGE_FORMAT_ERROR_MSG"), AtCommonResource.MESSAGE_RESOURCE.getText("Error"), 0);
                    return;
                }
                for (int i = 0; i < pagesToPrint.size(); ++i) {
                    AtDebug.debug("will print page: " + pagesToPrint.get(i));
                }
                Book book = new Book();
                PageFormat pageFormat = null;
                for (int i = 0; i < pagesToPrint.size(); ++i) {
                    Integer pageNo = (Integer)pagesToPrint.get(i);
                    int pageInt = pageNo;
                    if (pageInt > ((Provider)Provider.this).ReportPreviewPane.this.pages.length || pageInt <= 0) continue;
                    AbstractReportPage page = ((Provider)Provider.this).ReportPreviewPane.this.pages[pageInt - 1];
                    pageFormat = page.getPageFormat();
                    book.append(page, pageFormat);
                }
                try {
                    PdfProperties pdfProp = new PdfProperties();
                    pdfProp.setAutoCorrectFontName(((Provider)Provider.this).ReportPreviewPane.this.printerClass.isSubstituteFont());
                    pdfProp.setApplyPrepress(((Provider)Provider.this).ReportPreviewPane.this.printerClass.isAntialiased());
                    ConversionFactory.saveAsPdf(outputStream, book, pdfProp);
                }
                catch (Throwable t) {
                    AtDebug.debug(9, t);
                }
                AtDebug.debug("PDF document is produced for viewing.");
            }

            void goActionPerformed(ActionEvent evt) {
                int pageNo = ((Provider)Provider.this).ReportPreviewPane.this.previewActionComponent.getPageFieldValue() - 1;
                AtDebug.debug("page index to show: " + pageNo + ", pages.length=" + ((Provider)Provider.this).ReportPreviewPane.this.pages.length);
                if (pageNo >= ((Provider)Provider.this).ReportPreviewPane.this.pages.length) {
                    pageNo = ((Provider)Provider.this).ReportPreviewPane.this.pages.length - 1;
                    ((Provider)Provider.this).ReportPreviewPane.this.previewActionComponent.setPageFieldValue(pageNo);
                } else if (pageNo < 0) {
                    pageNo = 0;
                }
                ReportPreviewPane.this.showPageIndex(pageNo);
                ((Provider)Provider.this).ReportPreviewPane.this.thumbnailsView.setThumbnailSelectionIndex(ReportPreviewPane.this.getDisplayedPageIndex());
            }

            Vector getSelectedPages() {
                String value = ((Provider)Provider.this).ReportPreviewPane.this.previewActionComponent.getPrintFieldValue();
                if (ReportPreviewPane.this.hasIllegalChars(value)) {
                    JOptionPane.showMessageDialog(ReportPreviewPane.this.view, AtCommonResource.MESSAGE_RESOURCE.getText("STRING_HAS_ILLEGAL_CHARS"), AtCommonResource.MESSAGE_RESOURCE.getText("Error"), 0);
                    return null;
                }
                String pageString = ReportPreviewPane.this.getFilteredPageString();
                Vector<Integer> allPages = new Vector<Integer>();
                StringTokenizer tk = new StringTokenizer(pageString, ",");
                while (tk.hasMoreTokens()) {
                    String token = tk.nextToken();
                    if (ReportPreviewPane.this.isRangeToken(token)) {
                        Vector rangePages = ReportPreviewPane.this.getPagesFromRange(token);
                        allPages.addAll(rangePages);
                        continue;
                    }
                    int pageNo = Integer.parseInt(token);
                    allPages.add(new Integer(pageNo));
                }
                Vector<Integer> pagesToPrint = allPages;
                int minPageNo = 1;
                int maxPageNo = ((Provider)Provider.this).ReportPreviewPane.this.pages.length;
                Vector<Integer> filteredPages = new Vector<Integer>();
                for (int i = 0; i < pagesToPrint.size(); ++i) {
                    Integer aPageNo = (Integer)pagesToPrint.get(i);
                    if (aPageNo < minPageNo || aPageNo > maxPageNo) continue;
                    filteredPages.add(aPageNo);
                }
                return filteredPages;
            }

            void printActionPerformed(ActionEvent evt) {
                PrintService[] services;
                if (!ReportPreviewPane.this.validateRange()) {
                    return;
                }
                Vector pagesToPrint = this.getSelectedPages();
                if (pagesToPrint == null) {
                    return;
                }
                if (pagesToPrint == null || pagesToPrint.size() < 1) {
                    JOptionPane.showMessageDialog(ReportPreviewPane.this.view, AtCommonResource.MESSAGE_RESOURCE.getText("RANGE_FORMAT_ERROR_MSG"), AtCommonResource.MESSAGE_RESOURCE.getText("Error"), 0);
                    return;
                }
                for (int i = 0; i < pagesToPrint.size(); ++i) {
                    AtDebug.debug("will print page: " + pagesToPrint.get(i));
                }
                Book book = new Book();
                for (int i = 0; i < pagesToPrint.size(); ++i) {
                    Integer pageNo = (Integer)pagesToPrint.get(i);
                    int pageInt = pageNo;
                    if (pageInt > ((Provider)Provider.this).ReportPreviewPane.this.pages.length || pageInt <= 0) continue;
                    AbstractReportPage page = ((Provider)Provider.this).ReportPreviewPane.this.pages[pageInt - 1];
                    book.append(page, page.getPageFormat());
                }
                DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
                PrintRequestAttributeSet pAttrs = new HashPrintRequestAttributeSet();
                if (((Provider)Provider.this).ReportPreviewPane.this.printerClass != null) {
                    ((Provider)Provider.this).ReportPreviewPane.this.pdfProperties.setAutoCorrectFontName(((Provider)Provider.this).ReportPreviewPane.this.printerClass.isSubstituteFont());
                    ((Provider)Provider.this).ReportPreviewPane.this.pdfProperties.setApplyPrepress(((Provider)Provider.this).ReportPreviewPane.this.printerClass.isAntialiased());
                    pAttrs = ((Provider)Provider.this).ReportPreviewPane.this.printerClass.getPrintRequestAttributeSet();
                }
                if ((services = PrintServiceLookup.lookupPrintServices(flavor, pAttrs)) == null || services.length <= 0) {
                    JOptionPane.showMessageDialog(ReportPreviewPane.this.view, AtCommonResource.MESSAGE_RESOURCE.getText("NO_SERVICE_MSG"), AtCommonResource.MESSAGE_RESOURCE.getText("Information"), 1);
                    return;
                }
                ReportPreviewPane.this.print(services, book);
            }
        }
    }
}

