/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.report.internal;

import com.activetree.common.report.AtShapeElement;
import com.activetree.common.report.internal.ComponentElementDescriptor;
import com.activetree.common.report.internal.ElementDescriptor;
import com.activetree.common.report.internal.IconElementDescriptor;
import com.activetree.common.report.internal.LineDescriptor;
import com.activetree.common.report.internal.StringElementDescriptor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;

public class ContentLineDescriptor
extends LineDescriptor {
    public ContentLineDescriptor(PageFormat pf, boolean isUseCellRenderer) {
        super(pf, isUseCellRenderer);
    }

    public void draw(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        float maxLineHeight = this.getMaxHeight();
        ElementDescriptor elm = null;
        if (this.elements.size() > 0) {
            elm = (ElementDescriptor)this.elements.get(0);
        }
        int elmAlignment = elm.getHorizontalAlignment();
        float fontHeight = elm.getFontMetrics().getHeight();
        int elmType = elm.getValueType();
        float start_y = this.previousLineY + maxLineHeight;
        float start_x = this.imageStartX;
        if (elmAlignment == 11) {
            start_x = this.imageStartX + (this.imageWidth - elm.getWidth()) / 2.0f;
        } else if (elmAlignment == 12) {
            start_x = this.imageStartX + this.imageWidth - elm.getWidth();
        }
        if (start_x < this.imageStartX) {
            start_x = this.imageStartX;
        }
        if (elmType == 1) {
            StringElementDescriptor strElm = (StringElementDescriptor)elm;
            this.provider.theProvider.drawStringElement(g2d, strElm, start_x, start_y -= fontHeight / 4.0f, null);
        } else if (elmType == 2) {
            this.provider.theProvider.drawIconElement(g2d, (IconElementDescriptor)elm, start_x, start_y, maxLineHeight, null);
        } else if (elmType == 3) {
            this.provider.theProvider.drawFormElement(g2d, (ComponentElementDescriptor)elm, start_x, start_y, maxLineHeight, null, this.isUseCellRenderer());
        } else if (elmType == 4) {
            this.provider.theProvider.drawShapeElement(g2d, (AtShapeElement)elm, start_x, start_y, null);
        }
        if (elm.isDrawBorder()) {
            g2d.setColor(elm.getBorderColor());
            g2d.draw(elm.getBounds());
        }
    }
}

