/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.report.internal;

import com.activetree.common.report.internal.ElementDescriptor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.text.AttributeSet;

public class IconElementDescriptor
extends ElementDescriptor {
    protected int width = -1;
    protected int height = -1;
    protected boolean resizeToFit = true;

    public IconElementDescriptor(Image icon, int elementType, Font elmFont, FontMetrics elmFm, AttributeSet elmProperties, boolean resizeToFit) {
        super(elementType, icon, elmFont, elmFm, elmProperties);
        this.resizeToFit = resizeToFit;
    }

    public IconElementDescriptor(Image icon, int elementType, Font elmFont, FontMetrics elmFm, AttributeSet elmProperties, int width, int height, boolean resizeToFit) {
        super(elementType, icon, elmFont, elmFm, elmProperties);
        this.resizeToFit = resizeToFit;
        this.width = width;
        this.height = height;
    }

    public IconElementDescriptor(Image icon, int elementType, Font elmFont, FontMetrics elmFm, AttributeSet elmProperties, int width, int height, int halignment, int valignment, boolean resizeToFit) {
        super(elementType, icon, elmFont, elmFm, elmProperties);
        this.hAlignment = halignment;
        this.vAlignment = valignment;
        this.resizeToFit = resizeToFit;
        this.width = width;
        this.height = height;
    }

    public ElementDescriptor newInstance() {
        Image value = (Image)this.value;
        int elementType = this.elementType;
        Font font = this.font;
        FontMetrics fm = this.fontMetrics;
        AttributeSet attrs = this.attrSet;
        IconElementDescriptor c = new IconElementDescriptor(value, elementType, font, fm, attrs, this.width, this.height, this.hAlignment, this.vAlignment, this.resizeToFit);
        c.attrSet = this.attrSet;
        c.bbox = (Rectangle)this.bbox.clone();
        c.borderColor = this.borderColor;
        c.elementType = this.elementType;
        c.font = font;
        c.fontMetrics = this.fontMetrics;
        c.value = value;
        c.width = this.width;
        c.height = this.height;
        c.isDrawCellBorder = this.isDrawCellBorder;
        return c;
    }

    public void setValue(Object value) {
        if (!(value instanceof ImageIcon)) {
            throw new RuntimeException(this.getClass().getName() + ": value is not an ImageIcon.");
        }
        this.value = value;
    }

    public float getWidth() {
        Object icon = this.getValue();
        double iconWidth = -1.0;
        if (this.width != -1) {
            iconWidth = this.width;
        } else if (icon instanceof Icon) {
            iconWidth = ((Icon)icon).getIconWidth();
        } else if (icon instanceof Image) {
            iconWidth = ((Image)icon).getWidth(null);
        }
        float leftIndent = this.getLeftIndent();
        leftIndent = (float)((double)leftIndent * this.getZoom());
        return (float)((double)leftIndent + (iconWidth *= this.getZoom()));
    }

    public float getHeight() {
        Object icon = this.getValue();
        double iconHeight = -1.0;
        if (this.height != -1) {
            iconHeight = this.height;
        } else if (icon instanceof Icon) {
            iconHeight = ((Icon)icon).getIconHeight();
        } else if (icon instanceof Image) {
            iconHeight = ((Image)icon).getHeight(null);
        }
        return (float)(iconHeight *= this.getZoom());
    }

    public boolean isResizeToFit() {
        return this.resizeToFit;
    }

    public void setResizeToFit(boolean resizeToFit) {
        this.resizeToFit = resizeToFit;
    }
}

