/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.report.internal;

import com.activetree.common.report.AtElement;
import com.activetree.common.report.AtIconElement;
import com.activetree.common.report.AtLineElement;
import com.activetree.common.report.AtPrintUtil;
import com.activetree.common.report.AtShapeElement;
import com.activetree.common.report.AtStringElement;
import com.activetree.common.report.PrintableCell;
import com.activetree.common.report.internal.ComponentElementDescriptor;
import com.activetree.common.report.internal.ComponentTableElementDescriptor;
import com.activetree.common.report.internal.ElementDescriptor;
import com.activetree.common.report.internal.IconElementDescriptor;
import com.activetree.common.report.internal.IconTableElementDescriptor;
import com.activetree.common.report.internal.NewlineElementDescriptor;
import com.activetree.common.report.internal.SplittedElement;
import com.activetree.common.report.internal.StringElementDescriptor;
import com.activetree.common.report.internal.StringTableElementDescriptor;
import com.activetree.common.utils.AtDebug;
import com.activetree.common.utils.GraphicsUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.text.StyleConstants;

public class LineDescriptor
implements Serializable {
    protected PageFormat pageFormat;
    protected float imageStartX = 0.0f;
    protected float imageStartY = 0.0f;
    protected float imageWidth = 0.0f;
    protected float imageHeight = 0.0f;
    protected int horizontalGap = 0;
    public boolean lineFilled = false;
    public float width = 0.0f;
    public float previousLineY = 0.0f;
    protected boolean isUseCellRenderer;
    Vector elements = new Vector();
    Vector positionElements = new Vector();
    Provider provider = new Provider();

    public LineDescriptor(PageFormat pageFormat, boolean isUseCellRenderer) {
        this.isUseCellRenderer = isUseCellRenderer;
        this.pageFormat = pageFormat;
        this.imageStartX = (float)pageFormat.getImageableX();
        this.imageStartY = (float)pageFormat.getImageableY();
        this.imageWidth = (float)pageFormat.getImageableWidth();
        this.imageHeight = (float)pageFormat.getImageableHeight();
    }

    public boolean isUseCellRenderer() {
        return this.isUseCellRenderer;
    }

    public void setIsUseCellRenderer(boolean isUseCellRenderer) {
        this.isUseCellRenderer = isUseCellRenderer;
    }

    public float getImageStartX() {
        return this.imageStartX;
    }

    public void setImageStartX(float newImageStartX) {
        if (newImageStartX < 0.0f) {
            throw new RuntimeException("Value less than 0 not allowed.");
        }
        float deltaChange = newImageStartX - this.imageStartX;
        this.imageStartX = newImageStartX;
        this.imageWidth -= deltaChange;
    }

    public float getImageStartY() {
        return this.imageStartY;
    }

    public void setImageStartY(float newImageStartY) {
        if (newImageStartY < 0.0f) {
            throw new RuntimeException("Value less than 0 not allowed.");
        }
        float deltaChange = newImageStartY - this.imageStartY;
        this.imageStartY = newImageStartY;
        this.imageHeight -= deltaChange;
    }

    public LineDescriptor newInstance() {
        int i;
        LineDescriptor ld = new LineDescriptor(this.pageFormat, this.isUseCellRenderer);
        ld.pageFormat = this.pageFormat;
        ld.imageStartX = this.imageStartX;
        ld.imageStartY = this.imageStartY;
        ld.imageWidth = this.imageWidth;
        ld.imageHeight = this.imageHeight;
        ld.lineFilled = this.lineFilled;
        ld.width = this.width;
        ld.previousLineY = this.previousLineY;
        for (i = 0; this.elements != null && i < this.elements.size(); ++i) {
            ElementDescriptor elm = (ElementDescriptor)this.elements.get(i);
            if (elm == null) {
                ld.elements.add(elm);
                continue;
            }
            ElementDescriptor newElm = elm.newInstance();
            ld.elements.add(newElm);
        }
        for (i = 0; this.positionElements != null && i < this.positionElements.size(); ++i) {
            Float aPosition = (Float)this.positionElements.get(i);
            Float clonedPosition = new Float(aPosition.floatValue());
            ld.positionElements.add(clonedPosition);
        }
        return ld;
    }

    public SplittedElement addElement(ElementDescriptor elm) {
        return this.provider.theProvider.addElement(elm);
    }

    public SplittedElement addElementWithoutCheck(ElementDescriptor elm) {
        return this.provider.theProvider.addElementWithourCheck(elm);
    }

    public ElementDescriptor getElement(int idx) {
        return (ElementDescriptor)this.elements.get(idx);
    }

    public int getElementCount() {
        return this.elements.size();
    }

    public ElementDescriptor[] getElements() {
        ElementDescriptor[] elms = new ElementDescriptor[this.elements.size()];
        for (int i = 0; i < this.elements.size(); ++i) {
            elms[i] = (ElementDescriptor)this.elements.get(i);
        }
        return elms;
    }

    public float getMaxHeight() {
        float maxHeight = 0.0f;
        ElementDescriptor[] elms = this.getElements();
        for (int i = 0; i < elms.length; ++i) {
            float elmHeight = elms[i].getHeight();
            if (!(maxHeight < elmHeight)) continue;
            maxHeight = elmHeight;
        }
        if (elms.length == 0) {
            maxHeight = AtElement.getFontMetrics(AtElement.DEFAULT_FONT).getHeight();
        }
        return maxHeight;
    }

    public void setHorizontalGap(int hGap) {
        this.horizontalGap = hGap;
    }

    public int getHorizontalGap() {
        return this.horizontalGap;
    }

    public float getLineSpacing() {
        return this.getLineGap();
    }

    public float getLineGap() {
        float gap = 0.0f;
        for (int i = 0; i < this.elements.size(); ++i) {
            ElementDescriptor aElm = (ElementDescriptor)this.elements.get(0);
            if (aElm == null) {
                return 0.0f;
            }
            float linespace = 0.0f;
            if (aElm.getAttributeSet() != null) {
                linespace = StyleConstants.getLineSpacing(aElm.getAttributeSet());
            }
            if (!(linespace > gap)) continue;
            gap = linespace;
        }
        return gap;
    }

    public float getSpaceAbove() {
        float gap = 0.0f;
        for (int i = 0; i < this.elements.size(); ++i) {
            ElementDescriptor aElm = (ElementDescriptor)this.elements.get(0);
            if (aElm == null) {
                return 0.0f;
            }
            float space_above = 0.0f;
            if (aElm.getAttributeSet() != null) {
                space_above = StyleConstants.getSpaceAbove(aElm.getAttributeSet());
            }
            if (!(space_above > gap)) continue;
            gap = space_above;
        }
        return gap;
    }

    public float getSpaceBelow() {
        float gap = 0.0f;
        for (int i = 0; i < this.elements.size(); ++i) {
            ElementDescriptor aElm = (ElementDescriptor)this.elements.get(0);
            if (aElm == null) {
                return 0.0f;
            }
            float space_below = 0.0f;
            if (aElm.getAttributeSet() != null) {
                space_below = StyleConstants.getSpaceBelow(aElm.getAttributeSet());
            }
            if (!(space_below > gap)) continue;
            gap = space_below;
        }
        return gap;
    }

    public void draw(Graphics g) {
        this.provider.theProvider.draw(g);
    }

    class Provider
    implements Serializable {
        TheProvider theProvider = new TheProvider();

        Provider() {
        }

        class TheProvider
        implements Serializable {
            StringBuffer buf = new StringBuffer();
            Rectangle cellBbox = new Rectangle();

            TheProvider() {
            }

            void draw(Graphics g) {
                Graphics2D g2d = (Graphics2D)g;
                float maxLineHeight = LineDescriptor.this.getMaxHeight();
                float endsAt = -1.0f;
                float lineSpacing = LineDescriptor.this.getLineSpacing();
                for (int i = 0; i < ((Provider)Provider.this).LineDescriptor.this.elements.size(); ++i) {
                    Color orgColor = g.getColor();
                    Font orgFont = g.getFont();
                    ElementDescriptor elm = (ElementDescriptor)((Provider)Provider.this).LineDescriptor.this.elements.get(i);
                    if (elm == null) {
                        AtDebug.debug("Got a null ElementDescriptor at index: " + i + " in the LineDescriptor. Continue...");
                        continue;
                    }
                    Float startX = (Float)((Provider)Provider.this).LineDescriptor.this.positionElements.get(i);
                    float start_x = ((Provider)Provider.this).LineDescriptor.this.imageStartX + startX.floatValue();
                    float start_y = ((Provider)Provider.this).LineDescriptor.this.previousLineY + maxLineHeight;
                    start_y -= lineSpacing;
                    float elmw = elm.getWidth();
                    Rectangle2D.Double elmBBox = new Rectangle2D.Double(start_x, ((Provider)Provider.this).LineDescriptor.this.previousLineY, elmw, maxLineHeight);
                    Color elmBgColor = (Color)elm.getStyle("BackgroundColor");
                    this.drawElementBackground(g2d, elmBgColor, elmBBox);
                    int elmType = elm.getValueType();
                    if (elmType == 1) {
                        StringElementDescriptor strElm = (StringElementDescriptor)elm;
                        endsAt = this.drawStringElement(g2d, strElm, start_x, start_y, elmBBox);
                    } else if (elmType == 2) {
                        endsAt = this.drawIconElement(g2d, (IconElementDescriptor)elm, start_x, start_y, maxLineHeight, elmBBox);
                    } else if (elmType == 3) {
                        ComponentElementDescriptor compElm = (ComponentElementDescriptor)elm;
                        boolean useCellRenderer = compElm.isUseCellRenderer();
                        endsAt = this.drawFormElement(g2d, (ComponentElementDescriptor)elm, start_x, start_y, maxLineHeight, elmBBox, useCellRenderer);
                    } else if (elmType == 4) {
                        endsAt = this.drawShapeElement(g2d, (AtShapeElement)elm, start_x, start_y, elmBBox);
                    }
                    if (elm.isDrawBorder()) {
                        g2d.setColor(elm.getBorderColor());
                        g2d.draw(elmBBox);
                    }
                    g.setColor(orgColor);
                    g.setFont(orgFont);
                }
            }

            float drawStringElement(Graphics2D g2d, StringElementDescriptor elm, float start_x, float start_y, Rectangle2D bbox) {
                Color orgColor = g2d.getColor();
                Font orgFont = g2d.getFont();
                Font font = (Font)elm.getStyle("Font");
                Color fgColor = (Color)elm.getStyle("ForegroundColor");
                if (elm instanceof StringTableElementDescriptor) {
                    StringTableElementDescriptor strElm = (StringTableElementDescriptor)elm;
                    String cellValue = (String)strElm.getValue();
                    int cellWidth = (int)strElm.getWidth();
                    int cellHeight = (int)strElm.getHeight();
                    Font zoomedFont = (Font)strElm.getStyle("Font");
                    if (zoomedFont == null) {
                        zoomedFont = strElm.getFont();
                    }
                    JTable table = strElm.getTable();
                    int sx = (int)strElm.getX();
                    int sy = (int)strElm.getY();
                    int cellAlignment = strElm.getCellAlignment();
                    this.drawTableCellString(cellValue, g2d, cellWidth, cellHeight, zoomedFont, table, sx, sy, cellAlignment);
                    g2d.setColor(orgColor);
                    g2d.setFont(orgFont);
                    return 0.0f;
                }
                this.buf.delete(0, this.buf.length());
                if (elm instanceof NewlineElementDescriptor) {
                    return -1.0f;
                }
                Object underlined = elm.getStyle("Underline");
                Boolean strikeThrough = (Boolean)elm.getStyle("StrikeThrough");
                String value = (String)elm.getValue();
                if (value == null || value.length() == 0) {
                    return -1.0f;
                }
                char ch = ' ';
                for (int i = 0; i < value.length(); ++i) {
                    char aChar = value.charAt(i);
                    if (aChar == '\n') {
                        this.buf.append(ch);
                        continue;
                    }
                    this.buf.append(aChar);
                }
                value = this.buf.toString();
                g2d.setFont(font);
                FontMetrics fm = g2d.getFontMetrics(font);
                float elmWidth = (int)elm.getWidth();
                float leftIndent = elm.getLeftIndent();
                int strWidth = (int)(elmWidth - leftIndent);
                double fontHeight = elm.getHeight();
                double x = start_x;
                double y = start_y;
                if (bbox != null) {
                    x = AtPrintUtil.getHorizontalAlignedX(bbox, elm);
                    y = AtPrintUtil.getVerticalAlignedY(bbox, elm);
                }
                g2d.setPaint(fgColor);
                g2d.drawString(value, (float)(x += (double)leftIndent), (float)y);
                if (underlined != null) {
                    g2d.drawLine((int)x, (int)y + 1, (int)(x + (double)strWidth), (int)y + 1);
                }
                if (strikeThrough != null) {
                    Color strikeThruColor = (Color)elm.getStyle("StrikeThroughColor");
                    if (strikeThruColor == null) {
                        strikeThruColor = SystemColor.blue.darker().darker();
                    }
                    g2d.setColor(strikeThruColor);
                    float strikeY = (float)(y - fontHeight / 4.0);
                    g2d.drawLine((int)x, (int)strikeY, (int)(x + (double)strWidth), (int)strikeY);
                }
                g2d.setFont(orgFont);
                g2d.setColor(orgColor);
                return start_x + (float)strWidth;
            }

            float drawIconElement(Graphics2D g2d, IconElementDescriptor elm, float start_x, float start_y, float maxLineHeight, Rectangle2D elmBBox) {
                if (elm instanceof IconTableElementDescriptor) {
                    IconTableElementDescriptor tableCellIcon = (IconTableElementDescriptor)elm;
                    Image icon = (Image)tableCellIcon.getValue();
                    int cellHeight = (int)tableCellIcon.getHeight();
                    int cellWidth = (int)tableCellIcon.getWidth();
                    JTable table = tableCellIcon.getTable();
                    int sx = (int)tableCellIcon.getX();
                    int sy = (int)tableCellIcon.getY();
                    double zoom = tableCellIcon.getZoom();
                    this.drawTableCellIcon(icon, g2d, cellHeight, cellWidth, table, sx, sy, zoom);
                    return 0.0f;
                }
                double zoom = elm.getZoom();
                Image image = (Image)elm.getValue();
                double iconH = elm.getHeight();
                double iconW = elm.getWidth();
                iconW *= zoom;
                double y = (double)start_y - (iconH *= zoom);
                if (iconH < (double)maxLineHeight) {
                    y -= ((double)maxLineHeight - iconH) / 2.0;
                }
                g2d.drawImage(image, (int)start_x, (int)y, (int)iconW, (int)iconH, null);
                double endsAt = (double)start_x + iconW;
                return (float)endsAt;
            }

            void drawTableCellString(String cellValue, Graphics2D g, int maxColWidth, int maxRowHeight, Font zoomedFont, JTable table, int sx, int sy, int alignment) {
                FontMetrics fm = table.getFontMetrics(zoomedFont);
                float fontHeight = fm.getHeight();
                float strWidth = GraphicsUtil.stringWidth(zoomedFont, cellValue);
                float strx = sx + 3;
                if (alignment == 11) {
                    strx = (float)sx + ((float)maxColWidth - strWidth) / 2.0f;
                } else if (alignment == 12) {
                    strx = (float)(sx + maxColWidth - 3) - strWidth;
                }
                float leading = fm.getLeading();
                float ascent = fm.getAscent();
                float descent = fm.getDescent();
                float stry = (float)(sy + maxRowHeight) - descent;
                if (fontHeight < (float)maxRowHeight) {
                    float extraHeight = (float)maxRowHeight - fontHeight;
                    float deltaH = extraHeight / 2.0f;
                    stry -= deltaH;
                }
                g.setColor(table.getForeground());
                g.setFont(zoomedFont);
                g.drawString(cellValue, strx, stry);
            }

            void drawTableCellIcon(Image icon, Graphics2D g, int maxRowHeight, int maxColWidth, JTable table, int sx, int sy, double zoom) {
                int iconW = icon.getWidth(null);
                int iconH = icon.getHeight(null);
                iconW = (int)((double)iconW * zoom);
                iconH = (int)((double)iconH * zoom);
                int x = sx + (maxColWidth / 2 - iconW / 2);
                int y = sy + (maxRowHeight / 2 - iconH / 2);
                if (y >= sy + maxRowHeight) {
                    y = sy + maxRowHeight - 1;
                }
                if (x >= sx + maxColWidth) {
                    x = sx + maxColWidth - 1;
                }
                g.drawImage(icon, x, y, iconW, iconH, table);
            }

            float drawFormElement(Graphics2D g2d, ComponentElementDescriptor elm, float start_x, float start_y, float maxLineHeight, Rectangle2D elmBBox, boolean isUseCellRenderer) {
                Color orgColor = g2d.getColor();
                Font orgFont = g2d.getFont();
                if (elm instanceof ComponentTableElementDescriptor) {
                    ComponentTableElementDescriptor tableRendererElm = (ComponentTableElementDescriptor)elm;
                    JTable table = tableRendererElm.getTable();
                    Object cellObject = tableRendererElm.getValue();
                    int maxWidth = (int)tableRendererElm.getWidth();
                    int maxHeight = (int)tableRendererElm.getHeight();
                    int row = tableRendererElm.getRow();
                    int column = tableRendererElm.getColumn();
                    boolean isHeaderCell = tableRendererElm.isHeaderCell();
                    double zoom = tableRendererElm.getZoom();
                    int sx = (int)tableRendererElm.getX();
                    int sy = (int)tableRendererElm.getY();
                    this.drawFromTableCellRenderer(cellObject, g2d, maxHeight, maxWidth, row, column, isHeaderCell, table, zoom, sx, sy, isUseCellRenderer);
                    g2d.setFont(orgFont);
                    g2d.setColor(orgColor);
                    return 0.0f;
                }
                Component form = (Component)elm.getValue();
                int w = form.getWidth();
                int h = form.getHeight();
                Image image = form.createImage(w, h);
                Graphics formG = image.getGraphics();
                form.paintAll(formG);
                float iconH = image.getHeight(null);
                float iconW = image.getWidth(null);
                float y = start_y - iconH;
                if (iconH < maxLineHeight) {
                    y -= (maxLineHeight - iconH) / 2.0f;
                }
                g2d.drawImage(image, (int)start_x, (int)y, (int)iconW, (int)iconH, null);
                AtDebug.debug("\t\t1. form=[" + image + "] at(" + start_x + "," + y + ")");
                g2d.setFont(orgFont);
                g2d.setColor(orgColor);
                return start_x + (float)w;
            }

            float drawShapeElement(Graphics2D g2d, AtShapeElement shapeElm, float start_x, float start_y, Rectangle2D elmBBox) {
                AtElement shape = (AtElement)shapeElm.getValue();
                if (shape == null) {
                    return -1.0f;
                }
                boolean fitToWidth = shapeElm.isFitShapeToWidth();
                float endsAt = -1.0f;
                if (shape instanceof AtLineElement) {
                    AtLineElement line = (AtLineElement)shape;
                    int width = line.getWidth();
                    int thickness = line.getThickness();
                    if (fitToWidth) {
                        width = (int)(((Provider)Provider.this).LineDescriptor.this.imageStartX + ((Provider)Provider.this).LineDescriptor.this.imageWidth - start_x);
                    }
                    int y = (int)start_y;
                    if (line.getAlignment() == 1) {
                        y = (int)(start_y - (shapeElm.getHeight() / 2.0f - (float)(thickness / 2)));
                    } else if (line.getAlignment() == 3) {
                        y -= thickness + 1;
                    } else if (line.getAlignment() == 2) {
                        y = (int)((float)y - (shapeElm.getHeight() - 1.0f));
                    }
                    Rectangle lineBbox = new Rectangle((int)start_x, y, width, thickness);
                    g2d.setPaint(line.getForeGround());
                    g2d.fill(lineBbox);
                    endsAt = start_x + (float)width;
                }
                return endsAt;
            }

            void drawFromTableCellRenderer(Object cellObject, Graphics2D g, int maxRowHeight, int maxColWidth, int row, int col, boolean isHeaderCell, JTable table, double zoom, int sx, int sy, boolean isUseCellRenderer) {
                Color orgColor = g.getColor();
                Font orgFont = g.getFont();
                int comph = maxRowHeight;
                Component rendererComp = AtPrintUtil.getCellRendererComponent(table, row, col, isHeaderCell);
                if (isHeaderCell) {
                    JTableHeader tableHeader = table.getTableHeader();
                    Rectangle r = tableHeader.getHeaderRect(col);
                    comph = (int)r.getHeight();
                    comph = (int)((double)comph * zoom);
                } else {
                    Rectangle cellBBox = table.getCellRect(row, col, false);
                    comph = (int)cellBBox.getHeight();
                    comph = (int)((double)comph * zoom);
                }
                if (rendererComp == null) {
                    AtDebug.debug("ERROR: no cell renderer is found for the table cell.");
                    return;
                }
                this.drawTableCellComponent(g, rendererComp, maxColWidth, comph, maxRowHeight, maxColWidth, isHeaderCell, table, sx, sy, zoom, row, col, isUseCellRenderer);
                g.setColor(orgColor);
                g.setFont(orgFont);
            }

            void drawTableCellComponent(Graphics2D g, Component comp, int compw, int comph, int maxRowHeight, int maxColWidth, boolean isHeaderCell, JTable table, int sx, int sy, double zoom, int row, int col, boolean isUseCellRenderer) {
                this.cellBbox.x = sx;
                this.cellBbox.y = sy;
                this.cellBbox.width = maxColWidth;
                this.cellBbox.height = maxRowHeight;
                Rectangle cellBounds = (Rectangle)this.cellBbox.clone();
                Object cellValue = AtPrintUtil.getCellValue(table, row, col);
                if (isUseCellRenderer) {
                    AtElement value = AtPrintUtil.defaultPrintableCell.getContent(table, row, col, isHeaderCell, cellBounds, zoom);
                    if (value instanceof AtStringElement) {
                        AtStringElement strElm = (AtStringElement)value;
                        AtPrintUtil.drawStringElement(strElm, g, maxColWidth, maxRowHeight, sx, sy, zoom);
                    } else if (value instanceof AtIconElement) {
                        AtPrintUtil.drawIconElement(g, (AtIconElement)value, cellBounds, zoom);
                    } else {
                        AtPrintUtil.defaultPrintableCell.draw(g, table, cellValue, row, col, isHeaderCell, cellBounds, zoom);
                    }
                } else if (table instanceof PrintableCell && ((PrintableCell)((Object)table)).getContent(table, row, col, isHeaderCell, cellBounds, zoom) != null) {
                    AtElement value = ((PrintableCell)((Object)table)).getContent(table, row, col, isHeaderCell, cellBounds, zoom);
                    if (value instanceof AtStringElement) {
                        AtStringElement strElm = (AtStringElement)value;
                        AtPrintUtil.drawStringElement(strElm, g, maxColWidth, maxRowHeight, sx, sy, zoom);
                    } else if (value instanceof AtIconElement) {
                        AtPrintUtil.drawIconElement(g, (AtIconElement)value, cellBounds, zoom);
                    }
                } else if (table instanceof PrintableCell) {
                    PrintableCell pc = (PrintableCell)((Object)table);
                    pc.draw(g, table, cellValue, row, col, isHeaderCell, cellBounds, zoom);
                } else if (comp instanceof Component) {
                    JComponent renderer = (JComponent)comp;
                    int imgWidth = compw;
                    int imgHeight = comph;
                    renderer.setSize(imgWidth, imgHeight);
                    BufferedImage compImg = new BufferedImage(imgWidth - 1, imgHeight, 1);
                    Graphics imgG = compImg.getGraphics();
                    renderer.paint(imgG);
                    int compx = sx + 1;
                    int compy = sy + (maxRowHeight / 2 - comph / 2);
                    g.drawImage((Image)compImg, compx, compy, table);
                }
            }

            private boolean canFit(ElementDescriptor elm) {
                float maxW = ((Provider)Provider.this).LineDescriptor.this.imageWidth;
                float availableWidth = maxW - ((Provider)Provider.this).LineDescriptor.this.width;
                float elmWidth = elm.getWidth();
                return !(elmWidth > availableWidth);
            }

            SplittedElement addElementWithourCheck(ElementDescriptor elm) {
                if (elm == null) {
                    return null;
                }
                ((Provider)Provider.this).LineDescriptor.this.positionElements.add(new Float(((Provider)Provider.this).LineDescriptor.this.width));
                ((Provider)Provider.this).LineDescriptor.this.elements.add(elm);
                int hGap = LineDescriptor.this.getHorizontalGap();
                ((Provider)Provider.this).LineDescriptor.this.width += elm.getWidth() + (float)hGap;
                return null;
            }

            SplittedElement addElement(ElementDescriptor elm) {
                if (elm == null) {
                    return null;
                }
                if (!this.canFit(elm)) {
                    ((Provider)Provider.this).LineDescriptor.this.lineFilled = true;
                    int type = elm.getValueType();
                    if (type == 2) {
                        SplittedElement spElm = new SplittedElement(elm, null, false);
                        spElm.elmType = 2;
                        ((Provider)Provider.this).LineDescriptor.this.positionElements.add(new Float(((Provider)Provider.this).LineDescriptor.this.width));
                        ((Provider)Provider.this).LineDescriptor.this.elements.add(elm);
                        return spElm;
                    }
                    if (type == 3) {
                        SplittedElement spElm = new SplittedElement(elm, null, false);
                        spElm.elmType = 3;
                        ((Provider)Provider.this).LineDescriptor.this.positionElements.add(new Float(((Provider)Provider.this).LineDescriptor.this.width));
                        ((Provider)Provider.this).LineDescriptor.this.elements.add(elm);
                        return spElm;
                    }
                    if (type == 4) {
                        SplittedElement spElm = new SplittedElement(elm, null, false);
                        spElm.elmType = 4;
                        ((Provider)Provider.this).LineDescriptor.this.positionElements.add(new Float(((Provider)Provider.this).LineDescriptor.this.width));
                        ((Provider)Provider.this).LineDescriptor.this.elements.add(elm);
                        return spElm;
                    }
                    if (type == 1) {
                        SplittedElement spElm = this.splitElement(elm);
                        spElm.elmType = 1;
                        if (spElm.splitted) {
                            ((Provider)Provider.this).LineDescriptor.this.positionElements.add(new Float(((Provider)Provider.this).LineDescriptor.this.width));
                            ((Provider)Provider.this).LineDescriptor.this.elements.add(spElm.element1);
                            return spElm;
                        }
                        return spElm;
                    }
                    if (type == 5) {
                        SplittedElement spElm = new SplittedElement(elm, null, false);
                        spElm.elmType = 5;
                        ((Provider)Provider.this).LineDescriptor.this.positionElements.add(new Float(((Provider)Provider.this).LineDescriptor.this.width));
                        ((Provider)Provider.this).LineDescriptor.this.elements.add(elm);
                        return spElm;
                    }
                }
                ((Provider)Provider.this).LineDescriptor.this.positionElements.add(new Float(((Provider)Provider.this).LineDescriptor.this.width));
                ((Provider)Provider.this).LineDescriptor.this.elements.add(elm);
                int hGap = LineDescriptor.this.getHorizontalGap();
                ((Provider)Provider.this).LineDescriptor.this.width += elm.getWidth() + (float)hGap;
                return null;
            }

            SplittedElement splitElement(ElementDescriptor elmToSplit) {
                if (elmToSplit.getValueType() != 1) {
                    return new SplittedElement(elmToSplit, null, false);
                }
                float maxW = ((Provider)Provider.this).LineDescriptor.this.imageWidth;
                float elmWidth = elmToSplit.getWidth();
                StringElementDescriptor strElm = (StringElementDescriptor)elmToSplit;
                char[] chElms = strElm.getCharElements();
                float currWidth = ((Provider)Provider.this).LineDescriptor.this.width + elmWidth;
                int idx = -1;
                int actualIdx = -1;
                for (idx = chElms.length - 1; idx >= 0; --idx) {
                    if (!((currWidth -= strElm.getCharWidth(chElms[idx])) <= maxW)) continue;
                    actualIdx = idx;
                    int i = -1;
                    if (chElms[idx] != ' ') {
                        for (i = idx; i >= 0; --i) {
                            if (chElms[i] != ' ') continue;
                            idx = i;
                            break;
                        }
                    }
                    if (i != -1) break;
                    idx = 0;
                    break;
                }
                SplittedElement spElm = null;
                if (idx == 0 && ((Provider)Provider.this).LineDescriptor.this.width > 0.0f) {
                    spElm = new SplittedElement(null, elmToSplit, false);
                } else if (idx == 0 && ((Provider)Provider.this).LineDescriptor.this.width == 0.0f) {
                    String orgStr = (String)elmToSplit.getValue();
                    String element1 = orgStr.substring(0, actualIdx + 1);
                    String element2 = orgStr.substring(actualIdx + 1);
                    StringElementDescriptor elm1 = new StringElementDescriptor(element1, elmToSplit.getValueType(), elmToSplit.getFont(), elmToSplit.getFontMetrics(), elmToSplit.getAttributeSet());
                    elm1.setStyles(strElm.getStyles());
                    StringElementDescriptor elm2 = new StringElementDescriptor(element2, elmToSplit.getValueType(), elmToSplit.getFont(), elmToSplit.getFontMetrics(), elmToSplit.getAttributeSet());
                    elm2.setStyles(strElm.getStyles());
                    spElm = new SplittedElement(elm1, elm2, true);
                } else if (idx > 0) {
                    String orgStr = (String)elmToSplit.getValue();
                    String element1 = orgStr.substring(0, idx + 1);
                    String element2 = orgStr.substring(idx + 1);
                    StringElementDescriptor elm1 = new StringElementDescriptor(element1, elmToSplit.getValueType(), elmToSplit.getFont(), elmToSplit.getFontMetrics(), elmToSplit.getAttributeSet());
                    elm1.setStyles(strElm.getStyles());
                    StringElementDescriptor elm2 = new StringElementDescriptor(element2, elmToSplit.getValueType(), elmToSplit.getFont(), elmToSplit.getFontMetrics(), elmToSplit.getAttributeSet());
                    elm2.setStyles(strElm.getStyles());
                    spElm = new SplittedElement(elm1, elm2, true);
                }
                return spElm;
            }

            void drawElementBackground(Graphics2D g, Color elmBgColor, Rectangle2D bbox) {
                if (elmBgColor == null) {
                    return;
                }
                if (elmBgColor.getRed() == 255 && elmBgColor.getGreen() == 255 && elmBgColor.getBlue() == 255) {
                    return;
                }
                Color orgColor = g.getColor();
                Color drvBgColor = elmBgColor;
                g.setColor(drvBgColor);
                Rectangle2D r = bbox;
                g.fill(r);
                g.setColor(orgColor);
            }
        }
    }
}

