/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.report.page;

import com.activetree.common.conversion.impl.BMP;
import com.activetree.common.doc.DocEvent;
import com.activetree.common.internal.DemoShape;
import com.activetree.common.page.AbstractPage;
import com.activetree.common.report.page.AbstractReportPage;
import com.activetree.common.report.page.PageImageReader;
import com.activetree.common.utils.AtDebug;
import com.activetree.common.utils.MediaUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;

public class AtImagePage
extends AbstractReportPage
implements PageImageReader {
    protected Object imageSource;
    protected boolean isFitToPrintableArea = false;
    protected boolean verticallyCentered = true;
    protected boolean horizontallyCentered = true;

    public AtImagePage() {
    }

    public AtImagePage(int pageNo, Object imageSource) {
        this(pageNo, AtImagePage.createPageFormat(imageSource), imageSource, null);
    }

    public AtImagePage(int pageNo, PageFormat pf, Object imageSource, DemoShape demoShape) {
        super(pageNo, 4, pf, null, 1.0, true, false, demoShape);
        this.printPageIndex = pageNo;
        this.printerPageFormat = super.getPageFormat();
        this.imageSource = imageSource;
    }

    public AbstractPage newInstance() {
        AtImagePage cp = new AtImagePage();
        cp.imageSource = this.imageSource;
        cp.isFitToPrintableArea = this.isFitToPrintableArea;
        cp.printerPageFormat = MediaUtil.getClonedPageFormat(this.printerPageFormat);
        cp.verticallyCentered = this.verticallyCentered;
        cp.horizontallyCentered = this.horizontallyCentered;
        super.copyAttributes(cp);
        return cp;
    }

    public Object getImageSource() {
        return this.imageSource;
    }

    public void setImageSource(Object imageSource) {
        this.imageSource = imageSource;
    }

    public void setPrintPageIndex(int printPageIndex) {
        this.printPageIndex = printPageIndex;
    }

    public Rectangle2D getPrintableArea() {
        double imgh;
        double imgw;
        double imgy;
        PageFormat pf = this.getPageFormat();
        double imgx = pf.getImageableX();
        Rectangle2D.Float mediaBox = new Rectangle2D.Float((float)imgx, (float)(imgy = pf.getImageableY()), (float)(imgw = pf.getImageableWidth()), (float)(imgh = pf.getImageableHeight()));
        if (mediaBox != null) {
            mediaBox.width -= mediaBox.x;
            mediaBox.height -= mediaBox.y;
        }
        return mediaBox;
    }

    private static final PageFormat createPageFormat(Object imgSource) {
        BufferedImage bi = AtImagePage.getImageFromSource(imgSource);
        int w = bi.getWidth();
        int h = bi.getHeight();
        Rectangle2D.Double printableArea = new Rectangle2D.Double(0.0, 0.0, w, h);
        PageFormat pf = MediaUtil.getSelectedPageFormat(printableArea);
        return pf;
    }

    public boolean isHorizontallyCentered() {
        return this.horizontallyCentered;
    }

    public void setHorizontallyCentered(boolean horizontallyCentered) {
        this.horizontallyCentered = horizontallyCentered;
    }

    public boolean isVerticallyCentered() {
        return this.verticallyCentered;
    }

    public void setVerticallyCentered(boolean verticallyCentered) {
        this.verticallyCentered = verticallyCentered;
    }

    public void setFitToPage(boolean fitToPage) {
        this.isFitToPrintableArea = fitToPage;
    }

    public boolean isFitToPage() {
        return this.isFitToPrintableArea;
    }

    public void setPrinterPageFormat(PageFormat printerPageFormat) {
        this.printerPageFormat = printerPageFormat;
    }

    public BufferedImage getImage() {
        AtDebug.debug(this.getPageIndex() + ": get image [" + this.imageSource + "]");
        BufferedImage bi = AtImagePage.getImageFromSource(this.imageSource);
        return bi;
    }

    public static BufferedImage getImageFromSource(Object imageSource) {
        BufferedImage bi;
        block19: {
            bi = null;
            try {
                if (imageSource == null) {
                    throw new RuntimeException("No image source set");
                }
                if (imageSource instanceof String) {
                    bi = ImageIO.read(new File((String)imageSource));
                    break block19;
                }
                if (imageSource instanceof File) {
                    bi = ImageIO.read((File)imageSource);
                    break block19;
                }
                if (imageSource instanceof URL) {
                    bi = ImageIO.read((URL)imageSource);
                    break block19;
                }
                if (imageSource instanceof InputStream) {
                    bi = ImageIO.read((InputStream)imageSource);
                    break block19;
                }
                if (imageSource instanceof ImageInputStream) {
                    bi = ImageIO.read((ImageInputStream)imageSource);
                    break block19;
                }
                if (imageSource instanceof byte[]) {
                    ByteArrayInputStream bis = new ByteArrayInputStream((byte[])imageSource);
                    bi = ImageIO.read(bis);
                    break block19;
                }
                throw new RuntimeException("\"" + imageSource.getClass().getName() + "\" - unknown image source");
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        if (bi == null && AtImagePage.isBmp(imageSource)) {
            InputStream bmpStream = null;
            try {
                if (imageSource instanceof String) {
                    bmpStream = new FileInputStream((String)imageSource);
                } else if (imageSource instanceof File) {
                    bmpStream = new FileInputStream((File)imageSource);
                } else if (imageSource instanceof URL) {
                    bmpStream = ((URL)imageSource).openStream();
                }
                Image img = BMP.loadBMP(bmpStream);
                if (img instanceof BufferedImage) {
                    bi = (BufferedImage)img;
                } else {
                    int iw = img.getWidth(null);
                    int ih = img.getHeight(null);
                    bi = new BufferedImage(iw, ih, 2);
                    Graphics2D g = bi.createGraphics();
                    g.drawImage(img, 0, 0, null);
                }
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        return bi;
    }

    protected static boolean isBmp(Object imgSource) {
        if (imgSource == null) {
            return false;
        }
        String s = imgSource.toString();
        return s.lastIndexOf(".bmp") >= 0;
    }

    public PageFormat getPrinterPageFormat() {
        return this.printerPageFormat;
    }

    public void draw(Graphics g) {
        this.drawPrintable(g, this.getPrinterPageFormat(), this.printPageIndex);
        this.drawHeaderFooterPageNumber(g);
        if (this.docListenerManager != null) {
            DocEvent docEvt = new DocEvent(this.getSource(), 2, this.getPageIndex(), this.renderingReason);
            docEvt.setInfo(this.getDocInfo());
            this.docListenerManager.notifyDocListeners(docEvt);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void drawPrintable(Graphics g, PageFormat printerImagePageFormat, int pageIndex) {
        double scaleToUse;
        double imageableY;
        double imageableX;
        double imageableHeight;
        double imageableWidth;
        double pfHeight;
        double pfWidth;
        BufferedImage img;
        double imageHeight;
        double imageWidth;
        boolean viewRendering;
        Font orgFont;
        Shape orgClip;
        Color orgColor;
        Graphics2D g2d;
        block18: {
            block16: {
                double orgScale;
                block17: {
                    Object renderingReason;
                    AtDebug.debug("\nPrint page Number (" + pageIndex + ")-----");
                    AtDebug.debug("pageScaling=" + this.pageScaling);
                    g2d = (Graphics2D)g;
                    orgColor = g2d.getColor();
                    orgClip = g2d.getClip();
                    orgFont = g2d.getFont();
                    viewRendering = false;
                    if (pageIndex < 0) {
                        viewRendering = true;
                    }
                    if ((renderingReason = this.getRenderingReason()) != null && !renderingReason.equals("PageRenderingReasonPrinting")) {
                        viewRendering = true;
                    }
                    imageWidth = 0.0;
                    imageHeight = 0.0;
                    img = this.getImage();
                    if (img != null) {
                        imageWidth = img.getWidth();
                        imageHeight = img.getHeight();
                    }
                    if (imageWidth > imageHeight && !viewRendering && this.isPrinting()) {
                        printerImagePageFormat.setOrientation(0);
                    }
                    pfWidth = printerImagePageFormat.getWidth();
                    pfHeight = printerImagePageFormat.getHeight();
                    imageableWidth = printerImagePageFormat.getImageableWidth();
                    imageableHeight = printerImagePageFormat.getImageableHeight();
                    imageableX = printerImagePageFormat.getImageableX();
                    imageableY = printerImagePageFormat.getImageableY();
                    scaleToUse = orgScale = this.getZoom();
                    if (!this.isPrinting()) break block16;
                    double widthResizeFactor = imageableWidth / imageWidth;
                    double heightResizeFactor = imageableHeight / imageHeight;
                    AtDebug.debug("widthResizeFactor=" + widthResizeFactor);
                    AtDebug.debug("heightResizeFactor=" + heightResizeFactor);
                    scaleToUse = Math.min(widthResizeFactor, heightResizeFactor);
                    if (this.pageScaling != 10) break block17;
                    scaleToUse = orgScale;
                    break block18;
                }
                if (this.pageScaling == 12) {
                    if (scaleToUse > 1.0) {
                        scaleToUse = orgScale;
                    }
                    break block18;
                } else if (this.pageScaling != 11) {
                    // empty if block
                }
                break block18;
            }
            if (this.isImageConversion()) {
                scaleToUse = this.getScale();
            }
        }
        AtDebug.debug("scaleToUse: " + scaleToUse);
        double scaled_imageW = imageWidth * scaleToUse;
        double scaled_imageH = imageHeight * scaleToUse;
        Point2D.Double mediaImageStartPoint = new Point2D.Double(0.0, 0.0);
        mediaImageStartPoint.x = printerImagePageFormat.getImageableX();
        mediaImageStartPoint.y = printerImagePageFormat.getImageableY();
        if (!viewRendering) {
            double dw = printerImagePageFormat.getImageableWidth() - scaled_imageW;
            double dh = printerImagePageFormat.getImageableHeight() - scaled_imageH;
            AtDebug.debug("dw=" + dw + ", dh=" + dh + ", curr mediaImageStartPoint=" + mediaImageStartPoint);
            if (this.isHorizontallyCentered()) {
                double newx = mediaImageStartPoint.x + dw / 2.0;
                if (newx > printerImagePageFormat.getImageableX()) {
                    mediaImageStartPoint.x += dw / 2.0;
                }
                if (mediaImageStartPoint.x < imageableX) {
                    mediaImageStartPoint.x = imageableX;
                }
            }
            if (this.isVerticallyCentered()) {
                double newy = mediaImageStartPoint.y + dh / 2.0;
                if (newy > printerImagePageFormat.getImageableY()) {
                    mediaImageStartPoint.y += dh / 2.0;
                }
                if (mediaImageStartPoint.y < imageableY) {
                    mediaImageStartPoint.y = imageableY;
                }
            }
        }
        AtDebug.debug("mediaImageStartPoint.x=" + mediaImageStartPoint.x);
        AtDebug.debug("mediaImageStartPoint.y=" + mediaImageStartPoint.y);
        Rectangle clip = new Rectangle(0, 0, (int)scaled_imageW, (int)scaled_imageH);
        g2d.setClip(clip);
        g2d.scale(scaleToUse, scaleToUse);
        g2d.setColor(SystemColor.white);
        g2d.fill(clip);
        AtDebug.debug("Paper size: (" + pfWidth + "," + pfHeight + ")");
        AtDebug.debug("Clip: " + clip);
        AtDebug.debug("imageWidth=" + imageWidth + ", imageHeight=" + imageHeight);
        AtDebug.debug("imageableWidth=" + imageableWidth + ", imageableHeight=" + imageableHeight);
        AtDebug.debug("scaled_imageW=" + scaled_imageW + ", scaled_imageH=" + scaled_imageH);
        AtDebug.debug("imageableX=" + imageableX + ", imageableY=" + imageableY);
        g2d.drawImage((Image)img, (int)mediaImageStartPoint.x, (int)mediaImageStartPoint.y, null);
        Rectangle2D.Double currImgRect = new Rectangle2D.Double(0.0, 0.0, img.getWidth(), img.getHeight());
        PageFormat currPf = MediaUtil.getSelectedPageFormat(currImgRect);
        this.pageNumberProvider.theProvider.drawDemoShape(g2d, currPf);
        g2d.scale(1.0, 1.0);
        g2d.setColor(orgColor);
        g2d.setFont(orgFont);
        g2d.setClip(orgClip);
    }
}

