/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.report.page;

import com.activetree.common.internal.DemoShape;
import com.activetree.common.page.AbstractPage;
import com.activetree.common.report.AtBorderRenderer;
import com.activetree.common.report.AtElement;
import com.activetree.common.report.AtIconElement;
import com.activetree.common.report.AtPrintUtil;
import com.activetree.common.report.AtStringElement;
import com.activetree.common.report.PageHeaderFooterListener;
import com.activetree.common.report.PrintableCell;
import com.activetree.common.report.internal.ComponentTableElementDescriptor;
import com.activetree.common.report.internal.ElementDescriptor;
import com.activetree.common.report.internal.IconTableElementDescriptor;
import com.activetree.common.report.internal.LineDescriptor;
import com.activetree.common.report.internal.StringTableElementDescriptor;
import com.activetree.common.report.page.AbstractReportPage;
import com.activetree.common.report.util.ReportUtil;
import com.activetree.common.resource.AtCommonResource;
import com.activetree.common.utils.AtDebug;
import com.activetree.common.utils.GraphicsUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.SystemColor;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;

public class TablePage
extends AbstractReportPage {
    public static final int LEADING = 10;
    public static final int CENTER = 11;
    public static final int TRAILING = 12;
    public static final int TOP = 13;
    public static final int BOTTOM = 14;
    public static final String EMPTY_STRING = "";
    protected static String T = AtCommonResource.MESSAGE_RESOURCE.getText("TRUE_SHORT_CUT");
    protected static String F = AtCommonResource.MESSAGE_RESOURCE.getText("FALSE_SHORT_CUT");
    protected int startRow;
    protected int endRow;
    protected int startCol;
    protected int endCol;
    protected boolean printHeader;
    protected int x;
    protected int y;
    protected double[] maxColWidths = null;
    protected JTable table = null;
    protected boolean headerBold = true;
    protected boolean drawCellBorder = false;
    protected TablePageRenderer pageRenderer = new TablePageRenderer();
    protected AtBorderRenderer tableCellBorderRenderer;
    protected Hashtable colAlignment = new Hashtable();
    protected Hashtable colOrdering = new Hashtable();
    protected boolean fitSmallerTableToPageWidth = false;
    protected int sx = 0;
    protected int sy = 0;
    protected boolean isLinesGenerated = false;
    protected Vector lineElements = null;
    protected Rectangle cellBbox = new Rectangle();

    public AbstractPage newInstance() {
        TablePage cp = new TablePage();
        cp.startRow = this.startRow;
        cp.endRow = this.endRow;
        cp.startCol = this.startCol;
        cp.endCol = this.endCol;
        cp.printHeader = this.printHeader;
        cp.x = this.x;
        cp.y = this.y;
        cp.maxColWidths = this.maxColWidths;
        cp.table = this.table;
        cp.headerBold = this.headerBold;
        cp.drawCellBorder = this.drawCellBorder;
        cp.tableCellBorderRenderer = this.tableCellBorderRenderer;
        if (this.colAlignment != null) {
            cp.colAlignment = (Hashtable)this.colAlignment.clone();
        }
        if (this.colOrdering != null) {
            cp.colOrdering = (Hashtable)this.colOrdering.clone();
        }
        cp.fitSmallerTableToPageWidth = this.fitSmallerTableToPageWidth;
        cp.sx = this.sx;
        cp.sy = this.sy;
        cp.isLinesGenerated = this.isLinesGenerated;
        if (this.lineElements != null) {
            cp.lineElements = (Vector)this.lineElements.clone();
        }
        cp.cellBbox = this.cellBbox;
        super.copyAttributes(cp);
        cp.setHeaderHeight(this.getHeaderHeight());
        cp.setFooterHeight(this.getFooterHeight());
        return cp;
    }

    public void setColumnAlignment(int colIndex, Integer alignment) {
        this.colAlignment.put(new Integer(colIndex), alignment);
    }

    public Integer getColumnAlignment(int colIndex) {
        Integer alignment = (Integer)this.colAlignment.get(new Integer(colIndex));
        return alignment;
    }

    public void setColumnOrder(int columnIndex, Integer order) {
        this.colOrdering.put(new Integer(columnIndex), order);
    }

    public Integer getColumnOrder(int colIndex) {
        Integer colOrder = (Integer)this.colOrdering.get(new Integer(colIndex));
        if (colOrder != null) {
            return colOrder;
        }
        return null;
    }

    public void setFitSmallerTableToPageWidth(boolean fitSmallerTableToPageWidth) {
        this.fitSmallerTableToPageWidth = fitSmallerTableToPageWidth;
    }

    public boolean isFitSmallerTableToPageWidth() {
        return this.fitSmallerTableToPageWidth;
    }

    protected TablePage() {
    }

    public TablePage(int startCol, int endCol, int startRow, int endRow, boolean printHeader, double[] maxColWidths, JTable table, int pageNo, int pageNoLoc, PageFormat pf, int startX, int startY, boolean headerBold, boolean drawCellBorder, PageHeaderFooterListener headerFooterListener, double zoom, boolean isAntiAliased, AtBorderRenderer tableCellBorderRenderer, boolean isUseCellRenderer, DemoShape demoShape) {
        super(pageNo, pageNoLoc, pf, headerFooterListener, zoom, isAntiAliased, isUseCellRenderer, demoShape);
        this.startRow = startRow;
        this.endRow = endRow;
        this.startCol = startCol;
        this.endCol = endCol;
        this.printHeader = printHeader;
        this.x = startX;
        this.y = startY;
        this.maxColWidths = maxColWidths;
        this.table = table;
        this.drawCellBorder = drawCellBorder;
        this.headerBold = headerBold;
        this.tableCellBorderRenderer = tableCellBorderRenderer;
    }

    public TablePage(int startCol, int endCol, int startRow, int endRow, boolean printHeader, double[] maxColWidths, JTable table, int pageNo, int pageNoLoc, PageFormat pf, boolean headerBold, boolean drawCellBorder, PageHeaderFooterListener headerFooterListener, double zoom, boolean isAntiAliased, boolean isUseCellRenderer, AtBorderRenderer tableCellBorderRenderer, DemoShape demoShape) {
        super(pageNo, pageNoLoc, pf, headerFooterListener, zoom, isAntiAliased, isUseCellRenderer, demoShape);
        this.startRow = startRow;
        this.endRow = endRow;
        this.startCol = startCol;
        this.endCol = endCol;
        this.printHeader = printHeader;
        this.x = (int)pf.getImageableX();
        this.y = (int)pf.getImageableY();
        this.maxColWidths = maxColWidths;
        this.table = table;
        this.drawCellBorder = drawCellBorder;
        this.headerBold = headerBold;
        this.isAntiAliased = isAntiAliased;
        this.tableCellBorderRenderer = tableCellBorderRenderer;
    }

    public boolean isPrintHeader() {
        return this.printHeader;
    }

    public void setPrintHeader(boolean printHeader) {
        this.printHeader = printHeader;
    }

    public boolean isDrawCellBorder() {
        return this.drawCellBorder;
    }

    public void setDrawCellBorder(boolean drawCellBorder) {
        this.drawCellBorder = drawCellBorder;
    }

    public void setHeaderBold(boolean headerBold) {
        this.headerBold = headerBold;
    }

    public boolean isHeaderBold() {
        return this.headerBold;
    }

    int getImageEnd() {
        this.draw(AtPrintUtil.getDefaultGraphics());
        return this.sy;
    }

    public void draw(Graphics g) {
        AtDebug.debug("TablePage.draw() page#" + this.getPageNumber() + ", zoom=" + this.getZoom());
        Graphics2D g2d = (Graphics2D)g;
        g2d.scale(this.scale, this.scale);
        this.pageRenderer.theRenderer.draw(g2d);
    }

    public LineDescriptor[] getLineElements() {
        if (!this.isLinesGenerated) {
            this.lineElements = this.pageRenderer.theRenderer.generateLineElements();
            this.isLinesGenerated = true;
        }
        if (this.lineElements == null) {
            return null;
        }
        LineDescriptor[] lines = new LineDescriptor[this.lineElements.size()];
        for (int row = 0; this.lineElements != null && row < this.lineElements.size(); ++row) {
            Vector aLine = (Vector)this.lineElements.get(row);
            LineDescriptor line = new LineDescriptor(this.getPageFormat(), this.isUseCellRenderer());
            for (int col = 0; col < aLine.size(); ++col) {
                ElementDescriptor elm = (ElementDescriptor)aLine.get(col);
                line.addElementWithoutCheck(elm);
            }
            lines[row] = line;
        }
        return lines;
    }

    private Font getFont(Font f) {
        Font font = null;
        font = this.isFitSmallerTableToPageWidth() ? f : AtPrintUtil.getFont(f, this.getZoom());
        if (font == null) {
            font = AtPrintUtil.getDefaultFont();
        }
        return font;
    }

    public double getZoom() {
        if (this.isFitSmallerTableToPageWidth()) {
            return 1.0;
        }
        return super.getZoom();
    }

    protected double getOptimumCellWidth(Rectangle currCellBbox, double maxColWidth) {
        PageFormat orgPageFormat = super.getPageFormat();
        double rightMargin = orgPageFormat.getWidth() - orgPageFormat.getImageableX() - orgPageFormat.getImageableWidth();
        double availableWidth = orgPageFormat.getWidth() - (double)currCellBbox.x - rightMargin;
        double cellWidth = currCellBbox.width;
        if ((double)currCellBbox.width > availableWidth) {
            cellWidth = availableWidth;
        }
        return cellWidth;
    }

    protected void drawCellBorder(Graphics2D g, double maxColWidth, double maxRowHeight, Object cellObject, int row, int col, boolean isHeaderCell) {
        this.pageRenderer.theRenderer.drawTableCellBorder(g, maxColWidth, maxRowHeight, cellObject, row, col, isHeaderCell);
    }

    private class TablePageRenderer
    implements Serializable {
        TheRenderer theRenderer = new TheRenderer();

        private TablePageRenderer() {
        }

        class TheRenderer
        implements Serializable {
            int count = 0;
            AttributeSet elmAttrSet = new SimpleAttributeSet();

            TheRenderer() {
            }

            Vector generateLineElements() {
                ElementDescriptor cellElm;
                int cellAlignment;
                Object cellObject;
                double maxColWidth;
                Vector lineElements = new Vector();
                TableColumnModel tcm = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.table.getColumnModel();
                ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.x;
                ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.y;
                if (TablePage.this.isPrintHeader()) {
                    Vector<ElementDescriptor> headerLine = new Vector<ElementDescriptor>();
                    double maxHeaderHeight = AtPrintUtil.calculateMaxRowHeight(((TablePageRenderer)TablePageRenderer.this).TablePage.this.table, null, TablePage.this.getZoom(), 0, true);
                    for (int col = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.startCol; col <= ((TablePageRenderer)TablePageRenderer.this).TablePage.this.endCol; ++col) {
                        Component cr = AtPrintUtil.getCellRendererComponent(((TablePageRenderer)TablePageRenderer.this).TablePage.this.table, -1, col, true);
                        Color cellFg = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.table.getForeground();
                        Color cellBg = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.table.getBackground();
                        Font cellFont = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.table.getFont();
                        if (cr != null) {
                            cellFg = cr.getForeground();
                            cellBg = cr.getBackground();
                            cellFont = cr.getFont();
                        }
                        if (TablePage.this.isHeaderBold()) {
                            cellFont = cellFont.deriveFont(1);
                        }
                        Font zoomedFont = TablePage.this.getFont(cellFont);
                        TableColumn cm = tcm.getColumn(col);
                        maxColWidth = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.maxColWidths[col];
                        cellObject = cm.getHeaderValue();
                        cellAlignment = this.getCellAlignment(((TablePageRenderer)TablePageRenderer.this).TablePage.this.table, -1, col, cellObject, true);
                        cellElm = this.getElementDescriptor(cellObject, zoomedFont, null, cellFg, cellBg, maxColWidth, maxHeaderHeight, TablePage.this.isDrawCellBorder(), true, -1, col, cellAlignment, cr);
                        headerLine.add(cellElm);
                        ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx = (int)((double)((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx + maxColWidth);
                    }
                    ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy = (int)((double)((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy + maxHeaderHeight);
                    lineElements.add(headerLine);
                }
                for (int row = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.startRow; ((TablePageRenderer)TablePageRenderer.this).TablePage.this.startRow != -1 && ((TablePageRenderer)TablePageRenderer.this).TablePage.this.endRow != -1 && row <= ((TablePageRenderer)TablePageRenderer.this).TablePage.this.endRow; ++row) {
                    ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.x;
                    double maxRowHeight = AtPrintUtil.calculateMaxRowHeight(((TablePageRenderer)TablePageRenderer.this).TablePage.this.table, null, TablePage.this.getZoom(), row, false);
                    Vector<ElementDescriptor> rowLine = new Vector<ElementDescriptor>();
                    for (int col = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.startCol; col <= ((TablePageRenderer)TablePageRenderer.this).TablePage.this.endCol; ++col) {
                        Component cr = AtPrintUtil.getCellRendererComponent(((TablePageRenderer)TablePageRenderer.this).TablePage.this.table, row, col, false);
                        Color cellFg = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.table.getForeground();
                        Color cellBg = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.table.getBackground();
                        Font cellFont = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.table.getFont();
                        if (cr != null) {
                            cellFg = cr.getForeground() != null ? cr.getForeground() : cellFg;
                            cellBg = cr.getBackground() != null ? cr.getBackground() : cellBg;
                            cellFont = cr.getFont() != null ? cr.getFont() : cellFont;
                        }
                        Font zoomedFont = TablePage.this.getFont(cellFont);
                        maxColWidth = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.maxColWidths[col];
                        cellObject = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.table.getValueAt(row, col);
                        cellAlignment = this.getCellAlignment(((TablePageRenderer)TablePageRenderer.this).TablePage.this.table, row, col, cellObject, false);
                        cellElm = this.getElementDescriptor(cellObject, zoomedFont, null, cellFg, cellBg, maxColWidth, maxRowHeight, TablePage.this.isDrawCellBorder(), false, row, col, cellAlignment, cr);
                        rowLine.add(cellElm);
                        ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx = (int)((double)((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx + maxColWidth);
                    }
                    lineElements.add(rowLine);
                    ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy = (int)((double)((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy + maxRowHeight);
                }
                return lineElements;
            }

            int getCellAlignment(JTable table, int row, int col, Object cellValue, boolean isHeaderCell) {
                int cellAlignment = 10;
                try {
                    Integer colAl = TablePage.this.getColumnAlignment(col);
                    cellAlignment = colAl != null ? colAl : AtPrintUtil.getCellAlignment(table, isHeaderCell, row, col, cellValue);
                }
                catch (Throwable t) {
                    AtDebug.debug(9, t);
                }
                return cellAlignment;
            }

            void draw(Graphics g) {
                TablePage.this.clipPrintableArea(g);
                TableColumnModel tcm = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.table.getColumnModel();
                ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.x;
                ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.y;
                g.setColor(((TablePageRenderer)TablePageRenderer.this).TablePage.this.table.getTableHeader().getForeground());
                if (TablePage.this.isPrintHeader()) {
                    this.drawHeader((Graphics2D)g, tcm);
                }
                this.drawRows((Graphics2D)g);
                TablePage.this.drawHeaderFooterPageNumber(g);
            }

            void drawHeader(Graphics2D g, TableColumnModel tcm) {
                double maxHeaderHeight = AtPrintUtil.calculateMaxRowHeight(((TablePageRenderer)TablePageRenderer.this).TablePage.this.table, null, TablePage.this.getZoom(), 0, true);
                for (int col = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.startCol; col <= ((TablePageRenderer)TablePageRenderer.this).TablePage.this.endCol; ++col) {
                    Component cp = AtPrintUtil.getCellRendererComponent(((TablePageRenderer)TablePageRenderer.this).TablePage.this.table, -1, col, true);
                    Color cellFg = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.table.getForeground();
                    Color cellBg = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.table.getBackground();
                    Font cellFont = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.table.getFont();
                    if (cp != null) {
                        cellFg = cp.getForeground();
                        cellBg = cp.getBackground();
                        cellFont = cp.getFont();
                    }
                    if (TablePage.this.isHeaderBold()) {
                        cellFont = cellFont.deriveFont(1);
                    }
                    Font zoomedFont = TablePage.this.getFont(cellFont);
                    TableColumn tc = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.table.getColumnModel().getColumn(col);
                    double maxColWidth = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.maxColWidths[col];
                    Object cellObject = tc.getHeaderValue();
                    int cellAlignment = this.getCellAlignment(((TablePageRenderer)TablePageRenderer.this).TablePage.this.table, -1, col, cellObject, true);
                    this.drawCell(cellObject, g, maxHeaderHeight, maxColWidth, -1, col, true, zoomedFont, cellBg, cellFg, cellAlignment, cp);
                    ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx = (int)((double)((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx + maxColWidth);
                }
                ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy = (int)((double)((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy + maxHeaderHeight);
            }

            void drawRows(Graphics2D g) {
                if (((TablePageRenderer)TablePageRenderer.this).TablePage.this.startRow == -1 || ((TablePageRenderer)TablePageRenderer.this).TablePage.this.endRow == -1) {
                    return;
                }
                for (int row = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.startRow; row <= ((TablePageRenderer)TablePageRenderer.this).TablePage.this.endRow; ++row) {
                    ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.x;
                    double maxRowHeight = AtPrintUtil.calculateMaxRowHeight(((TablePageRenderer)TablePageRenderer.this).TablePage.this.table, null, TablePage.this.getZoom(), row, false);
                    for (int col = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.startCol; col <= ((TablePageRenderer)TablePageRenderer.this).TablePage.this.endCol; ++col) {
                        Component cr = AtPrintUtil.getCellRendererComponent(((TablePageRenderer)TablePageRenderer.this).TablePage.this.table, row, col, false);
                        Color cellFg = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.table.getForeground();
                        Color cellBg = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.table.getBackground();
                        Font cellFont = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.table.getFont();
                        if (cr != null) {
                            cellFg = cr.getForeground();
                            cellBg = cr.getBackground();
                            cellFont = cr.getFont();
                        }
                        Font zoomedFont = TablePage.this.getFont(cellFont);
                        double maxColWidth = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.maxColWidths[col];
                        Object cellObject = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.table.getValueAt(row, col);
                        int cellAlignment = this.getCellAlignment(((TablePageRenderer)TablePageRenderer.this).TablePage.this.table, row, col, cellObject, false);
                        this.drawCell(cellObject, g, maxRowHeight, maxColWidth, row, col, false, zoomedFont, cellBg, cellFg, cellAlignment, cr);
                        ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx = (int)((double)((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx + maxColWidth);
                    }
                    ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy = (int)((double)((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy + maxRowHeight);
                }
            }

            void drawCell(Object cellObject, Graphics2D g, double maxRowHeight, double maxColWidth, int row, int col, boolean isHeaderCell, Font zoomedFont, Color cellBg, Color cellFg, int cellAlignment, Component cr) {
                ((TablePageRenderer)TablePageRenderer.this).TablePage.this.cellBbox.x = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx;
                ((TablePageRenderer)TablePageRenderer.this).TablePage.this.cellBbox.y = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy;
                ((TablePageRenderer)TablePageRenderer.this).TablePage.this.cellBbox.width = (int)maxColWidth;
                ((TablePageRenderer)TablePageRenderer.this).TablePage.this.cellBbox.height = (int)maxRowHeight;
                ((TablePageRenderer)TablePageRenderer.this).TablePage.this.cellBbox.width = (int)TablePage.this.getOptimumCellWidth(((TablePageRenderer)TablePageRenderer.this).TablePage.this.cellBbox, maxColWidth);
                Rectangle cellBounds = (Rectangle)((TablePageRenderer)TablePageRenderer.this).TablePage.this.cellBbox.clone();
                this.drawCellBackground(cellBg, g, ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx, ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy, maxColWidth, maxRowHeight);
                if (((TablePageRenderer)TablePageRenderer.this).TablePage.this.isUseCellRenderer) {
                    AtElement value = AtPrintUtil.defaultPrintableCell.getContent(((TablePageRenderer)TablePageRenderer.this).TablePage.this.table, row, col, isHeaderCell, cellBounds, TablePage.this.getZoom());
                    if (value instanceof AtStringElement) {
                        AtStringElement strElm = (AtStringElement)value;
                        AtPrintUtil.drawStringElement(strElm, g, (int)maxColWidth, (int)maxRowHeight, ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx, ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy, TablePage.this.getZoom());
                    } else if (value instanceof AtIconElement) {
                        AtPrintUtil.drawIconElement(g, (AtIconElement)value, cellBounds, TablePage.this.getZoom());
                    } else {
                        AtPrintUtil.defaultPrintableCell.draw(g, ((TablePageRenderer)TablePageRenderer.this).TablePage.this.table, cellObject, row, col, isHeaderCell, cellBounds, TablePage.this.getZoom());
                    }
                } else if (((TablePageRenderer)TablePageRenderer.this).TablePage.this.table instanceof PrintableCell && ((PrintableCell)((Object)((TablePageRenderer)TablePageRenderer.this).TablePage.this.table)).getContent(((TablePageRenderer)TablePageRenderer.this).TablePage.this.table, row, col, isHeaderCell, cellBounds, TablePage.this.getZoom()) != null) {
                    AtElement value = ((PrintableCell)((Object)((TablePageRenderer)TablePageRenderer.this).TablePage.this.table)).getContent(((TablePageRenderer)TablePageRenderer.this).TablePage.this.table, row, col, isHeaderCell, cellBounds, TablePage.this.getZoom());
                    if (value instanceof AtStringElement) {
                        AtStringElement strElm = (AtStringElement)value;
                        AtPrintUtil.drawStringElement(strElm, g, (int)maxColWidth, (int)maxRowHeight, ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx, ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy, TablePage.this.getZoom());
                    } else if (value instanceof AtIconElement) {
                        AtPrintUtil.drawIconElement(g, (AtIconElement)value, cellBounds, TablePage.this.getZoom());
                    }
                } else if (((TablePageRenderer)TablePageRenderer.this).TablePage.this.table instanceof PrintableCell) {
                    PrintableCell pc = (PrintableCell)((Object)((TablePageRenderer)TablePageRenderer.this).TablePage.this.table);
                    pc.draw(g, ((TablePageRenderer)TablePageRenderer.this).TablePage.this.table, cellObject, row, col, isHeaderCell, cellBounds, TablePage.this.getZoom());
                } else if (cr instanceof JTree) {
                    this.drawTreeCell(g, (JTree)cr, row, col, isHeaderCell, cellObject, maxColWidth, maxRowHeight, zoomedFont, cellBg, cellFg, cellAlignment, cr);
                } else if (cellObject == null) {
                    this.drawFromRenderer(cellObject, g, maxRowHeight, maxColWidth, row, col, isHeaderCell, zoomedFont, cellBg, cellFg, cellAlignment, cr);
                } else if (cellObject instanceof String) {
                    this.drawString((String)cellObject, g, maxColWidth, maxRowHeight, zoomedFont, cellBg, cellFg, cellAlignment);
                } else if (cellObject instanceof Number) {
                    String numberText = cellObject.toString();
                    this.drawString(numberText, g, maxColWidth, maxRowHeight, zoomedFont, cellBg, cellFg, cellAlignment);
                } else if (cellObject instanceof Icon) {
                    ImageIcon icon = (ImageIcon)cellObject;
                    this.drawIcon(icon.getImage(), g, maxRowHeight, maxColWidth, cellBg);
                } else if (cellObject instanceof Image) {
                    Image image = (Image)cellObject;
                    this.drawIcon(image, g, maxRowHeight, maxColWidth, cellBg);
                } else {
                    this.drawFromRenderer(cellObject, g, maxRowHeight, maxColWidth, row, col, isHeaderCell, zoomedFont, cellBg, cellFg, cellAlignment, cr);
                }
                TablePage.this.drawCellBorder(g, maxColWidth, maxRowHeight, cellObject, row, col, isHeaderCell);
            }

            void drawTreeCell(Graphics2D g, JTree tree, int row, int col, boolean isHeaderCell, Object cellObject, double maxColWidth, double maxRowHeight, Font zoomedFont, Color cellBg, Color cellFg, int cellAlignment, Component cr) {
                int nodeIconIndentX;
                Image expansionIcon = ReportUtil.getExpansionIcon(tree);
                Image collapseIcon = ReportUtil.getCollapseIcon(tree);
                Image nodeExpIcon = AtPrintUtil.getTreeNodeExpansionIcon(tree, row, expansionIcon, collapseIcon);
                Image treeCellIcon = AtPrintUtil.getIconImageForTreeCell(tree, row, cellObject);
                JTree rendererComp = tree;
                int orgSx = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx;
                int orgSy = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy;
                int deltax = nodeIconIndentX = AtPrintUtil.getTreeNodeIconIndentationX(tree, row, expansionIcon, collapseIcon, 3, TablePage.this.getZoom());
                if (treeCellIcon != null) {
                    double iconw = treeCellIcon.getWidth(null);
                    double iconh = treeCellIcon.getHeight(null);
                    double iconx = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx + nodeIconIndentX;
                    double icony = (double)((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy + maxRowHeight / 2.0 - (iconh *= TablePage.this.getZoom()) / 2.0;
                    g.drawImage(treeCellIcon, (int)iconx, (int)icony, (int)(iconw *= TablePage.this.getZoom()), (int)iconh, null);
                    deltax = (int)((double)deltax + iconw);
                }
                if (nodeExpIcon != null) {
                    double iconh = nodeExpIcon.getHeight(null);
                    double iconw = nodeExpIcon.getWidth(null);
                    double expIconIndentX = AtPrintUtil.getTreeNodeExpIconCenterIndentationX(tree, row, expansionIcon, collapseIcon, 3, nodeIconIndentX, TablePage.this.getZoom());
                    double iconx = (double)((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx + (expIconIndentX -= (iconw *= TablePage.this.getZoom()) / 2.0);
                    double icony = (double)((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy + maxRowHeight / 2.0 - (iconh *= TablePage.this.getZoom()) / 2.0;
                    g.drawImage(nodeExpIcon, (int)iconx, (int)icony, (int)iconw, (int)iconh, null);
                }
                ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx += deltax;
                ((TablePageRenderer)TablePageRenderer.this).TablePage.this.cellBbox.x = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx;
                ((TablePageRenderer)TablePageRenderer.this).TablePage.this.cellBbox.y = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy;
                ((TablePageRenderer)TablePageRenderer.this).TablePage.this.cellBbox.width = (int)maxColWidth;
                ((TablePageRenderer)TablePageRenderer.this).TablePage.this.cellBbox.height = (int)maxRowHeight;
                ((TablePageRenderer)TablePageRenderer.this).TablePage.this.cellBbox.width = (int)TablePage.this.getOptimumCellWidth(((TablePageRenderer)TablePageRenderer.this).TablePage.this.cellBbox, maxColWidth);
                Rectangle cellBounds = (Rectangle)((TablePageRenderer)TablePageRenderer.this).TablePage.this.cellBbox.clone();
                if (((TablePageRenderer)TablePageRenderer.this).TablePage.this.isUseCellRenderer) {
                    AtElement value = AtPrintUtil.defaultPrintableCell.getContent(((TablePageRenderer)TablePageRenderer.this).TablePage.this.table, row, col, isHeaderCell, cellBounds, TablePage.this.getZoom());
                    if (value instanceof AtStringElement) {
                        AtStringElement strElm = (AtStringElement)value;
                        AtPrintUtil.drawStringElement(strElm, g, (int)maxColWidth, (int)maxRowHeight, ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx, ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy, TablePage.this.getZoom());
                    } else if (value instanceof AtIconElement) {
                        AtPrintUtil.drawIconElement(g, (AtIconElement)value, cellBounds, TablePage.this.getZoom());
                    } else {
                        AtPrintUtil.defaultPrintableCell.draw(g, ((TablePageRenderer)TablePageRenderer.this).TablePage.this.table, cellObject, row, col, isHeaderCell, cellBounds, TablePage.this.getZoom());
                    }
                } else if (((TablePageRenderer)TablePageRenderer.this).TablePage.this.table instanceof PrintableCell && ((PrintableCell)((Object)((TablePageRenderer)TablePageRenderer.this).TablePage.this.table)).getContent(((TablePageRenderer)TablePageRenderer.this).TablePage.this.table, row, col, isHeaderCell, cellBounds, TablePage.this.getZoom()) != null) {
                    AtElement value = ((PrintableCell)((Object)((TablePageRenderer)TablePageRenderer.this).TablePage.this.table)).getContent(((TablePageRenderer)TablePageRenderer.this).TablePage.this.table, row, col, isHeaderCell, cellBounds, TablePage.this.getZoom());
                    if (value instanceof AtStringElement) {
                        AtStringElement strElm = (AtStringElement)value;
                        AtPrintUtil.drawStringElement(strElm, g, (int)maxColWidth, (int)maxRowHeight, ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx, ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy, TablePage.this.getZoom());
                    } else if (value instanceof AtIconElement) {
                        AtPrintUtil.drawIconElement(g, (AtIconElement)value, cellBounds, TablePage.this.getZoom());
                    }
                } else if (((TablePageRenderer)TablePageRenderer.this).TablePage.this.table instanceof PrintableCell) {
                    PrintableCell pc = (PrintableCell)((Object)((TablePageRenderer)TablePageRenderer.this).TablePage.this.table);
                    pc.draw(g, ((TablePageRenderer)TablePageRenderer.this).TablePage.this.table, cellObject, row, col, isHeaderCell, cellBounds, TablePage.this.getZoom());
                } else if (cellObject instanceof String) {
                    this.drawString((String)cellObject, g, maxColWidth, maxRowHeight, zoomedFont, cellBg, cellFg, cellAlignment);
                } else if (cellObject instanceof Number) {
                    String numberText = cellObject.toString();
                    this.drawString(numberText, g, maxColWidth, maxRowHeight, zoomedFont, cellBg, cellFg, cellAlignment);
                } else if (cellObject instanceof Icon) {
                    ImageIcon icon = (ImageIcon)cellObject;
                    this.drawIcon(icon.getImage(), g, maxRowHeight, maxColWidth, cellBg);
                } else if (cellObject instanceof Image) {
                    Image image = (Image)cellObject;
                    this.drawIcon(image, g, maxRowHeight, maxColWidth, cellBg);
                } else {
                    this.drawFromRenderer(cellObject, g, maxRowHeight, maxColWidth, row, col, isHeaderCell, zoomedFont, cellBg, cellFg, cellAlignment, cr);
                }
                ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx = orgSx;
                ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy = orgSy;
            }

            void drawTableCellBorder(Graphics2D g, double maxColWidth, double maxRowHeight, Object cellObject, int row, int col, boolean isHeaderCell) {
                if (TablePage.this.isDrawCellBorder()) {
                    Color orgColor = g.getColor();
                    Font orgFont = g.getFont();
                    Rectangle cellBorderRect = new Rectangle();
                    cellBorderRect.x = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx;
                    cellBorderRect.y = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy;
                    cellBorderRect.width = (int)maxColWidth;
                    cellBorderRect.height = (int)maxRowHeight;
                    PageFormat orgPageFormat = TablePage.this.pageFormat;
                    double rightMargin = orgPageFormat.getWidth() - orgPageFormat.getImageableX() - orgPageFormat.getImageableWidth();
                    double availableWidth = orgPageFormat.getWidth() - (double)cellBorderRect.x - rightMargin;
                    double cellWidth = cellBorderRect.width;
                    if ((double)cellBorderRect.width > availableWidth) {
                        cellWidth = availableWidth + 12.0;
                    }
                    cellBorderRect.width = (int)cellWidth;
                    if (((TablePageRenderer)TablePageRenderer.this).TablePage.this.tableCellBorderRenderer == null) {
                        g.setColor(((TablePageRenderer)TablePageRenderer.this).TablePage.this.table.getGridColor());
                        g.draw(cellBorderRect);
                    } else {
                        ((TablePageRenderer)TablePageRenderer.this).TablePage.this.tableCellBorderRenderer.drawBorder(((TablePageRenderer)TablePageRenderer.this).TablePage.this.table, cellObject, row, col, isHeaderCell, g, cellBorderRect);
                    }
                    g.setColor(orgColor);
                    g.setFont(orgFont);
                }
            }

            void drawString(String cellValue, Graphics2D g, double maxColWidth, double maxRowHeight, Font zoomedFont, Color cellBg, Color cellFg, int alignment) {
                FontMetrics fm = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.table.getFontMetrics(zoomedFont);
                int strWidth = GraphicsUtil.stringWidth(zoomedFont, cellValue);
                double strx = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx + 3;
                if (alignment == 11) {
                    strx = (double)((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx + (maxColWidth - (double)strWidth) / 2.0;
                } else if (alignment == 12) {
                    strx = (double)((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx + maxColWidth - 3.0 - (double)strWidth;
                }
                double fontHeight = fm.getHeight();
                double stry = 0.0;
                if (fontHeight < maxRowHeight) {
                    double deltaY = (maxRowHeight - fontHeight) / 2.0;
                    stry = (double)((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy + deltaY + fontHeight / 4.0 * 3.0;
                } else {
                    stry = (double)((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy + maxRowHeight / 4.0 * 3.0;
                }
                Color orgColor = g.getColor();
                Font orgFont = g.getFont();
                g.setFont(zoomedFont);
                g.setColor(cellFg);
                g.drawString(cellValue, (int)strx, (int)stry);
                g.setFont(orgFont);
                g.setColor(orgColor);
            }

            void drawString(AtStringElement cellValue, Graphics2D g, double maxColWidth, double maxRowHeight) {
                Font zoomedFont = TablePage.this.getFont(cellValue.getFont());
                FontMetrics fm = AtStringElement.getFontMetrics(zoomedFont);
                int strWidth = GraphicsUtil.stringWidth(zoomedFont, cellValue.getText());
                int alignment = cellValue.getAlignment();
                double strx = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx + 3;
                if (alignment == 11) {
                    strx = (double)((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx + (maxColWidth - (double)strWidth) / 2.0;
                } else if (alignment == 12) {
                    strx = (double)((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx + maxColWidth - 4.0 - (double)strWidth;
                }
                Color orgColor = g.getColor();
                Font orgFont = g.getFont();
                Stroke orgStroke = g.getStroke();
                double fontHeight = fm.getHeight();
                double stry = 0.0;
                if (fontHeight < maxRowHeight) {
                    double deltaY = (maxRowHeight - fontHeight) / 2.0;
                    stry = (double)((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy + deltaY + fontHeight / 4.0 * 3.0;
                } else {
                    stry = (double)((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy + maxRowHeight / 4.0 * 3.0;
                }
                g.setColor(cellValue.getForeground());
                g.setFont(zoomedFont);
                String cellText = cellValue.getText();
                if (cellText != null && !cellText.equals(TablePage.EMPTY_STRING)) {
                    g.drawString(cellValue.getText(), (int)strx, (int)stry);
                }
                if (cellText != null && !cellText.equals(TablePage.EMPTY_STRING) && cellValue.isUnderlined()) {
                    g.drawLine((int)strx, (int)stry + 1, (int)(strx + (double)strWidth), (int)stry + 1);
                }
                if (cellText != null && !cellText.equals(TablePage.EMPTY_STRING) && cellValue.isStrikeThrough()) {
                    Color strikeThruColor = cellValue.getStrikeThroughColor();
                    if (strikeThruColor == null) {
                        strikeThruColor = SystemColor.blue.darker().darker();
                    }
                    g.setColor(strikeThruColor);
                    double strikeY = stry - (double)(fm.getHeight() / 4);
                    g.drawLine((int)strx, (int)strikeY, (int)(strx + (double)strWidth), (int)strikeY);
                }
                g.setColor(orgColor);
                g.setFont(orgFont);
                g.setStroke(orgStroke);
            }

            void drawIcon(Image icon, Graphics2D g, double maxRowHeight, double maxColWidth, Color cellBg) {
                int iconW = icon.getWidth(null);
                int iconH = icon.getHeight(null);
                iconW = (int)((double)iconW * TablePage.this.getZoom());
                iconH = (int)((double)iconH * TablePage.this.getZoom());
                double x = (double)((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx + (maxColWidth / 2.0 - (double)(iconW / 2));
                double y = (double)((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy + (maxRowHeight / 2.0 - (double)(iconH / 2));
                if (y >= (double)((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy + maxRowHeight) {
                    y = (double)((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy + maxRowHeight - 1.0;
                }
                if (x >= (double)((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx + maxColWidth) {
                    x = (double)((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx + maxColWidth - 1.0;
                }
                g.drawImage(icon, (int)x, (int)y, iconW, iconH, null);
            }

            void drawFromRenderer(Object cellObject, Graphics2D g, double maxRowHeight, double maxColWidth, int row, int col, boolean isHeaderCell, Font zoomedFont, Color cellBg, Color cellFg, int cellAlignment, Component cr) {
                Color orgColor = g.getColor();
                Font orgFont = g.getFont();
                if (cr == null) {
                    AtDebug.debug("TablePage: cell renderer comp null - returning.");
                    return;
                }
                double comph = AtPrintUtil.getCellRendererWidth(((TablePageRenderer)TablePageRenderer.this).TablePage.this.table, row, col, isHeaderCell);
                double compw = AtPrintUtil.getCellRendererHeight(((TablePageRenderer)TablePageRenderer.this).TablePage.this.table, row, col, isHeaderCell);
                comph *= TablePage.this.getZoom();
                compw *= TablePage.this.getZoom();
                if (cr instanceof JLabel) {
                    this.drawJLabel((JLabel)cr, g, compw, comph, maxRowHeight, maxColWidth, isHeaderCell, cellAlignment, zoomedFont, cellBg, cellFg);
                } else if (cr instanceof JToggleButton) {
                    this.drawJToggleButton((JToggleButton)cr, g, compw, comph, maxRowHeight, maxColWidth, isHeaderCell, cellAlignment, zoomedFont, cellBg, cellFg);
                } else {
                    this.drawComponent(g, cr, compw, comph, maxRowHeight, maxColWidth, isHeaderCell, row, col, cellBg, cellFg, cellObject);
                }
                g.setColor(orgColor);
                g.setFont(orgFont);
            }

            void drawComponent(Graphics2D g, Component comp, double compw, double comph, double maxRowHeight, double maxColWidth, boolean isHeaderCell, int row, int col, Color cellBg, Color cellFg, Object cellValue) {
                ((TablePageRenderer)TablePageRenderer.this).TablePage.this.cellBbox.x = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx;
                ((TablePageRenderer)TablePageRenderer.this).TablePage.this.cellBbox.y = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy;
                ((TablePageRenderer)TablePageRenderer.this).TablePage.this.cellBbox.width = (int)maxColWidth;
                ((TablePageRenderer)TablePageRenderer.this).TablePage.this.cellBbox.height = (int)maxRowHeight;
                ((TablePageRenderer)TablePageRenderer.this).TablePage.this.cellBbox.width = (int)TablePage.this.getOptimumCellWidth(((TablePageRenderer)TablePageRenderer.this).TablePage.this.cellBbox, maxColWidth);
                Rectangle cellBounds = (Rectangle)((TablePageRenderer)TablePageRenderer.this).TablePage.this.cellBbox.clone();
                Object cellObject = AtPrintUtil.getCellValue(((TablePageRenderer)TablePageRenderer.this).TablePage.this.table, row, col);
                if (((TablePageRenderer)TablePageRenderer.this).TablePage.this.isUseCellRenderer) {
                    AtElement value = AtPrintUtil.defaultPrintableCell.getContent(((TablePageRenderer)TablePageRenderer.this).TablePage.this.table, row, col, isHeaderCell, cellBounds, TablePage.this.getZoom());
                    if (value instanceof AtStringElement) {
                        AtStringElement strElm = (AtStringElement)value;
                        AtPrintUtil.drawStringElement(strElm, g, (int)maxColWidth, (int)maxRowHeight, ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx, ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy, TablePage.this.getZoom());
                    } else if (value instanceof AtIconElement) {
                        AtPrintUtil.drawIconElement(g, (AtIconElement)value, cellBounds, TablePage.this.getZoom());
                    } else {
                        AtPrintUtil.defaultPrintableCell.draw(g, ((TablePageRenderer)TablePageRenderer.this).TablePage.this.table, cellObject, row, col, isHeaderCell, cellBounds, TablePage.this.getZoom());
                    }
                } else if (((TablePageRenderer)TablePageRenderer.this).TablePage.this.table instanceof PrintableCell && ((PrintableCell)((Object)((TablePageRenderer)TablePageRenderer.this).TablePage.this.table)).getContent(((TablePageRenderer)TablePageRenderer.this).TablePage.this.table, row, col, isHeaderCell, cellBounds, TablePage.this.getZoom()) != null) {
                    AtElement value = ((PrintableCell)((Object)((TablePageRenderer)TablePageRenderer.this).TablePage.this.table)).getContent(((TablePageRenderer)TablePageRenderer.this).TablePage.this.table, row, col, isHeaderCell, cellBounds, TablePage.this.getZoom());
                    if (value instanceof AtStringElement) {
                        AtStringElement strElm = (AtStringElement)value;
                        AtPrintUtil.drawStringElement(strElm, g, (int)maxColWidth, (int)maxRowHeight, ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx, ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy, TablePage.this.getZoom());
                    } else if (value instanceof AtIconElement) {
                        AtPrintUtil.drawIconElement(g, (AtIconElement)value, cellBounds, TablePage.this.getZoom());
                    }
                } else if (((TablePageRenderer)TablePageRenderer.this).TablePage.this.table instanceof PrintableCell) {
                    PrintableCell pc = (PrintableCell)((Object)((TablePageRenderer)TablePageRenderer.this).TablePage.this.table);
                    pc.draw(g, ((TablePageRenderer)TablePageRenderer.this).TablePage.this.table, cellObject, row, col, isHeaderCell, cellBounds, TablePage.this.getZoom());
                } else if (((TablePageRenderer)TablePageRenderer.this).TablePage.this.table instanceof Component) {
                    JTable renderer = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.table;
                    int imgWidth = (int)compw;
                    int imgHeight = (int)comph;
                    renderer.setSize(imgWidth, imgHeight);
                    BufferedImage compImg = new BufferedImage(imgWidth, imgHeight, 2);
                    Graphics2D imgG = compImg.createGraphics();
                    imgG.setColor(SystemColor.white);
                    imgG.fillRect(0, 0, imgWidth, imgHeight);
                    imgG.scale(TablePage.this.getZoom(), TablePage.this.getZoom());
                    renderer.printAll(imgG);
                    int compx = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx + 1;
                    int compy = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy + (int)(maxRowHeight / 2.0 - comph / 2.0);
                    g.drawImage((Image)compImg, compx, compy, ((TablePageRenderer)TablePageRenderer.this).TablePage.this.table);
                } else if (comp != null) {
                    AtPrintUtil.defaultPrintableCell.draw(g, ((TablePageRenderer)TablePageRenderer.this).TablePage.this.table, cellValue, row, col, isHeaderCell, cellBounds, TablePage.this.getZoom());
                }
            }

            void drawJLabel(JLabel comp, Graphics2D g, double compw, double comph, double maxRowHeight, double maxColWidth, boolean isHeaderCell, int cellAlignment, Font zoomedFont, Color cellBg, Color cellFg) {
                String label;
                Color orgColor = g.getColor();
                Font orgFont = g.getFont();
                JLabel labelComp = comp;
                double startx = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx;
                double starty = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy + 3;
                double maxh = comph;
                double maxw = compw;
                if (startx + maxw >= (double)((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx + maxColWidth) {
                    maxw = (double)((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx + maxColWidth - 3.0 - startx;
                }
                if (starty + comph >= (double)((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy + maxRowHeight) {
                    maxh = (double)((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy + maxRowHeight - 3.0 - starty;
                }
                Icon icon = labelComp.getIcon();
                double labelycenter = starty + maxh / 2.0;
                if (icon != null && icon instanceof ImageIcon) {
                    ImageIcon imageIcon = (ImageIcon)icon;
                    Image image = imageIcon.getImage();
                    double iconw = icon.getIconWidth();
                    double iconh = icon.getIconHeight();
                    double iconx = startx + 3.0;
                    double icony = starty + (maxh - iconh) / 2.0;
                    g.drawImage(image, (int)iconx, (int)icony, (int)(iconw *= TablePage.this.getZoom()), (int)(iconh *= TablePage.this.getZoom()), ((TablePageRenderer)TablePageRenderer.this).TablePage.this.table);
                    startx = (int)(iconx + iconw);
                    labelycenter = (int)(icony + iconh / 2.0);
                }
                if ((label = labelComp.getText()) != null && label.length() > 0) {
                    FontMetrics tfm = comp.getFontMetrics(zoomedFont);
                    double labelybase = labelycenter + (double)(tfm.getHeight() / 4);
                    g.setFont(zoomedFont);
                    g.setColor(cellFg);
                    g.drawString(label, (float)(startx + 3.0), (float)labelybase);
                }
                g.setFont(orgFont);
                g.setColor(orgColor);
            }

            void drawJToggleButton(JToggleButton comp, Graphics2D g, double compw, double comph, double maxRowHeight, double maxColWidth, boolean isHeaderCell, int cellAlignment, Font zoomedFont, Color cellBg, Color cellFg) {
                Color orgColor = g.getColor();
                Font orgFont = g.getFont();
                double startx = (double)((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx + (maxColWidth - compw) / 2.0;
                if (startx - 3.0 <= (double)((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx) {
                    startx = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx + 3;
                }
                double starty = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy + 3;
                double maxh = comph;
                double maxw = compw;
                if (startx + maxw >= (double)((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx + maxColWidth) {
                    maxw = (double)((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx + maxColWidth - 3.0 - startx;
                }
                if (starty + comph >= (double)((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy + maxRowHeight) {
                    maxh = (double)((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy + maxRowHeight - 3.0 - starty;
                }
                Icon icon = comp.getIcon();
                double labelycenter = starty + maxh / 2.0;
                if (icon != null && icon instanceof ImageIcon) {
                    ImageIcon imageIcon = (ImageIcon)icon;
                    Image image = imageIcon.getImage();
                    double iconw = icon.getIconWidth();
                    double iconh = icon.getIconHeight();
                    double iconx = startx + 3.0;
                    double icony = starty + (maxh - iconh) / 2.0;
                    double icon_paintw = iconw - 3.0;
                    double icon_painth = iconh - 3.0;
                    g.drawImage(image, (int)iconx, (int)icony, (int)icon_paintw, (int)icon_painth, ((TablePageRenderer)TablePageRenderer.this).TablePage.this.table);
                    startx = iconx + icon_paintw + 3.0;
                    labelycenter = icony + icon_painth / 2.0;
                } else {
                    String label = F;
                    if (comp.isSelected()) {
                        label = T;
                    }
                    FontMetrics tfm = ((TablePageRenderer)TablePageRenderer.this).TablePage.this.table.getFontMetrics(((TablePageRenderer)TablePageRenderer.this).TablePage.this.table.getFont());
                    double labelybase = labelycenter + (double)(tfm.getHeight() / 4);
                    g.setColor(cellFg);
                    g.setFont(zoomedFont);
                    g.drawString(label, (float)(startx + 3.0), (float)labelybase);
                }
                g.setFont(orgFont);
                g.setColor(orgColor);
            }

            ElementDescriptor getElementDescriptor(Object cellObject, Font zoomedFont, FontMetrics elmFm, Color elmForeground, Color elmBackground, double maxWidth, double maxHeight, boolean isDrawCellBorder, boolean isHeaderCell, int row, int col, int cellAlignment, Component cr) {
                StringTableElementDescriptor strElm;
                StringTableElementDescriptor strElm2;
                ComponentTableElementDescriptor tableElm;
                ElementDescriptor elm = null;
                if (((TablePageRenderer)TablePageRenderer.this).TablePage.this.isUseCellRenderer) {
                    tableElm = new ComponentTableElementDescriptor(cellObject, 3, zoomedFont, elmFm, this.elmAttrSet, TablePage.this.isUseCellRenderer());
                    tableElm.setWidth((float)maxWidth);
                    tableElm.setHeight((float)maxHeight);
                    tableElm.setRow(row);
                    tableElm.setColumn(col);
                    tableElm.setIsHeaderCell(isHeaderCell);
                    tableElm.setTable(((TablePageRenderer)TablePageRenderer.this).TablePage.this.table);
                    if (TablePage.this.isFitSmallerTableToPageWidth()) {
                        tableElm.setZoom(1.0);
                    } else {
                        tableElm.setZoom(TablePage.this.getZoom());
                    }
                    tableElm.setX(((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx);
                    tableElm.setY(((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy);
                    elm = tableElm;
                } else if (((TablePageRenderer)TablePageRenderer.this).TablePage.this.table != null && ((TablePageRenderer)TablePageRenderer.this).TablePage.this.table instanceof PrintableCell) {
                    tableElm = new ComponentTableElementDescriptor(cellObject, 3, zoomedFont, elmFm, this.elmAttrSet, TablePage.this.isUseCellRenderer());
                    tableElm.setWidth((float)maxWidth);
                    tableElm.setHeight((float)maxHeight);
                    tableElm.setRow(row);
                    tableElm.setColumn(col);
                    tableElm.setIsHeaderCell(isHeaderCell);
                    tableElm.setTable(((TablePageRenderer)TablePageRenderer.this).TablePage.this.table);
                    if (TablePage.this.isFitSmallerTableToPageWidth()) {
                        tableElm.setZoom(1.0);
                    } else {
                        tableElm.setZoom(TablePage.this.getZoom());
                    }
                    tableElm.setX(((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx);
                    tableElm.setY(((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy);
                    elm = tableElm;
                } else if (cellObject == null) {
                    Component rendererComp = cr;
                    if (rendererComp == null) {
                        strElm2 = new StringTableElementDescriptor(" ", 1, zoomedFont, elmFm, this.elmAttrSet, cellAlignment);
                        strElm2.addStyle("Font", zoomedFont);
                        strElm2.addStyle("ForegroundColor", elmForeground);
                        strElm2.addStyle("BackgroundColor", elmBackground);
                        if (TablePage.this.isFitSmallerTableToPageWidth()) {
                            strElm2.setZoom(1.0);
                        } else {
                            strElm2.setZoom(TablePage.this.getZoom());
                        }
                        elm = strElm2;
                    } else {
                        ComponentTableElementDescriptor tableElm2 = new ComponentTableElementDescriptor(cellObject, 3, zoomedFont, elmFm, this.elmAttrSet, TablePage.this.isUseCellRenderer());
                        tableElm2.setWidth((float)maxWidth);
                        tableElm2.setHeight((float)maxHeight);
                        tableElm2.setRow(row);
                        tableElm2.setColumn(col);
                        tableElm2.setIsHeaderCell(isHeaderCell);
                        tableElm2.setTable(((TablePageRenderer)TablePageRenderer.this).TablePage.this.table);
                        if (TablePage.this.isFitSmallerTableToPageWidth()) {
                            tableElm2.setZoom(1.0);
                        } else {
                            tableElm2.setZoom(TablePage.this.getZoom());
                        }
                        tableElm2.setX(((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx);
                        tableElm2.setY(((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy);
                        elm = tableElm2;
                    }
                } else if (cellObject instanceof Number) {
                    String numberCellValue = null;
                    if (cellObject != null && cellObject instanceof Number) {
                        numberCellValue = cellObject.toString();
                    }
                    strElm2 = new StringTableElementDescriptor(numberCellValue, 1, zoomedFont, elmFm, this.elmAttrSet, cellAlignment);
                    strElm2.addStyle("Font", zoomedFont);
                    strElm2.addStyle("ForegroundColor", elmForeground);
                    strElm2.addStyle("BackgroundColor", elmBackground);
                    strElm2.setTable(((TablePageRenderer)TablePageRenderer.this).TablePage.this.table);
                    if (TablePage.this.isFitSmallerTableToPageWidth()) {
                        strElm2.setZoom(1.0);
                    } else {
                        strElm2.setZoom(TablePage.this.getZoom());
                    }
                    strElm2.setX(((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx);
                    strElm2.setY(((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy);
                    elm = strElm2;
                } else if (cellObject instanceof String) {
                    strElm = new StringTableElementDescriptor(cellObject, 1, zoomedFont, elmFm, this.elmAttrSet, cellAlignment);
                    strElm.addStyle("Font", zoomedFont);
                    strElm.addStyle("ForegroundColor", elmForeground);
                    strElm.addStyle("BackgroundColor", elmBackground);
                    strElm.setTable(((TablePageRenderer)TablePageRenderer.this).TablePage.this.table);
                    if (TablePage.this.isFitSmallerTableToPageWidth()) {
                        strElm.setZoom(1.0);
                    } else {
                        strElm.setZoom(TablePage.this.getZoom());
                    }
                    strElm.setX(((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx);
                    strElm.setY(((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy);
                    elm = strElm;
                } else if (cellObject instanceof ImageIcon) {
                    Image image = ((ImageIcon)cellObject).getImage();
                    IconTableElementDescriptor iconElm = new IconTableElementDescriptor(image, 2, zoomedFont, elmFm, this.elmAttrSet);
                    this.setIconElementProperties(iconElm, image, (int)maxWidth, (int)maxHeight);
                    elm = iconElm;
                } else if (cellObject instanceof Image) {
                    IconTableElementDescriptor iconElm = new IconTableElementDescriptor(cellObject, 2, zoomedFont, elmFm, this.elmAttrSet);
                    this.setIconElementProperties(iconElm, (Image)cellObject, (int)maxWidth, (int)maxHeight);
                    elm = iconElm;
                } else if (cellObject instanceof Component) {
                    tableElm = new ComponentTableElementDescriptor(cellObject, 3, zoomedFont, elmFm, this.elmAttrSet, TablePage.this.isUseCellRenderer());
                    tableElm.setWidth((float)maxWidth);
                    tableElm.setHeight((float)maxHeight);
                    tableElm.setRow(row);
                    tableElm.setColumn(col);
                    tableElm.setIsHeaderCell(isHeaderCell);
                    tableElm.setTable(((TablePageRenderer)TablePageRenderer.this).TablePage.this.table);
                    if (TablePage.this.isFitSmallerTableToPageWidth()) {
                        tableElm.setZoom(1.0);
                    } else {
                        tableElm.setZoom(TablePage.this.getZoom());
                    }
                    tableElm.setX(((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx);
                    tableElm.setY(((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy);
                    elm = tableElm;
                } else if (cr == null) {
                    strElm = new StringTableElementDescriptor(" ", 1, zoomedFont, elmFm, this.elmAttrSet, cellAlignment);
                    strElm.addStyle("Font", zoomedFont);
                    strElm.addStyle("ForegroundColor", elmForeground);
                    strElm.addStyle("BackgroundColor", elmBackground);
                    strElm.setTable(((TablePageRenderer)TablePageRenderer.this).TablePage.this.table);
                    if (TablePage.this.isFitSmallerTableToPageWidth()) {
                        strElm.setZoom(1.0);
                    } else {
                        strElm.setZoom(TablePage.this.getZoom());
                    }
                    strElm.setX(((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx);
                    strElm.setY(((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy);
                    elm = strElm;
                } else {
                    tableElm = new ComponentTableElementDescriptor(cellObject, 3, zoomedFont, elmFm, this.elmAttrSet, TablePage.this.isUseCellRenderer());
                    tableElm.setWidth((float)maxWidth);
                    tableElm.setHeight((float)maxHeight);
                    tableElm.setRow(row);
                    tableElm.setColumn(col);
                    tableElm.setIsHeaderCell(isHeaderCell);
                    tableElm.setTable(((TablePageRenderer)TablePageRenderer.this).TablePage.this.table);
                    if (TablePage.this.isFitSmallerTableToPageWidth()) {
                        tableElm.setZoom(1.0);
                    } else {
                        tableElm.setZoom(TablePage.this.getZoom());
                    }
                    tableElm.setX(((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx);
                    tableElm.setY(((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy);
                    elm = tableElm;
                }
                if (elm != null) {
                    elm.setX(((TablePageRenderer)TablePageRenderer.this).TablePage.this.sx);
                    elm.setY(((TablePageRenderer)TablePageRenderer.this).TablePage.this.sy);
                    elm.setWidth((float)maxWidth);
                    elm.setHeight((float)maxHeight);
                    elm.setDrawBorder(isDrawCellBorder);
                    elm.setFont(zoomedFont);
                    elm.addStyle("Font", zoomedFont);
                    if (cr != null) {
                        FontMetrics zoomedFm = cr.getFontMetrics(zoomedFont);
                        elm.setFontMetrics(zoomedFm);
                        Color bg = cr.getBackground();
                        Color fg = cr.getForeground();
                        if (bg != null) {
                            elm.addStyle("BackgroundColor", bg);
                        }
                        if (fg != null) {
                            elm.addStyle("ForegroundColor", fg);
                        }
                    }
                    elm.setBorderColor(((TablePageRenderer)TablePageRenderer.this).TablePage.this.table.getGridColor());
                }
                return elm;
            }

            void setIconElementProperties(IconTableElementDescriptor iconElm, Image icon, int cellWidth, int cellHeight) {
                iconElm.setTable(((TablePageRenderer)TablePageRenderer.this).TablePage.this.table);
                if (TablePage.this.isFitSmallerTableToPageWidth()) {
                    iconElm.setZoom(1.0);
                } else {
                    iconElm.setZoom(TablePage.this.getZoom());
                }
                iconElm.setWidth(cellWidth);
                iconElm.setHeight(cellHeight);
            }

            void drawCellBackground(Color cellBg, Graphics2D g, double sx, double sy, double cellWidth, double cellHeight) {
                if (cellBg == null) {
                    return;
                }
                if (cellBg.getRed() == 255 && cellBg.getGreen() == 255 && cellBg.getBlue() == 255) {
                    return;
                }
                Color orgColor = g.getColor();
                Color drvBgColor = cellBg;
                g.setColor(drvBgColor);
                g.fill(new Rectangle2D.Double(sx, sy, cellWidth, cellHeight));
                g.setColor(orgColor);
            }
        }
    }
}

