/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.report.printer;

import com.activetree.common.media.AtMediaSizeObject;
import com.activetree.common.media.StandardPapers;
import com.activetree.common.print.AbstractPrinter;
import com.activetree.common.print.dialog.AtPrintDialog;
import com.activetree.common.print.dialog.PaperSelectionDialog;
import com.activetree.common.report.AtPreviewFrame;
import com.activetree.common.report.PageHeaderFooterListener;
import com.activetree.common.report.page.AbstractReportPage;
import com.activetree.common.resource.AtCommonResource;
import com.activetree.common.utils.AtComponentUtil;
import com.activetree.common.utils.AtDebug;
import com.activetree.common.utils.MediaUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.geom.Rectangle2D;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.Serializable;
import java.util.Vector;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.Sides;
import javax.swing.JFrame;

public abstract class AbstractReportPrinter
extends AbstractPrinter
implements Serializable {
    protected String title = AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_PREVIEW");
    public static final int PRINT = 1;
    public static final int PREVIEW = 2;
    public static final int MARGIN = 6;
    protected AtPreviewFrame previewWindow;
    protected Book book = null;
    protected PageFormat pageFormat = new PageFormat();
    protected PrinterJob printer = null;
    protected Vector previewPages = new Vector();
    protected Dimension previewPaneSize = new Dimension(780, 500);
    protected AbstractReportPrinter printerClass;
    protected Object objectToPrint;
    protected PageHeaderFooterListener headerFooterListener;
    protected PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
    protected int tabSize = 8;
    private PrintProvider printProvider = new PrintProvider();
    protected AtPrintDialog printDialog = null;
    protected PaperSelectionDialog paperDialog = null;
    private boolean isUseCellRenderer = false;

    public AbstractReportPrinter() {
        try {
            this.printer = PrinterJob.getPrinterJob();
        }
        catch (Throwable t) {
            AtDebug.debug(9, t);
        }
        this.pageFormat = new PageFormat();
        this.printerClass = this;
    }

    public boolean isUseCellRenderer() {
        return this.isUseCellRenderer;
    }

    public void setUseCellRenderer(boolean useCellRenderer) {
        this.isUseCellRenderer = useCellRenderer;
    }

    public void setTabSize(int tabSize) {
        this.tabSize = tabSize;
    }

    public int getTabSize() {
        return this.tabSize;
    }

    protected void copyAttributes(AbstractPrinter anotherPrinter) {
        super.copyAttributes(anotherPrinter);
        if (anotherPrinter instanceof AbstractReportPrinter) {
            AbstractReportPrinter p = (AbstractReportPrinter)anotherPrinter;
            p.title = this.title;
            p.previewWindow = this.previewWindow;
            p.book = this.book;
            p.pageFormat = this.pageFormat;
            p.printer = this.printer;
            p.previewPages = this.previewPages;
            p.previewPaneSize = this.previewPaneSize;
            p.pageNoLocation = this.pageNoLocation;
            p.printerClass = this.printerClass;
            p.objectToPrint = this.objectToPrint;
            p.headerFooterListener = this.headerFooterListener;
            p.printService = this.printService;
            p.owner = this.owner;
        }
    }

    public void close() {
        this.objectToPrint = null;
        this.printerClass = null;
        this.headerFooterListener = null;
        this.previewWindow = null;
        this.book = null;
        if (this.previewPages != null) {
            this.previewPages.clear();
        }
        this.owner = null;
    }

    protected abstract Vector createPages(int var1);

    public abstract Pageable getPageable(Object var1);

    public abstract Pageable getPageable(Object var1, int var2);

    public void zoomIn() {
        this.zoom += 0.05;
        AtDebug.debug("zoomIn()...new zoom=" + this.zoom);
    }

    public void zoomOut() {
        this.zoom -= 0.05;
        AtDebug.debug("zoomOut()...new zoom=" + this.zoom);
    }

    public void setPrintService(PrintService defaultPrintService) {
        if (defaultPrintService == null) {
            throw new NullPointerException(AtCommonResource.MESSAGE_RESOURCE.getText("SETTING_NULL_PRINT_SERVICE"));
        }
        this.printService = defaultPrintService;
        if (this.printer != null) {
            try {
                this.printer.setPrintService(defaultPrintService);
            }
            catch (Throwable t) {
                throw new RuntimeException(t.getMessage());
            }
        }
    }

    public PrintService getPrintService() {
        return this.printService;
    }

    public void setPageHeaderFooterListener(PageHeaderFooterListener headerFooterListener) {
        this.headerFooterListener = headerFooterListener;
    }

    public PageHeaderFooterListener getHeaderFooterListener() {
        return this.headerFooterListener;
    }

    public Object getPrintObject() {
        return this.objectToPrint;
    }

    public void setPrintObject(Object objToPrint) {
        this.objectToPrint = objToPrint;
    }

    protected void createPreviewWindow(Component owner) {
        this.previewWindow = owner instanceof Dialog ? new AtPreviewFrame(this.toArray(), this.getPreviewPaneTitle(), this.printerClass) : (owner instanceof Frame ? new AtPreviewFrame(this.toArray(), this.getPreviewPaneTitle(), this.printerClass) : new AtPreviewFrame(this.toArray(), this.getPreviewPaneTitle(), this.printerClass));
        JFrame frame = this.previewWindow.getFrame();
        if (frame != null) {
            frame.setSize(this.getPreviewPaneSize());
        }
        AtComponentUtil.centerOnScreen(this.previewWindow);
    }

    public AtPreviewFrame getPreviewWindow() {
        return this.previewWindow;
    }

    public boolean showPrintSetup() {
        return this.printProvider.theProvider.showPrintSetup(true, false);
    }

    public boolean showPrintSetup(boolean showPageDialog) {
        return this.printProvider.theProvider.showPrintSetup(false, showPageDialog);
    }

    public boolean showPrintSetup(PrintRequestAttributeSet pAttrs, PageFormat customPageFormat, boolean showPrintSetupDialog, boolean showSetupDialog) {
        return this.printProvider.theProvider.showPrintSetup(pAttrs, customPageFormat, showPrintSetupDialog, showSetupDialog, true);
    }

    public boolean showPrintSetup(PrintRequestAttributeSet pAttrs, PageFormat customPageFormat, boolean showPrintDialog, boolean showPageDialog, boolean printerSelectionEnabled) {
        return this.printProvider.theProvider.showPrintSetup(pAttrs, customPageFormat, showPrintDialog, showPageDialog, printerSelectionEnabled);
    }

    public AbstractReportPage[] toArray() {
        return this.printProvider.theProvider.toArray();
    }

    public void setPreviewPaneSize(Dimension d) {
        this.previewPaneSize = d;
    }

    public Dimension getPreviewPaneSize() {
        return this.previewPaneSize;
    }

    public void setPreviewPaneTitle(String title) {
        this.title = title;
    }

    public String getPreviewPaneTitle() {
        return this.title;
    }

    public void setPageFormat(PageFormat newPageFormat) {
        if (newPageFormat == null) {
            throw new NullPointerException("Null PageFormat passed as argument.");
        }
        this.pageFormat = newPageFormat;
    }

    public PageFormat getPageFormat() {
        PageFormat clonedPf = MediaUtil.getClonedPageFormat(this.pageFormat);
        return clonedPf;
    }

    public Book getBook() {
        return this.book;
    }

    public void setBook(Book book) {
        this.book = book;
    }

    public Vector getPreviewPages() {
        return this.previewPages;
    }

    public void setPreviewPages(Vector previewPages) {
        this.previewPages = previewPages;
    }

    public PrinterJob getPrinterJob() {
        if (this.printer == null) {
            this.printer = PrinterJob.getPrinterJob();
        }
        return this.printer;
    }

    public void setPrinterJob(PrinterJob newPrinterJob) {
        this.printer = newPrinterJob;
    }

    public AtPrintDialog createPrinterDialog(MediaSizeName defaultMedia, PageFormat selectedPageFormat) {
        String title = AtCommonResource.MESSAGE_RESOURCE.getText("PRINT_SETUP_CMD");
        if (this.printDialog == null) {
            boolean modal = true;
            AtCommonResource.MESSAGE_RESOURCE.getText("DISCOVERED_PRINTERS");
            boolean showAllPapers = false;
            boolean printerSelectionEnabled = true;
            if (!(this.owner instanceof Frame && this.owner instanceof Dialog || this.owner == null)) {
                this.owner = AtComponentUtil.getWindowForComponent(this.owner);
            }
            this.printDialog = this.owner instanceof Frame ? new AtPrintDialog((Frame)this.owner, title, modal, showAllPapers, printerSelectionEnabled, defaultMedia) : (this.owner instanceof Dialog ? new AtPrintDialog((Dialog)this.owner, title, modal, showAllPapers, printerSelectionEnabled, defaultMedia) : new AtPrintDialog((Frame)null, title, modal, showAllPapers, printerSelectionEnabled, defaultMedia));
            this.printDialog.setPrintRequestAttributeSet(this.pAttrs);
            this.printDialog.setPrintServiceSelected(this.getPrintService());
            this.printDialog.setSelectedMedia(selectedPageFormat);
            this.printDialog.setCopies(this.getCopies());
            this.printDialog.setPrintJobName(this.getJobName());
            this.printDialog.setPrintRangeOfPagesEnabled(false);
            this.printDialog.setPrintCurrentPageEnabled(false);
            this.printDialog.setFitToPage(false);
            this.printDialog.getPageHandlingPane().setFitToPageVisible(false);
            this.printDialog.setChoosePaperSourceByPageSizeVisible(false);
            this.printDialog.getPageHandlingPane().getPageScalingLabel().setVisible(false);
            this.printDialog.getPageHandlingPane().getPageScalingCombo().setVisible(false);
            this.printDialog.getPageHandlingPane().getAutoRotateAndCenterCheck().setVisible(false);
        } else {
            this.printDialog.refresh();
        }
        if (this.owner instanceof Container) {
            AtComponentUtil.centerOnContainer((Container)this.owner, this.printDialog);
        }
        return this.printDialog;
    }

    public PaperSelectionDialog createPageDialog(MediaSizeName defaultMedia) {
        if (this.paperDialog == null) {
            boolean modal = true;
            if (!(this.owner instanceof Frame && this.owner instanceof Dialog || this.owner == null)) {
                this.owner = AtComponentUtil.getWindowForComponent(this.owner);
            }
            String title = AtCommonResource.MESSAGE_RESOURCE.getText("PaperSelection");
            this.paperDialog = this.owner instanceof Frame ? new PaperSelectionDialog((Frame)this.owner, title, modal, defaultMedia) : (this.owner instanceof Dialog ? new PaperSelectionDialog((Dialog)this.owner, title, modal, defaultMedia) : new PaperSelectionDialog((Frame)null, title, modal, defaultMedia));
            if (this.owner instanceof Container) {
                AtComponentUtil.centerOnContainer((Container)this.owner, this.paperDialog);
            }
        } else {
            this.paperDialog.refresh();
        }
        if (this.owner instanceof Container) {
            AtComponentUtil.centerOnContainer((Container)this.owner, this.paperDialog);
        }
        if (this.owner instanceof Container) {
            AtComponentUtil.centerOnContainer((Container)this.owner, this.paperDialog);
        }
        return this.paperDialog;
    }

    void initPageFormat(PageFormat customPageFormat, int pageNoLocation) {
        if (customPageFormat != null) {
            this.setPageFormat(customPageFormat);
        }
        if (this.getPageFormat() == null) {
            this.setPageFormat(new PageFormat());
        }
        this.setPageNumberLocation(pageNoLocation);
    }

    class PrintProvider
    implements Serializable {
        TheProvider theProvider = new TheProvider();

        PrintProvider() {
        }

        class TheProvider
        implements Serializable {
            TheProvider() {
            }

            boolean showPrintSetup(boolean showPrintDialog, boolean showPageDialog) {
                HashPrintRequestAttributeSet pAttrs = new HashPrintRequestAttributeSet();
                return this.showPrintSetup(pAttrs, null, showPrintDialog, showPageDialog, true);
            }

            AbstractReportPage[] toArray() {
                if (((PrintProvider)PrintProvider.this).AbstractReportPrinter.this.previewPages == null || ((PrintProvider)PrintProvider.this).AbstractReportPrinter.this.previewPages.size() == 0) {
                    return null;
                }
                AbstractReportPage[] pages = new AbstractReportPage[((PrintProvider)PrintProvider.this).AbstractReportPrinter.this.previewPages.size()];
                for (int i = 0; i < ((PrintProvider)PrintProvider.this).AbstractReportPrinter.this.previewPages.size(); ++i) {
                    pages[i] = (AbstractReportPage)((PrintProvider)PrintProvider.this).AbstractReportPrinter.this.previewPages.get(i);
                }
                return pages;
            }

            boolean showPrintSetup(PrintRequestAttributeSet pAttrs, PageFormat customPageFormat, boolean showPrintSetupDialog, boolean showPageSetupDialog, boolean isPrinting) {
                boolean okPressed;
                int orientation;
                double h;
                double w;
                Rectangle2D.Double paperArea;
                AtMediaSizeObject mso;
                AbstractReportPrinter.this.setPrintRequestAttributeSet(pAttrs);
                MediaSizeName defaultMedia = null;
                if (customPageFormat != null && (mso = StandardPapers.getMatchedMediaSizeObject(paperArea = new Rectangle2D.Double(0.0, 0.0, w = customPageFormat.getPaper().getWidth(), h = customPageFormat.getPaper().getHeight()), 0.0, 0.0, orientation = 1)) != null) {
                    defaultMedia = mso.getMediaSizeName();
                }
                if (showPrintSetupDialog) {
                    AtPrintDialog printDialog = AbstractReportPrinter.this.createPrinterDialog(defaultMedia, customPageFormat);
                    if (printDialog == null) {
                        return false;
                    }
                    okPressed = printDialog.showPrintDialog(true, false);
                    if (!okPressed) {
                        return false;
                    }
                    PageFormat userPf = printDialog.getSelectedPageFormat();
                    int copies = printDialog.getCopies();
                    boolean isCollate = printDialog.isCollate();
                    String printJobName = printDialog.getPrintJobName();
                    PrintService userPrintService = printDialog.getSelectedPrintService();
                    PrintQuality newPrintQuality = printDialog.getPrintQuality();
                    Sides newMediaSide = printDialog.getSideToPrint();
                    PrintRequestAttributeSet currPSet = AbstractReportPrinter.this.getPrintRequestAttributeSet();
                    AbstractReportPrinter.this.setPrintQuality(newPrintQuality);
                    AbstractReportPrinter.this.setSideToPrint(newMediaSide);
                    PrintRequestAttributeSet newPSet = AbstractReportPrinter.this.getModifiedPrintAttributeSet(currPSet);
                    AbstractReportPrinter.this.setPrintRequestAttributeSet(newPSet);
                    AbstractReportPrinter.this.setPrintService(userPrintService);
                    AbstractReportPrinter.this.setPageFormat(userPf);
                    AbstractReportPrinter.this.setCopies(copies);
                    AbstractReportPrinter.this.setCollate(isCollate);
                    AbstractReportPrinter.this.setJobName(printJobName);
                    if (((PrintProvider)PrintProvider.this).AbstractReportPrinter.this.printerClass != null) {
                        boolean isFitToPageWidth = printDialog.isFitToPage();
                        ((PrintProvider)PrintProvider.this).AbstractReportPrinter.this.printerClass.setFitToPageWidth(isFitToPageWidth);
                    }
                }
                if (!showPrintSetupDialog && showPageSetupDialog) {
                    PaperSelectionDialog paperDialog = AbstractReportPrinter.this.createPageDialog(defaultMedia);
                    if (paperDialog == null) {
                        return false;
                    }
                    okPressed = paperDialog.showPageDialog(true);
                    if (!okPressed) {
                        return false;
                    }
                    PageFormat pf = paperDialog.getSelectedPageFormat();
                    AbstractReportPrinter.this.setPageFormat(pf);
                }
                if (((PrintProvider)PrintProvider.this).AbstractReportPrinter.this.printer == null) {
                    try {
                        ((PrintProvider)PrintProvider.this).AbstractReportPrinter.this.printer = PrinterJob.getPrinterJob();
                    }
                    catch (Throwable t) {
                        AtDebug.debug(7, "WARNING! -- No printer installed yet.");
                        AtDebug.debug(7, t);
                    }
                }
                if (((PrintProvider)PrintProvider.this).AbstractReportPrinter.this.printer == null || ((PrintProvider)PrintProvider.this).AbstractReportPrinter.this.printer != null && ((PrintProvider)PrintProvider.this).AbstractReportPrinter.this.printer.getPrintService() == null) {
                    PrinterException pe = new PrinterException(AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_NO_PRINT_SERVICE"));
                    AtDebug.debug(9, pe);
                }
                try {
                    ((PrintProvider)PrintProvider.this).AbstractReportPrinter.this.printer.setJobName(AbstractReportPrinter.this.getJobName());
                    ((PrintProvider)PrintProvider.this).AbstractReportPrinter.this.printer.setPrintService(AbstractReportPrinter.this.getPrintService());
                }
                catch (Throwable ex) {
                    // empty catch block
                }
                return true;
            }
        }
    }
}

