/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.report.shape;

import com.activetree.common.report.shape.ShapeSourceInterface;
import com.activetree.common.resource.AtCommonResource;
import com.activetree.common.utils.GraphicsUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public abstract class AbstractShape2D
extends JPanel {
    public static final int MARGIN = 12;
    protected JScrollPane scroll;
    protected Shape shape;
    protected AffineTransform at = new AffineTransform();
    protected Dimension orgSize;
    protected Dimension size;
    protected String fontFamily = "Times New Roman";
    protected int fontSize = 80;
    protected int fontStyle = 0;
    protected Font font;
    protected boolean firsttime = true;
    protected Color textColor = new Color(255, 204, 204, 255);
    protected Color gradBeginColor = Color.getHSBColor(0.2f, 0.4f, 0.85f);
    protected Color gradEndColor = Color.getHSBColor(0.2f, 0.4f, 0.85f);
    protected boolean antiAliased = true;
    protected ShapeSourceInterface shapeSource;
    protected String text = AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_SMART_JPRINT");
    protected Graphics2D g2d;
    protected int w;
    protected int h;
    protected int fh;
    protected int closeStyle;
    protected String paintName;
    protected AffineTransform orgTransform;
    protected Stroke oldStroke;
    protected Paint oldPaint;

    public AbstractShape2D(ShapeSourceInterface shapeSource, Dimension size, String text) {
        this.shapeSource = shapeSource;
        this.orgSize = new Dimension(size.width, size.height);
        this.size = size;
        this.text = text;
        this.font = new Font(this.fontFamily, 0, this.fontSize);
        this.setBackground(Color.white);
        this.createScrollPane();
    }

    public abstract void createScrollPane();

    public abstract void recreateShape();

    public void setFontFamily(String newFontFamily) {
        this.fontFamily = newFontFamily;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int newSize) {
        this.fontSize = newSize;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(int fontStyle) {
        this.fontStyle = fontStyle;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public Color getGradientBeginColor() {
        return this.gradBeginColor;
    }

    public void setGradientBeginColor(Color gradEndColor) {
        this.gradBeginColor = gradEndColor;
    }

    public Color getGradientEndColor() {
        return this.gradEndColor;
    }

    public void setGradientEndColor(Color gradEndColor) {
        this.gradEndColor = gradEndColor;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Dimension getMinimumSize() {
        return this.size;
    }

    public Dimension getPreferredSize() {
        return this.size;
    }

    public boolean isAntiAliased() {
        return this.antiAliased;
    }

    public void setAntiAliased(boolean antiAliased) {
        this.antiAliased = antiAliased;
    }

    public void resetSize() {
        Shape ts = this.at.createTransformedShape(this.shape);
        Rectangle r = ts.getBounds();
        this.size.width = r.width + 200;
        this.size.height = r.height + 200;
    }

    public void setNewSize(Dimension d) {
        this.size.width = d.width;
        this.size.height = d.height;
    }

    public void paint(Graphics g) {
        this.g2d = (Graphics2D)g;
        if (this.isAntiAliased()) {
            GraphicsUtil.applyAntiAlias(g);
        }
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.w = this.getSize().width;
        this.h = this.getSize().height;
        if (this.firsttime) {
            this.identity();
            this.firsttime = false;
        }
        this.g2d.setStroke(this.shapeSource.getCurrentStroke());
        this.fh = this.getFontMetrics(this.font).getHeight();
        this.paintName = this.shapeSource.getCurrentPaint();
        Color bg1 = this.getGradientBeginColor();
        if (this.paintName.equals(AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_Normal"))) {
            this.g2d.setPaint(this.getTextColor());
        } else if (this.paintName.equals(AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_Gradient"))) {
            GradientPaint gp = new GradientPaint(0.0f, 0.0f, this.getGradientBeginColor(), this.w, this.h, this.getGradientEndColor(), false);
            this.g2d.setPaint(gp);
        } else if (this.paintName.equals(AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_Texture"))) {
            Color paintToApply = this.getTextColor();
            BufferedImage img = new BufferedImage(2, 2, 1);
            Graphics2D imgG = img.createGraphics();
            imgG.setColor(bg1);
            imgG.fillRect(0, 0, 3, 3);
            imgG.setColor(paintToApply);
            imgG.fillOval(0, 0, 3, 3);
            Rectangle rect = new Rectangle(0, 0, 3, 3);
            this.g2d.setPaint(new TexturePaint(img, rect));
        }
    }

    public void setTransform(Shape shape) {
        Rectangle r = shape.getBounds();
        AffineTransform newAt = new AffineTransform();
        newAt.concatenate(this.at);
        newAt.translate(-(r.x + r.width / 2), -(r.y + r.height / 2));
        this.g2d.transform(newAt);
    }

    public void identity() {
        this.at.setToIdentity();
        this.at.translate(this.w / 2, this.h / 2);
        if (this.shapeSource.getScroller() != null) {
            this.scroll.updateUI();
        }
    }

    public void rotate(int deg) {
        this.at.rotate(Math.toRadians(deg));
    }

    public void scale(double dx, double dy) {
        this.at.scale(dx, dy);
    }

    public void shear(double dx, double dy) {
        this.at.shear(dx, dy);
    }

    public void drawShape() {
        String fillingStyle = this.shapeSource.getCurrentFilling();
        if (fillingStyle.equals(AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_Draw"))) {
            this.g2d.draw(this.shape);
        } else if (fillingStyle.equals(AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_Fill"))) {
            this.g2d.fill(this.shape);
        } else if (fillingStyle.equals(AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_DRAW_AND_FILL"))) {
            this.g2d.fill(this.shape);
            this.g2d.setColor(this.getTextColor());
            this.g2d.draw(this.shape);
        }
    }

    public JScrollPane getScrollPane() {
        return this.scroll;
    }

    public Font getTextFont() {
        return this.font;
    }

    public void setTextFont(Font newFont) {
        this.font = newFont;
    }
}

