/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.resource;

import com.activetree.common.utils.AtDebug;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class BaseResource
implements Serializable {
    protected final String delimiter = "|";
    protected ResourceBundle bundle;

    public BaseResource(Locale locale, String resourceName) {
        this.bundle = this.loadResourceBundle(resourceName, locale);
        if (this.bundle == null) {
            locale = new Locale(Locale.ENGLISH.getLanguage());
            this.bundle = this.loadResourceBundle(resourceName, locale);
        }
    }

    protected ResourceBundle loadResourceBundle(String resourceFile, Locale locale) {
        ResourceBundle resBundle = null;
        try {
            resBundle = this.tryLoadLocally(resourceFile, locale);
            if (resBundle == null) {
                resBundle = ResourceBundle.getBundle(resourceFile, locale);
            }
        }
        catch (Throwable t) {
            AtDebug.debug(9, t);
        }
        return resBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceBundle tryLoadLocally(String resourceFile, Locale locale) {
        String resName = "/" + resourceFile + "_" + locale.getLanguage() + ".properties";
        URL resUrl = this.getClass().getResource(resName);
        InputStream stream = null;
        try {
            stream = resUrl.openStream();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (stream != null) {
            stream = new BufferedInputStream(stream);
            try {
                PropertyResourceBundle t = new PropertyResourceBundle(stream);
                return t;
            }
            catch (Exception e) {
            }
            finally {
                try {
                    stream.close();
                }
                catch (Exception e) {}
            }
        }
        return null;
    }

    public String getText(String tag) {
        String value = this.getResourceValue(tag);
        String s = BaseResource.trimQuotes(value);
        StringTokenizer tokenizer = new StringTokenizer(s, "|");
        String text = tokenizer.nextToken();
        text = text.trim();
        return text;
    }

    public Properties getResourcesAsProperties() {
        Enumeration<String> keys = this.bundle.getKeys();
        Properties prop = null;
        while (keys != null && keys.hasMoreElements()) {
            String key = keys.nextElement();
            String value = this.getText(key);
            if (prop == null) {
                prop = new Properties();
            }
            prop.put(key, value);
        }
        return prop;
    }

    protected String getResourceValue(String key) {
        String value = "";
        if (this.bundle == null) {
            return "No Resource String";
        }
        value = this.bundle.getString(key);
        return value;
    }

    public static String trimQuotes(String string) {
        if (string == null) {
            return null;
        }
        string = BaseResource.trimLeading(string, "\"");
        string = BaseResource.trimTrailing(string, "\"");
        return string;
    }

    public static String trimLeading(String string, String c) {
        if (string == null) {
            return null;
        }
        if (string.startsWith(c)) {
            string = string.substring(1, string.length());
        }
        return string;
    }

    public static String trimTrailing(String string, String c) {
        if (string == null) {
            return null;
        }
        if (string.endsWith(c)) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }
}

