/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.swing;

import com.activetree.common.resource.AtCommonResource;
import com.activetree.common.swing.AtAbstractDocument;
import com.activetree.common.utils.AtDebug;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;

public class AtAmPmDocument
extends AtAbstractDocument {
    public static final String AM = AtCommonResource.MESSAGE_RESOURCE.getText("AM");
    public static final String PM = AtCommonResource.MESSAGE_RESOURCE.getText("PM");

    public void insertString(int offs, String str, AttributeSet attrs) throws BadLocationException {
        AtDebug.debug("offs: " + offs + ", str=" + str);
        String dervStr = this.getDerivedString(offs, str);
        if (dervStr.length() > AM.length() || dervStr.length() > PM.length()) {
            return;
        }
        boolean isValid = this.validate(offs, str);
        if (!isValid) {
            this.bell();
            return;
        }
        if (str != null) {
            str = str.toUpperCase();
        }
        super.insertString(offs, str, attrs);
    }

    public boolean validate(int offs, String str) {
        for (int idx = 0; idx < str.length(); ++idx) {
            char ch = str.charAt(idx);
            if (idx > AM.length()) {
                return false;
            }
            if (idx > PM.length()) {
                return false;
            }
            char amOffsChar = AM.charAt(offs + idx);
            char amOffsCharUpper = Character.toUpperCase(amOffsChar);
            char amOffsCharLower = Character.toLowerCase(amOffsChar);
            char pmOffsChar = PM.charAt(offs + idx);
            char pmOffsCharUpper = Character.toUpperCase(pmOffsChar);
            char pmOffsCharLower = Character.toLowerCase(pmOffsChar);
            if (ch == amOffsCharUpper || ch == amOffsCharLower || ch == pmOffsCharUpper || ch == pmOffsCharLower) continue;
            return false;
        }
        return true;
    }
}

