/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.swing;

import com.activetree.common.action.AtColorSelectionChangeListener;
import com.activetree.common.swing.AtColorSelectionChangeEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.colorchooser.DefaultColorSelectionModel;

public class AtColorChooser
extends JPanel {
    private Vector listeners = new Vector();
    private ColorPanel colorPane;
    private ColorSelectionModel colorSelModel = new DefaultColorSelectionModel(SystemColor.white);

    public AtColorChooser() {
        this.colorPane = new MainColorPanel();
        final AtColorChooser parent = this;
        this.colorPane.addMouseListener(new MouseAdapter(){
            Color lastSelectedColor;

            public void mousePressed(MouseEvent e) {
                Color newColor = AtColorChooser.this.colorPane.getColorForLocation(e.getX(), e.getY());
                AtColorChooser.this.colorSelModel.setSelectedColor(newColor);
                AtColorSelectionChangeEvent evt = new AtColorSelectionChangeEvent(parent, this.lastSelectedColor, newColor);
                AtColorChooser.this.notifyColorSelectionChange(evt);
                this.lastSelectedColor = newColor;
            }
        });
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.colorPane, "Center");
    }

    private void notifyColorSelectionChange(AtColorSelectionChangeEvent evt) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            AtColorSelectionChangeListener l2 = (AtColorSelectionChangeListener)this.listeners.get(i);
            l2.colorSelectionChanged(evt);
        }
    }

    public void addSelectionChangeListener(AtColorSelectionChangeListener l2) {
        if (!this.listeners.contains(l2)) {
            this.listeners.add(l2);
        }
    }

    public void removeSelectionChangeListener(AtColorSelectionChangeListener l2) {
        this.listeners.remove(l2);
    }

    public void removeAllSelectionChangeListeners() {
        this.listeners.removeAllElements();
    }

    public Color getSelectedColor() {
        return this.colorSelModel.getSelectedColor();
    }

    public ColorSelectionModel getColorSelectionModel() {
        return this.colorSelModel;
    }

    public static void main(String[] args) {
        final JFrame frame = new JFrame("Colors");
        frame.setContentPane(new AtColorChooser());
        frame.pack();
        frame.show();
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                frame.dispose();
                System.exit(0);
            }
        });
    }

    class ColorPanel
    extends JPanel {
        protected Color[] colors;
        protected Dimension swatchSize;
        protected Dimension numSwatches;
        protected Dimension gap;

        public ColorPanel() {
            this.initValues();
            this.initColors();
            this.setToolTipText("");
            this.setOpaque(true);
            this.setBackground(Color.white);
            this.setRequestFocusEnabled(false);
        }

        public boolean isFocusTraversable() {
            return false;
        }

        protected void initValues() {
        }

        public void paintComponent(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            for (int row = 0; row < this.numSwatches.height; ++row) {
                for (int column = 0; column < this.numSwatches.width; ++column) {
                    g.setColor(this.getColorForCell(column, row));
                    int x = column * (this.swatchSize.width + this.gap.width);
                    int y = row * (this.swatchSize.height + this.gap.height);
                    g.fillRect(x, y, this.swatchSize.width, this.swatchSize.height);
                    g.setColor(Color.black);
                    g.drawLine(x + this.swatchSize.width - 1, y, x + this.swatchSize.width - 1, y + this.swatchSize.height - 1);
                    g.drawLine(x, y + this.swatchSize.height - 1, x + this.swatchSize.width - 1, y + this.swatchSize.height - 1);
                }
            }
        }

        public Dimension getPreferredSize() {
            int x = this.numSwatches.width * (this.swatchSize.width + this.gap.width) - 1;
            int y = this.numSwatches.height * (this.swatchSize.height + this.gap.height) - 1;
            return new Dimension(x, y);
        }

        protected void initColors() {
        }

        public String getToolTipText(MouseEvent e) {
            Color color = this.getColorForLocation(e.getX(), e.getY());
            return color.getRed() + ", " + color.getGreen() + ", " + color.getBlue();
        }

        public Color getColorForLocation(int x, int y) {
            int column = x / (this.swatchSize.width + this.gap.width);
            int row = y / (this.swatchSize.height + this.gap.height);
            return this.getColorForCell(column, row);
        }

        private Color getColorForCell(int column, int row) {
            return this.colors[row * this.numSwatches.width + column];
        }
    }

    class MainColorPanel
    extends ColorPanel {
        MainColorPanel() {
        }

        protected void initValues() {
            this.swatchSize = UIManager.getDimension("ColorChooser.swatchesSwatchSize");
            this.numSwatches = new Dimension(31, 9);
            this.gap = new Dimension(1, 1);
        }

        protected void initColors() {
            int[] rawValues = this.initRawValues();
            int numColors = rawValues.length / 3;
            this.colors = new Color[numColors];
            for (int i = 0; i < numColors; ++i) {
                this.colors[i] = new Color(rawValues[i * 3], rawValues[i * 3 + 1], rawValues[i * 3 + 2]);
            }
        }

        private int[] initRawValues() {
            int[] rawValues = new int[]{255, 255, 255, 204, 255, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 255, 204, 255, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 255, 204, 204, 204, 204, 153, 255, 255, 153, 204, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 204, 153, 255, 255, 153, 255, 255, 153, 204, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 204, 153, 255, 255, 153, 204, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 153, 153, 255, 204, 204, 204, 204, 102, 255, 255, 102, 204, 255, 102, 153, 255, 102, 102, 255, 102, 102, 255, 102, 102, 255, 102, 102, 255, 102, 102, 255, 153, 102, 255, 204, 102, 255, 255, 102, 255, 255, 102, 204, 255, 102, 153, 255, 102, 102, 255, 102, 102, 255, 102, 102, 255, 102, 102, 255, 102, 102, 255, 153, 102, 255, 204, 102, 255, 255, 102, 204, 255, 102, 153, 255, 102, 102, 255, 102, 102, 255, 102, 102, 255, 102, 102, 255, 102, 102, 255, 102, 102, 255, 153, 102, 255, 204, 153, 153, 153, 51, 255, 255, 51, 204, 255, 51, 153, 255, 51, 102, 255, 51, 51, 255, 51, 51, 255, 51, 51, 255, 102, 51, 255, 153, 51, 255, 204, 51, 255, 255, 51, 255, 255, 51, 204, 255, 51, 153, 255, 51, 102, 255, 51, 51, 255, 51, 51, 255, 51, 51, 255, 102, 51, 255, 153, 51, 255, 204, 51, 255, 255, 51, 204, 255, 51, 153, 244, 51, 102, 255, 51, 51, 255, 51, 51, 255, 51, 51, 255, 51, 51, 255, 102, 51, 255, 153, 51, 255, 204, 153, 153, 153, 0, 255, 255, 0, 204, 255, 0, 153, 255, 0, 102, 255, 0, 51, 255, 0, 0, 255, 51, 0, 255, 102, 0, 255, 153, 0, 255, 204, 0, 255, 255, 0, 255, 255, 0, 204, 255, 0, 153, 255, 0, 102, 255, 0, 51, 255, 0, 0, 255, 51, 0, 255, 102, 0, 255, 153, 0, 255, 204, 0, 255, 255, 0, 204, 255, 0, 153, 255, 0, 102, 255, 0, 51, 255, 0, 0, 255, 0, 0, 255, 51, 0, 255, 102, 0, 255, 153, 0, 255, 204, 102, 102, 102, 0, 204, 204, 0, 204, 204, 0, 153, 204, 0, 102, 204, 0, 51, 204, 0, 0, 204, 51, 0, 204, 102, 0, 204, 153, 0, 204, 204, 0, 204, 204, 0, 204, 204, 0, 204, 204, 0, 153, 204, 0, 102, 204, 0, 51, 204, 0, 0, 204, 51, 0, 204, 102, 0, 204, 153, 0, 204, 204, 0, 204, 204, 0, 204, 204, 0, 153, 204, 0, 102, 204, 0, 51, 204, 0, 0, 204, 0, 0, 204, 51, 0, 204, 102, 0, 204, 153, 0, 204, 204, 102, 102, 102, 0, 153, 153, 0, 153, 153, 0, 153, 153, 0, 102, 153, 0, 51, 153, 0, 0, 153, 51, 0, 153, 102, 0, 153, 153, 0, 153, 153, 0, 153, 153, 0, 153, 153, 0, 153, 153, 0, 153, 153, 0, 102, 153, 0, 51, 153, 0, 0, 153, 51, 0, 153, 102, 0, 153, 153, 0, 153, 153, 0, 153, 153, 0, 153, 153, 0, 153, 153, 0, 102, 153, 0, 51, 153, 0, 0, 153, 0, 0, 153, 51, 0, 153, 102, 0, 153, 153, 0, 153, 153, 51, 51, 51, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 51, 102, 0, 0, 102, 51, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 51, 102, 0, 0, 102, 51, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 51, 102, 0, 0, 102, 0, 0, 102, 51, 0, 102, 102, 0, 102, 102, 0, 102, 102, 0, 0, 0, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 0, 51, 0, 0, 51, 51, 0, 51, 51, 0, 51, 51, 0, 51, 51, 51, 51, 51};
            return rawValues;
        }
    }
}

