/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.swing;

import com.activetree.common.action.AtPopup;
import com.activetree.common.resource.AtCommonResource;
import com.activetree.common.resource.AtImageList;
import com.activetree.common.swing.AtImageCellWidget;
import com.activetree.common.swing.AtStringCellWidget;
import com.activetree.common.utils.AtDebug;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AtDropDown
extends JPanel
implements AtPopup {
    protected AtStringCellWidget textLabel = new AtStringCellWidget("");
    protected AtImageCellWidget iconButton;
    protected ImageIcon defaultIcon;
    protected JPopupMenu popup;
    protected Vector items = new Vector();
    protected int lastSelectedIndex = -1;
    protected Object lastSelectedItem = null;
    protected Vector actionListeners = new Vector();
    private Dimension bestSize = null;
    protected Vector selectionListeners = new Vector();

    public AtDropDown() {
        this((Object[])null);
    }

    public AtDropDown(Object[] values) {
        this.copyItems(values);
        this.defaultIcon = this.createDefaultIcon();
        Container contentPane = this.createContentPane();
        this.addPopupListener();
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)contentPane, "Center");
        this.setBorder(new EtchedBorder());
    }

    private void copyItems(Object[] objs) {
        for (int i = 0; objs != null && i < objs.length; ++i) {
            this.items.add(objs[i]);
        }
    }

    public void setItems(Object[] values) {
        this.copyItems(values);
        this.setSelectedItem(values[0]);
    }

    protected JPopupMenu createPopup(Object[] values) {
        JPopupMenu pop = new JPopupMenu();
        PopupActionListener actionListener = new PopupActionListener();
        for (int i = 0; values != null && i < values.length; ++i) {
            JMenuItem menu = pop.add(values[i].toString());
            menu.setActionCommand(String.valueOf(i));
            menu.addActionListener(actionListener);
        }
        Dimension parentSize = this.getSize();
        Dimension popSize = pop.getPreferredSize();
        Dimension sz = new Dimension(parentSize.width, popSize.height);
        pop.setPopupSize(sz);
        if (this.bestSize == null) {
            this.bestSize = new Dimension(sz.width, parentSize.height);
        }
        return pop;
    }

    protected ImageIcon createDefaultIcon() {
        return AtImageList.IMAGE_LIST.ARROW_DOWN_16;
    }

    protected Container createContentPane() {
        this.iconButton = new AtImageCellWidget(this.defaultIcon);
        this.iconButton.setFocusEnabled(true);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.textLabel, "Center");
        panel.add((Component)this.iconButton, "East");
        return panel;
    }

    public void setBackground(Color bg) {
        if (this.textLabel != null) {
            this.textLabel.setBackground(bg);
        }
        super.setBackground(bg);
    }

    public void setForeground(Color fg) {
        if (this.textLabel != null) {
            this.textLabel.setForeground(fg);
        }
        super.setForeground(fg);
    }

    public void addMouseListener(MouseListener l2) {
        super.addMouseListener(l2);
        this.textLabel.addMouseListener(l2);
        this.iconButton.addMouseListener(l2);
    }

    public int getItemIndex(Object obj) {
        String itemIn = obj.toString();
        for (int i = 0; i < this.items.size(); ++i) {
            Object aItem = this.items.get(i);
            if (!aItem.toString().equals(itemIn)) continue;
            return i;
        }
        return -1;
    }

    public void setSelectedItem(Object obj) {
        int itemIndex = this.getItemIndex(obj);
        if (itemIndex < 0) {
            throw new RuntimeException(AtCommonResource.MESSAGE_RESOURCE.getText("ITEM_NOT_ON_LIST"));
        }
        this.textLabel.setText(obj.toString());
        this.lastSelectedIndex = itemIndex;
    }

    public Object getSelectedItem() {
        return this.textLabel.getText();
    }

    public Object getSelectedItem(int anIndex) {
        return this.items.get(anIndex);
    }

    public int getSelectedIndex() {
        return this.lastSelectedIndex;
    }

    public void setSelectedIndex(int selIdx) {
        Object selObj = this.getSelectedItem(selIdx);
        this.setSelectedItem(selObj);
    }

    public void popup(MouseEvent e) {
        Component comp = (Component)e.getSource();
        if (comp == this.textLabel || comp == this.iconButton || comp == this) {
            int comboHeight = this.getHeight();
            this.popup = this.createPopup(this.items.toArray());
            this.popup.show(this, 0, comboHeight);
            boolean popupRelocate = false;
            Point currLocation = this.popup.getLocationOnScreen();
            Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
            int popupWidth = this.popup.getWidth();
            int popupHeight = this.popup.getHeight();
            if (currLocation.x + popupWidth > scrSize.width) {
                currLocation.x -= popupWidth;
                popupRelocate = true;
            }
            if (currLocation.y + popupHeight > scrSize.height) {
                currLocation.y -= popupHeight;
                popupRelocate = true;
            }
            if (popupRelocate) {
                this.popup.setLocation(currLocation);
            }
            this.focusSelectedItem(this.popup);
        }
    }

    private void focusSelectedItem(JPopupMenu popup) {
        try {
            int selectedIndex = this.getSelectedIndex();
            JMenuItem selectedComp = (JMenuItem)popup.getComponent(selectedIndex);
            if (selectedComp != null) {
                popup.setSelected(selectedComp);
            }
        }
        catch (Throwable e) {
            AtDebug.debug(7, "AtDropDown.focusSelectedItem(): Couldn't set month combo popup item selected.");
            AtDebug.debug(9, e.getMessage());
        }
    }

    private void addPopupListener() {
        this.addMouseListener(new PopupAdapter());
    }

    public boolean addActionListner(ActionListener l2) {
        if (!this.actionListeners.contains(l2)) {
            return this.actionListeners.add(l2);
        }
        return false;
    }

    public boolean removeActionListner(ActionListener l2) {
        return this.actionListeners.remove(l2);
    }

    public boolean addSelectionListener(ListSelectionListener l2) {
        if (!this.selectionListeners.contains(l2)) {
            return this.selectionListeners.add(l2);
        }
        return false;
    }

    public boolean removeSelectionListener(ListSelectionListener l2) {
        return this.selectionListeners.remove(l2);
    }

    protected void notifyActionListeners(ActionEvent e) {
        for (int i = 0; i < this.actionListeners.size(); ++i) {
            ActionListener l2 = (ActionListener)this.actionListeners.get(i);
            l2.actionPerformed(e);
        }
    }

    protected void notifySelectionChangeListeners(ActionEvent e) {
        String newItemCmd = e.getActionCommand();
        int currSelIdx = Integer.parseInt(newItemCmd);
        Object currSelObj = this.items.get(currSelIdx);
        AtDebug.debug("AtDropDown.notifySelectionChnageListeners()...lastSelIdx: " + this.lastSelectedIndex + ", currSelectedIdx : " + currSelIdx + ", currSelItem: " + currSelObj.toString());
        if (this.lastSelectedIndex == currSelIdx) {
            AtDebug.debug("AtDropDown.notifySelectionChnageListeners()...return (do not notify for selection change).");
            return;
        }
        ListSelectionEvent evt = new ListSelectionEvent(this, this.lastSelectedIndex, currSelIdx, false);
        this.lastSelectedIndex = currSelIdx;
        this.lastSelectedItem = this.items.get(this.lastSelectedIndex);
        AtDebug.debug("AtDropDown.notifySelectionChnageListeners()...Notifying for selection change.");
        for (int i = 0; i < this.selectionListeners.size(); ++i) {
            ListSelectionListener l2 = (ListSelectionListener)this.selectionListeners.get(i);
            l2.valueChanged(evt);
        }
    }

    protected class PopupActionListener
    implements ActionListener {
        protected PopupActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            AtDropDown.this.notifySelectionChangeListeners(e);
            AtDropDown.this.notifyActionListeners(e);
        }
    }

    protected class PopupAdapter
    extends MouseAdapter {
        protected PopupAdapter() {
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                return;
            }
            AtDropDown.this.popup(e);
        }
    }
}

