/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.swing;

import com.activetree.common.swing.AtFileFilter;
import com.activetree.common.utils.AtComponentUtil;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import javax.swing.JFileChooser;

public class AtFileChooser {
    protected JFileChooser fileChooser;
    protected File currDirPath;
    protected File lastSelectedPath;
    protected String title;
    protected String approveButtonText;
    protected char approveButtonMnemonic;
    protected String approveButtonTooltip;
    protected String[] filters;
    protected String filterDescription;
    protected boolean isMultiSelection;
    protected AtFileFilter fileFilter;

    public AtFileChooser(File currDirPath, String title, String approveButtonText, char approveButtonMnemonic, String approveButtonTooltip, String[] filters, String filterDescription, boolean isMultiSelection) {
        this.currDirPath = currDirPath;
        this.title = title;
        this.approveButtonText = approveButtonText;
        this.approveButtonMnemonic = approveButtonMnemonic;
        this.approveButtonTooltip = approveButtonTooltip;
        this.filters = filters;
        this.filterDescription = filterDescription;
        this.isMultiSelection = isMultiSelection;
    }

    public File showDialog(int type, Component parent) {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser(this.currDirPath);
            this.fileFilter = new AtFileFilter(this.filters, this.filterDescription);
            this.fileChooser.addChoosableFileFilter(this.fileFilter);
        }
        this.fileChooser.setControlButtonsAreShown(true);
        this.fileChooser.setApproveButtonText(this.approveButtonText);
        this.fileChooser.setApproveButtonMnemonic(this.approveButtonMnemonic);
        this.fileChooser.setApproveButtonToolTipText(this.approveButtonTooltip);
        if (this.getLastSelectedPath() != null) {
            this.fileChooser.setCurrentDirectory(this.getLastSelectedPath());
        }
        this.fileChooser.setMultiSelectionEnabled(this.isMultiSelection);
        this.fileChooser.setApproveButtonMnemonic(this.approveButtonMnemonic);
        int retCode = -1;
        Window window = AtComponentUtil.getWindowForComponent(parent);
        if (type == 1) {
            retCode = this.fileChooser.showOpenDialog(window);
        } else if (type == 2) {
            retCode = this.fileChooser.showSaveDialog(window);
        }
        if (retCode != 0) {
            return null;
        }
        File selectedFile = this.fileChooser.getSelectedFile();
        this.setLastSelectedPath(selectedFile);
        return selectedFile;
    }

    public void setSelectedFile(String file) {
        if (this.fileChooser != null) {
            this.fileChooser.setSelectedFile(null);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getApproveButtonText() {
        return this.approveButtonText;
    }

    public void setApproveButtonText(String approveButtonText) {
        this.approveButtonText = approveButtonText;
    }

    public char getApproveButtonMnemonic() {
        return this.approveButtonMnemonic;
    }

    public void setApproveButtonMnemonic(char approveButtonMnemonic) {
        this.approveButtonMnemonic = approveButtonMnemonic;
    }

    public String getApproveButtonTooltip() {
        return this.approveButtonTooltip;
    }

    public void setApproveButtonTooltip(String approveButtonTooltip) {
        this.approveButtonTooltip = approveButtonTooltip;
    }

    public String[] getFilters() {
        return this.filters;
    }

    public void setFilters(String[] filters) {
        this.filters = filters;
        if (this.fileFilter != null) {
            this.fileFilter.resetFileFilter(filters);
        }
    }

    public String getFilterDescription() {
        return this.filterDescription;
    }

    public void setFilterDescription(String filterDescription) {
        this.filterDescription = filterDescription;
        if (this.fileFilter != null) {
            this.fileFilter.setDescription(filterDescription);
        }
    }

    public boolean isMultiSelection() {
        return this.isMultiSelection;
    }

    public void setMultiSelection(boolean multiSelection) {
        this.isMultiSelection = multiSelection;
    }

    private void setLastSelectedPath(File file) {
        this.lastSelectedPath = file;
    }

    private File getLastSelectedPath() {
        return this.lastSelectedPath;
    }

    public File getSelectedFile() {
        return this.fileChooser.getSelectedFile();
    }

    public boolean isFileValid() {
        File file = this.getSelectedFile();
        return file != null && !file.isDirectory();
    }

    public JFileChooser getFileChooser() {
        return this.fileChooser;
    }
}

