/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.swing;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.filechooser.FileFilter;

public class AtFileFilter
extends FileFilter {
    private Hashtable filters = null;
    private String description = null;
    StringBuffer sb = new StringBuffer();

    public AtFileFilter() {
        this.filters = new Hashtable();
    }

    public AtFileFilter(String extension) {
        this(extension, null);
    }

    public AtFileFilter(String extension, String description) {
        this();
        if (extension != null) {
            this.addFileExtension(extension);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public AtFileFilter(String[] filters) {
        this(filters, null);
    }

    public AtFileFilter(String[] filters, String description) {
        this();
        for (int i = 0; i < filters.length; ++i) {
            this.addFileExtension(filters[i]);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = this.getFileExtension(f);
            if (extension != null && this.filters.get(this.getFileExtension(f)) != null) {
                return true;
            }
        }
        return false;
    }

    public String getDescription() {
        this.sb.delete(0, this.sb.length());
        if (this.description != null) {
            this.sb.append(this.description);
        }
        this.sb.append("[");
        Enumeration exts = this.filters.keys();
        int count = 0;
        if (exts != null && exts.hasMoreElements()) {
            do {
                if (++count > 1) {
                    this.sb.append(", ");
                }
                this.sb.append("*.");
                this.sb.append((String)exts.nextElement());
            } while (exts.hasMoreElements());
        }
        this.sb.append("]");
        return this.sb.toString();
    }

    public String getFileExtension(File f) {
        String filename;
        int i;
        if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }

    public void addFileExtension(String extension) {
        if (this.filters == null) {
            this.filters = new Hashtable();
        }
        this.filters.put(extension.toLowerCase(), this);
    }

    public void resetFileFilter(String[] extensions) {
        if (this.filters != null) {
            this.filters.clear();
        }
        for (int i = 0; extensions != null && i < extensions.length; ++i) {
            if (extensions[i] == null) continue;
            this.filters.put(extensions[i].toLowerCase(), this);
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static File getDefaultDocumentDirectory() {
        String userDir = ".";
        try {
            userDir = System.getProperty("user.dir");
        }
        catch (Throwable t) {
            // empty catch block
        }
        File docDir = new File(userDir);
        return docDir;
    }
}

