/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.swing;

import com.activetree.common.swing.AtStringCellWidget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.SystemColor;
import javax.swing.JPanel;

public class AtMonthWidget
extends JPanel {
    protected String[] days;
    private AtStringCellWidget[] dayControls = new AtStringCellWidget[7];

    public AtMonthWidget(String[] months) {
        this.days = months;
        this.setupContentPane(months);
    }

    protected void setupContentPane(String[] months) {
        this.setLayout(new GridLayout(1, 7));
        for (int i = 0; i < months.length; ++i) {
            this.dayControls[i] = this.createMonthCell(months[i].substring(0, 1));
            this.add(this.dayControls[i]);
        }
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getSize();
        d.height = this.dayControls[0].getWidgetHeight();
        return d;
    }

    protected AtStringCellWidget createMonthCell(String text) {
        AtStringCellWidget aMonthControl = new AtStringCellWidget(text){
            private Color fgColor;
            {
                this.fgColor = SystemColor.white;
            }

            protected void paintCellBorder(Graphics2D g) {
            }

            protected void paintBackground(Graphics2D g2d) {
                Dimension d = this.getSize();
                g2d.setPaint(SystemColor.gray);
                g2d.fill(new Rectangle(0, 0, d.width, d.height));
            }

            public Color getForeground() {
                return this.fgColor;
            }

            public boolean isMouseEnabled() {
                return false;
            }
        };
        return aMonthControl;
    }

    public void setDays(String[] days) {
        this.days = days;
        for (int i = 0; i < this.dayControls.length; ++i) {
            this.dayControls[i].setText(days[i]);
            this.dayControls[i].repaint();
        }
    }

    public String[] getDays() {
        return this.days;
    }
}

