/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.swing;

import com.activetree.common.swing.AtWidget;
import com.activetree.common.utils.GraphicsUtil;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;

public class AtStringCellWidget
extends AtWidget {
    protected String value;
    private boolean showFocusOnEmptyWidget = false;

    public AtStringCellWidget() {
        this("");
    }

    public AtStringCellWidget(String value) {
        this.value = value;
        this.actionCmd = value;
        this.calculateWidgetSize();
        this.setMouseEnaled(false);
    }

    protected void calculateWidgetSize() {
        this.pSize.width = this.getWidgetWidth();
        this.pSize.height = this.getWidgetHeight();
    }

    public int getWidgetWidth() {
        int width = GraphicsUtil.stringWidth(this.getFont(), this.value) + this.getWidgetMargin();
        return width;
    }

    public void setFocusOnEmptyWidget(boolean enabled) {
        this.showFocusOnEmptyWidget = enabled;
    }

    public boolean isFocusOnEmptyWidget() {
        return this.showFocusOnEmptyWidget;
    }

    public boolean isEmptyWidget() {
        return this.value == null || this.value.equals("");
    }

    protected void paintForeground(Graphics2D g2d) {
        Dimension d = this.getSize();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int fontHeight = fm.getHeight();
        String displayValue = "";
        if (this.value != null) {
            displayValue = this.value;
        }
        int strWidth = GraphicsUtil.stringWidth(this.getFont(), displayValue);
        int start_x = d.width / 2 - strWidth / 2;
        int start_y = d.height / 2 + fontHeight / 3;
        if (this.isSelected()) {
            g2d.setPaint(this.getSelectedForeground());
        } else {
            g2d.setPaint(this.getForeground());
        }
        if (this.mousePressed) {
            g2d.drawString(displayValue, start_x + 1, start_y + 1);
        } else {
            g2d.drawString(displayValue, start_x, start_y);
        }
    }

    public void paintFocus(Graphics2D g2d) {
        if (!this.isFocusOnEmptyWidget() && this.isEmptyWidget() && super.isEnabled()) {
            return;
        }
        super.paintFocus(g2d);
    }

    public void setText(String text) {
        this.value = text;
        this.calculateWidgetSize();
        this.repaint();
    }

    public String getText() {
        return this.value;
    }
}

