/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.swing;

import com.activetree.common.action.AtWidgetFocusListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.UIManager;

public abstract class AtWidget
extends JPanel
implements MouseListener {
    public static final Color BUTTON_FOCUS_BG = new Color(SystemColor.controlShadow.getRed(), SystemColor.controlShadow.getGreen(), SystemColor.controlShadow.getBlue(), 150);
    public static final Color SELECTION_BACKGROUND = new Color(153, 153, 255);
    public static final Color SELECTION_FOREGROUND = UIManager.getColor("Table.selectionForeground");
    public static final Color BUTTON_PRESS_BG = BUTTON_FOCUS_BG.darker();
    public static final Color BUTTON_FOCUS_BORDER = SystemColor.blue.darker().darker();
    public static final int WIDGET_MARGIN = 5;
    protected Vector actionListeners = new Vector();
    protected String actionCmd;
    protected Color pressedBgColor;
    protected Color defaultBgColor;
    protected Color defaultFgColor;
    protected Color selectionBg;
    protected Color selectionFg;
    protected Color gridColor = UIManager.getColor("Table.gridColor");
    protected Color focusBorderBg;
    protected Color focusBg;
    protected boolean selected = false;
    protected boolean focusEnabled = false;
    protected boolean paintCellBorder = false;
    private AtWidgetFocusListener focusListener;
    protected Dimension pSize = new Dimension(0, 0);
    protected boolean mousePressed = false;
    private boolean mouseEnabled = true;

    public AtWidget() {
        this.addMouseListener(this);
        this.defaultBgColor = this.getBackground();
        this.defaultFgColor = this.getForeground();
        this.selectionBg = SELECTION_BACKGROUND.darker();
        this.selectionFg = SELECTION_FOREGROUND;
        this.focusBg = BUTTON_FOCUS_BG;
        this.pressedBgColor = BUTTON_PRESS_BG;
        this.focusBorderBg = BUTTON_FOCUS_BORDER;
        this.focusListener = new AtWidgetFocusListener(this);
        this.addMouseListener(this.focusListener);
    }

    protected abstract void calculateWidgetSize();

    public abstract int getWidgetWidth();

    public int getWidgetMargin() {
        return 5;
    }

    public int getWidgetHeight() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        return fm.getHeight() + this.getWidgetMargin();
    }

    public void setWidgetFont(Font newFont) {
        super.setFont(newFont);
        this.calculateWidgetSize();
    }

    public Dimension getPreferredSize() {
        return this.pSize;
    }

    public void setFocusEnabled(boolean enable) {
        this.focusEnabled = enable;
    }

    public boolean isFocusEnabled() {
        return this.focusEnabled;
    }

    public boolean isFocusGained() {
        return this.focusListener.isFocusGained();
    }

    public void setPaintCellBorder(boolean paintCellBorder) {
        this.paintCellBorder = paintCellBorder;
    }

    public boolean isPaintCellBorder() {
        return this.paintCellBorder;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public Color getSelectedBackground() {
        return this.selectionBg;
    }

    public void setSelectedBackground(Color selBg) {
        this.selectionBg = selBg;
    }

    public void setSelectedForeground(Color fg) {
        this.selectionFg = fg;
    }

    public Color getSelectedForeground() {
        return this.selectionFg;
    }

    public Color getFocusBorderColor() {
        return this.focusBorderBg;
    }

    public void setFocusBorderColor(Color focusBorderColor) {
        this.focusBorderBg = focusBorderColor;
    }

    public Color getFocusBackground() {
        return this.focusBg;
    }

    public void setFocusBackground(Color focusBg) {
        this.focusBg = focusBg;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        this.paintBackground(g2d);
        this.paintFocus(g2d);
        this.paintForeground(g2d);
        this.paintCellBorder(g2d);
    }

    protected void paintCellBorder(Graphics2D g2d) {
        Dimension d = this.getSize();
        if (this.isFocusEnabled() && this.isFocusGained() && super.isEnabled()) {
            g2d.setColor(this.getFocusBorderColor());
            g2d.drawRect(2, 2, d.width - 5, d.height - 5);
        } else if (this.isSelected() && this.isPaintCellBorder()) {
            g2d.setColor(this.getFocusBorderColor());
            g2d.drawRect(2, 2, d.width - 5, d.height - 5);
        }
    }

    protected void paintFocus(Graphics2D g2d) {
        if (this.isFocusEnabled() && this.isFocusGained() && super.isEnabled()) {
            Dimension d = this.getSize();
            g2d.setPaint(this.getFocusBackground());
            g2d.fill(new Rectangle(1, 1, d.width - 2, d.height - 2));
        }
    }

    protected void paintBackground(Graphics2D g2d) {
        Dimension d = this.getSize();
        if (!this.isSelected()) {
            g2d.setPaint(this.getBackground());
            g2d.fill(new Rectangle(0, 0, d.width - 1, d.height - 1));
        } else {
            g2d.setPaint(this.getSelectedBackground());
            g2d.fill(new Rectangle(0, 0, d.width - 1, d.height - 1));
        }
    }

    protected void paintForeground(Graphics2D g2d) {
    }

    public Color getBackground() {
        if (this.mousePressed) {
            if (this.focusListener.isFocusGained()) {
                return this.pressedBgColor;
            }
            return super.getBackground();
        }
        return super.getBackground();
    }

    public void setMouseEnaled(boolean mouseEnabled) {
        this.mouseEnabled = mouseEnabled;
    }

    public boolean isMouseEnabled() {
        return this.mouseEnabled;
    }

    public void mousePressed(MouseEvent e) {
        if (!super.isEnabled()) {
            return;
        }
        if (this.isMouseEnabled() && e.getModifiers() == 16) {
            this.mousePressed = true;
        }
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        if (!super.isEnabled()) {
            return;
        }
        if (e.isPopupTrigger()) {
            return;
        }
        if (!super.isEnabled()) {
            return;
        }
        if (this.isMouseEnabled()) {
            this.mousePressed = false;
        }
        this.repaint();
    }

    public void mouseClicked(MouseEvent e) {
        if (!super.isEnabled()) {
            return;
        }
        if (e.getModifiers() != 16) {
            return;
        }
        if (super.isEnabled()) {
            this.notifyActionListeners();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void setActionCommand(String cmd) {
        this.actionCmd = cmd;
    }

    public String getActionCommand() {
        return this.actionCmd;
    }

    public boolean addActionListener(ActionListener l2) {
        if (!this.actionListeners.contains(l2)) {
            return this.actionListeners.add(l2);
        }
        return false;
    }

    public boolean removeActionListener(ActionListener l2) {
        return this.actionListeners.remove(l2);
    }

    protected void notifyActionListeners() {
        ActionEvent evt = new ActionEvent(this, 1001, this.getActionCommand());
        for (int i = 0; i < this.actionListeners.size(); ++i) {
            ((ActionListener)this.actionListeners.get(i)).actionPerformed(evt);
        }
    }
}

