/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.swing;

import com.activetree.common.resource.AtCommonResource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.Keymap;

public class AutoInputCombo
extends JComboBox
implements ItemListener {
    protected JComponent parentView;

    public AutoInputCombo(DefaultComboBoxModel model, final ActionListener actionListener, final String cmd, JComponent owner) {
        super(model);
        this.parentView = owner;
        super.setMaximumRowCount(10);
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        final JTextField tf = (JTextField)super.getEditor().getEditorComponent();
        Keymap map = tf.getKeymap();
        map.removeKeyStrokeBinding(enter);
        tf.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    String item = tf.getText();
                    AutoInputCombo.this.insertElement(item, (DefaultComboBoxModel)AutoInputCombo.this.getModel());
                    AutoInputCombo.this.parentView.grabFocus();
                    actionListener.actionPerformed(new ActionEvent(tf, 900, cmd));
                }
            }
        });
        super.setEditable(true);
        super.addItemListener(this);
    }

    public void selectedItemChanged() {
        super.selectedItemChanged();
    }

    public void itemStateChanged(ItemEvent evt) {
        Object item = evt.getItem();
        int stateChange = evt.getStateChange();
        if (stateChange == 1) {
            DefaultComboBoxModel model = (DefaultComboBoxModel)super.getModel();
            this.insertElement((String)item, model);
        } else if (stateChange == 2) {
            // empty if block
        }
    }

    public void insertElement(String elm, DefaultComboBoxModel model) {
        int elmIdx = model.getIndexOf(elm);
        if (elmIdx < 0 && elm != null && !elm.equals("")) {
            if (elm.equals(AtCommonResource.MESSAGE_RESOURCE.getText("NONE")) || elm.equals(AtCommonResource.MESSAGE_RESOURCE.getText("DOCUMENT_DATA_BYTES"))) {
                return;
            }
            model.insertElementAt(elm, 0);
        }
    }
}

