/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.swing;

import com.activetree.common.resource.AtCommonResource;
import com.activetree.common.swing.AtInsetsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class LogonDialog
extends JDialog
implements ActionListener {
    protected Image splashIcon;
    protected String[] message;
    protected JLabel usernameLabel;
    protected JLabel passwordLabel;
    protected JTextField userNameField;
    protected JPasswordField passwordField;
    protected JPanel buttonPanel;
    protected JButton okButton;
    protected JButton cancelButton;
    protected boolean okPressed = false;
    protected Dimension prefSize;

    public LogonDialog(Frame owner, String title, boolean modal, Image splashImage, String[] message) {
        super(owner, title, modal);
        this.initPane(splashImage, message);
    }

    public LogonDialog(Dialog owner, String title, boolean modal, Image splashImage, String[] message) {
        super(owner, title, modal);
        this.initPane(splashImage, message);
    }

    public void initPane(Image splashImage, String[] message) {
        this.splashIcon = splashImage;
        this.message = message;
        JPanel messagePane = null;
        int gridy = 0;
        for (int i = 0; message != null && i < message.length; ++i) {
            String msg = message[i];
            if (msg == null) continue;
            if (messagePane == null) {
                messagePane = new JPanel(new GridBagLayout());
            }
            JLabel label = new JLabel(msg);
            messagePane.add((Component)label, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.usernameLabel = new JLabel(AtCommonResource.MESSAGE_RESOURCE.getText("USER_NAME"));
        this.passwordLabel = new JLabel(AtCommonResource.MESSAGE_RESOURCE.getText("USER_PASSWORD"));
        this.userNameField = new JTextField("", 20){

            public int getHeight() {
                return 20;
            }
        };
        this.passwordField = new JPasswordField("", 20){

            public int getHeight() {
                return 20;
            }
        };
        this.okButton = new JButton(AtCommonResource.MESSAGE_RESOURCE.getText("Ok"));
        this.okButton.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("Ok"));
        this.cancelButton = new JButton(AtCommonResource.MESSAGE_RESOURCE.getText("Cancel"));
        this.cancelButton.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("Cancel"));
        SplashIconPane splashPane = null;
        if (this.splashIcon != null) {
            splashPane = new SplashIconPane(this.splashIcon);
        }
        this.okButton.setMnemonic('O');
        this.cancelButton.setMnemonic('C');
        this.buttonPanel = new JPanel(new GridBagLayout());
        this.buttonPanel.add((Component)this.okButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 3, new Insets(0, 0, 0, 10), 0, 0));
        this.buttonPanel.add((Component)this.cancelButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 3, new Insets(0, 0, 0, 10), 0, 0));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        JPanel logonPane = new JPanel(new GridBagLayout());
        logonPane.setLayout(new GridBagLayout());
        if (messagePane != null) {
            logonPane.add((Component)messagePane, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 5, 5), 0, 0));
        }
        logonPane.add((Component)this.usernameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 5, 0), 0, 0));
        logonPane.add((Component)this.userNameField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 5, 5), 0, 0));
        logonPane.add((Component)this.passwordLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 5, 0), 0, 0));
        logonPane.add((Component)this.passwordField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 5, 5), 0, 0));
        logonPane.add((Component)this.buttonPanel, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                LogonDialog.this.userNameField.grabFocus();
            }
        });
        this.userNameField.grabFocus();
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        if (splashPane != null) {
            c.add((Component)splashPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 5, 0), 0, 0));
            c.add((Component)logonPane, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 5, 5, 5), 0, 0));
        } else {
            c.add((Component)logonPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        }
        this.getRootPane().setDefaultButton(this.okButton);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                LogonDialog.this.cancelButton.doClick();
            }
        });
    }

    public JButton getDefaultButton() {
        return this.okButton;
    }

    public void actionPerformed(ActionEvent evt) {
        this.okPressed = false;
        if (evt.getSource() == this.okButton) {
            this.okPressed = true;
        }
        this.setVisible(false);
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public String getUserName() {
        String uid = this.userNameField.getText();
        if (uid != null && uid.length() > 0) {
            uid = uid.trim();
            return uid;
        }
        return null;
    }

    public String getPassword() {
        char[] pwd = this.passwordField.getPassword();
        if (pwd != null || pwd.length > 0) {
            return new String(pwd);
        }
        return null;
    }

    class SplashIconPane
    extends AtInsetsPanel {
        private Dimension prefSize;
        protected Image icon;

        public SplashIconPane(Image icon) {
            super(new Insets(0, 0, 0, 0));
            this.prefSize = new Dimension();
            this.icon = icon;
            this.setLayout(new BorderLayout());
            this.prefSize.width = icon.getWidth(null);
            this.prefSize.height = icon.getHeight(null);
            super.setSize(this.prefSize);
            super.setMinimumSize(this.prefSize);
        }

        public Dimension getPreferredSize() {
            return this.prefSize;
        }

        public Dimension getSize() {
            return this.prefSize;
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            int imgx = 0;
            int imgy = 0;
            int imgw = this.icon.getWidth(null);
            int imgh = this.icon.getHeight(null);
            g.drawImage(this.icon, imgx, imgy, imgw, imgh, this);
        }
    }
}

