/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.swing;

import com.activetree.common.resource.AtCommonResource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;

public class OkCancelButtonPane
extends JPanel
implements ActionListener {
    protected final Vector actionListeners = new Vector();
    protected JButton okButton;
    protected JButton cancelButton;
    private boolean okPressed = false;

    public OkCancelButtonPane() {
        this.setupContentPane();
        this.postInit();
    }

    protected void postInit() {
    }

    public void setupContentPane() {
        this.setLayout(new GridBagLayout());
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.okButton.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("PRINT_DIALOG_OK"));
        this.okButton.setText(AtCommonResource.MESSAGE_RESOURCE.getText("PRINT_DIALOG_OK"));
        this.okButton.setToolTipText(AtCommonResource.MESSAGE_RESOURCE.getText("PRINT_DIALOG_OK_TOOLTIP"));
        this.okButton.setActionCommand("ok");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.okButton, gridBagConstraints);
        this.cancelButton.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("PRINT_DIALOG_CANCEL"));
        this.cancelButton.setText(AtCommonResource.MESSAGE_RESOURCE.getText("PRINT_DIALOG_CANCEL"));
        this.cancelButton.setToolTipText(AtCommonResource.MESSAGE_RESOURCE.getText("PRINT_DIALOG_CANCEL_TOOLTIP"));
        this.cancelButton.setActionCommand("cancel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        gridBagConstraints.anchor = 16;
        this.add((Component)this.cancelButton, gridBagConstraints);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
    }

    public void refresh() {
    }

    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        boolean actionCommand = false;
        if (cmd != null && cmd.equalsIgnoreCase("ok")) {
            this.okPressed = true;
            actionCommand = true;
        } else if (cmd != null && cmd.equalsIgnoreCase("cancel")) {
            this.okPressed = false;
            actionCommand = true;
        }
        if (actionCommand) {
            this.notifyActionListeners(evt);
        }
    }

    protected void notifyActionListeners(ActionEvent evt) {
        for (int i = 0; i < this.actionListeners.size(); ++i) {
            ActionListener l2 = (ActionListener)this.actionListeners.get(i);
            l2.actionPerformed(evt);
        }
    }

    public boolean addActionListener(ActionListener l2) {
        if (!this.actionListeners.contains(l2)) {
            return this.actionListeners.add(l2);
        }
        return false;
    }

    public boolean removeActionListener(ActionListener l2) {
        boolean removed = this.actionListeners.remove(l2);
        return removed;
    }

    public void removeAllActionListeners() {
        this.actionListeners.removeAllElements();
    }

    public void setOkPressed(boolean pressed) {
        this.okPressed = pressed;
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public void setCancelButtonText(String text) {
        this.cancelButton.setText(text);
    }

    public String getCancelButtonText() {
        return this.cancelButton.getText();
    }

    public void setCancelButtonTooltip(String tooltip) {
        this.cancelButton.setToolTipText(tooltip);
    }

    public void setCancelButtonEnabled(boolean enabled) {
        this.cancelButton.setEnabled(enabled);
    }

    public void setCancelButtonVisible(boolean visible) {
        this.cancelButton.setVisible(visible);
    }

    public void setOkButtonText(String okButtonText) {
        this.okButton.setText(okButtonText);
    }

    public void setOkButtonTooltip(String okButtonTooltip) {
        this.okButton.setToolTipText(okButtonTooltip);
    }

    public void setOkButtonEnabled(boolean enabled) {
        this.okButton.setEnabled(enabled);
    }

    public void setOkButtonVisible(boolean visible) {
        this.okButton.setVisible(visible);
    }

    public void cancel() {
        this.cancelButton.doClick();
    }
}

