/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.swing;

import com.activetree.common.resource.AtCommonResource;
import com.activetree.common.swing.AtIntegerTypeDocument;
import com.activetree.common.swing.AtTextField;
import com.activetree.common.swing.OkCancelButtonPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ProxyDialog
extends JDialog {
    protected JLabel hostLabel;
    protected AtTextField hostValue;
    protected JLabel portLabel;
    protected AtTextField portValue;
    protected OkCancelButtonPane butPane;
    protected JLabel messageLabel;

    public ProxyDialog(Dialog dialog, String title, boolean modal, String msg) {
        super(dialog, title, modal);
        this.setupContentPane(msg);
    }

    public ProxyDialog(Frame frame, String title, boolean modal, String msg) {
        super(frame, title, modal);
        this.setupContentPane(msg);
    }

    protected void setupContentPane(String message) {
        String proxyHostMsg = AtCommonResource.MESSAGE_RESOURCE.getText("PROXY_HOST");
        String proxyPortMsg = AtCommonResource.MESSAGE_RESOURCE.getText("PROXY_PORT");
        this.messageLabel = new JLabel(message);
        this.hostLabel = new JLabel(proxyHostMsg);
        this.hostValue = new AtTextField(20);
        this.portLabel = new JLabel(proxyPortMsg);
        this.portValue = new AtTextField(new AtIntegerTypeDocument(), "80", 6);
        this.butPane = new OkCancelButtonPane();
        this.butPane.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProxyDialog.this.hide();
            }
        });
        JPanel top = new JPanel(new GridBagLayout());
        top.add((Component)this.messageLabel, new GridBagConstraints(0, 0, 4, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        top.add((Component)this.hostLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        top.add((Component)this.hostValue, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        top.add((Component)this.portLabel, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        top.add((Component)this.portValue, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        top.add((Component)this.butPane, new GridBagConstraints(0, 2, 4, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.setContentPane(top);
        this.pack();
    }

    public boolean isOkPressed() {
        return this.butPane.isOkPressed();
    }

    public void setMessage(String msg) {
        this.messageLabel.setText(msg);
    }

    public String getMessage() {
        return this.messageLabel.getText();
    }

    public String getHostLabel() {
        return this.hostLabel.getText();
    }

    public void setHostLabel(String hostLabel) {
        this.hostLabel.setText(hostLabel);
    }

    public String getHostValue() {
        return this.hostValue.getText();
    }

    public void setHostValue(String hostValue) {
        this.hostValue.setText(hostValue);
    }

    public String getPortLabel() {
        return this.portLabel.getText();
    }

    public void setPortLabel(String portLabel) {
        this.portLabel.setText(portLabel);
    }

    public String getPortValue() {
        return this.portValue.getText();
    }

    public void setPortValue(String portValue) {
        this.portValue.setText(portValue);
    }
}

