/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.utils;

import com.activetree.common.data.KeyValue;
import com.activetree.common.resource.AtCommonResource;
import com.activetree.common.swing.AtFileChooser;
import com.activetree.common.swing.AtFileFilter;
import com.activetree.common.utils.AtDebug;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class FileChooserUtil
implements Serializable {
    static AtFileChooser fileChooser;
    private static String lastLookupDir;

    public static OutputStream getOutputStream(Component owner, String extension, String description, int openOrSave) {
        String userHome = ".";
        try {
            userHome = System.getProperty("user.home");
        }
        catch (Throwable t) {
            // empty catch block
        }
        KeyValue kv = FileChooserUtil.getOutputStream(owner, extension, description, openOrSave, userHome);
        if (kv != null) {
            return (OutputStream)kv.value;
        }
        return null;
    }

    public static KeyValue getOutputStream(Component owner, String extension, String description, int openOrSave, String dirToOpen) {
        int reply;
        String[] filters = new String[]{extension};
        String selectDialogTitle = AtCommonResource.MESSAGE_RESOURCE.getText("SELECT_OR_ENTER_A_FILE_NAME");
        String approveButtonText = AtCommonResource.MESSAGE_RESOURCE.getText("SELECT");
        char approveButtonMnemonic = AtCommonResource.MESSAGE_RESOURCE.getMnemonic("SELECT");
        String approveButtonTooltip = AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_SELECT_A_FILE");
        String fileFilterText = description;
        if (dirToOpen == null) {
            dirToOpen = ".";
        }
        File defaultFile = new File(dirToOpen);
        if (fileChooser == null) {
            fileChooser = new AtFileChooser(defaultFile, selectDialogTitle, approveButtonText, approveButtonMnemonic, approveButtonTooltip, filters, fileFilterText, false);
        } else {
            fileChooser.setFilters(filters);
            fileChooser.setFilterDescription(fileFilterText);
            fileChooser.setSelectedFile(null);
        }
        File file = fileChooser.showDialog(openOrSave, owner);
        if (file == null) {
            return null;
        }
        String fileNameStr = file.toString();
        AtDebug.debug("Selected file's absolute path name: " + file.getAbsolutePath());
        AtDebug.debug("Filename before adding extension: " + fileNameStr);
        if (fileNameStr != null && fileNameStr.lastIndexOf(filters[0]) < 0) {
            fileNameStr = fileNameStr + "." + filters[0];
            AtDebug.debug("filename after adding extension: " + fileNameStr);
        }
        file = new File(fileNameStr);
        String aFileName = AtCommonResource.MESSAGE_RESOURCE.getText("A_FILE_NAME");
        String isAlreadyExisting = AtCommonResource.MESSAGE_RESOURCE.getText("IS_ALREADY_EXISTING");
        String doYouWantToOverwriteIt = AtCommonResource.MESSAGE_RESOURCE.getText("DO_YOU_WANT_TO_OVERWRITE_IT");
        String confirm = AtCommonResource.MESSAGE_RESOURCE.getText("CONFIRM");
        if (file.exists() && (reply = JOptionPane.showConfirmDialog(owner, aFileName + " \"" + file.getAbsolutePath() + "\" " + isAlreadyExisting + "\n\n" + doYouWantToOverwriteIt, confirm, 0, 1)) != 0) {
            return null;
        }
        String couldNotSaveInto = AtCommonResource.MESSAGE_RESOURCE.getText("COULD_NOT_SAVE_INTO");
        String enterAValidFileName = AtCommonResource.MESSAGE_RESOURCE.getText("ENTER_A_VALID_FILENAME");
        String fileCreationError = AtCommonResource.MESSAGE_RESOURCE.getText("FILE_CREATION_ERROR");
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
        }
        catch (Throwable t) {
            String errorMessage = t.getMessage();
            JOptionPane.showMessageDialog(owner, couldNotSaveInto + " \"" + file.getAbsoluteFile() + "\".\n\n" + errorMessage + "\n\n" + enterAValidFileName + "\n\n", fileCreationError, 0);
            return null;
        }
        PrintStream ps = new PrintStream(fos);
        KeyValue kv = new KeyValue(file, ps);
        return kv;
    }

    public static void saveAsFile(String csvData, String fileExt, String fileExtDesc, Component owner) {
        try {
            int reply;
            String fileDir = null;
            if (lastLookupDir == null) {
                fileDir = System.getProperty("user.home");
                if (fileDir == null) {
                    fileDir = ".";
                }
                lastLookupDir = fileDir;
            } else {
                fileDir = lastLookupDir;
            }
            JFileChooser fileChooser = new JFileChooser(fileDir);
            AtFileFilter filter = new AtFileFilter();
            filter.addFileExtension(fileExt);
            filter.setDescription(fileExtDesc);
            fileChooser.setFileFilter(filter);
            int retCode = fileChooser.showSaveDialog(owner);
            if (retCode != 0) {
                return;
            }
            File file = fileChooser.getSelectedFile();
            String fileNameStr = file.toString();
            if (fileNameStr != null && fileNameStr.lastIndexOf(fileExt) < 0) {
                fileNameStr = fileNameStr + fileExt;
            }
            file = new File(fileNameStr);
            String aFileName = AtCommonResource.MESSAGE_RESOURCE.getText("A_FILE_NAME");
            String isAlreadyExisting = AtCommonResource.MESSAGE_RESOURCE.getText("IS_ALREADY_EXISTING");
            String doYouWantToOverwriteIt = AtCommonResource.MESSAGE_RESOURCE.getText("DO_YOU_WANT_TO_OVERWRITE_IT");
            String confirm = AtCommonResource.MESSAGE_RESOURCE.getText("CONFIRM");
            if (file.exists() && (reply = JOptionPane.showConfirmDialog(owner, aFileName + " \"" + file.getAbsolutePath() + "\" " + isAlreadyExisting + "\n\n" + doYouWantToOverwriteIt, confirm, 0, 1)) != 0) {
                return;
            }
            String couldNotSaveInto = AtCommonResource.MESSAGE_RESOURCE.getText("COULD_NOT_SAVE_INTO");
            String enterAValidFileName = AtCommonResource.MESSAGE_RESOURCE.getText("ENTER_A_VALID_FILENAME");
            String fileCreationError = AtCommonResource.MESSAGE_RESOURCE.getText("FILE_CREATION_ERROR");
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(file);
            }
            catch (Throwable t) {
                String errorMessage = t.getMessage();
                JOptionPane.showMessageDialog(owner, couldNotSaveInto + " \"" + file.getAbsoluteFile() + "\".\n\n" + errorMessage + "\n\n" + enterAValidFileName + "\n\n", fileCreationError, 0);
                return;
            }
            PrintStream ps = new PrintStream(fos);
            ps.print(csvData);
            ps.flush();
            ps.close();
            lastLookupDir = file.getPath();
        }
        catch (Throwable ex) {
            String noFileAccessPermission = AtCommonResource.MESSAGE_RESOURCE.getText("NO_WRITE_PERMISSION");
            String fileCreationErr = AtCommonResource.MESSAGE_RESOURCE.getText("FILE_CREATION_ERROR");
            JOptionPane.showMessageDialog(owner, noFileAccessPermission + "\n" + ex.getMessage(), fileCreationErr, 0);
            return;
        }
    }

    public static final boolean canWrite(Component owner, String fileName) {
        int reply;
        if (fileName == null) {
            return false;
        }
        File file = new File(fileName);
        String aFileName = AtCommonResource.MESSAGE_RESOURCE.getText("A_FILE_NAME");
        String isAlreadyExisting = AtCommonResource.MESSAGE_RESOURCE.getText("IS_ALREADY_EXISTING");
        String doYouWantToOverwriteIt = AtCommonResource.MESSAGE_RESOURCE.getText("DO_YOU_WANT_TO_OVERWRITE_IT");
        String confirm = AtCommonResource.MESSAGE_RESOURCE.getText("CONFIRM");
        return !file.exists() || (reply = JOptionPane.showConfirmDialog(owner, aFileName + " \"" + file.getAbsolutePath() + "\" " + isAlreadyExisting + "\n\n" + doYouWantToOverwriteIt, confirm, 0, 1)) == 0;
    }

    static {
        lastLookupDir = null;
    }
}

