/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.utils;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.io.Serializable;

public class GraphicsUtil
implements Serializable {
    private static RenderingHints hints;
    static final Font titleFont;
    static final Color titleFg;
    static final Color borderColor;

    public static final RenderingHints getRenderingHints() {
        return hints;
    }

    public static final Font getTitleFont() {
        return titleFont;
    }

    public static final Color getTitleForeground() {
        return titleFg;
    }

    public static final Color getBorderColor() {
        return borderColor;
    }

    public static void applyAntiAlias(Graphics g) {
        if (g instanceof Graphics2D) {
            RenderingHints hints = GraphicsUtil.getRenderingHints();
            ((Graphics2D)g).setRenderingHints(hints);
        }
    }

    public static final int stringWidth(Font font, String value) {
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(font);
        int sw = fm.stringWidth(value);
        return sw;
    }

    static {
        titleFont = new Font("Arial", 1, 12);
        titleFg = Color.decode("#003366");
        borderColor = Color.decode("#4b73af");
        hints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
    }
}

