/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.utils;

import com.activetree.common.resource.AtCommonResource;
import com.activetree.common.utils.AtDebug;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Hashtable;

public class JreUtil
implements Serializable {
    public static int KB = 1024;
    public static int MB = KB * KB;
    private static Hashtable SPECIAL_JRE_VERSIONS = new Hashtable();

    public static final String getShortMemoryInfo() {
        Runtime rt = Runtime.getRuntime();
        long roundup = MB / 2 - 1;
        long totalMem = rt.totalMemory();
        long freeMem = rt.freeMemory();
        long freeMb = (freeMem + roundup) / (long)MB;
        long totalMb = (totalMem + roundup) / (long)MB;
        long usedMb = totalMb - freeMb;
        StringBuffer b = new StringBuffer();
        b.append(usedMb);
        b.append("M ");
        b.append(AtCommonResource.MESSAGE_RESOURCE.getText("PAGE_OF"));
        b.append(" ");
        b.append(totalMb);
        b.append("M");
        return b.toString();
    }

    public static String getMemoryInfo() {
        long KB = 1024L;
        long MB = KB * KB;
        Runtime rt = Runtime.getRuntime();
        long roundup = MB / 2L - 1L;
        long totalMem = rt.totalMemory();
        long freeMem = rt.freeMemory();
        long maxMemory = rt.maxMemory();
        long freeMb = (freeMem + roundup) / MB;
        long totalMb = (totalMem + roundup) / MB;
        long usedMb = totalMb - freeMb;
        long maxMb = (maxMemory + roundup) / MB;
        String megabytes = AtCommonResource.MESSAGE_RESOURCE.getText("MB");
        String heading = AtCommonResource.MESSAGE_RESOURCE.getText("MemoryUsage") + ": ";
        String memoryInfo = heading + AtCommonResource.MESSAGE_RESOURCE.getText("Max") + ": " + maxMb + " " + megabytes + ", " + AtCommonResource.MESSAGE_RESOURCE.getText("Used") + ": " + usedMb + " " + megabytes + ", " + AtCommonResource.MESSAGE_RESOURCE.getText("Free") + ": " + freeMb + " " + megabytes + ", " + AtCommonResource.MESSAGE_RESOURCE.getText("Total") + ": " + totalMb + " " + megabytes;
        return memoryInfo;
    }

    public static int getOperatingSystem() {
        String s = System.getProperty("os.name");
        if (s != null) {
            if (s.equalsIgnoreCase("Windows")) {
                return 0;
            }
            if (s.equalsIgnoreCase("Mac")) {
                return 3;
            }
            if (s.equalsIgnoreCase("Unix")) {
                return 1;
            }
            if (s.equalsIgnoreCase("Linux")) {
                return 2;
            }
        }
        return 1;
    }

    public static final boolean isSpecialJREversion(String currJreVersion) {
        Object reply = SPECIAL_JRE_VERSIONS.get(currJreVersion);
        return reply != null;
    }

    public static boolean isJreEqualsOrHigher(String versionStr) {
        String inputVersion = JreUtil.getVersionNumber(versionStr);
        String javaVersion = System.getProperty("java.version");
        String jreVersion = JreUtil.getVersionNumber(javaVersion);
        int len = Math.min(inputVersion.length(), jreVersion.length());
        String usedInputVersion = inputVersion;
        try {
            usedInputVersion = inputVersion.substring(0, len);
        }
        catch (Throwable t) {
            // empty catch block
        }
        String usedJreStr = jreVersion;
        try {
            usedJreStr = jreVersion.substring(0, len);
        }
        catch (Throwable t) {
            // empty catch block
        }
        int inputV = Integer.parseInt(usedInputVersion);
        int jreV = Integer.parseInt(usedJreStr);
        return jreV >= inputV;
    }

    public static String getVersionNumber(String versionStr) {
        StringBuffer b1 = new StringBuffer();
        for (int i = 0; i < versionStr.length(); ++i) {
            char ch = versionStr.charAt(i);
            if (!Character.isDigit(ch)) continue;
            b1.append(ch);
        }
        String s1 = b1.toString();
        return s1;
    }

    public static final int getJREMajorVersionNumber() {
        String javaVersion = System.getProperty("java.version");
        int idx = javaVersion.indexOf(46);
        String major = javaVersion.substring(0, idx);
        return Integer.parseInt(major);
    }

    public static final int getJREMinorVersionNumber() {
        String javaVersion = System.getProperty("java.version");
        int idx = javaVersion.indexOf(46);
        javaVersion = javaVersion.substring(idx + 1);
        idx = javaVersion.indexOf(46);
        String minor = javaVersion.substring(0, idx);
        return Integer.parseInt(minor);
    }

    public static final int getJREMildVersionNumber() {
        char ch;
        String javaVersion = System.getProperty("java.version");
        int idx = javaVersion.indexOf(46);
        javaVersion = javaVersion.substring(idx + 1);
        idx = javaVersion.indexOf(46);
        javaVersion = javaVersion.substring(idx + 1);
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < javaVersion.length() && Character.isDigit(ch = javaVersion.charAt(i)); ++i) {
            b.append(ch);
        }
        String mild = b.toString();
        return Integer.parseInt(mild);
    }

    public static final String getJREUpdateVersion() {
        char ch;
        String javaVersion = System.getProperty("java.version");
        int idx = javaVersion.indexOf(46);
        javaVersion = javaVersion.substring(idx + 1);
        idx = javaVersion.indexOf(46);
        javaVersion = javaVersion.substring(idx + 1);
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < javaVersion.length() && Character.isDigit(ch = javaVersion.charAt(i)); ++i) {
            b.append(ch);
        }
        idx = b.length();
        javaVersion = javaVersion.substring(idx + 1);
        return javaVersion;
    }

    public static final String getJREMajorMinorVersion() {
        int major = JreUtil.getJREMajorVersionNumber();
        int minor = JreUtil.getJREMinorVersionNumber();
        String mn = major + "." + minor;
        return mn;
    }

    public static final String getJREVersion() {
        String javaVersion = System.getProperty("java.version");
        return javaVersion;
    }

    public static final int executeCmd(String cmd) throws Throwable {
        AtDebug.debug("executeCmd: " + cmd);
        Process p = Runtime.getRuntime().exec(cmd);
        int exitCode = p.waitFor();
        InputStream errStream = p.getErrorStream();
        InputStream inputStream = p.getInputStream();
        StringBuffer errBuf = new StringBuffer();
        StringBuffer stdoutBuf = new StringBuffer();
        int ch = -1;
        while (errStream != null && (ch = errStream.read()) != -1) {
            errBuf.append((char)ch);
        }
        ch = -1;
        while (inputStream != null && (ch = inputStream.read()) != -1) {
            stdoutBuf.append((char)ch);
        }
        p.destroy();
        AtDebug.debug("STDOUT\n" + stdoutBuf.toString());
        AtDebug.debug("STDERR\n" + errBuf.toString());
        AtDebug.debug("Done (exit code: " + exitCode + ")");
        return exitCode;
    }

    public static void main(String[] args) throws Throwable {
        String inputJreVersion = args[0];
        boolean isEqOrHigher = JreUtil.isJreEqualsOrHigher(inputJreVersion);
        String jreVersion = JreUtil.getJREVersion();
        System.out.println("JRE:" + jreVersion + " >= InputJRE:" + inputJreVersion + " ? " + isEqOrHigher);
    }

    static {
        SPECIAL_JRE_VERSIONS.put("1.5", new Boolean(true));
        SPECIAL_JRE_VERSIONS.put("1.6", new Boolean(true));
        SPECIAL_JRE_VERSIONS.put("1.7", new Boolean(true));
    }
}

