/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.viewer;

import com.activetree.common.media.AtMediaSizeObject;
import com.activetree.common.media.StandardPapers;
import com.activetree.common.page.AbstractPage;
import com.activetree.common.resource.AtCommonResource;
import com.activetree.common.utils.AtDebug;
import com.activetree.common.utils.DataUtil;
import com.activetree.common.viewer.MultiPageView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class AbstractPageView
extends JPanel {
    public static final String INCH_SHORT = AtCommonResource.MESSAGE_RESOURCE.getText("INCH_SHORT");
    public static final String PIXEL_SHORT = AtCommonResource.MESSAGE_RESOURCE.getText("PIXEL_SHORT");
    public static final String CM = AtCommonResource.MESSAGE_RESOURCE.getText("CM");
    protected MultiPageView pagesView;
    protected Insets insets = new Insets(5, 5, 5, 6);
    protected int pageShadowMargin = 0;
    protected boolean tooltipEnabled = true;
    protected AbstractPage page;
    protected boolean antiAliased = true;
    protected boolean drawPageBorder = true;
    protected boolean singlePageMode;
    private boolean pageLoadingEnabled = true;
    protected final Dimension size = new Dimension();
    protected Object image;
    protected int rotation = 0;
    protected int pageIndexForView = -1;
    protected String pageSizeInfo;
    protected String pageSizeInfoTooltip;

    public AbstractPageView(MultiPageView pagesView, int pageIndexForView, boolean singlePageMode) {
        this.pagesView = pagesView;
        this.pageIndexForView = pageIndexForView;
        this.singlePageMode = singlePageMode;
        AbstractPage pageData = pagesView.getDocViewer().getPageAt(pageIndexForView);
        this.setPage(pageData, false);
        if (!singlePageMode) {
            this.insets = pageIndexForView == 0 ? new Insets(5, 5, 3, 6) : new Insets(3, 5, 3, 6);
        }
    }

    public void clean() {
        this.pagesView = null;
        this.page = null;
        this.image = null;
    }

    public boolean isPageLoadingEnabled() {
        return this.pageLoadingEnabled;
    }

    public void setPageLoadingEnabled(boolean pageLoadingEnabled) {
        this.pageLoadingEnabled = pageLoadingEnabled;
    }

    public int getPageIndexForView() {
        return this.pageIndexForView;
    }

    public String getPageSizeInfo() {
        return this.pageSizeInfo;
    }

    public void setPageSizeInfo(String pageSizeInfo) {
        this.pageSizeInfo = pageSizeInfo;
    }

    public String getPageSizeInfoTooltip() {
        return this.pageSizeInfoTooltip;
    }

    public void setPageSizeInfoTooltip(String pageSizeInfoTooltip) {
        this.pageSizeInfoTooltip = pageSizeInfoTooltip;
    }

    public int getPageShadowMargin() {
        return this.pageShadowMargin;
    }

    public void setPageShadowMargin(int pageShadowMargin) {
        this.pageShadowMargin = pageShadowMargin;
    }

    public void setMargins(Insets insets) {
        this.insets = insets;
    }

    public Insets getMargins() {
        return this.insets;
    }

    public boolean isDrawPageBorder() {
        return this.drawPageBorder;
    }

    public void setDrawPageBorder(boolean drawPageBorder) {
        this.drawPageBorder = drawPageBorder;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public void setAntiAliased(boolean antiAliased) {
        this.antiAliased = antiAliased;
    }

    public boolean isAntiAliased() {
        return this.antiAliased;
    }

    public AbstractPage getPage() {
        return this.page;
    }

    public void setPageImage(Image pageImage) {
        this.image = pageImage;
    }

    public Image getPageImage() {
        if (this.image != null && this.image instanceof Image) {
            return (Image)this.image;
        }
        return null;
    }

    public void setPage(AbstractPage page, boolean updateView) {
        super.setToolTipText(null);
        try {
            this.page = page;
            if (page == null) {
                page = null;
                this.image = null;
                this.setViewSize(new Rectangle2D.Float(0.0f, 0.0f, 10.0f, 10.0f), -1.0);
                this.repaint();
                return;
            }
            page.setRenderingReason("PageRenderingReasonViewing");
            try {
                this.resizeView(updateView);
            }
            catch (Throwable t) {}
        }
        catch (Throwable t) {
            String message = t.getMessage();
            if (message == null) {
                message = t instanceof OutOfMemoryError ? AtCommonResource.MESSAGE_RESOURCE.getText("OUT_OF_MEMORY_ERROR") : AtCommonResource.MESSAGE_RESOURCE.getText("GENERAL_ERROR");
            }
            JOptionPane.showMessageDialog(this.pagesView.getDocViewer(), message, AtCommonResource.MESSAGE_RESOURCE.getText("Error"), 0);
        }
    }

    public void resizeView(boolean updateView) {
        if (this.page != null) {
            try {
                Rectangle2D printableArea = this.getRotatedPrintableArea(this.page);
                if (updateView) {
                    this.image = this.createPageImage(this.page, printableArea, -1.0f);
                    this.createPageTooltip(printableArea);
                }
                this.setViewSize(printableArea, -1.0);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setPage(BufferedImage pageImage) {
        super.setToolTipText(null);
        try {
            Rectangle2D.Float printableArea = new Rectangle2D.Float(0.0f, 0.0f, pageImage.getWidth(), pageImage.getHeight());
            this.image = pageImage;
            this.createPageTooltip(printableArea);
            this.setViewSize(printableArea, -1.0);
        }
        catch (Throwable t) {
            AtDebug.debug(9, t);
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.page == null) {
            return;
        }
        if (this.image == null && this.isPageLoadingEnabled()) {
            Runnable r = new Runnable(){

                public void run() {
                    try {
                        AbstractPageView.this.setPage(AbstractPageView.this.page, true);
                        AbstractPageView.this.repaint();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            };
            this.image = this.page;
            SwingUtilities.invokeLater(r);
        }
        Dimension fakeImageSize = null;
        if (this.image == null && !this.isPageLoadingEnabled()) {
            fakeImageSize = this.createFakeImageSize(this.page);
        }
        Graphics2D g = (Graphics2D)graphics;
        this.applyTransformation(g);
        Dimension d = this.getSize();
        Color oldColor = g.getColor();
        int width = d.width;
        int height = d.height;
        double imgw = -1.0;
        double imgh = -1.0;
        if (this.image != null && this.image instanceof Image) {
            imgw = ((Image)this.image).getWidth(null);
            imgh = ((Image)this.image).getHeight(null);
        } else if (fakeImageSize != null) {
            imgw = fakeImageSize.width;
            imgh = fakeImageSize.height;
        }
        double x = ((double)width - imgw - (double)this.getPageShadowMargin()) / 2.0;
        double y = ((double)height - imgh - (double)this.getPageShadowMargin()) / 2.0;
        Rectangle pageArea = new Rectangle((int)x, (int)y, (int)imgw, (int)imgh);
        if (this.isDrawPageBorder()) {
            g.setColor(SystemColor.black);
            g.fillRect(pageArea.x + this.getPageShadowMargin(), pageArea.y + this.getPageShadowMargin(), pageArea.width, pageArea.height);
            g.setColor(SystemColor.white);
            g.fillRect(pageArea.x, pageArea.y, pageArea.width, pageArea.height);
            g.setColor(SystemColor.black);
            g.drawRect(pageArea.x, pageArea.y, pageArea.width, pageArea.height);
        }
        if (this.image != null && this.image instanceof Image) {
            g.drawImage((Image)this.image, (int)x, (int)y, this);
        }
        if (this.isDrawPageBorder()) {
            g.drawRect(pageArea.x, pageArea.y, pageArea.width, pageArea.height);
        }
        g.setColor(oldColor);
    }

    protected void draw(Graphics g) {
        try {
            this.page.draw(g);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void setViewSize(Rectangle2D printableArea, double zoomIn) {
        double pw = printableArea.getWidth();
        double ph = printableArea.getHeight();
        double zoom = zoomIn;
        if (zoom == -1.0) {
            zoom = this.pagesView.getDocViewer().getCurrentUserSelectedZoom();
        }
        pw *= zoom;
        ph *= zoom;
        int angle = this.rotation % 360;
        if (angle == 90 || angle == 270 || angle == -90 || angle == -270) {
            double tmp = pw;
            pw = ph;
            ph = tmp;
        }
        this.size.width = (int)pw + (this.insets.left + this.insets.right);
        this.size.height = (int)ph + (this.insets.top + this.insets.bottom);
        this.size.width += this.getPageShadowMargin();
        this.size.height += this.getPageShadowMargin();
        this.setSize(this.size);
        this.setPreferredSize(this.size);
        this.validate();
        this.revalidate();
    }

    public void setTooltipEnabled(boolean enabled) {
        this.tooltipEnabled = enabled;
    }

    public boolean isTooltipEnabled() {
        return this.tooltipEnabled;
    }

    protected void createPageTooltip(Rectangle2D imgArea) {
        if (!this.isTooltipEnabled()) {
            return;
        }
        AtMediaSizeObject mo = null;
        try {
            mo = StandardPapers.getMatchedMediaSizeObject(imgArea, 1.0, 1.0, 1);
        }
        catch (Throwable t) {
            // empty catch block
        }
        String sizeTooltip = "";
        String sizeInfo = "";
        if (mo == null) {
            int imgw = (int)imgArea.getWidth();
            int imgh = (int)imgArea.getHeight();
            double inchw = 0.013888888888888888 * (double)imgw;
            double inchh = 0.013888888888888888 * (double)imgh;
            String sw = DataUtil.getString(inchw, 2);
            String sh = DataUtil.getString(inchh, 2);
            double cmsWidth = 0.035277777777777776 * (double)imgw;
            double cmsHeight = 0.035277777777777776 * (double)imgh;
            String cmsWstr = DataUtil.getString(cmsWidth, 2);
            String cmsHstr = DataUtil.getString(cmsHeight, 2);
            sizeInfo = sw + "x" + sh + " " + INCH_SHORT;
            sizeTooltip = sw + "x" + sh + "" + INCH_SHORT + " " + imgw + "x" + imgh + "" + PIXEL_SHORT + " " + cmsWstr + "x" + cmsHstr + "" + CM;
        } else {
            String mediaName = mo.getMediaName();
            sizeTooltip = sizeTooltip + mediaName;
            double wInch = mo.getMediaWidthInch();
            double hInch = mo.getMediaHeightInch();
            String wIn = DataUtil.getString(wInch, 2);
            String hIn = DataUtil.getString(hInch, 2);
            sizeTooltip = sizeTooltip + " " + wIn + "x" + hIn + "" + INCH_SHORT;
            sizeInfo = wIn + "x" + hIn + " " + INCH_SHORT;
            double pixelw = mo.getMediaWidthPixel();
            double pixelh = mo.getMediaHeightPixel();
            String pxw = DataUtil.getString(pixelw, 0);
            String pxh = DataUtil.getString(pixelh, 0);
            sizeTooltip = sizeTooltip + " " + pxw + "x" + pxh + "" + PIXEL_SHORT;
            double wCms = mo.getMediaWidthCM();
            double hCms = mo.getMediaHeightCM();
            String cmsWidth = DataUtil.getString(wCms, 2);
            String cmsHeight = DataUtil.getString(hCms, 2);
            sizeTooltip = sizeTooltip + " " + cmsWidth + "x" + cmsHeight + "" + CM;
        }
        this.pageSizeInfoTooltip = sizeTooltip;
        this.pageSizeInfo = sizeInfo;
    }

    protected Dimension createFakeImageSize(AbstractPage page) {
        double zoom = this.pagesView.getFitZoom(page.getPageIndex());
        Rectangle2D printableArea = this.getRotatedPrintableArea(page);
        this.setViewSize(printableArea, zoom);
        double imgw = printableArea.getWidth() * zoom;
        double imgh = printableArea.getHeight() * zoom;
        Dimension fakeImageSize = new Dimension((int)imgw, (int)imgh);
        return fakeImageSize;
    }

    protected Object createPageImage(AbstractPage page, Rectangle2D printableArea, float scale) throws Throwable {
        double scaleToUse = this.pagesView.getDocViewer().getCurrentUserSelectedZoom();
        if (scale > 0.0f) {
            scaleToUse = scale;
        }
        double imgw = printableArea.getWidth() * scaleToUse;
        double imgh = printableArea.getHeight() * scaleToUse;
        BufferedImage pageImage = new BufferedImage((int)imgw, (int)imgh, 1);
        Graphics g = pageImage.getGraphics();
        g.setColor(SystemColor.white);
        g.fillRect(0, 0, pageImage.getWidth(null), pageImage.getHeight(null));
        page.draw(g);
        return pageImage;
    }

    public void rotate(int direction, int degrees, boolean isRelativeToPreviousRotation) {
        if (this.page == null) {
            return;
        }
        try {
            if (isRelativeToPreviousRotation) {
                this.pagesView.getDocViewer();
                this.rotation = direction == 1 ? (this.rotation += 90) : (this.rotation -= 90);
            } else {
                this.rotation = degrees;
            }
            Rectangle2D printableArea = this.getRotatedPrintableArea(this.page);
            this.setViewSize(printableArea, -1.0);
            this.repaint();
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    protected void applyTransformation(Graphics2D g) {
        Dimension viewSize = this.getSize();
        int cx = viewSize.width / 2;
        int cy = viewSize.height / 2;
        g.rotate(Math.toRadians(this.rotation), cx, cy);
    }

    protected double getRotatedPageWidth() {
        AbstractPage pageData = this.getPage();
        if (pageData == null) {
            return 0.0;
        }
        Rectangle2D printableArea = this.getRotatedPrintableArea(pageData);
        double pageWidth = printableArea.getWidth();
        double pageHeight = printableArea.getHeight();
        int angle = this.rotation % 360;
        if (angle == 90 || angle == 270 || angle == -90 || angle == -270) {
            return pageHeight;
        }
        return pageWidth;
    }

    protected double getRotatedPageHeight() {
        AbstractPage pageData = this.getPage();
        if (pageData == null) {
            return 0.0;
        }
        Rectangle2D printableArea = this.getRotatedPrintableArea(pageData);
        double pageWidth = printableArea.getWidth();
        double pageHeight = printableArea.getHeight();
        int angle = this.rotation % 360;
        if (angle == 90 || angle == 270 || angle == -90 || angle == -270) {
            return pageWidth;
        }
        return pageHeight;
    }

    public Rectangle2D getRotatedPrintableArea(AbstractPage pageData) {
        Rectangle2D printableArea = pageData.getPrintableArea();
        return printableArea;
    }
}

