/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.viewer;

import com.activetree.common.exception.AtUserActionVetoException;
import com.activetree.common.object.PasswordProvider;
import com.activetree.common.page.AbstractPage;
import com.activetree.common.print.AbstractPrinter;
import com.activetree.common.swing.CustomScrollPane;
import com.activetree.common.utils.AtComponentUtil;
import com.activetree.common.utils.AtDebug;
import com.activetree.common.utils.CursorUtil;
import com.activetree.common.viewer.AbstractDocumentViewer;
import com.activetree.common.viewer.AbstractPageView;
import com.activetree.common.viewer.PagesGroupPane;
import com.activetree.common.viewer.ThumbnailData;
import com.activetree.common.viewer.ThumbnailView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.Pageable;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public abstract class AbstractThumbnailsView
extends JPanel {
    protected AbstractDocumentViewer viewer;
    protected final Vector thumbnails = new Vector();
    protected JComponent nailViewer = this;
    protected MouseListener loadListener;
    protected GlassPane glassPane;

    public AbstractDocumentViewer getViewer() {
        return this.viewer;
    }

    protected void setPageLoadingEnabled(boolean enable) {
        for (int i = 0; i < this.thumbnails.size(); ++i) {
            ThumbnailView aThumbnaialView = (ThumbnailView)this.thumbnails.get(i);
            aThumbnaialView.setThumbnailLoadingEnabled(enable);
        }
        this.repaint();
    }

    public GlassPane getGlassPane() {
        return this.glassPane;
    }

    public AbstractThumbnailsView(AbstractDocumentViewer docViewer) {
        this.viewer = docViewer;
        this.setLayout(new BorderLayout(0, 0));
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                AbstractThumbnailsView.this.grabFocus();
            }

            public void mouseClicked(MouseEvent e) {
                CursorUtil.setCursorToAllPanes(AbstractThumbnailsView.this.viewer, CursorUtil.WAIT_CURSOR);
                AbstractThumbnailsView.this.handleMouseClick(e);
                CursorUtil.setCursorToAllPanes(AbstractThumbnailsView.this.viewer, CursorUtil.DEFAULT_CURSOR);
            }
        });
        MouseAdapter thumbnailLoadListener = new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                AbstractThumbnailsView.this.setThumbnailLoadingEnabled(false);
            }

            public void mouseReleased(MouseEvent evt) {
                AbstractThumbnailsView.this.setThumbnailLoadingEnabled(true);
            }
        };
        JScrollPane thumbnailScroller = this.viewer.getThumbnailsScroller();
        if (thumbnailScroller instanceof CustomScrollPane) {
            CustomScrollPane customScroller = (CustomScrollPane)thumbnailScroller;
            customScroller.addScrollChangeListener(thumbnailLoadListener);
        }
    }

    protected abstract AbstractPrinter createDocumentPrinter();

    protected abstract PasswordProvider createPasswordProvider();

    protected abstract void setLicenseKey();

    private void clean() {
        this.cleanOldViews();
        this.removeAll();
    }

    public void setAutoPageLoadingOnScrollingEnabled(boolean enable) {
        JScrollPane tnScroller = this.getViewer().getThumbnailsScroller();
        if (!(tnScroller instanceof CustomScrollPane)) {
            return;
        }
        CustomScrollPane customScroller = (CustomScrollPane)tnScroller;
        if (enable) {
            if (this.loadListener == null) {
                this.loadListener = new MouseAdapter(){

                    public void mousePressed(MouseEvent evt) {
                        AbstractThumbnailsView.this.setPageLoadingEnabled(false);
                    }

                    public void mouseReleased(MouseEvent evt) {
                        AbstractThumbnailsView.this.setPageLoadingEnabled(true);
                        Runnable r = new Runnable(this){
                            private final /* synthetic */ 3 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run() {
                                3.access$000(this.this$1).updateControls();
                            }
                        };
                        SwingUtilities.invokeLater(r);
                    }

                    static /* synthetic */ AbstractThumbnailsView access$000(3 x0) {
                        return x0.AbstractThumbnailsView.this;
                    }
                };
            } else {
                customScroller.removeScrollChangeListener(this.loadListener);
            }
            customScroller.addScrollChangeListener(this.loadListener);
        } else if (this.loadListener != null) {
            customScroller.removeScrollChangeListener(this.loadListener);
        }
    }

    public void refreshUI() {
        this.clean();
        this.createThumbnails();
        this.createView();
        int dispPageIdx = this.viewer.getDisplayedPageIndex();
        this.setThumbnailSelectionIndex(dispPageIdx);
    }

    protected void setThumbnailLoadingEnabled(boolean enable) {
        for (int i = 0; i < this.thumbnails.size(); ++i) {
            ThumbnailView aView = (ThumbnailView)this.thumbnails.get(i);
            aView.setThumbnailLoadingEnabled(enable);
        }
        this.repaint();
    }

    private Point getConvertedPoint(MouseEvent evt) {
        Point mp = evt.getPoint();
        Component c = evt.getComponent();
        JRootPane rootPane = (JRootPane)AtComponentUtil.getParentForComponent(c, JRootPane.class);
        Point tP = SwingUtilities.convertPoint(c, mp, rootPane);
        return tP;
    }

    private MouseEvent getConvertedMouseEvent(MouseEvent e) {
        Point tP = this.getConvertedPoint(e);
        MouseEvent tMe = new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), tP.x, tP.y, e.getClickCount(), e.isPopupTrigger());
        return tMe;
    }

    private void cleanOldViews() {
        for (int i = 0; i < this.thumbnails.size(); ++i) {
            ThumbnailView aThumbnaialView = (ThumbnailView)this.thumbnails.get(i);
            aThumbnaialView.clean();
        }
        this.thumbnails.clear();
    }

    private void createThumbnails() {
        if (this.viewer.getPages() == null || this.viewer.getPages().length <= 0) {
            return;
        }
        try {
            Pageable newPages;
            PasswordProvider passwordProvider = this.createPasswordProvider();
            AbstractPrinter thumbnailReader = this.createDocumentPrinter();
            thumbnailReader.setPasswordProvider(passwordProvider);
            Object docSource = this.viewer.getDocumentSource();
            this.setLicenseKey();
            byte[] docContent = this.viewer.getDocPrinter().getData();
            if (docContent != null) {
                docSource = docContent;
            }
            if ((newPages = thumbnailReader.getPageable(docSource)) == null || newPages.getNumberOfPages() == 0 || thumbnailReader.hasError()) {
                String errMsg = thumbnailReader.getErrorMessage();
                throw new RuntimeException(errMsg);
            }
            for (int i = 0; newPages != null && i < newPages.getNumberOfPages(); ++i) {
                AbstractPage aPage = (AbstractPage)newPages.getPrintable(i);
                aPage.setRenderingReason("PageRenderingReasonThumbnailLoading");
                ThumbnailData data = new ThumbnailData(aPage, i);
                int displayedPageIndex = this.viewer.getDisplayedPageIndex();
                if (i == displayedPageIndex) {
                    data.selected = true;
                }
                ThumbnailView thumbnailView = this.createThumbnailView(data, this.viewer);
                this.thumbnails.add(thumbnailView);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public ThumbnailView createThumbnailView(ThumbnailData data, AbstractDocumentViewer viewer) {
        ThumbnailView tnView = new ThumbnailView(data, viewer);
        return tnView;
    }

    void createView() {
        this.glassPane = new GlassPane();
        if (this.thumbnails == null || this.thumbnails.size() <= 0) {
            return;
        }
        GlassPaneTop all = new GlassPaneTop(new GridBagLayout());
        PagesGroupPane aRowGroup = new PagesGroupPane(new GridBagLayout());
        int rowCount = 0;
        int rowGroup = 0;
        for (int i = 0; this.thumbnails != null && i < this.thumbnails.size(); ++i) {
            Component aThumbnailView = (Component)this.thumbnails.get(i);
            aRowGroup.add(aThumbnailView, new GridBagConstraints(0, ++rowCount - 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            if (rowCount < 512) continue;
            all.add((Component)aRowGroup, new GridBagConstraints(0, rowGroup, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            ++rowGroup;
            aRowGroup = new PagesGroupPane(new GridBagLayout());
            rowCount = 0;
        }
        if (rowCount > 0 && rowCount < 512) {
            all.add((Component)aRowGroup, new GridBagConstraints(0, rowGroup, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.add((Component)all, "North");
    }

    protected void scrollFromPagesViewScroll() {
    }

    public void setThumbnailSelectionIndex(int selectedThumbnailIdx) {
        if (selectedThumbnailIdx >= 0 && selectedThumbnailIdx < this.thumbnails.size()) {
            this.unselectAll();
            ThumbnailView selectedThumbnail = (ThumbnailView)this.thumbnails.get(selectedThumbnailIdx);
            selectedThumbnail.getData().selected = true;
            Rectangle thumbnailBbox = this.getThumbnailBounds(selectedThumbnailIdx);
            JScrollPane thumbnailsScroller = this.viewer.getThumbnailsScroller();
            Rectangle viewRect = thumbnailsScroller.getViewport().getViewRect();
            Dimension viewSize = thumbnailsScroller.getViewport().getViewSize();
            Point viewPos = new Point(thumbnailBbox.x, thumbnailBbox.y);
            viewPos.y -= viewRect.height / 2;
            viewPos.y += thumbnailBbox.height / 2;
            if (viewPos.y < 0) {
                viewPos.y = 0;
            }
            if (viewPos.y + viewRect.height > viewSize.height) {
                viewPos.y = viewSize.height - viewRect.height;
            }
            thumbnailsScroller.getViewport().setViewPosition(viewPos);
            Runnable r = new Runnable(){

                public void run() {
                    AbstractThumbnailsView.this.unloadInvisiblePages();
                }
            };
            SwingUtilities.invokeLater(r);
        }
        this.revalidate();
        this.repaint();
    }

    void handleMouseClick(MouseEvent evt) {
        if (this.thumbnails == null) {
            return;
        }
        Point p = evt.getPoint();
        int selectedThumbnailIdx = -1;
        ThumbnailView selectedThumbnail = null;
        for (int i = 0; this.thumbnails != null && i < this.thumbnails.size(); ++i) {
            ThumbnailView aThumbnailView = (ThumbnailView)this.thumbnails.get(i);
            Rectangle bbox = this.getThumbnailBounds(i);
            if (!bbox.contains(p)) continue;
            selectedThumbnailIdx = i;
            selectedThumbnail = aThumbnailView;
            break;
        }
        if (selectedThumbnail != null) {
            try {
                ActionEvent ae = new ActionEvent(selectedThumbnail.getData(), 1001, "THUMBNAIL_SELECTION_CMD");
                this.viewer.notifyViewerControlActionListeners(ae);
            }
            catch (AtUserActionVetoException ex) {
                AtDebug.debug("User action is vetowed by: " + ex.getClass().getName());
                return;
            }
        }
        if (selectedThumbnailIdx >= 0) {
            this.unselectAll();
            AtDebug.debug("selecting " + selectedThumbnailIdx);
            ThumbnailView selectedView = (ThumbnailView)this.thumbnails.get(selectedThumbnailIdx);
            selectedView.getData().selected = true;
            this.viewer.showPageIndex(selectedThumbnailIdx);
        }
        this.revalidate();
        this.repaint();
    }

    public void unselectAll() {
        for (int i = 0; this.thumbnails != null && i < this.thumbnails.size(); ++i) {
            ThumbnailView aThumbnailView = (ThumbnailView)this.thumbnails.get(i);
            aThumbnailView.getData().selected = false;
        }
    }

    public Rectangle getThumbnailBounds(int thumbnailIndex) {
        ThumbnailView aThumbnailView = (ThumbnailView)this.thumbnails.get(thumbnailIndex);
        Container parent = aThumbnailView.getParent();
        if (parent instanceof PagesGroupPane) {
            Rectangle parentBbox = parent.getBounds();
            Rectangle selfBbox = aThumbnailView.getBounds();
            selfBbox.x = parentBbox.x + selfBbox.x;
            selfBbox.y = parentBbox.y + selfBbox.y;
            return selfBbox;
        }
        return aThumbnailView.getBounds();
    }

    public ThumbnailView getThumbnailView(int pageIndex) {
        for (int i = 0; this.thumbnails != null && i < this.thumbnails.size(); ++i) {
            ThumbnailView aPageView = (ThumbnailView)this.thumbnails.get(i);
            if (aPageView.getData().getPageIndex() != pageIndex) continue;
            return aPageView;
        }
        return null;
    }

    protected void updateControls() {
        this.unloadInvisiblePages();
    }

    protected ThumbnailView[] getVisibleThumbnails() {
        ArrayList<ThumbnailView> list = new ArrayList<ThumbnailView>();
        JScrollPane tnScroller = this.getViewer().getThumbnailsScroller();
        Component pagesComp = tnScroller.getViewport().getView();
        Rectangle visRect = tnScroller.getViewport().getVisibleRect();
        Rectangle viewRect = tnScroller.getViewport().getViewRect();
        Dimension viewSize = tnScroller.getViewport().getViewSize();
        int matchCount = 0;
        int unmatchCountAfter = 0;
        boolean unmatchCountBefore = false;
        for (int page = 0; page < this.thumbnails.size(); ++page) {
            if (page >= 511) {
                int x = 10;
                ++x;
            }
            ThumbnailView aPageView = (ThumbnailView)this.thumbnails.get(page);
            Rectangle bbox = this.getAbsoluteBounds(aPageView);
            bbox.grow(-4, -4);
            if (viewRect.intersects(bbox)) {
                list.add(aPageView);
                ++matchCount;
            } else if (matchCount > 0) {
                ++unmatchCountAfter;
            }
            if (matchCount > 0 && unmatchCountAfter > 0) break;
        }
        ThumbnailView[] visPages = new ThumbnailView[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            visPages[i] = (ThumbnailView)list.get(i);
        }
        return visPages;
    }

    protected ThumbnailView[] getInvisibleThumbnails() {
        ThumbnailView[] visPages = this.getVisibleThumbnails();
        Vector allPages = (Vector)this.thumbnails.clone();
        for (int i = 0; visPages != null && i < visPages.length; ++i) {
            allPages.remove(visPages[i]);
        }
        ThumbnailView[] retPages = new ThumbnailView[allPages.size()];
        for (int i = 0; i < allPages.size(); ++i) {
            retPages[i] = (ThumbnailView)allPages.get(i);
        }
        return retPages;
    }

    protected void unloadAllThumbnails() {
        for (int i = 0; i < this.thumbnails.size(); ++i) {
            AbstractPageView aPageView = (AbstractPageView)this.thumbnails.get(i);
            aPageView.setPageImage(null);
        }
    }

    protected void unloadInvisiblePages() {
        ThumbnailView[] invisPages = this.getInvisibleThumbnails();
        for (int i = 0; invisPages != null && i < invisPages.length; ++i) {
            invisPages[i].setThumbnailImage(null);
        }
    }

    protected Rectangle getAbsoluteBounds(Component source) {
        PagesGroupPane parentForPage = (PagesGroupPane)AtComponentUtil.getParentForComponent(source, PagesGroupPane.class, true);
        Rectangle parentBbox = null;
        if (parentForPage != null) {
            parentBbox = parentForPage.getBounds();
        }
        Rectangle selfBbox = source.getBounds();
        if (parentBbox == null) {
            return selfBbox;
        }
        int x = parentBbox.x + selfBbox.x;
        int y = parentBbox.y + selfBbox.y;
        Rectangle bbox = new Rectangle(x, y, selfBbox.width, selfBbox.height);
        return bbox;
    }

    protected class GlassPane
    extends JComponent {
        Rectangle outerRedBox = null;
        public Rectangle redBox = null;
        final ArrayList dragBoxes = new ArrayList();
        private Point lastMp;
        int ID = 0;

        public boolean isDragPossible(MouseEvent tMe) {
            Point translatedPoint = tMe.getPoint();
            for (int i = 0; i < this.dragBoxes.size(); ++i) {
                Shape aShape = (Shape)this.dragBoxes.get(i);
                if (aShape == null || !aShape.contains(translatedPoint)) continue;
                return true;
            }
            return false;
        }

        public void setLastMousePoint(Point lastMp) {
            this.lastMp = lastMp;
        }

        public void doDrag(MouseEvent tMe) {
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D g = (Graphics2D)graphics;
            if (this.redBox != null) {
                g.setColor(SystemColor.red);
            }
        }
    }

    protected class GlassPaneTop
    extends JPanel {
        boolean gpAdded;

        public GlassPaneTop(LayoutManager lm) {
            super(lm);
            this.gpAdded = false;
            this.addComponentListener(new ComponentAdapter(this){
                private final /* synthetic */ GlassPaneTop this$1;
                {
                    this.this$1 = this$1;
                }

                public void componentShown(ComponentEvent e) {
                    this.addGp(e);
                }

                public void componentResized(ComponentEvent e) {
                    this.addGp(e);
                }

                public void componentMoved(ComponentEvent e) {
                    this.addGp(e);
                }

                public void componentHidden(ComponentEvent e) {
                }

                private void addGp(ComponentEvent evt) {
                    if (!this.this$1.gpAdded) {
                        Window w = AtComponentUtil.getWindowForComponent(GlassPaneTop.access$100((GlassPaneTop)this.this$1).viewer);
                        this.this$1.getRootPane().setGlassPane(GlassPaneTop.access$100((GlassPaneTop)this.this$1).glassPane);
                        GlassPaneTop.access$100((GlassPaneTop)this.this$1).glassPane.setVisible(true);
                        w.invalidate();
                        w.validate();
                        this.this$1.gpAdded = true;
                    }
                }
            });
        }

        static /* synthetic */ AbstractThumbnailsView access$100(GlassPaneTop x0) {
            return x0.AbstractThumbnailsView.this;
        }
    }
}

